
ANDROID_COMMON_CONFIG_DIR := $(call my-dir)

# Include common product.mk
include $(ANDROID_COMMON_CONFIG_DIR)/../../common/config/product.mk

# Setup TARGET_OS
TARGET_OS := linux
TARGET_OS_FLAVOUR := android
TARGET_LIBC := bionic

# Setup arch/cpu based on abi
ifeq ("$(ANDROID_ABI)","armeabi")
  TARGET_ARCH := arm
  TARGET_CPU := armv5te
else ifeq ("$(ANDROID_ABI)","armeabi-v7a")
  TARGET_ARCH := arm
  TARGET_CPU := armv7a
else ifeq ("$(ANDROID_ABI)","armeabi_v7a")
  TARGET_ARCH := arm
  TARGET_CPU := armv7a
else ifeq ("$(ANDROID_ABI)","mips")
  TARGET_ARCH := mips
  TARGET_CPU :=
else ifeq ("$(ANDROID_ABI)","x86")
  TARGET_ARCH := x86
  TARGET_CPU :=
else ifeq ("$(ANDROID_ABI)","")
  $(error Missing ANDROID_ABI)
else
  $(error Invalid ANDROID_ABI: $(ANDROID_ABI))
endif

ifndef ANDROID_NDK_PATH
  $(error Missing ANDROID_NDK_PATH)
endif

ifndef ANDROID_SDK_PATH
  $(error Missing ANDROID_SDK_PATH)
endif

TARGET_ANDROID_APILEVEL := 14
TARGET_ANDROID_NDK := $(ANDROID_NDK_PATH)
TARGET_ANDROID_SDK := $(ANDROID_SDK_PATH)

TARGET_DEFAULT_LIB_DESTDIR := usr/lib
