/*
# Software License Agreement (BSD License)
#
# Copyright (c) 2012 Yujin Robot, Jihoon Lee
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
#    * Redistributions of source code must retain the above copyright
#        notice, this list of conditions and the following disclaimer.
#    * Redistributions in binary form must reproduce the above
#        copyright notice, this list of conditions and the following
#        disclaimer in the documentation and/or other materials provided
#        with the distribution.
#    * Neither the name of Yujin Robot nor the names of its
#        contributors may be used to endorse or promote products derived
#        from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef ROCON_TF_RECONSTRUCTOR_ROCON_POSE_CLIENT_H_
#define ROCON_TF_RECONSTRUCTOR_ROCON_POSE_CLIENT_H_

#include<ros/ros.h>
#include<geometry_msgs/PoseStamped.h>

namespace rocon {

  class RoconPoseClient {
    public:
      RoconPoseClient();
      RoconPoseClient(ros::NodeHandle& nh,std::string client_name,std::string topic_name);
      ~RoconPoseClient();

      void processPose(const geometry_msgs::PoseStamped::ConstPtr msg);
      geometry_msgs::PoseStamped getPoseStamped();
      std::string getClientName();
      bool isInitialized();


    private:
      std::string client_name;
      std::string pose_topic;
      ros::Subscriber sub;
      bool initialized;

      geometry_msgs::PoseStamped pose_stamped;
  };
}

#endif
