//
// server.hpp
// ~~~~~~~~~~
//
// Copyright (c) 2003-2011 Christopher M. Kohlhoff (chris at kohlhoff dot com)
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//

#ifndef HTTP_SERVER3_SERVER_H
#define HTTP_SERVER3_SERVER_H

#include <boost/asio.hpp>
#include <string>
#include <vector>
#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>
#include "connection.h"

#include "encoder_manager.h"

#include "server_configuration.h"

namespace ros_http_video_streamer
{

/// The top-level class of the HTTP server.
class server
  : private boost::noncopyable
{
public:
  /// Construct the server to listen on the specified TCP address and port, and
  /// serve up files from the given directory.
  explicit server(const ServerConfiguration& server_conf,  std::size_t thread_pool_size);

  /// Run the server's io_service loop.
  void run();

  /// Stop the server.
  void stop();

private:
  /// Handle completion of an asynchronous accept operation.
  void handle_accept(const boost::system::error_code& e);

  const ServerConfiguration& server_conf_;

  /// The number of threads that will call io_service::run().
  std::size_t thread_pool_size_;

  /// The io_service used to perform asynchronous operations.
  boost::asio::io_service io_service_;

  /// Acceptor used to listen for incoming connections.
  boost::asio::ip::tcp::acceptor acceptor_;

  // Encoder manager to handle encoding instances
  EncoderManager encoder_manager_;

  /// The next connection to be accepted.
  connection_ptr new_connection_;


  //std::vector<boost::shared_ptr<boost::thread> > connection_threads_;
};

} // ros_http_video_streamer

#endif // HTTP_SERVER3_SERVER_HPP
