#!/usr/bin/env python

import roslib
roslib.load_manifest('rospilot')
import rospilot  # noqa  need this line because it sets up the sys.path
import rospy
from vlc_server import server
import std_srvs.srv
from optparse import OptionParser
import time
import os


class VlcNode:
    def __init__(self, mrl, media_path):
        self.recorder = server.VlcRecorder(mrl=mrl, mux="wmv")
        self.media_path = os.path.expanduser(media_path)

        if not os.path.exists(self.media_path):
            os.makedirs(self.media_path)

        rospy.init_node("ros_vlc")
        rospy.Service('start_record',
                      std_srvs.srv.Empty,
                      self.handle_start_record)
        rospy.Service('stop_record',
                      std_srvs.srv.Empty,
                      self.handle_stop_record)

    @classmethod
    def media_time(self):
        return int(round(time.time() * 1000))

    def handle_start_record(self, empty_message):
        date = VlcNode.media_time()
        self.recorder.start_record("%s/vid.%s.mjpeg" % (self.media_path, date))
        return std_srvs.srv.EmptyResponse()

    def handle_stop_record(self, empty_message):
        self.recorder.stop_record()
        return std_srvs.srv.EmptyResponse()

    # NOTE: Not tested.
    def handle_take_snapshot(self, empty_message):
        date = VlcNode.media_time()
        self.recorder.take_snapshot("%s/pic.%s.png" % (self.media_path, date),
                                    640, 480)

    def run(self):
        rospy.loginfo("Vlc Node Initialized and waiting...")
        rospy.spin()

if __name__ == '__main__':
    parser = OptionParser("ros_vlc.py <options>")
    parser.add_option(
        "--media_path",
        dest="media_path",
        help="Directory to store media generated by drone",
        default="/tmp")
    parser.add_option(
        "--input_stream",
        dest="input_stream",
        help="Media Resource Location of incoming stream",
        default="http://0.0.0.0:8080/stream?topic=/camera/image_raw/compressed")
    (opts, args) = parser.parse_args()
    node = VlcNode(
        mrl=opts.input_stream,
        media_path=opts.media_path)
    node.run()
