# Software License Agreement (BSD License)
#
# Copyright (c) 2012, Willow Garage, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
#  * Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above
#    copyright notice, this list of conditions and the following
#    disclaimer in the documentation and/or other materials provided
#    with the distribution.
#  * Neither the name of Willow Garage, Inc. nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

"""
.. module:: widgets
    :synopsis: Widgets for the rqt_robot_dashboard.

.. moduleauthor:: Ze'ev Klapow, Aaron Blasdel <ablasdel@gmail.com>

This module provides a set of standard widgets for using with the Dashboard class.

To use them you must provide instances of them to your dashboard in its :func:`get_widgets` method. For example::

    from rqt_robot_dashboard.dashboard import Dashboard
    from rqt_robot_dashboard.widgets import MonitorDashWidget, ConsoleDashWidget, BatteryDashWidget

    class MyDashboard(Dashboard):
        def get_widgets(self):
            self.monitor = MonitorDashWidget(self.context)
            self.console = ConsoleDashWidget(self.context)
            self.battery = BatteryDashWidget(self.context)

            return [[self.monitor, self.console],[self.battery]]

Would create a simple dashboard with the ability to open a rqt_robot_monitor and a ROS console and monitor the battery.
"""

from .icon_tool_button import IconToolButton
from .battery_dash_widget import BatteryDashWidget
from .console_dash_widget import ConsoleDashWidget
from .menu_dash_widget import MenuDashWidget
from .monitor_dash_widget import MonitorDashWidget
from .nav_view_dash_widget import NavViewDashWidget
