#ifndef ORO_TYPESTREAMSELECTOR_HPP_
#define ORO_TYPESTREAMSELECTOR_HPP_

#include <ostream>
#include <istream>


namespace RTT
{
    namespace types {
        template<typename T, bool b_value>
        struct TypeStreamSelector;
        template<typename T>
        struct TypeStreamSelector<T,true>
        {
            static std::ostream& write(std::ostream& os, T const& t)
            {
#ifdef OS_HAVE_STREAMS
                os << t;
#endif
                return os;
            }
            static std::istream& read(std::istream& os, T& t)
            {
#ifdef OS_HAVE_STREAMS
                os >> t;
#endif
                return os;
            }
        };
        template<typename T>
        struct TypeStreamSelector<T,false>
        {
            static std::ostream& write(std::ostream& os, T)
            {
                return os;
            }
            static std::istream& read(std::istream& os, T& )
            {
                return os;
            }
        };
    }
}

#endif /* ORO_TYPESTREAMSELECTOR_HPP_ */
