/*
 * Decompiled with CFR 0.152.
 */
package de.csmp.jeiscp;

import de.csmp.jeiscp.EiscpMessageFormatException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EiscpProtocolHelper {
    private static final Log log = LogFactory.getLog(EiscpProtocolHelper.class);

    public static byte[] iscpToEiscpMessage(String message) throws IOException {
        byte[] messageBytes = message.getBytes();
        int dataSize = messageBytes.length + 2;
        if (dataSize > 255) {
            throw new IOException("dataSize > 255 not implemented");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write("ISCP".getBytes());
        bos.write(0);
        bos.write(0);
        bos.write(0);
        bos.write(16);
        bos.write(0);
        bos.write(0);
        bos.write(0);
        bos.write(dataSize);
        bos.write(1);
        bos.write(0);
        bos.write(0);
        bos.write(0);
        bos.write(messageBytes);
        bos.write(13);
        bos.write(10);
        byte[] eiscpMessage = bos.toByteArray();
        return eiscpMessage;
    }

    public static byte[] parseEiscpToIscpMessage(byte[] response) throws Exception {
        EiscpProtocolHelper.validateIscpSignature(response, 0);
        EiscpProtocolHelper.validateHeaderLengthSignature(response, 4);
        int messageSize = EiscpProtocolHelper.readMessageSize(response, 8);
        EiscpProtocolHelper.validateEiscpVersion(response, 12);
        int messageOffset = 16;
        byte[] messageBytes = new byte[messageSize];
        System.arraycopy(response, messageOffset, messageBytes, 0, messageSize);
        return messageBytes;
    }

    public static void validateEiscpVersion(byte[] response, int offset) throws EiscpMessageFormatException {
        if (response[offset++] != 1 || response[offset++] != 0 || response[offset++] != 0 || response[offset++] != 0) {
            throw new EiscpMessageFormatException("illegal version != 01 00 00 00");
        }
    }

    public static int readMessageSize(byte[] response, int offset) throws EiscpMessageFormatException {
        if (response[offset++] != 0 || response[offset++] != 0) {
            throw new EiscpMessageFormatException("illegal message size > 0x0000ffff");
        }
        int messageSize = response[offset++] * 256 + response[offset++];
        return messageSize;
    }

    public static void validateHeaderLengthSignature(byte[] response, int offset) throws EiscpMessageFormatException {
        if (response[offset++] != 0 || response[offset++] != 0 || response[offset++] != 0 || response[offset++] != 16) {
            throw new EiscpMessageFormatException("illegal header size != 0x10");
        }
    }

    public static void validateIscpSignature(byte[] response, int offset) throws EiscpMessageFormatException {
        if (response[offset++] != 73 || response[offset++] != 83 || response[offset++] != 67 || response[offset++] != 80) {
            throw new EiscpMessageFormatException("illegal signature != ISCP");
        }
    }

    public static String parseIscpMessage(byte[] iscpMessage) throws EiscpMessageFormatException {
        if (iscpMessage[0] == 33 && iscpMessage[1] == 49) {
            int length = iscpMessage.length;
            if (EiscpProtocolHelper.isEofMarker(iscpMessage[length - 1]) && EiscpProtocolHelper.isEofMarker(iscpMessage[--length - 1]) && EiscpProtocolHelper.isEofMarker(iscpMessage[--length - 1])) {
                --length;
            }
            String res = new String(iscpMessage, 2, length - 3);
            return res;
        }
        throw new EiscpMessageFormatException("wrong ISC signature");
    }

    public static boolean isEofMarker(byte b) {
        return b == 13 || b == 10;
    }

    public static String interpreteEiscpResponse(byte[] response) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("response: " + response.length + " bytes - " + EiscpProtocolHelper.convertToHexString(response)));
        }
        byte[] iscpMessage = EiscpProtocolHelper.parseEiscpToIscpMessage(response);
        if (log.isDebugEnabled()) {
            log.debug((Object)("iscpMessage: " + EiscpProtocolHelper.convertToHexString(iscpMessage)));
        }
        String iscpResult = EiscpProtocolHelper.parseIscpMessage(iscpMessage);
        return iscpResult;
    }

    public static String convertToHexString(byte[] byteArray) {
        String ret = "";
        for (int i = 0; i < byteArray.length; ++i) {
            if (i > 0) {
                ret = ret + " ";
            }
            if (byteArray[i] < 16) {
                ret = ret + "0";
            }
            ret = ret + Integer.toString(byteArray[i], 16);
        }
        return ret.toUpperCase();
    }

    public static String convertToHexString(byte sByte) {
        return EiscpProtocolHelper.convertToHexString(new byte[]{sByte});
    }
}

