/*
 * Decompiled with CFR 0.152.
 */
package de.csmp.jeiscp.app;

import de.csmp.jeiscp.EiscpConnector;
import de.csmp.jeiscp.EiscpListener;
import de.csmp.jeiscp.EiscpProtocolHelper;
import de.csmp.jeiscp.app.gui.OnkyoControllerMainFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppGuiController
implements EiscpListener {
    private static final Log log = LogFactory.getLog(AppGuiController.class);
    EiscpConnector conn;
    OnkyoControllerMainFrame frm;
    ByteArrayOutputStream imageBos = null;

    public AppGuiController(EiscpConnector conn) {
        this.conn = conn;
        this.frm = new OnkyoControllerMainFrame();
        final AppGuiController fController = this;
        this.frm.getTglBtnMute().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fController.sendCommand(AppGuiController.this.frm.getTglBtnMute().isSelected() ? "audio-muting::on" : "audio-muting::off");
            }
        });
        this.frm.getTglbtnOnoff().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fController.sendCommand(AppGuiController.this.frm.getTglbtnOnoff().isSelected() ? "system-power::on" : "system-power::standby");
            }
        });
        this.frm.getVolumeSlider().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                int vol = AppGuiController.this.frm.getVolumeSlider().getValue();
                String cmd = "MVL" + EiscpProtocolHelper.convertToHexString((byte)vol);
                fController.sendIscpCommand(cmd);
            }
        });
    }

    public void sendIscpCommand(String cmd) {
        try {
            this.conn.sendIscpCommand(cmd);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public void sendCommand(String cmd) {
        try {
            this.conn.sendCommand(cmd);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public void show() {
        this.frm.setVisible(true);
    }

    @Override
    public void receivedIscpMessage(String message) {
        boolean unhandled = false;
        if (message.equals("PWR01")) {
            this.frm.getTglbtnOnoff().setText("ON");
            this.frm.getTglbtnOnoff().setSelected(true);
        } else if (message.equals("PWR00")) {
            this.frm.getTglbtnOnoff().setText("Off");
            this.frm.getTglbtnOnoff().setSelected(false);
        } else if (message.startsWith("MVL")) {
            int vol = Integer.parseInt(message.substring(3), 16);
            this.frm.getVolumeSlider().setValue(vol);
            this.frm.getLblVolume().setText("" + vol);
        } else if (message.equals("AMT01")) {
            this.frm.getTglBtnMute().setSelected(true);
        } else if (message.equals("AMT00")) {
            this.frm.getTglBtnMute().setSelected(false);
        } else if (message.startsWith("NTM")) {
            this.frm.setTitle(message.substring("NTM".length()));
        } else if (message.startsWith("NJA")) {
            int cmdSkip = "NJA".length();
            String flag = message.substring(cmdSkip, cmdSkip + 2);
            if (flag.equals("00")) {
                this.imageBos = new ByteArrayOutputStream();
                this.writeHexAsBytes(this.imageBos, message.substring(cmdSkip + 2));
            } else if (flag.equals("01")) {
                this.writeHexAsBytes(this.imageBos, message.substring(cmdSkip + 2));
            } else if (flag.equals("02")) {
                this.writeHexAsBytes(this.imageBos, message.substring(cmdSkip + 2));
                try {
                    File tmp = File.createTempFile(this.getClass().getSimpleName(), ".bmp");
                    FileOutputStream os = new FileOutputStream(tmp);
                    os.write(this.imageBos.toByteArray());
                    os.close();
                    log.info((Object)("wrote image to " + tmp.getAbsolutePath()));
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
                this.imageBos = null;
            } else {
                unhandled = true;
            }
        } else {
            unhandled = true;
        }
        if (unhandled) {
            log.info((Object)("unhandled: \"" + message + "\" " + message.length()));
        }
    }

    private void writeHexAsBytes(ByteArrayOutputStream bos, String hexString) {
        for (int i = 0; i < hexString.length(); i += 2) {
            bos.write((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
    }
}

