/*
 * Decompiled with CFR 0.152.
 */
package de.csmp.jeiscp.app;

import de.csmp.jeiscp.EiscpConnector;
import de.csmp.jeiscp.EiscpProtocolHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;

public class BlockingDumbConsoleApp {
    public static void main(String[] args) {
        try {
            System.out.println(BlockingDumbConsoleApp.class.getName());
            System.out.println(StringUtils.repeat((char)'=', (int)30));
            EiscpConnector conn = new EiscpConnector("192.168.2.15");
            Thread.sleep(100L);
            if (conn.available() > 0) {
                byte[] msg = conn.readMessage();
                String iscpResult = EiscpProtocolHelper.interpreteEiscpResponse(msg);
                System.out.println("greeting: " + iscpResult);
            }
            BufferedReader bin = new BufferedReader(new InputStreamReader(System.in));
            BlockingDumbConsoleApp.sendCommandDisplayResult(conn, "PWRQSTN");
            BlockingDumbConsoleApp.sendCommandDisplayResult(conn, "MVLQSTN");
            BlockingDumbConsoleApp.sendCommandDisplayResult(conn, "IFVQSTN");
            System.out.println("ready");
            System.out.println("Enter quit or command like...");
            System.out.println("\tPWRQSTN PWR01 PWR00 MVLQSTN MVL{0-100} IFAQSTN IFVQSTN RESQSTN");
            boolean quit = false;
            while (!quit) {
                String input = bin.readLine();
                if ("quit".equals(input)) {
                    System.out.println("bye");
                    quit = true;
                    continue;
                }
                conn.readMessage();
                BlockingDumbConsoleApp.sendCommandDisplayResult(conn, input);
            }
        }
        catch (Exception ex) {
            System.err.println("Fehler");
            ex.printStackTrace();
        }
    }

    public static void sendCommandDisplayResult(EiscpConnector conn, String input) throws IOException, InterruptedException, Exception {
        conn.sendIscpCommand(input);
        Thread.sleep(200L);
        byte[] message = conn.readMessage();
        if (message != null) {
            String iscpResult = EiscpProtocolHelper.interpreteEiscpResponse(message);
            System.out.println("iscpResult: " + iscpResult);
        } else {
            System.out.println("no result");
        }
    }
}

