/*
 * Decompiled with CFR 0.152.
 */
package de.csmp.jeiscp.app;

import de.csmp.jeiscp.EiscpConnector;
import de.csmp.jeiscp.EiscpListener;
import de.csmp.jeiscp.app.AppGuiController;
import de.csmp.jeiscp.eiscp.Command;
import de.csmp.jeiscp.eiscp.EiscpCommandsParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadedConsoleApp
implements EiscpListener {
    private static final Log log = LogFactory.getLog(ThreadedConsoleApp.class);
    private static final boolean ENABLE_GUI = true;
    AppGuiController gui = null;

    public static void main(String[] args) {
        ThreadedConsoleApp app = new ThreadedConsoleApp();
        app.start();
    }

    public void start() {
        try {
            System.out.println(ThreadedConsoleApp.class.getName());
            System.out.println(StringUtils.repeat((char)'=', (int)60));
            EiscpConnector conn = EiscpConnector.autodiscover();
            conn.attachListener(this);
            this.gui = new AppGuiController(conn);
            conn.sendCommand("system-power::query");
            conn.sendCommand("master-volume::query");
            conn.sendCommand("video-infomation::query");
            conn.sendCommand("monitor-out-resolution::query");
            Thread.sleep(500L);
            this.gui.show();
            System.out.println(StringUtils.repeat((char)'-', (int)60));
            System.out.println("Enter quit or ISCP commands like...");
            System.out.println("\tPWRQSTN\n\tPWR01\n\tPWR00\n\tMVLQSTN\n\tMVL{0-100}\n\tIFAQSTN\n\tIFVQSTN\n\tRESQSTN");
            System.out.println("For command reference compare to manual");
            System.out.println(StringUtils.repeat((char)'-', (int)60));
            BufferedReader bin = new BufferedReader(new InputStreamReader(System.in));
            boolean quit = false;
            while (!quit) {
                String input = bin.readLine();
                if ("quit".equalsIgnoreCase(input)) {
                    System.out.println("bye");
                    quit = true;
                    continue;
                }
                conn.sendIscpCommand(input);
            }
            conn.close();
            System.exit(0);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    @Override
    public void receivedIscpMessage(String message) {
        Command cmd = EiscpCommandsParser.getCommandByIscp(message);
        if (message.startsWith("NJA")) {
            if (message.startsWith("NJA00")) {
                System.out.print(">> NJAxx receive image.");
            } else if (message.startsWith("NJA01")) {
                System.out.print(".");
            } else if (message.startsWith("NJA02")) {
                System.out.print("done");
            }
        } else if (cmd != null) {
            System.out.println(">> " + cmd);
        } else {
            System.out.println(">> " + message);
        }
        if (this.gui != null) {
            this.gui.receivedIscpMessage(message);
        }
    }
}

