;; model for irex demo

(defun make-obj ()
  (let (base l1 l2 top obj (pad 40))
    (setq base (make-cube 120 (+ 350 pad) (+ 15 pad)))
    (send base :locate #f(10 0 7.5))
    (setq l1 (make-cylinder (+ 15 pad) 715))
    (setq l2 (make-cylinder (+ 15 pad) 715))
    ;(setq l1 (make-cube 30 30 715 :pos (float-vector 0 0 (/ 715 2))))
    ;(setq l2 (make-cube 30 30 715 :pos (float-vector 0 0 (/ 715 2))))
    (send l1 :locate #f(0 -150 15))
    (send l2 :locate #f(0  150 15))
    (setq top (make-cube (+ 50 pad) (+ 350 pad) (+ 50 pad)))
    (send top :locate (float-vector 0 0 (+ 715 15 (/ (+ 50 pad) 2))))
    (send base :assoc l1)
    (send base :assoc l2)
    (send base :assoc top)
    (setq obj (instance bodyset :init (make-cascoords) :bodies (list base l1 l2 top) :name "gate"))
    (send obj :locate #f(330 0 -150))
    (send-all (send obj :bodies) :set-color :tomato)

    ;;(eus2stl (format nil "/tmp/irex_model_base.stl") (instance faceset :init :faces (send base :faces)))
    ;;(eus2stl (format nil "/tmp/irex_model_l1.stl")  (instance faceset :init :faces (send l1 :faces)))
    ;;(eus2stl (format nil "/tmp/irex_model_l2.stl")  (instance faceset :init :faces (send l2 :faces)))
    ;;(eus2stl (format nil "/tmp/irex_model_top.stl") (instance faceset :init :faces (send top :faces)))
    obj))

(defun make-base ()
  (let (base obj)
    (setq base (make-cube (+ 300 10) (+ 300 10) 150))
    (send base :locate (float-vector (- 150 210) 0 (/ 150 -2)))
    (setq obj (instance bodyset :init (make-cascoords) :bodies (list base) :name "base"))
    (send-all (send obj :bodies) :set-color :gray60)
    obj))

(defun make-rc8 ()
  (let (rc8-1 rc8-2 obj)
    (setq rc8-1 (make-cube 410 (+ 456 10) (+ 94 10)))
    (setq rc8-2 (make-cube 410 (+ 456 10) (+ 94 10)))
    (send rc8-1 :locate (float-vector 0 0 (+ (/ (+ 94 10) 2) -150)))
    (send rc8-2 :locate (float-vector 0 0 (+ (/ (+ 94 10) 2) -120)))
    (send rc8-2 :locate (float-vector 0 0 (+ 94 0)))
    (send rc8-1 :assoc rc8-2)
    (send rc8-1 :locate (float-vector (+ 1000 -210 (/ 410 -2)) (+ 600 0 (/ (+ 456 10) -2)) 0))
    (setq obj (instance bodyset :init (make-cascoords) :bodies (list rc8-1 rc8-2) :name "rc8"))
    (send-all (send obj :bodies) :set-color :gray80)
    obj))

(defun make-cage ()
  (let (cage wall1 wall2 wall3 wall4 obj)
    (setq cage (make-cube 1000 1200 20))
    (send cage :locate (float-vector (- 500 210) 0 -150))
    (send cage :set-color :snow)
    (setq wall1 (make-cube 10 1200 1000))
    (send wall1 :locate (float-vector (- 1000 210) 0 (+ (/ 1000 2) -150)))
    (send wall1 :set-color :snow 0.1)
    (setq wall2 (make-cube 10 1200 1000))
    (send wall2 :locate (float-vector -210 0 (+ (/ 1000 2) -150)))
    (send wall2 :set-color :snow 0.1)
    (setq wall3 (make-cube 1000 10 1000))
    (send wall3 :locate (float-vector (- 500 210) -600 (+ (/ 1000 2) -150)))
    (send wall3 :set-color :snow 0.1)
    (setq wall4 (make-cube 1000 10 1000))
    (send wall4 :locate (float-vector (- 500 210)  600 (+ (/ 1000 2) -150)))
    (send wall4 :set-color :snow 0.1)
    (setq obj (instance bodyset :init (make-cascoords) :bodies (list cage wall1 wall2 wall3 wall4) :name "cage"))
    obj))

(setq obj (make-obj))
(setq base (make-base))
(setq rc8 (make-rc8))
(setq cage (make-cage))
(objects (list obj base rc8 cage))
(load "package://eusurdf/euslisp/read-stl.l")
(eus2stl (format nil "/tmp/irex_model.stl") (instance faceset :init :faces (send obj :faces)))


;(load "package://euscollada/src/eus2collada.l")
;(write-collada-file (instance faceset :init :faces (send obj :faces)) "/tmp/" :name "irex_model")
;(write-collada-file obj "/tmp/" :name "irex_model")
;(load "package://euslisp/jskeus/irteus/irtcollada.l")
;(eus2collada obj "/tmp/" )



(with-open-file
  (f "/tmp/irex_model.scene" :direction :output)
  (format f "irex_scene~%")
  (dolist (obj (objects))
    (format f "* irex_model_~A~%" (send obj :name))
    (format f "~A~%" (length (send obj :bodies)))
    (dolist (b (send obj :bodies))
      (setq pos (scale 0.001 (send b :worldpos)))
      (cond ((assoc :cube (send b :csg))
             (setq csg (scale 0.001 (coerce (cdr (assoc :cube (send b :csg))) float-vector)))
             (format f "box~%")
             (format f "~A ~A ~A~%" (elt csg 0) (elt csg 1) (elt csg 2))
             )
            ((assoc :cylinder (send b :csg))
             (setq csg (scale 0.001 (coerce (cdr (assoc :cylinder (send b :csg))) float-vector)))
             (format f "cylinder~%")
             (format f "~A ~A~%" (elt csg 0) (elt csg 1))
             (setq pos (v+ pos (float-vector 0 0 (/ (elt csg 1) 2))))
             )
            )
      (format f "~A ~A ~A~%" (elt pos 0) (elt pos 1) (elt pos 2))
      (format f "0 0 0 1~%")
      (setq col (get b :face-color))
      (format f "~A ~A ~A ~A~%" (elt col 0) (elt col 1) (elt col 2)
              (if (> (length col) 3) (elt col 3) 1.0))
      )
    )
  (format f ".~%")
  )

