/**
Software License Agreement (BSD)

\file      NavdataMessageDefinitions.h
\authors   Mani Monajjemi <mmonajje@sfu.ca>
\copyright Copyright (c) 2012, Autonomy Lab (Simon Fraser University), All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that
the following conditions are met:
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the
   following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
   following disclaimer in the documentation and/or other materials provided with the distribution.
 * Neither the name of Autonomy Lab nor the names of its contributors may be used to endorse or promote
   products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WAR-
RANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, IN-
DIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
// Autogenerated from source-files using the CreateNavdataFormat.py script

#ifdef NAVDATA_STRUCTS_INCLUDES
#include "ardrone_autonomy/navdata_demo.h"
#include "ardrone_autonomy/navdata_time.h"
#include "ardrone_autonomy/navdata_raw_measures.h"
#include "ardrone_autonomy/navdata_phys_measures.h"
#include "ardrone_autonomy/navdata_gyros_offsets.h"
#include "ardrone_autonomy/navdata_euler_angles.h"
#include "ardrone_autonomy/navdata_references.h"
#include "ardrone_autonomy/navdata_trims.h"
#include "ardrone_autonomy/navdata_rc_references.h"
#include "ardrone_autonomy/navdata_pwm.h"
#include "ardrone_autonomy/navdata_altitude.h"
#include "ardrone_autonomy/navdata_vision_raw.h"
#include "ardrone_autonomy/navdata_vision_of.h"
#include "ardrone_autonomy/navdata_vision.h"
#include "ardrone_autonomy/navdata_vision_perf.h"
#include "ardrone_autonomy/navdata_trackers_send.h"
#include "ardrone_autonomy/navdata_vision_detect.h"
#include "ardrone_autonomy/navdata_watchdog.h"
#include "ardrone_autonomy/navdata_adc_data_frame.h"
#include "ardrone_autonomy/navdata_video_stream.h"
#include "ardrone_autonomy/navdata_games.h"
#include "ardrone_autonomy/navdata_pressure_raw.h"
#include "ardrone_autonomy/navdata_magneto.h"
#include "ardrone_autonomy/navdata_wind_speed.h"
#include "ardrone_autonomy/navdata_kalman_pressure.h"
#include "ardrone_autonomy/navdata_hdvideo_stream.h"
#include "ardrone_autonomy/navdata_wifi.h"
#include "ardrone_autonomy/navdata_zimmu_3000.h"
#include <std_msgs/UInt16.h>
#include <std_msgs/UInt32.h>
#include <std_msgs/Float32.h>
#include <std_msgs/Int32.h>
#include <std_msgs/Int16.h>
#include <std_msgs/UInt8.h>
#include <ardrone_autonomy/vector31.h>
#include <ardrone_autonomy/vector21.h>
#include <ardrone_autonomy/matrix33.h>
#endif

#ifdef NAVDATA_STRUCTS_HEADER_PUBLIC
	void PublishNavdataTypes(const navdata_unpacked_t &n, const ros::Time &received);
#endif

#ifdef NAVDATA_STRUCTS_HEADER_PRIVATE
	ros::Publisher pub_navdata_demo;
	bool enabled_navdata_demo;
	ardrone_autonomy::navdata_demo navdata_demo_msg;
	ros::Publisher pub_navdata_time;
	bool enabled_navdata_time;
	ardrone_autonomy::navdata_time navdata_time_msg;
	ros::Publisher pub_navdata_raw_measures;
	bool enabled_navdata_raw_measures;
	ardrone_autonomy::navdata_raw_measures navdata_raw_measures_msg;
	ros::Publisher pub_navdata_phys_measures;
	bool enabled_navdata_phys_measures;
	ardrone_autonomy::navdata_phys_measures navdata_phys_measures_msg;
	ros::Publisher pub_navdata_gyros_offsets;
	bool enabled_navdata_gyros_offsets;
	ardrone_autonomy::navdata_gyros_offsets navdata_gyros_offsets_msg;
	ros::Publisher pub_navdata_euler_angles;
	bool enabled_navdata_euler_angles;
	ardrone_autonomy::navdata_euler_angles navdata_euler_angles_msg;
	ros::Publisher pub_navdata_references;
	bool enabled_navdata_references;
	ardrone_autonomy::navdata_references navdata_references_msg;
	ros::Publisher pub_navdata_trims;
	bool enabled_navdata_trims;
	ardrone_autonomy::navdata_trims navdata_trims_msg;
	ros::Publisher pub_navdata_rc_references;
	bool enabled_navdata_rc_references;
	ardrone_autonomy::navdata_rc_references navdata_rc_references_msg;
	ros::Publisher pub_navdata_pwm;
	bool enabled_navdata_pwm;
	ardrone_autonomy::navdata_pwm navdata_pwm_msg;
	ros::Publisher pub_navdata_altitude;
	bool enabled_navdata_altitude;
	ardrone_autonomy::navdata_altitude navdata_altitude_msg;
	ros::Publisher pub_navdata_vision_raw;
	bool enabled_navdata_vision_raw;
	ardrone_autonomy::navdata_vision_raw navdata_vision_raw_msg;
	ros::Publisher pub_navdata_vision_of;
	bool enabled_navdata_vision_of;
	ardrone_autonomy::navdata_vision_of navdata_vision_of_msg;
	ros::Publisher pub_navdata_vision;
	bool enabled_navdata_vision;
	ardrone_autonomy::navdata_vision navdata_vision_msg;
	ros::Publisher pub_navdata_vision_perf;
	bool enabled_navdata_vision_perf;
	ardrone_autonomy::navdata_vision_perf navdata_vision_perf_msg;
	ros::Publisher pub_navdata_trackers_send;
	bool enabled_navdata_trackers_send;
	ardrone_autonomy::navdata_trackers_send navdata_trackers_send_msg;
	ros::Publisher pub_navdata_vision_detect;
	bool enabled_navdata_vision_detect;
	ardrone_autonomy::navdata_vision_detect navdata_vision_detect_msg;
	ros::Publisher pub_navdata_watchdog;
	bool enabled_navdata_watchdog;
	ardrone_autonomy::navdata_watchdog navdata_watchdog_msg;
	ros::Publisher pub_navdata_adc_data_frame;
	bool enabled_navdata_adc_data_frame;
	ardrone_autonomy::navdata_adc_data_frame navdata_adc_data_frame_msg;
	ros::Publisher pub_navdata_video_stream;
	bool enabled_navdata_video_stream;
	ardrone_autonomy::navdata_video_stream navdata_video_stream_msg;
	ros::Publisher pub_navdata_games;
	bool enabled_navdata_games;
	ardrone_autonomy::navdata_games navdata_games_msg;
	ros::Publisher pub_navdata_pressure_raw;
	bool enabled_navdata_pressure_raw;
	ardrone_autonomy::navdata_pressure_raw navdata_pressure_raw_msg;
	ros::Publisher pub_navdata_magneto;
	bool enabled_navdata_magneto;
	ardrone_autonomy::navdata_magneto navdata_magneto_msg;
	ros::Publisher pub_navdata_wind_speed;
	bool enabled_navdata_wind_speed;
	ardrone_autonomy::navdata_wind_speed navdata_wind_speed_msg;
	ros::Publisher pub_navdata_kalman_pressure;
	bool enabled_navdata_kalman_pressure;
	ardrone_autonomy::navdata_kalman_pressure navdata_kalman_pressure_msg;
	ros::Publisher pub_navdata_hdvideo_stream;
	bool enabled_navdata_hdvideo_stream;
	ardrone_autonomy::navdata_hdvideo_stream navdata_hdvideo_stream_msg;
	ros::Publisher pub_navdata_wifi;
	bool enabled_navdata_wifi;
	ardrone_autonomy::navdata_wifi navdata_wifi_msg;
	ros::Publisher pub_navdata_zimmu_3000;
	bool enabled_navdata_zimmu_3000;
	ardrone_autonomy::navdata_zimmu_3000 navdata_zimmu_3000_msg;

	bool enabled_legacy_navdata;

	bool initialized_navdata_publishers;
#endif

#ifdef NAVDATA_STRUCTS_INITIALIZE
	if(!initialized_navdata_publishers)
	{
		initialized_navdata_publishers = true;

		ros::param::param("~enable_legacy_navdata", enabled_legacy_navdata, true);
		if(enabled_legacy_navdata)
		{
      navdata_pub = node_handle.advertise<ardrone_autonomy::Navdata>("ardrone/navdata", 200);
      imu_pub = node_handle.advertise<sensor_msgs::Imu>("ardrone/imu", 200);
      mag_pub = node_handle.advertise<geometry_msgs::Vector3Stamped>("ardrone/mag", 200);
		}
    odo_pub = node_handle.advertise<nav_msgs::Odometry>("ardrone/odometry", 200);

		//-------------------------

		ros::param::param("~enable_navdata_demo", enabled_navdata_demo, false);
		if(enabled_navdata_demo)
		{
			pub_navdata_demo = node_handle.advertise<ardrone_autonomy::navdata_demo>("ardrone/navdata_demo", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_time", enabled_navdata_time, false);
		if(enabled_navdata_time)
		{
			pub_navdata_time = node_handle.advertise<ardrone_autonomy::navdata_time>("ardrone/navdata_time", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_raw_measures", enabled_navdata_raw_measures, false);
		if(enabled_navdata_raw_measures)
		{
			pub_navdata_raw_measures = node_handle.advertise<ardrone_autonomy::navdata_raw_measures>("ardrone/navdata_raw_measures", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_phys_measures", enabled_navdata_phys_measures, false);
		if(enabled_navdata_phys_measures)
		{
			pub_navdata_phys_measures = node_handle.advertise<ardrone_autonomy::navdata_phys_measures>("ardrone/navdata_phys_measures", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_gyros_offsets", enabled_navdata_gyros_offsets, false);
		if(enabled_navdata_gyros_offsets)
		{
			pub_navdata_gyros_offsets = node_handle.advertise<ardrone_autonomy::navdata_gyros_offsets>("ardrone/navdata_gyros_offsets", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_euler_angles", enabled_navdata_euler_angles, false);
		if(enabled_navdata_euler_angles)
		{
			pub_navdata_euler_angles = node_handle.advertise<ardrone_autonomy::navdata_euler_angles>("ardrone/navdata_euler_angles", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_references", enabled_navdata_references, false);
		if(enabled_navdata_references)
		{
			pub_navdata_references = node_handle.advertise<ardrone_autonomy::navdata_references>("ardrone/navdata_references", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_trims", enabled_navdata_trims, false);
		if(enabled_navdata_trims)
		{
			pub_navdata_trims = node_handle.advertise<ardrone_autonomy::navdata_trims>("ardrone/navdata_trims", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_rc_references", enabled_navdata_rc_references, false);
		if(enabled_navdata_rc_references)
		{
			pub_navdata_rc_references = node_handle.advertise<ardrone_autonomy::navdata_rc_references>("ardrone/navdata_rc_references", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_pwm", enabled_navdata_pwm, false);
		if(enabled_navdata_pwm)
		{
			pub_navdata_pwm = node_handle.advertise<ardrone_autonomy::navdata_pwm>("ardrone/navdata_pwm", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_altitude", enabled_navdata_altitude, false);
		if(enabled_navdata_altitude)
		{
			pub_navdata_altitude = node_handle.advertise<ardrone_autonomy::navdata_altitude>("ardrone/navdata_altitude", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_vision_raw", enabled_navdata_vision_raw, false);
		if(enabled_navdata_vision_raw)
		{
			pub_navdata_vision_raw = node_handle.advertise<ardrone_autonomy::navdata_vision_raw>("ardrone/navdata_vision_raw", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_vision_of", enabled_navdata_vision_of, false);
		if(enabled_navdata_vision_of)
		{
			pub_navdata_vision_of = node_handle.advertise<ardrone_autonomy::navdata_vision_of>("ardrone/navdata_vision_of", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_vision", enabled_navdata_vision, false);
		if(enabled_navdata_vision)
		{
			pub_navdata_vision = node_handle.advertise<ardrone_autonomy::navdata_vision>("ardrone/navdata_vision", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_vision_perf", enabled_navdata_vision_perf, false);
		if(enabled_navdata_vision_perf)
		{
			pub_navdata_vision_perf = node_handle.advertise<ardrone_autonomy::navdata_vision_perf>("ardrone/navdata_vision_perf", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_trackers_send", enabled_navdata_trackers_send, false);
		if(enabled_navdata_trackers_send)
		{
			pub_navdata_trackers_send = node_handle.advertise<ardrone_autonomy::navdata_trackers_send>("ardrone/navdata_trackers_send", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_vision_detect", enabled_navdata_vision_detect, false);
		if(enabled_navdata_vision_detect)
		{
			pub_navdata_vision_detect = node_handle.advertise<ardrone_autonomy::navdata_vision_detect>("ardrone/navdata_vision_detect", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_watchdog", enabled_navdata_watchdog, false);
		if(enabled_navdata_watchdog)
		{
			pub_navdata_watchdog = node_handle.advertise<ardrone_autonomy::navdata_watchdog>("ardrone/navdata_watchdog", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_adc_data_frame", enabled_navdata_adc_data_frame, false);
		if(enabled_navdata_adc_data_frame)
		{
			pub_navdata_adc_data_frame = node_handle.advertise<ardrone_autonomy::navdata_adc_data_frame>("ardrone/navdata_adc_data_frame", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_video_stream", enabled_navdata_video_stream, false);
		if(enabled_navdata_video_stream)
		{
			pub_navdata_video_stream = node_handle.advertise<ardrone_autonomy::navdata_video_stream>("ardrone/navdata_video_stream", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_games", enabled_navdata_games, false);
		if(enabled_navdata_games)
		{
			pub_navdata_games = node_handle.advertise<ardrone_autonomy::navdata_games>("ardrone/navdata_games", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_pressure_raw", enabled_navdata_pressure_raw, false);
		if(enabled_navdata_pressure_raw)
		{
			pub_navdata_pressure_raw = node_handle.advertise<ardrone_autonomy::navdata_pressure_raw>("ardrone/navdata_pressure_raw", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_magneto", enabled_navdata_magneto, false);
		if(enabled_navdata_magneto)
		{
			pub_navdata_magneto = node_handle.advertise<ardrone_autonomy::navdata_magneto>("ardrone/navdata_magneto", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_wind_speed", enabled_navdata_wind_speed, false);
		if(enabled_navdata_wind_speed)
		{
			pub_navdata_wind_speed = node_handle.advertise<ardrone_autonomy::navdata_wind_speed>("ardrone/navdata_wind_speed", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_kalman_pressure", enabled_navdata_kalman_pressure, false);
		if(enabled_navdata_kalman_pressure)
		{
			pub_navdata_kalman_pressure = node_handle.advertise<ardrone_autonomy::navdata_kalman_pressure>("ardrone/navdata_kalman_pressure", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_hdvideo_stream", enabled_navdata_hdvideo_stream, false);
		if(enabled_navdata_hdvideo_stream)
		{
			pub_navdata_hdvideo_stream = node_handle.advertise<ardrone_autonomy::navdata_hdvideo_stream>("ardrone/navdata_hdvideo_stream", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_wifi", enabled_navdata_wifi, false);
		if(enabled_navdata_wifi)
		{
			pub_navdata_wifi = node_handle.advertise<ardrone_autonomy::navdata_wifi>("ardrone/navdata_wifi", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

		ros::param::param("~enable_navdata_zimmu_3000", enabled_navdata_zimmu_3000, false);
		if(enabled_navdata_zimmu_3000)
		{
			pub_navdata_zimmu_3000 = node_handle.advertise<ardrone_autonomy::navdata_zimmu_3000>("ardrone/navdata_zimmu_3000", NAVDATA_QUEUE_SIZE);
		}

		//-------------------------

	}
#endif

#ifdef NAVDATA_STRUCTS_SOURCE
void ARDroneDriver::PublishNavdataTypes(const navdata_unpacked_t &n, const ros::Time &received)
{
	if(initialized_navdata_publishers)
	{
		if(enabled_navdata_demo && pub_navdata_demo.getNumSubscribers()>0)
		{
			navdata_demo_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_demo_msg.header.stamp = received;
      navdata_demo_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_demo.tag;
			uint16_t m;
			m = c;

				navdata_demo_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_demo.size;
			uint16_t m;
			m = c;

				navdata_demo_msg.size = m;
			}

			{				
			uint32_t c = n.navdata_demo.ctrl_state;
			uint32_t m;
			m = c;

				navdata_demo_msg.ctrl_state = m;
			}

			{				
			uint32_t c = n.navdata_demo.vbat_flying_percentage;
			uint32_t m;
			m = c;

				navdata_demo_msg.vbat_flying_percentage = m;
			}

			{				
			float32_t c = n.navdata_demo.theta;
			float32_t m;
			m = c;

				navdata_demo_msg.theta = m;
			}

			{				
			float32_t c = n.navdata_demo.phi;
			float32_t m;
			m = c;

				navdata_demo_msg.phi = m;
			}

			{				
			float32_t c = n.navdata_demo.psi;
			float32_t m;
			m = c;

				navdata_demo_msg.psi = m;
			}

			{				
			int32_t c = n.navdata_demo.altitude;
			int32_t m;
			m = c;

				navdata_demo_msg.altitude = m;
			}

			{				
			float32_t c = n.navdata_demo.vx;
			float32_t m;
			m = c;

				navdata_demo_msg.vx = m;
			}

			{				
			float32_t c = n.navdata_demo.vy;
			float32_t m;
			m = c;

				navdata_demo_msg.vy = m;
			}

			{				
			float32_t c = n.navdata_demo.vz;
			float32_t m;
			m = c;

				navdata_demo_msg.vz = m;
			}

			{				
			uint32_t c = n.navdata_demo.num_frames;
			uint32_t m;
			m = c;

				navdata_demo_msg.num_frames = m;
			}

			{				
			uint32_t c = n.navdata_demo.detection_camera_type;
			uint32_t m;
			m = c;

				navdata_demo_msg.detection_camera_type = m;
			}

			pub_navdata_demo.publish(navdata_demo_msg);
		}

		//-------------------------

		if(enabled_navdata_time && pub_navdata_time.getNumSubscribers()>0)
		{
			navdata_time_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_time_msg.header.stamp = received;
      navdata_time_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_time.tag;
			uint16_t m;
			m = c;

				navdata_time_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_time.size;
			uint16_t m;
			m = c;

				navdata_time_msg.size = m;
			}

			{				
			uint32_t c = n.navdata_time.time;
			uint32_t m;
			m = c;

				navdata_time_msg.time = m;
			}

			pub_navdata_time.publish(navdata_time_msg);
		}

		//-------------------------

		if(enabled_navdata_raw_measures && pub_navdata_raw_measures.getNumSubscribers()>0)
		{
			navdata_raw_measures_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_raw_measures_msg.header.stamp = received;
      navdata_raw_measures_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_raw_measures.tag;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_raw_measures.size;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.size = m;
			}

			navdata_raw_measures_msg.raw_gyros.clear();
			for(int i=0; i<NB_GYROS; i++)
			{				
			int16_t c = n.navdata_raw_measures.raw_gyros[i];
			int16_t m;
			m = c;

				navdata_raw_measures_msg.raw_gyros.push_back(m);
			}
			
			navdata_raw_measures_msg.raw_gyros_110.clear();
			for(int i=0; i<2; i++)
			{				
			int16_t c = n.navdata_raw_measures.raw_gyros_110[i];
			int16_t m;
			m = c;

				navdata_raw_measures_msg.raw_gyros_110.push_back(m);
			}
			
			{				
			uint32_t c = n.navdata_raw_measures.vbat_raw;
			uint32_t m;
			m = c;

				navdata_raw_measures_msg.vbat_raw = m;
			}

			{				
			uint16_t c = n.navdata_raw_measures.us_debut_echo;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.us_debut_echo = m;
			}

			{				
			uint16_t c = n.navdata_raw_measures.us_fin_echo;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.us_fin_echo = m;
			}

			{				
			uint16_t c = n.navdata_raw_measures.us_association_echo;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.us_association_echo = m;
			}

			{				
			uint16_t c = n.navdata_raw_measures.us_distance_echo;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.us_distance_echo = m;
			}

			{				
			uint16_t c = n.navdata_raw_measures.us_courbe_temps;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.us_courbe_temps = m;
			}

			{				
			uint16_t c = n.navdata_raw_measures.us_courbe_valeur;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.us_courbe_valeur = m;
			}

			{				
			uint16_t c = n.navdata_raw_measures.us_courbe_ref;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.us_courbe_ref = m;
			}

			{				
			uint16_t c = n.navdata_raw_measures.flag_echo_ini;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.flag_echo_ini = m;
			}

			{				
			uint16_t c = n.navdata_raw_measures.nb_echo;
			uint16_t m;
			m = c;

				navdata_raw_measures_msg.nb_echo = m;
			}

			{				
			uint32_t c = n.navdata_raw_measures.sum_echo;
			uint32_t m;
			m = c;

				navdata_raw_measures_msg.sum_echo = m;
			}

			{				
			int32_t c = n.navdata_raw_measures.alt_temp_raw;
			int32_t m;
			m = c;

				navdata_raw_measures_msg.alt_temp_raw = m;
			}

			{				
			int16_t c = n.navdata_raw_measures.gradient;
			int16_t m;
			m = c;

				navdata_raw_measures_msg.gradient = m;
			}

			pub_navdata_raw_measures.publish(navdata_raw_measures_msg);
		}

		//-------------------------

		if(enabled_navdata_phys_measures && pub_navdata_phys_measures.getNumSubscribers()>0)
		{
			navdata_phys_measures_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_phys_measures_msg.header.stamp = received;
      navdata_phys_measures_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_phys_measures.tag;
			uint16_t m;
			m = c;

				navdata_phys_measures_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_phys_measures.size;
			uint16_t m;
			m = c;

				navdata_phys_measures_msg.size = m;
			}

			{				
			float32_t c = n.navdata_phys_measures.accs_temp;
			float32_t m;
			m = c;

				navdata_phys_measures_msg.accs_temp = m;
			}

			{				
			uint16_t c = n.navdata_phys_measures.gyro_temp;
			uint16_t m;
			m = c;

				navdata_phys_measures_msg.gyro_temp = m;
			}

			navdata_phys_measures_msg.phys_accs.clear();
			for(int i=0; i<NB_ACCS; i++)
			{				
			float32_t c = n.navdata_phys_measures.phys_accs[i];
			float32_t m;
			m = c;

				navdata_phys_measures_msg.phys_accs.push_back(m);
			}
			
			navdata_phys_measures_msg.phys_gyros.clear();
			for(int i=0; i<NB_GYROS; i++)
			{				
			float32_t c = n.navdata_phys_measures.phys_gyros[i];
			float32_t m;
			m = c;

				navdata_phys_measures_msg.phys_gyros.push_back(m);
			}
			
			{				
			uint32_t c = n.navdata_phys_measures.alim3V3;
			uint32_t m;
			m = c;

				navdata_phys_measures_msg.alim3V3 = m;
			}

			{				
			uint32_t c = n.navdata_phys_measures.vrefEpson;
			uint32_t m;
			m = c;

				navdata_phys_measures_msg.vrefEpson = m;
			}

			{				
			uint32_t c = n.navdata_phys_measures.vrefIDG;
			uint32_t m;
			m = c;

				navdata_phys_measures_msg.vrefIDG = m;
			}

			pub_navdata_phys_measures.publish(navdata_phys_measures_msg);
		}

		//-------------------------

		if(enabled_navdata_gyros_offsets && pub_navdata_gyros_offsets.getNumSubscribers()>0)
		{
			navdata_gyros_offsets_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_gyros_offsets_msg.header.stamp = received;
      navdata_gyros_offsets_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_gyros_offsets.tag;
			uint16_t m;
			m = c;

				navdata_gyros_offsets_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_gyros_offsets.size;
			uint16_t m;
			m = c;

				navdata_gyros_offsets_msg.size = m;
			}

			navdata_gyros_offsets_msg.offset_g.clear();
			for(int i=0; i<NB_GYROS; i++)
			{				
			float32_t c = n.navdata_gyros_offsets.offset_g[i];
			float32_t m;
			m = c;

				navdata_gyros_offsets_msg.offset_g.push_back(m);
			}
			
			pub_navdata_gyros_offsets.publish(navdata_gyros_offsets_msg);
		}

		//-------------------------

		if(enabled_navdata_euler_angles && pub_navdata_euler_angles.getNumSubscribers()>0)
		{
			navdata_euler_angles_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_euler_angles_msg.header.stamp = received;
      navdata_euler_angles_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_euler_angles.tag;
			uint16_t m;
			m = c;

				navdata_euler_angles_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_euler_angles.size;
			uint16_t m;
			m = c;

				navdata_euler_angles_msg.size = m;
			}

			{				
			float32_t c = n.navdata_euler_angles.theta_a;
			float32_t m;
			m = c;

				navdata_euler_angles_msg.theta_a = m;
			}

			{				
			float32_t c = n.navdata_euler_angles.phi_a;
			float32_t m;
			m = c;

				navdata_euler_angles_msg.phi_a = m;
			}

			pub_navdata_euler_angles.publish(navdata_euler_angles_msg);
		}

		//-------------------------

		if(enabled_navdata_references && pub_navdata_references.getNumSubscribers()>0)
		{
			navdata_references_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_references_msg.header.stamp = received;
      navdata_references_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_references.tag;
			uint16_t m;
			m = c;

				navdata_references_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_references.size;
			uint16_t m;
			m = c;

				navdata_references_msg.size = m;
			}

			{				
			int32_t c = n.navdata_references.ref_theta;
			int32_t m;
			m = c;

				navdata_references_msg.ref_theta = m;
			}

			{				
			int32_t c = n.navdata_references.ref_phi;
			int32_t m;
			m = c;

				navdata_references_msg.ref_phi = m;
			}

			{				
			int32_t c = n.navdata_references.ref_theta_I;
			int32_t m;
			m = c;

				navdata_references_msg.ref_theta_I = m;
			}

			{				
			int32_t c = n.navdata_references.ref_phi_I;
			int32_t m;
			m = c;

				navdata_references_msg.ref_phi_I = m;
			}

			{				
			int32_t c = n.navdata_references.ref_pitch;
			int32_t m;
			m = c;

				navdata_references_msg.ref_pitch = m;
			}

			{				
			int32_t c = n.navdata_references.ref_roll;
			int32_t m;
			m = c;

				navdata_references_msg.ref_roll = m;
			}

			{				
			int32_t c = n.navdata_references.ref_yaw;
			int32_t m;
			m = c;

				navdata_references_msg.ref_yaw = m;
			}

			{				
			int32_t c = n.navdata_references.ref_psi;
			int32_t m;
			m = c;

				navdata_references_msg.ref_psi = m;
			}

			{				
			float32_t c = n.navdata_references.vx_ref;
			float32_t m;
			m = c;

				navdata_references_msg.vx_ref = m;
			}

			{				
			float32_t c = n.navdata_references.vy_ref;
			float32_t m;
			m = c;

				navdata_references_msg.vy_ref = m;
			}

			{				
			float32_t c = n.navdata_references.theta_mod;
			float32_t m;
			m = c;

				navdata_references_msg.theta_mod = m;
			}

			{				
			float32_t c = n.navdata_references.phi_mod;
			float32_t m;
			m = c;

				navdata_references_msg.phi_mod = m;
			}

			{				
			float32_t c = n.navdata_references.k_v_x;
			float32_t m;
			m = c;

				navdata_references_msg.k_v_x = m;
			}

			{				
			float32_t c = n.navdata_references.k_v_y;
			float32_t m;
			m = c;

				navdata_references_msg.k_v_y = m;
			}

			{				
			uint32_t c = n.navdata_references.k_mode;
			uint32_t m;
			m = c;

				navdata_references_msg.k_mode = m;
			}

			{				
			float32_t c = n.navdata_references.ui_time;
			float32_t m;
			m = c;

				navdata_references_msg.ui_time = m;
			}

			{				
			float32_t c = n.navdata_references.ui_theta;
			float32_t m;
			m = c;

				navdata_references_msg.ui_theta = m;
			}

			{				
			float32_t c = n.navdata_references.ui_phi;
			float32_t m;
			m = c;

				navdata_references_msg.ui_phi = m;
			}

			{				
			float32_t c = n.navdata_references.ui_psi;
			float32_t m;
			m = c;

				navdata_references_msg.ui_psi = m;
			}

			{				
			float32_t c = n.navdata_references.ui_psi_accuracy;
			float32_t m;
			m = c;

				navdata_references_msg.ui_psi_accuracy = m;
			}

			{				
			int32_t c = n.navdata_references.ui_seq;
			int32_t m;
			m = c;

				navdata_references_msg.ui_seq = m;
			}

			pub_navdata_references.publish(navdata_references_msg);
		}

		//-------------------------

		if(enabled_navdata_trims && pub_navdata_trims.getNumSubscribers()>0)
		{
			navdata_trims_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_trims_msg.header.stamp = received;
      navdata_trims_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_trims.tag;
			uint16_t m;
			m = c;

				navdata_trims_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_trims.size;
			uint16_t m;
			m = c;

				navdata_trims_msg.size = m;
			}

			{				
			float32_t c = n.navdata_trims.angular_rates_trim_r;
			float32_t m;
			m = c;

				navdata_trims_msg.angular_rates_trim_r = m;
			}

			{				
			float32_t c = n.navdata_trims.euler_angles_trim_theta;
			float32_t m;
			m = c;

				navdata_trims_msg.euler_angles_trim_theta = m;
			}

			{				
			float32_t c = n.navdata_trims.euler_angles_trim_phi;
			float32_t m;
			m = c;

				navdata_trims_msg.euler_angles_trim_phi = m;
			}

			pub_navdata_trims.publish(navdata_trims_msg);
		}

		//-------------------------

		if(enabled_navdata_rc_references && pub_navdata_rc_references.getNumSubscribers()>0)
		{
			navdata_rc_references_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_rc_references_msg.header.stamp = received;
      navdata_rc_references_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_rc_references.tag;
			uint16_t m;
			m = c;

				navdata_rc_references_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_rc_references.size;
			uint16_t m;
			m = c;

				navdata_rc_references_msg.size = m;
			}

			{				
			int32_t c = n.navdata_rc_references.rc_ref_pitch;
			int32_t m;
			m = c;

				navdata_rc_references_msg.rc_ref_pitch = m;
			}

			{				
			int32_t c = n.navdata_rc_references.rc_ref_roll;
			int32_t m;
			m = c;

				navdata_rc_references_msg.rc_ref_roll = m;
			}

			{				
			int32_t c = n.navdata_rc_references.rc_ref_yaw;
			int32_t m;
			m = c;

				navdata_rc_references_msg.rc_ref_yaw = m;
			}

			{				
			int32_t c = n.navdata_rc_references.rc_ref_gaz;
			int32_t m;
			m = c;

				navdata_rc_references_msg.rc_ref_gaz = m;
			}

			{				
			int32_t c = n.navdata_rc_references.rc_ref_ag;
			int32_t m;
			m = c;

				navdata_rc_references_msg.rc_ref_ag = m;
			}

			pub_navdata_rc_references.publish(navdata_rc_references_msg);
		}

		//-------------------------

		if(enabled_navdata_pwm && pub_navdata_pwm.getNumSubscribers()>0)
		{
			navdata_pwm_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_pwm_msg.header.stamp = received;
      navdata_pwm_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_pwm.tag;
			uint16_t m;
			m = c;

				navdata_pwm_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_pwm.size;
			uint16_t m;
			m = c;

				navdata_pwm_msg.size = m;
			}

			{				
			uint8_t c = n.navdata_pwm.motor1;
			uint8_t m;
			m = c;

				navdata_pwm_msg.motor1 = m;
			}

			{				
			uint8_t c = n.navdata_pwm.motor2;
			uint8_t m;
			m = c;

				navdata_pwm_msg.motor2 = m;
			}

			{				
			uint8_t c = n.navdata_pwm.motor3;
			uint8_t m;
			m = c;

				navdata_pwm_msg.motor3 = m;
			}

			{				
			uint8_t c = n.navdata_pwm.motor4;
			uint8_t m;
			m = c;

				navdata_pwm_msg.motor4 = m;
			}

			{				
			uint8_t c = n.navdata_pwm.sat_motor1;
			uint8_t m;
			m = c;

				navdata_pwm_msg.sat_motor1 = m;
			}

			{				
			uint8_t c = n.navdata_pwm.sat_motor2;
			uint8_t m;
			m = c;

				navdata_pwm_msg.sat_motor2 = m;
			}

			{				
			uint8_t c = n.navdata_pwm.sat_motor3;
			uint8_t m;
			m = c;

				navdata_pwm_msg.sat_motor3 = m;
			}

			{				
			uint8_t c = n.navdata_pwm.sat_motor4;
			uint8_t m;
			m = c;

				navdata_pwm_msg.sat_motor4 = m;
			}

			{				
			float32_t c = n.navdata_pwm.gaz_feed_forward;
			float32_t m;
			m = c;

				navdata_pwm_msg.gaz_feed_forward = m;
			}

			{				
			float32_t c = n.navdata_pwm.gaz_altitude;
			float32_t m;
			m = c;

				navdata_pwm_msg.gaz_altitude = m;
			}

			{				
			float32_t c = n.navdata_pwm.altitude_integral;
			float32_t m;
			m = c;

				navdata_pwm_msg.altitude_integral = m;
			}

			{				
			float32_t c = n.navdata_pwm.vz_ref;
			float32_t m;
			m = c;

				navdata_pwm_msg.vz_ref = m;
			}

			{				
			int32_t c = n.navdata_pwm.u_pitch;
			int32_t m;
			m = c;

				navdata_pwm_msg.u_pitch = m;
			}

			{				
			int32_t c = n.navdata_pwm.u_roll;
			int32_t m;
			m = c;

				navdata_pwm_msg.u_roll = m;
			}

			{				
			int32_t c = n.navdata_pwm.u_yaw;
			int32_t m;
			m = c;

				navdata_pwm_msg.u_yaw = m;
			}

			{				
			float32_t c = n.navdata_pwm.yaw_u_I;
			float32_t m;
			m = c;

				navdata_pwm_msg.yaw_u_I = m;
			}

			{				
			int32_t c = n.navdata_pwm.u_pitch_planif;
			int32_t m;
			m = c;

				navdata_pwm_msg.u_pitch_planif = m;
			}

			{				
			int32_t c = n.navdata_pwm.u_roll_planif;
			int32_t m;
			m = c;

				navdata_pwm_msg.u_roll_planif = m;
			}

			{				
			int32_t c = n.navdata_pwm.u_yaw_planif;
			int32_t m;
			m = c;

				navdata_pwm_msg.u_yaw_planif = m;
			}

			{				
			float32_t c = n.navdata_pwm.u_gaz_planif;
			float32_t m;
			m = c;

				navdata_pwm_msg.u_gaz_planif = m;
			}

			{				
			uint16_t c = n.navdata_pwm.current_motor1;
			uint16_t m;
			m = c;

				navdata_pwm_msg.current_motor1 = m;
			}

			{				
			uint16_t c = n.navdata_pwm.current_motor2;
			uint16_t m;
			m = c;

				navdata_pwm_msg.current_motor2 = m;
			}

			{				
			uint16_t c = n.navdata_pwm.current_motor3;
			uint16_t m;
			m = c;

				navdata_pwm_msg.current_motor3 = m;
			}

			{				
			uint16_t c = n.navdata_pwm.current_motor4;
			uint16_t m;
			m = c;

				navdata_pwm_msg.current_motor4 = m;
			}

			{				
			float32_t c = n.navdata_pwm.altitude_der;
			float32_t m;
			m = c;

				navdata_pwm_msg.altitude_der = m;
			}

			pub_navdata_pwm.publish(navdata_pwm_msg);
		}

		//-------------------------

		if(enabled_navdata_altitude && pub_navdata_altitude.getNumSubscribers()>0)
		{
			navdata_altitude_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_altitude_msg.header.stamp = received;
      navdata_altitude_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_altitude.tag;
			uint16_t m;
			m = c;

				navdata_altitude_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_altitude.size;
			uint16_t m;
			m = c;

				navdata_altitude_msg.size = m;
			}

			{				
			int32_t c = n.navdata_altitude.altitude_vision;
			int32_t m;
			m = c;

				navdata_altitude_msg.altitude_vision = m;
			}

			{				
			float32_t c = n.navdata_altitude.altitude_vz;
			float32_t m;
			m = c;

				navdata_altitude_msg.altitude_vz = m;
			}

			{				
			int32_t c = n.navdata_altitude.altitude_ref;
			int32_t m;
			m = c;

				navdata_altitude_msg.altitude_ref = m;
			}

			{				
			int32_t c = n.navdata_altitude.altitude_raw;
			int32_t m;
			m = c;

				navdata_altitude_msg.altitude_raw = m;
			}

			{				
			float32_t c = n.navdata_altitude.obs_accZ;
			float32_t m;
			m = c;

				navdata_altitude_msg.obs_accZ = m;
			}

			{				
			float32_t c = n.navdata_altitude.obs_alt;
			float32_t m;
			m = c;

				navdata_altitude_msg.obs_alt = m;
			}

			{				
			vector31_t c = n.navdata_altitude.obs_x;
			ardrone_autonomy::vector31 m;
			m.x = c.x;
			m.y = c.y;
			m.z = c.z;

				navdata_altitude_msg.obs_x = m;
			}

			{				
			uint32_t c = n.navdata_altitude.obs_state;
			uint32_t m;
			m = c;

				navdata_altitude_msg.obs_state = m;
			}

			{				
			vector21_t c = n.navdata_altitude.est_vb;
			ardrone_autonomy::vector21 m;
			m.x = c.x;
			m.y = c.y;

				navdata_altitude_msg.est_vb = m;
			}

			{				
			uint32_t c = n.navdata_altitude.est_state;
			uint32_t m;
			m = c;

				navdata_altitude_msg.est_state = m;
			}

			pub_navdata_altitude.publish(navdata_altitude_msg);
		}

		//-------------------------

		if(enabled_navdata_vision_raw && pub_navdata_vision_raw.getNumSubscribers()>0)
		{
			navdata_vision_raw_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_vision_raw_msg.header.stamp = received;
      navdata_vision_raw_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_vision_raw.tag;
			uint16_t m;
			m = c;

				navdata_vision_raw_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_vision_raw.size;
			uint16_t m;
			m = c;

				navdata_vision_raw_msg.size = m;
			}

			{				
			float32_t c = n.navdata_vision_raw.vision_tx_raw;
			float32_t m;
			m = c;

				navdata_vision_raw_msg.vision_tx_raw = m;
			}

			{				
			float32_t c = n.navdata_vision_raw.vision_ty_raw;
			float32_t m;
			m = c;

				navdata_vision_raw_msg.vision_ty_raw = m;
			}

			{				
			float32_t c = n.navdata_vision_raw.vision_tz_raw;
			float32_t m;
			m = c;

				navdata_vision_raw_msg.vision_tz_raw = m;
			}

			pub_navdata_vision_raw.publish(navdata_vision_raw_msg);
		}

		//-------------------------

		if(enabled_navdata_vision_of && pub_navdata_vision_of.getNumSubscribers()>0)
		{
			navdata_vision_of_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_vision_of_msg.header.stamp = received;
      navdata_vision_of_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_vision_of.tag;
			uint16_t m;
			m = c;

				navdata_vision_of_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_vision_of.size;
			uint16_t m;
			m = c;

				navdata_vision_of_msg.size = m;
			}

			navdata_vision_of_msg.of_dx.clear();
			for(int i=0; i<5; i++)
			{				
			float32_t c = n.navdata_vision_of.of_dx[i];
			float32_t m;
			m = c;

				navdata_vision_of_msg.of_dx.push_back(m);
			}
			
			navdata_vision_of_msg.of_dy.clear();
			for(int i=0; i<5; i++)
			{				
			float32_t c = n.navdata_vision_of.of_dy[i];
			float32_t m;
			m = c;

				navdata_vision_of_msg.of_dy.push_back(m);
			}
			
			pub_navdata_vision_of.publish(navdata_vision_of_msg);
		}

		//-------------------------

		if(enabled_navdata_vision && pub_navdata_vision.getNumSubscribers()>0)
		{
			navdata_vision_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_vision_msg.header.stamp = received;
      navdata_vision_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_vision.tag;
			uint16_t m;
			m = c;

				navdata_vision_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_vision.size;
			uint16_t m;
			m = c;

				navdata_vision_msg.size = m;
			}

			{				
			uint32_t c = n.navdata_vision.vision_state;
			uint32_t m;
			m = c;

				navdata_vision_msg.vision_state = m;
			}

			{				
			int32_t c = n.navdata_vision.vision_misc;
			int32_t m;
			m = c;

				navdata_vision_msg.vision_misc = m;
			}

			{				
			float32_t c = n.navdata_vision.vision_phi_trim;
			float32_t m;
			m = c;

				navdata_vision_msg.vision_phi_trim = m;
			}

			{				
			float32_t c = n.navdata_vision.vision_phi_ref_prop;
			float32_t m;
			m = c;

				navdata_vision_msg.vision_phi_ref_prop = m;
			}

			{				
			float32_t c = n.navdata_vision.vision_theta_trim;
			float32_t m;
			m = c;

				navdata_vision_msg.vision_theta_trim = m;
			}

			{				
			float32_t c = n.navdata_vision.vision_theta_ref_prop;
			float32_t m;
			m = c;

				navdata_vision_msg.vision_theta_ref_prop = m;
			}

			{				
			int32_t c = n.navdata_vision.new_raw_picture;
			int32_t m;
			m = c;

				navdata_vision_msg.new_raw_picture = m;
			}

			{				
			float32_t c = n.navdata_vision.theta_capture;
			float32_t m;
			m = c;

				navdata_vision_msg.theta_capture = m;
			}

			{				
			float32_t c = n.navdata_vision.phi_capture;
			float32_t m;
			m = c;

				navdata_vision_msg.phi_capture = m;
			}

			{				
			float32_t c = n.navdata_vision.psi_capture;
			float32_t m;
			m = c;

				navdata_vision_msg.psi_capture = m;
			}

			{				
			int32_t c = n.navdata_vision.altitude_capture;
			int32_t m;
			m = c;

				navdata_vision_msg.altitude_capture = m;
			}

			{				
			uint32_t c = n.navdata_vision.time_capture;
			uint32_t m;
			m = c;

				navdata_vision_msg.time_capture = m;
			}

			{				
			velocities_t c = n.navdata_vision.body_v;
			ardrone_autonomy::vector31 m;
			m.x = c.x;
			m.y = c.y;
			m.z = c.z;

				navdata_vision_msg.body_v = m;
			}

			{				
			float32_t c = n.navdata_vision.delta_phi;
			float32_t m;
			m = c;

				navdata_vision_msg.delta_phi = m;
			}

			{				
			float32_t c = n.navdata_vision.delta_theta;
			float32_t m;
			m = c;

				navdata_vision_msg.delta_theta = m;
			}

			{				
			float32_t c = n.navdata_vision.delta_psi;
			float32_t m;
			m = c;

				navdata_vision_msg.delta_psi = m;
			}

			{				
			uint32_t c = n.navdata_vision.gold_defined;
			uint32_t m;
			m = c;

				navdata_vision_msg.gold_defined = m;
			}

			{				
			uint32_t c = n.navdata_vision.gold_reset;
			uint32_t m;
			m = c;

				navdata_vision_msg.gold_reset = m;
			}

			{				
			float32_t c = n.navdata_vision.gold_x;
			float32_t m;
			m = c;

				navdata_vision_msg.gold_x = m;
			}

			{				
			float32_t c = n.navdata_vision.gold_y;
			float32_t m;
			m = c;

				navdata_vision_msg.gold_y = m;
			}

			pub_navdata_vision.publish(navdata_vision_msg);
		}

		//-------------------------

		if(enabled_navdata_vision_perf && pub_navdata_vision_perf.getNumSubscribers()>0)
		{
			navdata_vision_perf_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_vision_perf_msg.header.stamp = received;
      navdata_vision_perf_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_vision_perf.tag;
			uint16_t m;
			m = c;

				navdata_vision_perf_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_vision_perf.size;
			uint16_t m;
			m = c;

				navdata_vision_perf_msg.size = m;
			}

			{				
			float32_t c = n.navdata_vision_perf.time_corners;
			float32_t m;
			m = c;

				navdata_vision_perf_msg.time_corners = m;
			}

			{				
			float32_t c = n.navdata_vision_perf.time_compute;
			float32_t m;
			m = c;

				navdata_vision_perf_msg.time_compute = m;
			}

			{				
			float32_t c = n.navdata_vision_perf.time_tracking;
			float32_t m;
			m = c;

				navdata_vision_perf_msg.time_tracking = m;
			}

			{				
			float32_t c = n.navdata_vision_perf.time_trans;
			float32_t m;
			m = c;

				navdata_vision_perf_msg.time_trans = m;
			}

			{				
			float32_t c = n.navdata_vision_perf.time_update;
			float32_t m;
			m = c;

				navdata_vision_perf_msg.time_update = m;
			}

			navdata_vision_perf_msg.time_custom.clear();
			for(int i=0; i<NAVDATA_MAX_CUSTOM_TIME_SAVE; i++)
			{				
			float32_t c = n.navdata_vision_perf.time_custom[i];
			float32_t m;
			m = c;

				navdata_vision_perf_msg.time_custom.push_back(m);
			}
			
			pub_navdata_vision_perf.publish(navdata_vision_perf_msg);
		}

		//-------------------------

		if(enabled_navdata_trackers_send && pub_navdata_trackers_send.getNumSubscribers()>0)
		{
			navdata_trackers_send_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_trackers_send_msg.header.stamp = received;
      navdata_trackers_send_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_trackers_send.tag;
			uint16_t m;
			m = c;

				navdata_trackers_send_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_trackers_send.size;
			uint16_t m;
			m = c;

				navdata_trackers_send_msg.size = m;
			}

			navdata_trackers_send_msg.locked.clear();
			for(int i=0; i<DEFAULT_NB_TRACKERS_WIDTH * DEFAULT_NB_TRACKERS_HEIGHT; i++)
			{				
			int32_t c = n.navdata_trackers_send.locked[i];
			int32_t m;
			m = c;

				navdata_trackers_send_msg.locked.push_back(m);
			}
			
			navdata_trackers_send_msg.point.clear();
			for(int i=0; i<DEFAULT_NB_TRACKERS_WIDTH * DEFAULT_NB_TRACKERS_HEIGHT; i++)
			{				
			screen_point_t c = n.navdata_trackers_send.point[i];
			ardrone_autonomy::vector21 m;
			m.x = c.x;
			m.y = c.y;

				navdata_trackers_send_msg.point.push_back(m);
			}
			
			pub_navdata_trackers_send.publish(navdata_trackers_send_msg);
		}

		//-------------------------

		if(enabled_navdata_vision_detect && pub_navdata_vision_detect.getNumSubscribers()>0)
		{
			navdata_vision_detect_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_vision_detect_msg.header.stamp = received;
      navdata_vision_detect_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_vision_detect.tag;
			uint16_t m;
			m = c;

				navdata_vision_detect_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_vision_detect.size;
			uint16_t m;
			m = c;

				navdata_vision_detect_msg.size = m;
			}

			{				
			uint32_t c = n.navdata_vision_detect.nb_detected;
			uint32_t m;
			m = c;

				navdata_vision_detect_msg.nb_detected = m;
			}

			navdata_vision_detect_msg.type.clear();
			for(int i=0; i<NB_NAVDATA_DETECTION_RESULTS; i++)
			{				
			uint32_t c = n.navdata_vision_detect.type[i];
			uint32_t m;
			m = c;

				navdata_vision_detect_msg.type.push_back(m);
			}
			
			navdata_vision_detect_msg.xc.clear();
			for(int i=0; i<NB_NAVDATA_DETECTION_RESULTS; i++)
			{				
			uint32_t c = n.navdata_vision_detect.xc[i];
			uint32_t m;
			m = c;

				navdata_vision_detect_msg.xc.push_back(m);
			}
			
			navdata_vision_detect_msg.yc.clear();
			for(int i=0; i<NB_NAVDATA_DETECTION_RESULTS; i++)
			{				
			uint32_t c = n.navdata_vision_detect.yc[i];
			uint32_t m;
			m = c;

				navdata_vision_detect_msg.yc.push_back(m);
			}
			
			navdata_vision_detect_msg.width.clear();
			for(int i=0; i<NB_NAVDATA_DETECTION_RESULTS; i++)
			{				
			uint32_t c = n.navdata_vision_detect.width[i];
			uint32_t m;
			m = c;

				navdata_vision_detect_msg.width.push_back(m);
			}
			
			navdata_vision_detect_msg.height.clear();
			for(int i=0; i<NB_NAVDATA_DETECTION_RESULTS; i++)
			{				
			uint32_t c = n.navdata_vision_detect.height[i];
			uint32_t m;
			m = c;

				navdata_vision_detect_msg.height.push_back(m);
			}
			
			navdata_vision_detect_msg.dist.clear();
			for(int i=0; i<NB_NAVDATA_DETECTION_RESULTS; i++)
			{				
			uint32_t c = n.navdata_vision_detect.dist[i];
			uint32_t m;
			m = c;

				navdata_vision_detect_msg.dist.push_back(m);
			}
			
			navdata_vision_detect_msg.orientation_angle.clear();
			for(int i=0; i<NB_NAVDATA_DETECTION_RESULTS; i++)
			{				
			float32_t c = n.navdata_vision_detect.orientation_angle[i];
			float32_t m;
			m = c;

				navdata_vision_detect_msg.orientation_angle.push_back(m);
			}
			
			navdata_vision_detect_msg.rotation.clear();
			for(int i=0; i<NB_NAVDATA_DETECTION_RESULTS; i++)
			{				
			matrix33_t c = n.navdata_vision_detect.rotation[i];
			ardrone_autonomy::matrix33 m;
			m.m11 = c.m11;
			m.m12 = c.m12;
			m.m13 = c.m13;
			m.m21 = c.m21;
			m.m22 = c.m22;
			m.m23 = c.m23;
			m.m31 = c.m31;
			m.m32 = c.m32;
			m.m33 = c.m33;

				navdata_vision_detect_msg.rotation.push_back(m);
			}
			
			navdata_vision_detect_msg.translation.clear();
			for(int i=0; i<NB_NAVDATA_DETECTION_RESULTS; i++)
			{				
			vector31_t c = n.navdata_vision_detect.translation[i];
			ardrone_autonomy::vector31 m;
			m.x = c.x;
			m.y = c.y;
			m.z = c.z;

				navdata_vision_detect_msg.translation.push_back(m);
			}
			
			navdata_vision_detect_msg.camera_source.clear();
			for(int i=0; i<NB_NAVDATA_DETECTION_RESULTS; i++)
			{				
			uint32_t c = n.navdata_vision_detect.camera_source[i];
			uint32_t m;
			m = c;

				navdata_vision_detect_msg.camera_source.push_back(m);
			}
			
			pub_navdata_vision_detect.publish(navdata_vision_detect_msg);
		}

		//-------------------------

		if(enabled_navdata_watchdog && pub_navdata_watchdog.getNumSubscribers()>0)
		{
			navdata_watchdog_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_watchdog_msg.header.stamp = received;
      navdata_watchdog_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_watchdog.tag;
			uint16_t m;
			m = c;

				navdata_watchdog_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_watchdog.size;
			uint16_t m;
			m = c;

				navdata_watchdog_msg.size = m;
			}

			pub_navdata_watchdog.publish(navdata_watchdog_msg);
		}

		//-------------------------

		if(enabled_navdata_adc_data_frame && pub_navdata_adc_data_frame.getNumSubscribers()>0)
		{
			navdata_adc_data_frame_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_adc_data_frame_msg.header.stamp = received;
      navdata_adc_data_frame_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_adc_data_frame.tag;
			uint16_t m;
			m = c;

				navdata_adc_data_frame_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_adc_data_frame.size;
			uint16_t m;
			m = c;

				navdata_adc_data_frame_msg.size = m;
			}

			{				
			uint32_t c = n.navdata_adc_data_frame.version;
			uint32_t m;
			m = c;

				navdata_adc_data_frame_msg.version = m;
			}

			navdata_adc_data_frame_msg.data_frame.clear();
			for(int i=0; i<32; i++)
			{				
			uint8_t c = n.navdata_adc_data_frame.data_frame[i];
			uint8_t m;
			m = c;

				navdata_adc_data_frame_msg.data_frame.push_back(m);
			}
			
			pub_navdata_adc_data_frame.publish(navdata_adc_data_frame_msg);
		}

		//-------------------------

		if(enabled_navdata_video_stream && pub_navdata_video_stream.getNumSubscribers()>0)
		{
			navdata_video_stream_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_video_stream_msg.header.stamp = received;
      navdata_video_stream_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_video_stream.tag;
			uint16_t m;
			m = c;

				navdata_video_stream_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_video_stream.size;
			uint16_t m;
			m = c;

				navdata_video_stream_msg.size = m;
			}

			{				
			uint8_t c = n.navdata_video_stream.quant;
			uint8_t m;
			m = c;

				navdata_video_stream_msg.quant = m;
			}

			{				
			uint32_t c = n.navdata_video_stream.frame_size;
			uint32_t m;
			m = c;

				navdata_video_stream_msg.frame_size = m;
			}

			{				
			uint32_t c = n.navdata_video_stream.frame_number;
			uint32_t m;
			m = c;

				navdata_video_stream_msg.frame_number = m;
			}

			{				
			uint32_t c = n.navdata_video_stream.atcmd_ref_seq;
			uint32_t m;
			m = c;

				navdata_video_stream_msg.atcmd_ref_seq = m;
			}

			{				
			uint32_t c = n.navdata_video_stream.atcmd_mean_ref_gap;
			uint32_t m;
			m = c;

				navdata_video_stream_msg.atcmd_mean_ref_gap = m;
			}

			{				
			float32_t c = n.navdata_video_stream.atcmd_var_ref_gap;
			float32_t m;
			m = c;

				navdata_video_stream_msg.atcmd_var_ref_gap = m;
			}

			{				
			uint32_t c = n.navdata_video_stream.atcmd_ref_quality;
			uint32_t m;
			m = c;

				navdata_video_stream_msg.atcmd_ref_quality = m;
			}

			{				
			uint32_t c = n.navdata_video_stream.desired_bitrate;
			uint32_t m;
			m = c;

				navdata_video_stream_msg.desired_bitrate = m;
			}

			{				
			int32_t c = n.navdata_video_stream.data2;
			int32_t m;
			m = c;

				navdata_video_stream_msg.data2 = m;
			}

			{				
			int32_t c = n.navdata_video_stream.data3;
			int32_t m;
			m = c;

				navdata_video_stream_msg.data3 = m;
			}

			{				
			int32_t c = n.navdata_video_stream.data4;
			int32_t m;
			m = c;

				navdata_video_stream_msg.data4 = m;
			}

			{				
			int32_t c = n.navdata_video_stream.data5;
			int32_t m;
			m = c;

				navdata_video_stream_msg.data5 = m;
			}

			{				
			uint32_t c = n.navdata_video_stream.fifo_queue_level;
			uint32_t m;
			m = c;

				navdata_video_stream_msg.fifo_queue_level = m;
			}

			pub_navdata_video_stream.publish(navdata_video_stream_msg);
		}

		//-------------------------

		if(enabled_navdata_games && pub_navdata_games.getNumSubscribers()>0)
		{
			navdata_games_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_games_msg.header.stamp = received;
      navdata_games_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_games.tag;
			uint16_t m;
			m = c;

				navdata_games_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_games.size;
			uint16_t m;
			m = c;

				navdata_games_msg.size = m;
			}

			{				
			uint32_t c = n.navdata_games.double_tap_counter;
			uint32_t m;
			m = c;

				navdata_games_msg.double_tap_counter = m;
			}

			{				
			uint32_t c = n.navdata_games.finish_line_counter;
			uint32_t m;
			m = c;

				navdata_games_msg.finish_line_counter = m;
			}

			pub_navdata_games.publish(navdata_games_msg);
		}

		//-------------------------

		if(enabled_navdata_pressure_raw && pub_navdata_pressure_raw.getNumSubscribers()>0)
		{
			navdata_pressure_raw_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_pressure_raw_msg.header.stamp = received;
      navdata_pressure_raw_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_pressure_raw.tag;
			uint16_t m;
			m = c;

				navdata_pressure_raw_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_pressure_raw.size;
			uint16_t m;
			m = c;

				navdata_pressure_raw_msg.size = m;
			}

			{				
			int32_t c = n.navdata_pressure_raw.up;
			int32_t m;
			m = c;

				navdata_pressure_raw_msg.up = m;
			}

			{				
			int16_t c = n.navdata_pressure_raw.ut;
			int16_t m;
			m = c;

				navdata_pressure_raw_msg.ut = m;
			}

			{				
			int32_t c = n.navdata_pressure_raw.Temperature_meas;
			int32_t m;
			m = c;

				navdata_pressure_raw_msg.Temperature_meas = m;
			}

			{				
			int32_t c = n.navdata_pressure_raw.Pression_meas;
			int32_t m;
			m = c;

				navdata_pressure_raw_msg.Pression_meas = m;
			}

			pub_navdata_pressure_raw.publish(navdata_pressure_raw_msg);
		}

		//-------------------------

		if(enabled_navdata_magneto && pub_navdata_magneto.getNumSubscribers()>0)
		{
			navdata_magneto_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_magneto_msg.header.stamp = received;
      navdata_magneto_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_magneto.tag;
			uint16_t m;
			m = c;

				navdata_magneto_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_magneto.size;
			uint16_t m;
			m = c;

				navdata_magneto_msg.size = m;
			}

			{				
			int16_t c = n.navdata_magneto.mx;
			int16_t m;
			m = c;

				navdata_magneto_msg.mx = m;
			}

			{				
			int16_t c = n.navdata_magneto.my;
			int16_t m;
			m = c;

				navdata_magneto_msg.my = m;
			}

			{				
			int16_t c = n.navdata_magneto.mz;
			int16_t m;
			m = c;

				navdata_magneto_msg.mz = m;
			}

			{				
			vector31_t c = n.navdata_magneto.magneto_raw;
			ardrone_autonomy::vector31 m;
			m.x = c.x;
			m.y = c.y;
			m.z = c.z;

				navdata_magneto_msg.magneto_raw = m;
			}

			{				
			vector31_t c = n.navdata_magneto.magneto_rectified;
			ardrone_autonomy::vector31 m;
			m.x = c.x;
			m.y = c.y;
			m.z = c.z;

				navdata_magneto_msg.magneto_rectified = m;
			}

			{				
			vector31_t c = n.navdata_magneto.magneto_offset;
			ardrone_autonomy::vector31 m;
			m.x = c.x;
			m.y = c.y;
			m.z = c.z;

				navdata_magneto_msg.magneto_offset = m;
			}

			{				
			float32_t c = n.navdata_magneto.heading_unwrapped;
			float32_t m;
			m = c;

				navdata_magneto_msg.heading_unwrapped = m;
			}

			{				
			float32_t c = n.navdata_magneto.heading_gyro_unwrapped;
			float32_t m;
			m = c;

				navdata_magneto_msg.heading_gyro_unwrapped = m;
			}

			{				
			float32_t c = n.navdata_magneto.heading_fusion_unwrapped;
			float32_t m;
			m = c;

				navdata_magneto_msg.heading_fusion_unwrapped = m;
			}

			{				
			char c = n.navdata_magneto.magneto_calibration_ok;
			char m;
			m = c;

				navdata_magneto_msg.magneto_calibration_ok = m;
			}

			{				
			uint32_t c = n.navdata_magneto.magneto_state;
			uint32_t m;
			m = c;

				navdata_magneto_msg.magneto_state = m;
			}

			{				
			float32_t c = n.navdata_magneto.magneto_radius;
			float32_t m;
			m = c;

				navdata_magneto_msg.magneto_radius = m;
			}

			{				
			float32_t c = n.navdata_magneto.error_mean;
			float32_t m;
			m = c;

				navdata_magneto_msg.error_mean = m;
			}

			{				
			float32_t c = n.navdata_magneto.error_var;
			float32_t m;
			m = c;

				navdata_magneto_msg.error_var = m;
			}

			pub_navdata_magneto.publish(navdata_magneto_msg);
		}

		//-------------------------

		if(enabled_navdata_wind_speed && pub_navdata_wind_speed.getNumSubscribers()>0)
		{
			navdata_wind_speed_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_wind_speed_msg.header.stamp = received;
      navdata_wind_speed_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_wind_speed.tag;
			uint16_t m;
			m = c;

				navdata_wind_speed_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_wind_speed.size;
			uint16_t m;
			m = c;

				navdata_wind_speed_msg.size = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.wind_speed;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.wind_speed = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.wind_angle;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.wind_angle = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.wind_compensation_theta;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.wind_compensation_theta = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.wind_compensation_phi;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.wind_compensation_phi = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.state_x1;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.state_x1 = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.state_x2;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.state_x2 = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.state_x3;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.state_x3 = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.state_x4;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.state_x4 = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.state_x5;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.state_x5 = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.state_x6;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.state_x6 = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.magneto_debug1;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.magneto_debug1 = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.magneto_debug2;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.magneto_debug2 = m;
			}

			{				
			float32_t c = n.navdata_wind_speed.magneto_debug3;
			float32_t m;
			m = c;

				navdata_wind_speed_msg.magneto_debug3 = m;
			}

			pub_navdata_wind_speed.publish(navdata_wind_speed_msg);
		}

		//-------------------------

		if(enabled_navdata_kalman_pressure && pub_navdata_kalman_pressure.getNumSubscribers()>0)
		{
			navdata_kalman_pressure_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_kalman_pressure_msg.header.stamp = received;
      navdata_kalman_pressure_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_kalman_pressure.tag;
			uint16_t m;
			m = c;

				navdata_kalman_pressure_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_kalman_pressure.size;
			uint16_t m;
			m = c;

				navdata_kalman_pressure_msg.size = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.offset_pressure;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.offset_pressure = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.est_z;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.est_z = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.est_zdot;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.est_zdot = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.est_bias_PWM;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.est_bias_PWM = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.est_biais_pression;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.est_biais_pression = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.offset_US;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.offset_US = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.prediction_US;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.prediction_US = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.cov_alt;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.cov_alt = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.cov_PWM;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.cov_PWM = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.cov_vitesse;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.cov_vitesse = m;
			}

			{				
			bool_t c = n.navdata_kalman_pressure.bool_effet_sol;
			bool_t m;
			m = c;

				navdata_kalman_pressure_msg.bool_effet_sol = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.somme_inno;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.somme_inno = m;
			}

			{				
			bool_t c = n.navdata_kalman_pressure.flag_rejet_US;
			bool_t m;
			m = c;

				navdata_kalman_pressure_msg.flag_rejet_US = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.u_multisinus;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.u_multisinus = m;
			}

			{				
			float32_t c = n.navdata_kalman_pressure.gaz_altitude;
			float32_t m;
			m = c;

				navdata_kalman_pressure_msg.gaz_altitude = m;
			}

			{				
			bool_t c = n.navdata_kalman_pressure.Flag_multisinus;
			bool_t m;
			m = c;

				navdata_kalman_pressure_msg.Flag_multisinus = m;
			}

			{				
			bool_t c = n.navdata_kalman_pressure.Flag_multisinus_debut;
			bool_t m;
			m = c;

				navdata_kalman_pressure_msg.Flag_multisinus_debut = m;
			}

			pub_navdata_kalman_pressure.publish(navdata_kalman_pressure_msg);
		}

		//-------------------------

		if(enabled_navdata_hdvideo_stream && pub_navdata_hdvideo_stream.getNumSubscribers()>0)
		{
			navdata_hdvideo_stream_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_hdvideo_stream_msg.header.stamp = received;
      navdata_hdvideo_stream_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_hdvideo_stream.tag;
			uint16_t m;
			m = c;

				navdata_hdvideo_stream_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_hdvideo_stream.size;
			uint16_t m;
			m = c;

				navdata_hdvideo_stream_msg.size = m;
			}

			{				
			uint32_t c = n.navdata_hdvideo_stream.hdvideo_state;
			uint32_t m;
			m = c;

				navdata_hdvideo_stream_msg.hdvideo_state = m;
			}

			{				
			uint32_t c = n.navdata_hdvideo_stream.storage_fifo_nb_packets;
			uint32_t m;
			m = c;

				navdata_hdvideo_stream_msg.storage_fifo_nb_packets = m;
			}

			{				
			uint32_t c = n.navdata_hdvideo_stream.storage_fifo_size;
			uint32_t m;
			m = c;

				navdata_hdvideo_stream_msg.storage_fifo_size = m;
			}

			{				
			uint32_t c = n.navdata_hdvideo_stream.usbkey_size;
			uint32_t m;
			m = c;

				navdata_hdvideo_stream_msg.usbkey_size = m;
			}

			{				
			uint32_t c = n.navdata_hdvideo_stream.usbkey_freespace;
			uint32_t m;
			m = c;

				navdata_hdvideo_stream_msg.usbkey_freespace = m;
			}

			{				
			uint32_t c = n.navdata_hdvideo_stream.frame_number;
			uint32_t m;
			m = c;

				navdata_hdvideo_stream_msg.frame_number = m;
			}

			{				
			uint32_t c = n.navdata_hdvideo_stream.usbkey_remaining_time;
			uint32_t m;
			m = c;

				navdata_hdvideo_stream_msg.usbkey_remaining_time = m;
			}

			pub_navdata_hdvideo_stream.publish(navdata_hdvideo_stream_msg);
		}

		//-------------------------

		if(enabled_navdata_wifi && pub_navdata_wifi.getNumSubscribers()>0)
		{
			navdata_wifi_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_wifi_msg.header.stamp = received;
      navdata_wifi_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_wifi.tag;
			uint16_t m;
			m = c;

				navdata_wifi_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_wifi.size;
			uint16_t m;
			m = c;

				navdata_wifi_msg.size = m;
			}

			{				
			uint32_t c = n.navdata_wifi.link_quality;
			uint32_t m;
			m = c;

				navdata_wifi_msg.link_quality = m;
			}

			pub_navdata_wifi.publish(navdata_wifi_msg);
		}

		//-------------------------

		if(enabled_navdata_zimmu_3000 && pub_navdata_zimmu_3000.getNumSubscribers()>0)
		{
			navdata_zimmu_3000_msg.drone_time = ((double)ardrone_time_to_usec(n.navdata_time.time))/1000000.0;
			navdata_zimmu_3000_msg.header.stamp = received;
      navdata_zimmu_3000_msg.header.frame_id = drone_frame_base;

			{				
			uint16_t c = n.navdata_zimmu_3000.tag;
			uint16_t m;
			m = c;

				navdata_zimmu_3000_msg.tag = m;
			}

			{				
			uint16_t c = n.navdata_zimmu_3000.size;
			uint16_t m;
			m = c;

				navdata_zimmu_3000_msg.size = m;
			}

			{				
			int32_t c = n.navdata_zimmu_3000.vzimmuLSB;
			int32_t m;
			m = c;

				navdata_zimmu_3000_msg.vzimmuLSB = m;
			}

			{				
			float32_t c = n.navdata_zimmu_3000.vzfind;
			float32_t m;
			m = c;

				navdata_zimmu_3000_msg.vzfind = m;
			}

			pub_navdata_zimmu_3000.publish(navdata_zimmu_3000_msg);
		}

		//-------------------------

	}
}
#endif
