#!/usr/bin/python
# BSD 3-Clause License

# Copyright (c) 2019, Noam C. Golombek
# All rights reserved.

# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:

# 1. Redistributions of source code must retain the above copyright notice, this
#    list of conditions and the following disclaimer.

# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.

# 3. Neither the name of the copyright holder nor the names of its
#    contributors may be used to endorse or promote products derived from
#    this software without specific prior written permission.

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



import rospy
import roslib
import cv2

def exit_handler(camera, video_out, statistics_engine):
    """Hadle when the program exits. calculate the statistics and close any open cv2 device
    Inputs:
        camera (Camera) the Camera being used
        video_out (VideoSaver) the VideoSaver being used
        statistics_engine (StatisticsEngine) the StatisticsEngine being used"""
    if "cv2" in camera.camera_type and camera.video_source.isOpened():
        camera.video_source.release()

    if (video_out is not None and
            video_out.org_video_out is not None and
            video_out.org_video_out.isOpened()):
        video_out.org_video_out.release()

    if (video_out is not None and
            video_out.overlay_video_out is not None and
            video_out.overlay_video_out.isOpened()):
        video_out.overlay_video_out.release()

    if (video_out is not None and
            video_out.mask_video_out is not None and
            video_out.mask_video_out.isOpened()):
        video_out.mask_video_out.release()

    stat_string = statistics_engine.process_statistics()
    rospy.logerr(stat_string)
    cv2.destroyAllWindows()


def str2bool(s, return_string=False):
    """
    This function is not too correct if the argument is not any of True/False case
    """
    s = str(s)
    if s.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif s.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    elif s is None:
        return None
    elif return_string:
        return s
    else:
        return None