/*
 * Software License Agreement (BSD License)
 *
 *  Copyright (c) 2018, Locus Robotics
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *   * Neither the name of the copyright holder nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LOCOMOTOR_PUBLISHERS_H
#define LOCOMOTOR_PUBLISHERS_H

#include <ros/ros.h>
#include <nav_2d_msgs/Path2D.h>
#include <nav_2d_msgs/Twist2DStamped.h>

namespace locomotor
{
enum class PathType { NO_PATH, PATH_3D, PATH_2D };
enum class TwistType { NO_TWIST, TWIST_3D, TWIST_2D, TWIST_2D_STAMPED };

class PathPublisher
{
public:
  explicit PathPublisher(ros::NodeHandle& nh);
  void publishPath(const nav_2d_msgs::Path2D& global_plan);
protected:
  PathType path_type_;
  ros::Publisher pub_;
  double global_plan_epsilon_;
};

class TwistPublisher
{
public:
  explicit TwistPublisher(ros::NodeHandle& nh);
  void publishTwist(const nav_2d_msgs::Twist2DStamped& command);
protected:
  TwistType twist_type_;
  ros::Publisher pub_;
};
}  // namespace locomotor

#endif  // LOCOMOTOR_PUBLISHERS_H
