# Locate Netcdf install directory

# This module defines
# NETCDF_INSTALL where to find include, lib, bin, etc.
# NETCDF_FOUND, is set to true

MESSAGE("Looking for netcdf in ${NETCDF_INSTALL}")

SET( NETCDF_FOUND NETCDF_FOUND-NOTFOUND )
FIND_PATH(NETCDF_INCLUDE_DIRS netcdf.h HINTS ${NETCDF_INSTALL}/include )
FIND_LIBRARY(NETCDF_LIBS NAMES netcdf PATHS  ${NETCDF_INSTALL}/libs )

IF ( NETCDF_INCLUDE_DIRS AND NETCDF_LIBS )
  SET( NETCDF_FOUND TRUE)
  MESSAGE("Found NetCDF")
  MESSAGE("  include dirs: ${NETCDF_INCLUDE_DIRS}")
  MESSAGE("  libs: ${NETCDF_LIBS}")

  INCLUDE_DIRECTORIES( ${NETCDF_INCLUDE_DIRS} )

ELSE (NETCDF_INCLUDE_DIRS AND NETCDF_LIBS)
  MESSAGE( "  Can't find NETCDF" )
ENDIF(NETCDF_INCLUDE_DIRS AND NETCDF_LIBS)
