/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.util.Vector;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.ManagerServant;
import jp.go.aist.rtm.RTC.NamingBase;
import jp.go.aist.rtm.RTC.NamingOnCorba;
import jp.go.aist.rtm.RTC.RTObject_impl;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.util.CallbackFunction;
import jp.go.aist.rtm.RTC.util.StringUtil;

public class NamingManager
implements CallbackFunction {
    protected Vector<Names> m_names = new Vector();
    protected Vector<Comps> m_compNames = new Vector();
    protected Vector<Mgr> m_mgrNames = new Vector();
    protected Manager m_manager;
    protected Logbuf rtcout;

    public NamingManager(Manager manager) {
        this.m_manager = manager;
        this.rtcout = new Logbuf("NamingManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNameServer(String string, String string2) {
        this.rtcout.println(2, "NamingManager.registerNameServer(" + string + ", " + string2 + ")");
        NamingBase namingBase = this.createNamingObj(string, string2);
        Vector<Names> vector = this.m_names;
        synchronized (vector) {
            this.m_names.add(new Names(string, string2, namingBase));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindObject(String string, RTObject_impl rTObject_impl) {
        this.rtcout.println(2, "NamingManager.bindObject(" + string + ")");
        Vector<Names> vector = this.m_names;
        synchronized (vector) {
            int n = this.m_names.size();
            for (int i = 0; i < n; ++i) {
                if (this.m_names.elementAt((int)i).ns == null) continue;
                try {
                    this.m_names.elementAt((int)i).ns.bindObject(string, rTObject_impl);
                    continue;
                }
                catch (Exception exception) {
                    this.m_names.elementAt((int)i).ns = null;
                }
            }
            this.registerCompName(string, rTObject_impl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindObject(String string, ManagerServant managerServant) {
        this.rtcout.println(2, "NamingManager.bindObject(" + string + ")");
        Vector<Names> vector = this.m_names;
        synchronized (vector) {
            int n = this.m_names.size();
            for (int i = 0; i < n; ++i) {
                if (this.m_names.elementAt((int)i).ns == null) continue;
                try {
                    this.m_names.elementAt((int)i).ns.bindObject(string, managerServant);
                    continue;
                }
                catch (Exception exception) {
                    this.m_names.elementAt((int)i).ns = null;
                }
            }
            this.registerMgrName(string, managerServant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        this.rtcout.println(2, "NamingManager.update()");
        boolean bl = StringUtil.toBool(this.m_manager.getConfig().getProperty("naming.update.rebind"), "YES", "NO", false);
        Vector<Names> vector = this.m_names;
        synchronized (vector) {
            int n = this.m_names.size();
            for (int i = 0; i < n; ++i) {
                if (this.m_names.elementAt((int)i).ns == null) {
                    this.rtcout.println(3, "Retrying connection to " + this.m_names.elementAt((int)i).method + "/" + this.m_names.elementAt((int)i).nsname);
                    this.retryConnection(this.m_names.elementAt(i));
                    continue;
                }
                try {
                    if (bl) {
                        this.bindCompsTo(this.m_names.elementAt((int)i).ns);
                    }
                    if (this.m_names.elementAt((int)i).ns.isAlive()) continue;
                    this.rtcout.println(4, "Name server: " + this.m_names.elementAt((int)i).nsname + " (" + this.m_names.elementAt((int)i).method + ") disappeared.");
                    this.m_names.elementAt((int)i).ns = null;
                    continue;
                }
                catch (Exception exception) {
                    this.rtcout.println(4, "Name server: " + this.m_names.elementAt((int)i).nsname + " (" + this.m_names.elementAt((int)i).method + ") disappeared.");
                    this.m_names.elementAt((int)i).ns = null;
                }
            }
        }
    }

    protected void retryConnection(Names names) {
        block3: {
            NamingBase namingBase = null;
            try {
                namingBase = this.createNamingObj(names.method, names.nsname);
                if (namingBase != null) {
                    this.rtcout.println(4, "Connected to a name server: " + names.nsname + "/" + names.method);
                    names.ns = namingBase;
                    this.bindCompsTo(namingBase);
                    return;
                }
                this.rtcout.println(3, "Name service: " + names.method + "/" + names.nsname + " still not available.");
            }
            catch (Exception exception) {
                this.rtcout.println(3, "Name service: " + names.method + "/" + names.nsname + " disappeared again.");
                if (namingBase == null) break block3;
                names.ns = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindObject(String string) {
        this.rtcout.println(2, "NamingManager.unbindObject(" + string + ")");
        Vector<Names> vector = this.m_names;
        synchronized (vector) {
            int n = this.m_names.size();
            for (int i = 0; i < n; ++i) {
                if (this.m_names.elementAt((int)i).ns == null) continue;
                this.m_names.elementAt((int)i).ns.unbindObject(string);
            }
            this.unregisterCompName(string);
            this.unregisterMgrName(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindAll() {
        int n;
        int n2;
        Vector<String> vector;
        this.rtcout.println(2, "NamingManager.unbindAll(): m_compNames=" + Integer.toString(this.m_compNames.size()) + " m_mgrNames=" + Integer.toString(this.m_mgrNames.size()));
        Vector<Object> vector2 = this.m_compNames;
        synchronized (vector2) {
            vector = new Vector<String>();
            n2 = this.m_compNames.size();
            for (n = 0; n < n2; ++n) {
                vector.add(this.m_compNames.elementAt((int)n).name);
            }
            for (n = 0; n < vector.size(); ++n) {
                this.unbindObject((String)vector.elementAt(n));
            }
        }
        vector2 = this.m_mgrNames;
        synchronized (vector2) {
            vector = new Vector();
            n2 = this.m_mgrNames.size();
            for (n = 0; n < n2; ++n) {
                vector.add(this.m_mgrNames.elementAt((int)n).name);
            }
            for (n = 0; n < vector.size(); ++n) {
                this.unbindObject((String)vector.elementAt(n));
            }
        }
    }

    protected synchronized Vector<RTObject_impl> getObjects() {
        Vector<RTObject_impl> vector = new Vector<RTObject_impl>();
        int n = this.m_compNames.size();
        for (int i = 0; i < n; ++i) {
            vector.add(this.m_compNames.elementAt((int)i).rtobj);
        }
        return vector;
    }

    protected NamingBase createNamingObj(String string, String string2) {
        this.rtcout.println(2, "createNamingObj(method = " + string + ", nameserver = )" + string2);
        String string3 = string;
        if (string3.endsWith("corba")) {
            try {
                NamingOnCorba namingOnCorba;
                NamingOnCorba namingOnCorba2 = namingOnCorba = new NamingOnCorba(this.m_manager.getORB(), string2);
                if (namingOnCorba2 == null) {
                    return null;
                }
                this.rtcout.println(4, "NameServer connection succeeded: " + string + "/" + string2);
                return namingOnCorba2;
            }
            catch (Exception exception) {
                this.rtcout.println(4, "NameServer connection failed: " + string + "/" + string2);
                return null;
            }
        }
        return null;
    }

    protected void bindCompsTo(NamingBase namingBase) {
        int n = this.m_compNames.size();
        for (int i = 0; i < n; ++i) {
            namingBase.bindObject(this.m_compNames.elementAt((int)i).name, this.m_compNames.elementAt((int)i).rtobj);
        }
    }

    protected void registerCompName(String string, RTObject_impl rTObject_impl) {
        int n = this.m_compNames.size();
        for (int i = 0; i < n; ++i) {
            if (!this.m_compNames.elementAt((int)i).name.equals(string)) continue;
            this.m_compNames.elementAt((int)i).rtobj = rTObject_impl;
            return;
        }
        this.m_compNames.add(new Comps(string, rTObject_impl));
    }

    protected void registerMgrName(String string, ManagerServant managerServant) {
        int n = this.m_mgrNames.size();
        for (int i = 0; i < n; ++i) {
            if (!this.m_mgrNames.elementAt((int)i).name.equals(string)) continue;
            this.m_mgrNames.elementAt((int)i).mgr = managerServant;
            return;
        }
        this.m_mgrNames.add(new Mgr(string, managerServant));
    }

    protected void unregisterCompName(String string) {
        int n = this.m_compNames.size();
        for (int i = 0; i < n; ++i) {
            if (!this.m_compNames.elementAt((int)i).name.equals(string)) continue;
            this.m_compNames.remove(this.m_compNames.elementAt(i));
            return;
        }
    }

    protected void unregisterMgrName(String string) {
        int n = this.m_mgrNames.size();
        for (int i = 0; i < n; ++i) {
            if (!this.m_mgrNames.elementAt((int)i).name.equals(string)) continue;
            this.m_mgrNames.remove(this.m_mgrNames.elementAt(i));
            return;
        }
    }

    @Override
    public void doOperate() {
        this.update();
    }

    protected class Mgr {
        public String name;
        public ManagerServant mgr;

        public Mgr(String string, ManagerServant managerServant) {
            this.name = string;
            this.mgr = managerServant;
        }
    }

    protected class Comps {
        public String name;
        public RTObject_impl rtobj;

        public Comps(String string, RTObject_impl rTObject_impl) {
            this.name = string;
            this.rtobj = rTObject_impl;
        }
    }

    protected class Names {
        public String method;
        public String nsname;
        public NamingBase ns;

        public Names(String string, String string2, NamingBase namingBase) {
            this.method = string;
            this.nsname = string2;
            this.ns = namingBase;
        }
    }
}

