/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp.protocol;

import com.sun.media.rtsp.protocol.CSeqHeader;
import com.sun.media.rtsp.protocol.ContentBaseHeader;
import com.sun.media.rtsp.protocol.Debug;
import com.sun.media.rtsp.protocol.DurationHeader;
import com.sun.media.rtsp.protocol.Parser;
import com.sun.media.rtsp.protocol.RangeHeader;
import com.sun.media.rtsp.protocol.SessionHeader;
import com.sun.media.rtsp.protocol.TransportHeader;
import java.io.ByteArrayInputStream;

public class Header
extends Parser {
    public int type;
    public Object parameter;
    public int contentLength;
    public static final int TRANSPORT = 1;
    public static final int CSEQ = 2;
    public static final int SESSION = 3;
    public static final int DURATION = 4;
    public static final int RANGE = 5;
    public static final int DATE = 6;
    public static final int SERVER = 7;
    public static final int CONTENT_TYPE = 8;
    public static final int CONTENT_BASE = 9;
    public static final int CONTENT_LENGTH = 10;

    public Header(String input) {
        ByteArrayInputStream bin = new ByteArrayInputStream(input.getBytes());
        String id = this.getToken(bin);
        if (id.equalsIgnoreCase("CSeq:")) {
            this.type = 2;
            String number = this.getStringToken(bin).trim();
            this.parameter = new CSeqHeader(number);
        } else if (id.equalsIgnoreCase("Transport:")) {
            this.type = 1;
            String tx = this.getToken(bin);
            this.parameter = new TransportHeader(tx);
        } else if (id.equalsIgnoreCase("Session:")) {
            this.type = 3;
            String tx = this.getToken(bin);
            this.parameter = new SessionHeader(tx);
        } else if (id.equalsIgnoreCase("Duration:")) {
            this.type = 4;
            String tx = this.getToken(bin);
            Debug.println("Duration : " + tx);
            this.parameter = new DurationHeader(tx);
        } else if (id.equalsIgnoreCase("Range:")) {
            this.type = 5;
            String tx = this.getToken(bin);
            this.parameter = new RangeHeader(tx);
        } else if (id.equalsIgnoreCase("Date:")) {
            this.type = 6;
            String date = this.getStringToken(bin);
        } else if (id.equalsIgnoreCase("Allow:")) {
            this.type = 6;
            String entries = this.getStringToken(bin);
        } else if (id.equalsIgnoreCase("Server:")) {
            this.type = 7;
            String server = this.getStringToken(bin);
        } else if (id.equalsIgnoreCase("Content-Type:")) {
            this.type = 8;
            String content_type = this.getStringToken(bin);
        } else if (id.equalsIgnoreCase("Content-Base:")) {
            this.type = 9;
            String content_base = this.getStringToken(bin);
            this.parameter = new ContentBaseHeader(content_base);
        } else if (id.equalsIgnoreCase("Content-Length:")) {
            this.type = 10;
            String content_length = this.getStringToken(bin);
            this.contentLength = new Integer(content_length);
        } else if (id.equalsIgnoreCase("Last-Modified:")) {
            String date = this.getStringToken(bin);
        } else if (id.equalsIgnoreCase("RTP-Info:")) {
            String rtpInfo = this.getStringToken(bin);
        } else if (id.length() > 0) {
            Debug.println("unknown id : <" + id + ">");
            String tmp = this.getStringToken(bin);
        }
    }
}

