/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.executionContext;

import OpenRTM.DataFlowComponent;
import OpenRTM.DataFlowComponentHelper;
import OpenRTM.DataFlowComponentHolder;
import RTC.ComponentProfile;
import RTC.ExecutionContext;
import RTC.ExecutionContextListHolder;
import RTC.PortProfile;
import RTC.PortService;
import RTC.RTObject;
import _SDOPackage.Configuration;
import _SDOPackage.InterfaceNotImplemented;
import _SDOPackage.InternalError;
import _SDOPackage.InvalidParameter;
import _SDOPackage.NotAvailable;
import _SDOPackage.Organization;
import _SDOPackage.SDO;
import java.util.Iterator;
import java.util.Vector;
import jp.go.aist.rtm.RTC.RTObject_impl;
import jp.go.aist.rtm.RTC.SDOPackage.Organization_impl;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.util.StringUtil;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.IDLEntity;

public class PeriodicECOrganization
extends Organization_impl {
    protected RTObject_impl m_rtobj;
    protected ExecutionContext m_ec;
    protected Vector<Member> m_rtcMembers = new Vector();
    protected Vector<String> m_expPorts = new Vector();
    protected Logbuf rtcout;

    public PeriodicECOrganization(RTObject_impl rTObject_impl) {
        super(rTObject_impl.getObjRef());
        this.m_rtobj = rTObject_impl;
        this.m_ec = null;
        this.rtcout = new Logbuf("PeriodicECOrganization");
    }

    @Override
    public boolean add_members(SDO[] sDOArray) throws SystemException, InvalidParameter, NotAvailable, InternalError {
        int n;
        this.rtcout.println(3, "add_members()");
        this.updateExportedPortsList();
        for (SDO sDO : sDOArray) {
            DataFlowComponent dataFlowComponent;
            if (sDO == null || (dataFlowComponent = DataFlowComponentHelper.narrow(sDO)) == null) continue;
            Member member = new Member((DataFlowComponent)dataFlowComponent._duplicate());
            this.stopOwnedEC(member);
            this.addOrganizationToTarget(member);
            this.addParticipantToEC(member);
            this.addPort(member, this.m_expPorts);
            this.m_rtcMembers.add(member);
        }
        try {
            n = super.add_members(sDOArray) ? 1 : 0;
        }
        catch (InvalidParameter invalidParameter) {
            throw new InvalidParameter();
        }
        catch (NotAvailable notAvailable) {
            throw new NotAvailable();
        }
        catch (InternalError internalError) {
            throw new InternalError();
        }
        return n != 0;
    }

    @Override
    public boolean set_members(SDO[] sDOArray) throws SystemException, InvalidParameter, NotAvailable, InternalError {
        int n;
        this.rtcout.println(3, "set_members()");
        this.removeAllMembers();
        this.updateExportedPortsList();
        for (SDO sDO : sDOArray) {
            DataFlowComponent dataFlowComponent;
            if (sDO == null || (dataFlowComponent = DataFlowComponentHelper.narrow(sDO)) == null) continue;
            Member member = new Member((DataFlowComponent)dataFlowComponent._duplicate());
            this.stopOwnedEC(member);
            this.addOrganizationToTarget(member);
            this.addParticipantToEC(member);
            this.addPort(member, this.m_expPorts);
            this.m_rtcMembers.add(member);
        }
        try {
            n = super.set_members(sDOArray) ? 1 : 0;
        }
        catch (InvalidParameter invalidParameter) {
            throw new InvalidParameter();
        }
        catch (NotAvailable notAvailable) {
            throw new NotAvailable();
        }
        catch (InternalError internalError) {
            throw new InternalError();
        }
        return n != 0;
    }

    @Override
    public boolean remove_member(String string) throws SystemException, InvalidParameter, NotAvailable, InternalError {
        boolean bl;
        this.rtcout.println(3, "remove_member() id=(" + string + ")");
        Iterator<Member> iterator = this.m_rtcMembers.iterator();
        while (iterator.hasNext()) {
            Member member = iterator.next();
            if (member.profile_.instance_name.indexOf(string) != 0) continue;
            this.removePort(member, this.m_expPorts);
            this.m_rtobj.getProperties().setProperty("conf.default.exported_ports", StringUtil.flatten(this.m_expPorts));
            this.removeParticipantFromEC(member);
            this.removeOrganizationFromTarget(member);
            this.startOwnedEC(member);
            iterator.remove();
        }
        try {
            bl = super.remove_member(string);
        }
        catch (InvalidParameter invalidParameter) {
            throw new InvalidParameter();
        }
        catch (NotAvailable notAvailable) {
            throw new NotAvailable();
        }
        catch (InternalError internalError) {
            throw new InternalError();
        }
        return bl;
    }

    public void removeAllMembers() {
        this.rtcout.println(2, "removeAllMembers()");
        this.updateExportedPortsList();
        Iterator<Member> iterator = this.m_rtcMembers.iterator();
        while (iterator.hasNext()) {
            Member member = iterator.next();
            this.removePort(member, this.m_expPorts);
            this.removeParticipantFromEC(member);
            this.removeOrganizationFromTarget(member);
            this.startOwnedEC(member);
            try {
                super.remove_member(member.profile_.instance_name);
            }
            catch (SystemException systemException) {
            }
            catch (InvalidParameter invalidParameter) {
            }
            catch (NotAvailable notAvailable) {
            }
            catch (InternalError internalError) {
                // empty catch block
            }
            iterator.remove();
        }
        this.m_rtcMembers.clear();
        this.m_expPorts.clear();
    }

    public boolean sdoToDFC(SDO sDO, DataFlowComponentHolder dataFlowComponentHolder) {
        if (sDO == null) {
            return false;
        }
        dataFlowComponentHolder.value = DataFlowComponentHelper.narrow(sDO);
        return dataFlowComponentHolder.value != null;
    }

    public void stopOwnedEC(Member member) {
        this.rtcout.println(3, "stopOwnedEC()");
        ExecutionContextListHolder executionContextListHolder = new ExecutionContextListHolder();
        executionContextListHolder.value = member.eclist_;
        int n = executionContextListHolder.value.length;
        for (int i = 0; i < n; ++i) {
            executionContextListHolder.value[i].stop();
        }
    }

    public void startOwnedEC(Member member) {
        this.rtcout.println(3, "startOwnedEC()");
        ExecutionContextListHolder executionContextListHolder = new ExecutionContextListHolder();
        executionContextListHolder.value = member.eclist_;
        int n = executionContextListHolder.value.length;
        for (int i = 0; i < n; ++i) {
            executionContextListHolder.value[i].start();
        }
    }

    public void addOrganizationToTarget(Member member) {
        this.rtcout.println(3, "addOrganizationToTarget()");
        Configuration configuration = member.config_;
        if (configuration == null) {
            return;
        }
        try {
            configuration.add_organization((Organization)this.m_objref._duplicate());
        }
        catch (SystemException systemException) {
        }
        catch (InvalidParameter invalidParameter) {
        }
        catch (NotAvailable notAvailable) {
        }
        catch (InternalError internalError) {
            // empty catch block
        }
    }

    public void removeOrganizationFromTarget(Member member) {
        this.rtcout.println(3, "removeOrganizationFromTarget()");
        Configuration configuration = member.config_;
        if (configuration == null) {
            return;
        }
        try {
            String string = new String();
            string = this.m_pId;
            configuration.remove_organization(string);
        }
        catch (SystemException systemException) {
        }
        catch (InvalidParameter invalidParameter) {
        }
        catch (NotAvailable notAvailable) {
        }
        catch (InternalError internalError) {
            // empty catch block
        }
    }

    public void addParticipantToEC(Member member) {
        IDLEntity[] iDLEntityArray;
        this.rtcout.println(3, "addParticipantToEC()");
        if (this.m_ec == null) {
            iDLEntityArray = this.m_rtobj.get_owned_contexts();
            if (iDLEntityArray.length > 0) {
                this.m_ec = (ExecutionContext)iDLEntityArray[0]._duplicate();
            } else {
                return;
            }
        }
        this.m_ec.add_component((RTObject)member.rtobj_._duplicate());
        try {
            iDLEntityArray = member.rtobj_.get_organizations();
            for (int i = 0; i < iDLEntityArray.length; ++i) {
                SDO[] sDOArray = iDLEntityArray[i].get_members();
                for (int j = 0; j < sDOArray.length; ++j) {
                    DataFlowComponentHolder dataFlowComponentHolder = null;
                    if (!this.sdoToDFC(sDOArray[j], dataFlowComponentHolder)) continue;
                    this.m_ec.add_component(dataFlowComponentHolder.value);
                }
            }
        }
        catch (Exception exception) {
            this.rtcout.println(5, "no organization");
        }
    }

    public void removeParticipantFromEC(Member member) {
        IDLEntity[] iDLEntityArray;
        this.rtcout.println(3, "removeParticipantFromEC()");
        if (this.m_ec == null) {
            iDLEntityArray = this.m_rtobj.get_owned_contexts();
            if (iDLEntityArray.length > 0) {
                this.m_ec = (ExecutionContext)iDLEntityArray[0]._duplicate();
            } else {
                this.rtcout.println(7, "removeParticipantFromEC() no owned EC");
                return;
            }
        }
        this.m_ec.remove_component((RTObject)member.rtobj_._duplicate());
        try {
            iDLEntityArray = member.rtobj_.get_organizations();
            for (int i = 0; i < iDLEntityArray.length; ++i) {
                SDO[] sDOArray = iDLEntityArray[i].get_members();
                for (int j = 0; j < sDOArray.length; ++j) {
                    DataFlowComponentHolder dataFlowComponentHolder = null;
                    if (!this.sdoToDFC(sDOArray[j], dataFlowComponentHolder)) continue;
                    this.m_ec.remove_component(dataFlowComponentHolder.value);
                }
            }
        }
        catch (Exception exception) {
            this.rtcout.println(5, "no organization");
        }
    }

    public void addPort(Member member, Vector<String> vector) {
        this.rtcout.println(2, "addPort() portlist=" + StringUtil.flatten(vector));
        if (vector.size() == 0) {
            return;
        }
        String string = member.profile_.instance_name;
        PortProfile[] portProfileArray = new PortProfile[member.profile_.port_profiles.length];
        portProfileArray = member.profile_.port_profiles;
        int n = portProfileArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = portProfileArray[i].name;
            this.rtcout.println(3, "port_name: " + string2 + " is in " + StringUtil.flatten(vector));
            int n2 = -1;
            for (String string3 : vector) {
                if (string3.indexOf(string2) == -1) continue;
                n2 = 1;
                break;
            }
            if (n2 == -1) {
                this.rtcout.println(3, "Not Found: " + string2 + " is in " + StringUtil.flatten(vector));
                continue;
            }
            this.rtcout.println(3, "Found: " + string2 + " is in " + StringUtil.flatten(vector));
            this.m_rtobj.addPort((PortService)portProfileArray[i].port_ref._duplicate());
            this.rtcout.println(3, "Port " + string2 + " was delegated.");
        }
    }

    public void removePort(Member member, Vector<String> vector) {
        this.rtcout.println(2, "removePort() portlist=" + StringUtil.flatten(vector));
        if (vector.size() == 0) {
            return;
        }
        String string = new String();
        string = member.profile_.instance_name;
        PortProfile[] portProfileArray = new PortProfile[member.profile_.port_profiles.length];
        portProfileArray = member.profile_.port_profiles;
        int n = portProfileArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = portProfileArray[i].name;
            this.rtcout.println(3, "port_name: " + string2 + " is in " + StringUtil.flatten(vector));
            int n2 = -1;
            for (String string3 : vector) {
                if (string3.indexOf(string2) == -1) continue;
                n2 = 1;
                break;
            }
            if (n2 == -1) {
                this.rtcout.println(3, "Not Found: " + string2 + " is in " + StringUtil.flatten(vector));
                continue;
            }
            this.rtcout.println(3, "Found: " + string2 + " is in " + StringUtil.flatten(vector));
            this.m_rtobj.removePort((PortService)portProfileArray[i].port_ref._duplicate());
            vector.remove(string2);
            this.rtcout.println(3, "Port " + string2 + " was deleted.");
        }
    }

    private void updateExportedPortsList() {
        this.rtcout.println(3, "updateExportedPortsList()");
        String string = this.m_rtobj.getProperties().getProperty("conf.default.exported_ports");
        this.m_expPorts = StringUtil.split(string, ",");
        for (int i = 0; i < this.m_expPorts.size(); ++i) {
            this.m_expPorts.set(i, this.m_expPorts.get(i).trim());
        }
    }

    public void updateDelegatedPorts() {
        this.rtcout.println(3, "updateDelegatedPorts()");
        Vector<String> vector = new Vector();
        vector = this.m_expPorts;
        String string = new String();
        string = this.m_rtobj.getProperties().getProperty("conf.default.exported_ports");
        Vector<String> vector2 = new Vector();
        vector2 = StringUtil.split(string, ",");
        Vector<String> vector3 = new Vector<String>(vector);
        Vector<String> vector4 = new Vector<String>(vector2);
        vector3.removeAll(vector2);
        vector4.removeAll(vector);
        this.rtcout.println(1, "old    Ports: " + StringUtil.flatten(vector));
        this.rtcout.println(1, "new    Ports: " + StringUtil.flatten(vector2));
        this.rtcout.println(1, "remove Ports: " + StringUtil.flatten(vector3));
        this.rtcout.println(1, "add    Ports: " + StringUtil.flatten(vector4));
        int n = this.m_rtcMembers.size();
        for (int i = 0; i < n; ++i) {
            this.removePort(this.m_rtcMembers.elementAt(i), vector3);
            this.addPort(this.m_rtcMembers.elementAt(i), vector4);
        }
        this.m_expPorts = vector2;
    }

    protected class Member {
        public RTObject rtobj_;
        public ComponentProfile profile_;
        public ExecutionContext[] eclist_;
        public Configuration config_;

        public Member(RTObject rTObject) {
            this.rtobj_ = (RTObject)rTObject._duplicate();
            this.profile_ = rTObject.get_component_profile();
            this.eclist_ = rTObject.get_owned_contexts();
            try {
                this.config_ = rTObject.get_configuration();
            }
            catch (SystemException systemException) {
            }
            catch (InterfaceNotImplemented interfaceNotImplemented) {
            }
            catch (NotAvailable notAvailable) {
            }
            catch (InternalError internalError) {
                // empty catch block
            }
        }

        public Member(Member member) {
            this.rtobj_ = (RTObject)member.rtobj_._duplicate();
            this.profile_ = member.profile_;
            this.eclist_ = member.eclist_;
            this.config_ = (Configuration)member.config_._duplicate();
        }

        public Member operator(Member member) {
            Member member2 = member;
            member2.swap(this);
            return this;
        }

        public void swap(Member member) {
            RTObject rTObject = member.rtobj_;
            ComponentProfile componentProfile = member.profile_;
            ExecutionContext[] executionContextArray = member.eclist_;
            Configuration configuration = member.config_;
            member.rtobj_ = this.rtobj_;
            member.profile_ = this.profile_;
            member.eclist_ = this.eclist_;
            member.config_ = this.config_;
            this.rtobj_ = rTObject;
            this.profile_ = componentProfile;
            this.eclist_ = executionContextArray;
            this.config_ = configuration;
        }
    }
}

