/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import OpenRTM.CdrDataHolder;
import OpenRTM.OutPortCdr;
import OpenRTM.PortStatus;
import _SDOPackage.NVListHolder;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.ObjectCreator;
import jp.go.aist.rtm.RTC.ObjectDestructor;
import jp.go.aist.rtm.RTC.OutPortConsumerFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.CorbaConsumer;
import jp.go.aist.rtm.RTC.port.OutPortConsumer;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.OutputStream;

public class OutPortCorbaCdrConsumer
extends CorbaConsumer<OutPortCdr>
implements OutPortConsumer,
ObjectCreator<OutPortConsumer>,
ObjectDestructor {
    private BufferBase<OutputStream> m_buffer;
    private Logbuf rtcout = new Logbuf("OutPortCorbaCdrConsumer");

    public OutPortCorbaCdrConsumer() {
        super(OutPortCdr.class);
        this.rtcout.setLevel("PARANOID");
    }

    @Override
    public void init(Properties properties) {
    }

    @Override
    public void setBuffer(BufferBase<OutputStream> bufferBase) {
        this.m_buffer = bufferBase;
    }

    @Override
    public ReturnCode get(OutputStream outputStream) {
        CdrDataHolder cdrDataHolder = new CdrDataHolder();
        try {
            PortStatus portStatus = ((OutPortCdr)this._ptr()).get(cdrDataHolder);
            if (portStatus == PortStatus.PORT_OK) {
                outputStream.write_octet_array(cdrDataHolder.value, 0, cdrDataHolder.value.length);
                this.m_buffer.put(outputStream);
                this.m_buffer.advanceWptr();
                this.m_buffer.advanceRptr();
                return ReturnCode.PORT_OK;
            }
            return this.convertReturn(portStatus);
        }
        catch (Exception exception) {
            return ReturnCode.CONNECTION_LOST;
        }
    }

    @Override
    public boolean subscribeInterface(NVListHolder nVListHolder) {
        int n = NVUtil.find_index(nVListHolder, "dataport.corba_cdr.outport_ior");
        if (n < 0) {
            return false;
        }
        if (NVUtil.isString(nVListHolder, "dataport.corba_cdr.outport_ior")) {
            String string;
            try {
                string = nVListHolder.value[n].value.type().kind() == TCKind.tk_wstring ? nVListHolder.value[n].value.extract_wstring() : nVListHolder.value[n].value.extract_string();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                this.rtcout.println(6, "outport_ior has no string");
                return false;
            }
            ORB oRB = Manager.instance().getORB();
            Object object = oRB.string_to_object(string);
            if (object == null) {
                this.rtcout.println(6, "invalid IOR string has been passed");
                return false;
            }
            if (!super.setObject(object)) {
                this.rtcout.println(5, "Setting object to consumer failed.");
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void unsubscribeInterface(NVListHolder nVListHolder) {
        String string;
        int n = NVUtil.find_index(nVListHolder, "dataport.corba_cdr.outport_ior");
        if (n < 0) {
            return;
        }
        try {
            string = nVListHolder.value[n].value.type().kind() == TCKind.tk_wstring ? nVListHolder.value[n].value.extract_wstring() : nVListHolder.value[n].value.extract_string();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            this.rtcout.println(6, "inport_ior has no string");
            return;
        }
        ORB oRB = Manager.instance().getORB();
        Object object = oRB.string_to_object(string);
        if (((OutPortCdr)this._ptr())._is_equivalent(object)) {
            this.releaseObject();
        }
    }

    protected ReturnCode convertReturn(PortStatus portStatus) {
        switch (portStatus.value()) {
            case 0: {
                return ReturnCode.PORT_OK;
            }
            case 1: {
                return ReturnCode.BUFFER_EMPTY;
            }
            case 3: {
                return ReturnCode.BUFFER_TIMEOUT;
            }
            case 4: {
                return ReturnCode.PRECONDITION_NOT_MET;
            }
        }
        return ReturnCode.PORT_ERROR;
    }

    @Override
    public OutPortConsumer creator_() {
        return new OutPortCorbaCdrConsumer();
    }

    @Override
    public void destructor_(java.lang.Object object) {
        object = null;
    }

    public static void OutPortCorbaCdrConsumerInit() {
        OutPortConsumerFactory outPortConsumerFactory = OutPortConsumerFactory.instance();
        outPortConsumerFactory.addFactory("corba_cdr", new OutPortCorbaCdrConsumer(), new OutPortCorbaCdrConsumer());
    }
}

