#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file NamingManager.py
# @brief naming Service helper class
# @date $Date: 2007/08/27$
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2006-2008
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.


import threading
import traceback
import sys

import OpenRTM_aist


##
# @if jp
#
# @class NamingBase
# @brief NamingService ݥ饹
#
# NamingServer ݥ󥿡ե饹
# ݴ饹ϡʲδؿμ󶡤ʤФʤʤ
# - bindObject() : ꤷ֥ȤNamingServiceؤΥХ
# - unbindObject() : ꤷ֥ȤNamingServiceΥХ
#
# @since 0.4.0
#
# @else
#
# @endif
class NamingBase:
  """
  """

  ##
  # @if jp
  #
  # @brief NamingServiceإХɤؿ(֥饹)
  #
  # ꤷ֥ȤNamingServiceإХɤ<BR>
  # ֥饹Ǥμ
  #
  # @param self
  # @param name Хɻ̾
  # @param rtobj Хоݥ֥
  #
  # @else
  #
  # @endif
  def bindObject(self, name, rtobj):
    pass


  ##
  # @if jp
  #
  # @brief NamingService饢Хɤؿ(֥饹)
  #
  # ꤷ֥ȤNamingService饢Хɤ<BR>
  # ֥饹Ǥμ
  #
  # @param self
  # @param name Хоݥ֥
  #
  # @else
  #
  # @endif
  def unbindObject(self, name):
    pass

  ##
  # @if jp
  #
  # @brief ͡ॵФ¸ǧ롣
  # 
  # @return true:¸Ƥ, false:¸Ƥʤ
  #
  # @else
  #
  # @brief Check if the name service is alive
  # 
  # @return true: alive, false:non not alive
  #
  # @endif
  #
  # virtual bool isAlive() = 0;
  def isAlive(self):
    pass


##
# @if jp
#
# @class NamingOnCorba
# @brief CORBA  NamingServer 饹
#
# CORBA  NamingServer ѥ饹
# CORBA ݡͥȤNamingServiceؤϿʤɤ롣
#
# @since 0.4.0
#
# @else
#
# @biref ModuleManager class
#
# @endif
class NamingOnCorba(NamingBase):
  """
  """

  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  #
  # 󥹥ȥ饯
  #
  # @param self
  # @param orb ORB
  # @param names NamingServer ̾
  #
  # @else
  #
  # @endif
  def __init__(self, orb, names):
    self._rtcout = OpenRTM_aist.Manager.instance().getLogbuf('manager.namingoncorba')
    self._cosnaming = OpenRTM_aist.CorbaNaming(orb,names)
    self._endpoint = ""
    self._replaceEndpoint = False

  ##
  # @if jp
  #
  # @brief ꤷ CORBA ֥ȤNamingServiceإХ
  # 
  # ꤷ CORBA ֥Ȥꤷ̾Τ CORBA NamingService 
  # Хɤ롣
  # 
  # @param self
  # @param name Хɻ̾
  # @param rtobj or mgr Хоݥ֥
  #
  # @else
  #
  # @endif
  def bindObject(self, name, rtobj):
    self._rtcout.RTC_TRACE("bindObject(name = %s, rtobj or mgr)", name)
    try:
      self._cosnaming.rebindByString(name, rtobj.getObjRef(), True)
    except:
      self._rtcout.RTC_ERROR(OpenRTM_aist.Logger.print_exception())

    return


  ##
  # @if jp
  #
  # @brief ꤷ CORBA ֥ȤNamingService饢Х
  # 
  # ꤷ CORBA ֥Ȥ CORBA NamingService 饢Хɤ롣
  # 
  # @param self
  # @param name Хоݥ֥
  #
  # @else
  #
  # @endif
  def unbindObject(self, name):
    self._rtcout.RTC_TRACE("unbindObject(name  = %s)", name)
    try:
      self._cosnaming.unbind(name)
    except:
      self._rtcout.RTC_ERROR(OpenRTM_aist.Logger.print_exception())

    return


  ##
  # @if jp
  #
  # @brief ͡ॵФ¸ǧ롣
  # 
  # @return true:¸Ƥ, false:¸Ƥʤ
  #
  # @else
  #
  # @brief Check if the name service is alive
  # 
  # @return true: alive, false:non not alive
  #
  # @endif
  #
  # virtual bool isAlive();
  def isAlive(self):
    self._rtcout.RTC_TRACE("isAlive()")
    return self._cosnaming.isAlive()


##
# @if jp
#
# @class NamingManager
# @brief NamingServer 饹
#
# NamingServer ѥ饹
# ݡͥȤNamingServiceؤϿʤɤ롣
#
# @since 0.4.0
#
# @else
#
# @biref ModuleManager class
#
# @endif
class NamingManager:
  """
  """



  ##
  # @if jp
  #
  # @brief 󥹥ȥ饯
  #
  # 󥹥ȥ饯
  #
  # @param self
  # @param manager ޥ͡㥪֥
  #
  # @else
  #
  # @endif
  def __init__(self, manager):
    self._manager = manager
    self._rtcout = manager.getLogbuf('manager.namingmanager')
    #self._rtcout.setLogLevel(manager.getConfig().getProperty("logger.log_level"))
    #self._rtcout.setLogLock(OpenRTM_aist.toBool(manager.getConfig().getProperty("logger.stream_lock"), "enable", "disable", False))
    self._names = []
    self._namesMutex = threading.RLock()
    self._compNames = []
    self._mgrNames  = []
    self._compNamesMutex = threading.RLock()
    self._mgrNamesMutex = threading.RLock()


  ##
  # @if jp
  #
  # @brief NameServer Ͽ
  #
  # ꤷ NameServer Ͽ롣
  # ߻ǽʷ CORBA Τߡ
  #
  # @param self
  # @param method NamingService η
  # @param name_server Ͽ NameServer ̾
  #
  # @else
  #
  # @endif
  def registerNameServer(self, method, name_server):
    self._rtcout.RTC_TRACE("NamingManager::registerNameServer(%s, %s)",
                           (method, name_server))
    name = self.createNamingObj(method, name_server)
    self._names.append(self.Names(method, name_server, name))


  ##
  # @if jp
  #
  # @brief ꤷ֥ȤNamingServiceإХ
  # 
  # ꤷ֥Ȥꤷ̾Τ CORBA NamingService إХɤ롣
  # 
  # @param self
  # @param name Хɻ̾
  # @param rtobj Хоݥ֥
  #
  # @else
  #
  # @endif
  def bindObject(self, name, rtobj):
    self._rtcout.RTC_TRACE("NamingManager::bindObject(%s)", name)
    guard = OpenRTM_aist.ScopedLock(self._namesMutex)
    for i in range(len(self._names)):
      if self._names[i].ns:
        try:
          self._names[i].ns.bindObject(name, rtobj)
        except:
          del self._names[i].ns
          self._names[i].ns = 0

    self.registerCompName(name, rtobj)


  def bindManagerObject(self, name, mgr):
    self._rtcout.RTC_TRACE("NamingManager::bindManagerObject(%s)", name)
    guard = OpenRTM_aist.ScopedLock(self._namesMutex)
    for i in range(len(self._names)):
      if self._names[i].ns:
        try:
          self._names[i].ns.bindObject(name, mgr)
        except:
          del self._names[i].ns
          self._names[i].ns = 0

    self.registerMgrName(name, mgr)


  ##
  # @if jp
  #
  # @brief NamingServer ξι
  # 
  # ꤵƤ NameServer ϿƤ륪֥Ȥξ
  # 롣
  # 
  # @param self
  # 
  # @else
  #
  # @endif
  def update(self):
    self._rtcout.RTC_TRACE("NamingManager::update()")
    guard = OpenRTM_aist.ScopedLock(self._namesMutex)
    rebind = OpenRTM_aist.toBool(self._manager.getConfig().getProperty("naming.update.rebind"),
                                 "YES","NO",False)
    for i in range(len(self._names)):
      if self._names[i].ns is None:
        self._rtcout.RTC_DEBUG("Retrying connection to %s/%s",
                               (self._names[i].method,
                                self._names[i].nsname))
        self.retryConnection(self._names[i])

      else:
        try:
          if rebind:
            self.bindCompsTo(self._names[i].ns)
          if not self._names[i].ns.isAlive():
            self._rtcout.RTC_INFO("Name server: %s (%s) disappeared.",
                                  (self._names[i].nsname,
                                   self._names[i].method))
            del self._names[i].ns
            self._names[i].ns = None
        except:
          self._rtcout.RTC_INFO("Name server: %s (%s) disappeared.",
                                (self._names[i].nsname,
                                 self._names[i].method))
          del self._names[i].ns
          self._names[i].ns = None


    return


  ##
  # @if jp
  #
  # @brief ꤷ֥ȤNamingService饢Х
  # 
  # ꤷ֥Ȥ NamingService 饢Хɤ롣
  # 
  # @param self
  # @param name Хоݥ֥
  #
  # @else
  #
  # @endif
  def unbindObject(self, name):
    self._rtcout.RTC_TRACE("NamingManager::unbindObject(%s)", name)
    guard = OpenRTM_aist.ScopedLock(self._namesMutex)
    for i in range(len(self._names)):
      if self._names[i].ns:
        self._names[i].ns.unbindObject(name)
    self.unregisterCompName(name)
    self.unregisterMgrName(name)


  ##
  # @if jp
  #
  # @brief ƤΥ֥ȤNamingService饢Х
  # 
  # ƤΥ֥Ȥ CORBA NamingService 饢Хɤ롣
  # 
  # @param self
  # 
  # @else
  #
  # @endif
  def unbindAll(self):
    self._rtcout.RTC_TRACE("NamingManager::unbindAll(): %d names.", len(self._compNames))

    guard = OpenRTM_aist.ScopedLock(self._compNamesMutex)
    len_ = len(self._compNames)
    for i in range(len_):
      idx = (len_ - 1) - i
      self.unbindObject(self._compNames[idx].name)

    guard = OpenRTM_aist.ScopedLock(self._mgrNamesMutex)
    len_ = len(self._mgrNames)
    for i in range(len_):
      idx = (len_ - 1) - i
      self.unbindObject(self._mgrNames[idx].name)


  ##
  # @if jp
  #
  # @brief ХɤƤƤΥ֥Ȥ
  # 
  # ХɤƤƤΥ֥Ȥ 롣
  # 
  # @param self
  #
  # @return ХɺѤߥ֥ ꥹ
  # 
  # @else
  #
  # @endif
  def getObjects(self):
    comps = []
    guard = OpenRTM_aist.ScopedLock(self._compNamesMutex)
    for i in range(len(self._compNames)):
      comps.append(self._compNames[i].rtobj)
    return comps


  ##
  # @if jp
  #
  # @brief NameServer ѥ֥Ȥ
  # 
  # ꤷNameServer ѥ֥Ȥ롣
  #
  # @param self
  # @param method NamingService 
  # @param name_server NameServer ̾
  # 
  # @return  NameServer ֥
  # 
  # @else
  #
  # @endif
  def createNamingObj(self, method, name_server):
    self._rtcout.RTC_TRACE("createNamingObj(method = %s, nameserver = %s)",
                           (method, name_server))
    mth = method
    if mth == "corba":
      try:
        name = OpenRTM_aist.NamingOnCorba(self._manager.getORB(),name_server)
        if name is None:
          return None
        self._rtcout.RTC_INFO("NameServer connection succeeded: %s/%s",
                              (method, name_server))
        return name
      except:
        self._rtcout.RTC_INFO("NameServer connection failed: %s/%s",
                              (method, name_server))
        return None

    return None


  ##
  # @if jp
  #
  # @brief ѤߥݡͥȤ NameServer Ͽ
  # 
  # ѤߥݡͥȤꤷ NameServer Ͽ롣
  #
  # @param self
  # @param ns Ͽо NameServer
  # 
  # @else
  #
  # @endif
  def bindCompsTo(self, ns):
    for i in range(len(self._compNames)):
      ns.bindObject(self._compNames[i].name, self._compNames[i].rtobj)


  ##
  # @if jp
  #
  # @brief NameServer Ͽ륳ݡͥȤ
  # 
  # NameServer Ͽ륳ݡͥȤꤹ롣
  #
  # @param self
  # @param name ݡͥȤϿ̾
  # @param rtobj Ͽоݥ֥
  # 
  # @else
  #
  # @endif
  def registerCompName(self, name, rtobj):
    for i in range(len(self._compNames)):
      if self._compNames[i].name == name:
        self._compNames[i].rtobj = rtobj
        return

    self._compNames.append(self.Comps(name, rtobj))
    return


  def registerMgrName(self, name, mgr):
    for i in range(len(self._mgrNames)):
      if self._mgrNames[i].name == name:
        self._mgrNames[i].mgr = mgr
        return

    self._mgrNames.append(self.Mgr(name, mgr))
    return


  ##
  # @if jp
  #
  # @brief NameServer Ͽ륳ݡͥȤ
  # 
  # NameServer Ͽ륳ݡͥȤ롣
  #
  # @param self
  # @param name оݥݡͥȤ̾
  # 
  # @else
  #
  # @endif
  def unregisterCompName(self, name):
    len_ = len(self._compNames)
    for i in range(len_):
      idx = (len_-1) - i
      if self._compNames[idx].name == name:
        del self._compNames[idx]
        return
    return
    

  def unregisterMgrName(self, name):
    len_ = len(self._mgrNames)
    for i in range(len_):
      idx = (len_ -1) - i
      if self._mgrNames[idx].name == name:
        del self._mgrNames[idx]
        return
    return


  ##
  # @if jp
  #
  # @brief ݥͥȤХɤ
  # 
  # ͡ॵФ³ƥݥͥȤХɤ롣
  #
  # @param ns NameServer
  # 
  # @else
  #
  # @brief Rebind the component to NameServer
  # 
  # Connect with the NameServer and rebind the component. 
  #
  # @param ns NameServer
  # 
  # @endif
  #
  # void retryConnection(Names* ns);
  def retryConnection(self, ns):
    # recreate NamingObj
    nsobj = 0
    try:
      nsobj = self.createNamingObj(ns.method, ns.nsname)
      if nsobj != 0: # if succeed
        self._rtcout.RTC_INFO("Connected to a name server: %s/%s",
                              (ns.method, ns.nsname))
        ns.ns = nsobj
        self.bindCompsTo(nsobj) # rebind all comps to new NS
        return
      else:
        self._rtcout.RTC_DEBUG("Name service: %s/%s still not available.",
                               (ns.method, ns.nsname))

    except:
      self._rtcout.RTC_DEBUG("Name server: %s/%s disappeared again.",
                             (ns.method, ns.nsname))
      if nsobj != 0:
        del ns.ns
        ns.ns = 0

    return


  # Name Servers' method/name and object
  ##
  # @if jp
  # @class Names
  # @brief NameServer ѥ饹
  # @else
  #
  # @endif
  class Names:
    def __init__(self, meth, name, naming):
      self.method = meth
      self.nsname = name
      self.ns     = naming


  # Components' name and object
  ##
  # @if jp
  # @class Comps
  # @brief ݡͥȴѥ饹
  # @else
  #
  # @endif
  class Comps:
    def __init__(self, n, obj):
      self.name = n
      self.rtobj = obj


  class Mgr:
    def __init__(self, n, obj):
      self.name = n
      self.mgr = obj
