#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file StringUtil.py
# @brief String operation utility
# @date $Date: $
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2003-2008
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.



import string

##
# @if jp
# @brief ʸ󤬥פƤ뤫ȽǤ
#
# ꤵ줿ʸפƤ뤫ɤȽǤ롣
#
# @param _str פƤ뤫ɤȽǤʸޤʸ
# @param pos פƤ뤫ɤȽǤʸΰ
#
# @return ꤷʸפƤ true, ʳ false
#
# @else
# @brief Whether the character is escaped or not
#
# This operation returns true if the specified character is escaped, and
# if the specified character is not escaped, it returns false
#
# @param str The string thath includes the character to be investigated.
# @param pos The position of the character to be investigated.
#
# @return true: the character is escaped, false: the character is not escaped.
#
# @endif
def isEscaped(_str, pos):
  pos -= 1

  i = 0
  while pos >= 0 and _str[pos] == "\\":
    i += 1
    pos -= 1

  return i % 2 == 1


##
# @if jp
# @class escape_functor
# @brief  ʸ󥨥׽functor
# @else
#
# @endif
class escape_functor:
  def __init__(self):
    self._str = ""

  def __call__(self,c):
    if   c == '\t':
      self._str += "\\t"
    elif c == '\n':
      self._str += "\\n"
    elif c == '\f':
      self._str += "\\f"
    elif c == '\r':
      self._str += "\\r"
    elif c == '\\':
      self._str += "\\\\"
    else:
      self._str += c


##
# @if jp
# @class unescape_functor
# @brief  ʸ󥢥󥨥׽functor
# @else
#
# @endif
class unescape_functor:
  def __init__(self):
    self.count = 0
    self._str = ""

  def __call__(self,c):
    if c == "\\":
      self.count += 1
      if not (self.count % 2):
        self._str += c
    else:
      if self.count > 0 and (self.count % 2):
        self.count = 0
        if c == 't':
          self._str+='\t'
        elif c == 'n':
          self._str+='\n'
        elif c == 'f':
          self._str+='\f'
        elif c == 'r':
          self._str+='\r'
        elif c == '\"':
          self._str+='\"'
        elif c == '\'':
          self._str+='\''
        else:
          self._str+=c
      else:
        self.count = 0
        self._str+=c


##
# @if jp
# @class unique_strvec
# @brief  ʣʸfunctor
# @else
#
# @endif
class unique_strvec:
  def __init__(self):
    self._str = []

  def __call__(self,s):
    if self._str.count(s) == 0:
      return self._str.append(s)


##
# @if jp
# @brief  󥹥functor
# @else
#
# @endif
def for_each(_str, instance):
  for i in _str:
    instance(i)

  return instance


##
# @if jp
# @brief ʸ򥨥פ
# 
# ʸ򥨥ץ󥹤Ѵ롣<br>
# HT -> "\t" <br>
# LF -> "\n" <br>
# CR -> "\r" <br>
# FF -> "\f" <br>
# 󥰥륯ȡ֥륯ȤˤĤƤϤȤ˽Ϥʤ
# 
# @else
# 
# @brief Escape string
# 
# The following characters are converted. <br>
# HT -> "\t" <br>
# LF -> "\n" <br>
# CR -> "\r" <br>
# FF -> "\f" <br>
# Single quote and dobule quote are not processed.
# 
# @endif
def escape(_str):
  return for_each(_str, escape_functor())._str


##
# @if jp
# @brief ʸΥפ᤹
# 
# Υץ󥹤ʸѴ롣<br>
# "\t" -> HT <br>
# "\n" -> LF <br>
# "\r" -> CR <br>
# "\f" -> FF <br>
# "\"" -> "  <br>
# "\'" -> '  <br>
# 
# @else
# 
# @brief Unescape string
# 
# The following characters are converted. <br>
# "\t" -> HT <br>
# "\n" -> LF <br>
# "\r" -> CR <br>
# "\f" -> FF <br>
# "\'" -> '  <br>
# "\"" -> "  <br>
# @endif
def unescape(_str):
  return for_each(_str, unescape_functor())._str


##
# @if jp
# @brief ʸζʸ
#
# Ϳ줿ʸζʸ롣
# ʸȤưΤ' '(ڡ)'\\t'()
#
# @param str(list) ʸʸΥꥹ
#
# @else
# @brief Erase blank characters of string
#
# Erase blank characters that exist at the head of the given string.
# Space ' 'and tab '\\t' are supported as the blank character.
#
# @param str The target blank characters of string for the erase
#
# @endif
#
def eraseBlank(str):
    if len(str) == 0:
        return
    str[0] = str[0].strip(" ")
    l_str = str[0].split(" ")
    tmp_str = ""
    for s in l_str:
        if s:
            tmp_str+=s.strip(" ")

    tmp_str = tmp_str.strip('\t')
    l_str = tmp_str.split('\t')
    tmp_str = ""
    for s in l_str:
        if s:
            tmp_str+=s.strip('\t')

    str[0] = tmp_str


##
# @if jp
# @brief ʸƬζʸ
#
# Ϳ줿ʸƬ¸ߤʸ롣
# ʸȤưΤ' '(ڡ)'\\t'()
#
# @param _str Ƭʸʸ
#
# @else
# @brief Erase the head blank characters of string
# @endif
def eraseHeadBlank(_str):
  _str[0] = _str[0].lstrip('\t ')


##
# @if jp
# @brief ʸζʸ
#
# Ϳ줿ʸ¸ߤʸ롣
# ʸȤưΤ' '(ڡ)'\\t'()
#
# @param _str ʸʸ
#
# @else
# @brief Erase the tail blank characters of string
# @endif
def eraseTailBlank(_str):
  #_str[0] = _str[0].rstrip('\t ')
  if _str[0] == "":
    return

  while (_str[0][-1] == " " or _str[0][-1] == '\t') and not isEscaped(_str[0], len(_str[0]) - 1):
    _str[0] = _str[0][:-1]


#
# @if jp
# @brief ʸ
# @else
# @brief Erase the head/tail blank and replace upper case to lower case
# @endif
#
def normalize(_str):
  _str[0] = _str[0].strip().lower()
  return _str[0]


##
# @if jp
# @brief ʸ֤
#
# Ϳ줿ʸФơꤷʸ֤Ԥ
#
# @param str ֤оʸ
# @param _from ִʸ
# @param _to ִʸ
#
# @else
# @brief Replace string
# @endif
def replaceString(str, _from, _to):
  str[0] = str[0].replace(_from, _to)


##
# @if jp
# @brief ʸʬʸʬ䤹
# 
# ꤵ줿ʸͿ줿ǥߥʬ䤹롣
#
# @param input ʬоʸ
# @param delimiter ʬʸ(ǥߥ)
#
# @return ʸʬ̥ꥹ
#
# @else
# @brief Split string by delimiter
# @endif
def split(input, delimiter):
  if not input:
    return []

  del_result = input.split(delimiter)

  len_ = len(del_result)

  result = []
  for i in range(len_):
    if del_result[i] == "" or del_result[i] == " ":
      continue
      
    str_ = [del_result[i]]
    eraseHeadBlank(str_)
    eraseTailBlank(str_)
    result.append(str_[0])
    
  return result


##
# @if jp
# @brief Ϳ줿ʸboolͤѴ
# 
# ꤵ줿ʸtrueɽʸfalseɽʸӤη̤
# boolͤȤ֤
# Ӥη̡trueɽʸfalseɽʸΤɤȤפʤϡ
# Ϳ줿ǥե֤ͤ
#
# @param _str Ƚоʸ
# @param yes trueɽʸ
# @param no falseɽʸ
# @param default_value ǥե(ǥե:None)
# @else
# @brief Convert given string to bool value
# @endif
def toBool(_str, yes, no, default_value=None):
  if default_value is None:
    default_value = True

  _str = _str.upper()
  yes  = yes.upper()
  no   = no.upper()

  if _str.find(yes) != -1:
    return True
  elif (_str.find(no)) != -1:
    return False
  else:
    return default_value

##
# @if jp
# @brief ʸꥹˤʸ󤬴ޤޤ뤫ɤ
# 
# 1˥޶ڤΥꥹȤ2õоʸꤷ
# ʸ1˴ޤޤ뤫ȽǤ롣
#
# @param list оݥꥹ
# @param value õʸ
# @return true: ޤޤ롢false: ޤޤʤ
#
# @else
# @brief Include if a string is included in string list
# 
# if the second argument is included in the comma separated string
# list of the first argument, This operation returns "true value".
#
# @param list The target comma separated string
# @param value The searched string
# @return true: included, false: not included
#
# @endif
#
#  bool includes(const vstring& list, std::string value,
#                bool ignore_case = true);
def includes(_list, value, ignore_case = True):
  if not (type(_list) == list or type(_list) == str):
    return False

  if type(_list) == str:
    _list = _list.split(",")

  tmp_list = _list
  if ignore_case:
    value = value.lower()
    tmp_list = map((lambda x: x.lower()),_list)
    
  if tmp_list.count(value) > 0:
    return True

  return False
    


##
# @if jp
# @brief Ϳ줿ʸХѥɤȽǤ
#
# Ϳ줿ʸХѥɽǤ뤫ɤȽǤ롣
# ʸ󤬰ʲξˤХѥȤȽǤ롣
#  - Ƭʸ'/' (UNIXξ)
#  - Ƭʸե٥åȡ'/''\\' (Windowsξ)
#  - Ƭʸ'\\\\' (Windowsͥåȥѥξ)
#
# @param str Ƚоʸ
#
# @return ХѥȽ
#
# @else
# @brief Investigate whether the given string is absolute path or not
# @endif
def isAbsolutePath(str):
  if str[0] == "/":
    return True
  if str[0].isalpha() and str[1] == ":" and str[2] == "\\":
    return True
  if str[0] == "\\" and str[1] == "\\":
    return True

  return False


##
# @if jp
# @brief Ϳ줿ʸURLɤȽǤ
#
# Ϳ줿ʸURLɽɤȽǤ롣
# Ϳ줿ʸˡ'://'Ȥʸ󤬴ޤޤƤˤ
# URLɽȤȽǤ롣
#
# @param str Ƚоʸ
#
# @return URLȽ
#
# @else
# @brief Investigate whether the given string is URL or not
# @endif
def isURL(str):
  pos = 0
  if str == "":
    return False

  pos = str.find(":")
  if pos != 0 and pos != -1 and str[pos+1] == "/" and str[pos+2] == "/":
    return True

  return False


##
# @if jp
# @brief Ϳ줿֥ȤʸѴ
#
# ǻꤵ줿֥ȤʸѴ롣
#
# @param n Ѵоݥ֥
#
# @return ʸѴ
#
# @else
# @brief Convert the given object to st::string.
# @endif
def otos(n):
  if type(n) == int or type(n) == str or type(n) == long or type(n) == float:
    return str(n)



##
# @if jp
# @brief Ϳ줿ʸꥹȤѴ
#
# ǻꤵ줿ʸ,ʬ䤷ꥹȤѴ롣
#
# @param _type Ѵ̥ꥹ
# @param _str Ѵʸ
#
# @return ꥹѴ
#
# @else
# 
# @endif
def _stringToList(_type, _str):
  list_ = split(_str,",")
  len_ = len(list_)

  if len(_type[0]) < len(list_):
    sub = len(list_) - len(_type[0])
    for i in range(sub):
      _type[0].append(_type[0][0])
  elif len(_type[0]) > len(list_):
    sub = len(_type[0]) - len(list_)
    for i in range(sub):
      del _type[0][-1]

  for i in range(len_):
    str_ = [list_[i]]
    eraseHeadBlank(str_)
    eraseTailBlank(str_)
    list_[i] = str_[0]

  for i in range(len(list_)):
    if type(_type[0][i]) == int:
      _type[0][i] = int(list_[i])
    elif type(_type[0][i]) == long:
      _type[0][i] = long(list_[i])
    elif type(_type[0][i]) == float:
      _type[0][i] = float(list_[i])
    elif type(_type[0][i]) == str:
      _type[0][i] = str(list_[i])
    else:
      return False

  return True


##
# @if jp
# @brief Ϳ줿ʸ򥪥֥ȤѴ
#
# Ϳ줿ʸꤵ줿֥ȤѴ롣
#
# @param _type Ѵ襪֥
# @param _str Ѵʸ
#
# @return Ѵ¹Է
#
# @else
# @brief Convert the given object to st::string.
# @endif
def stringTo(_type, _str):
  if not _str:
    return False

  if type(_type[0]) == int:
    _type[0] = int(_str)
    return True
  elif type(_type[0]) == long:
    _type[0] = long(_str)
    return True
  elif type(_type[0]) == float:
    _type[0] = float(_str)
    return True
  elif type(_type[0]) == list:
    return _stringToList(_type, _str)
  elif type(_type[0]) == str:
    _type[0] = str(_str)
    return True
  
  return False


##
# @if jp
# @brief Ϳ줿ʸꥹȤʣ
#
# Ϳ줿ʸꥹȤʣꥹȤ롣
#
# @param sv ǧʸꥹ
#
# @return ʣ̥ꥹ
#
# @else
#
# @endif
def unique_sv(sv):
  return for_each(sv, unique_strvec())._str


##
# @if jp
# @brief Ϳ줿ʸꥹȤCSV
#
# Ϳ줿ʸꥹȤγǤ¤٤CSV롣
# ʸꥹȤξˤ϶ʸ֤
#
# @param sv CSVѴоʸꥹ
#
# @return CSVѴʸ
#
# @else
#
# @endif
def flatten(sv):
  if len(sv) == 0:
    return ""

  _str = ", ".join(sv)

  return _str


##
# @if jp
# @brief Ϳ줿ʸꥹȤꥹȤѴ
#
# Ϳ줿ʸꥹȤγ'\\0'ä
# ꥹȤѴ롣<br>
# ܥ⥸塼Ǥϰ򤽤Τޤ֤
#
# @param args Ѵоʸꥹ
#
# @return Ѵʸ
#
# @else
#
# @endif
def toArgv(args):
  return args
