// -*- C++ -*-
/*!
 * @file Task_win32.cpp
 * @brief Task class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2008
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#include <coil/Task.h>

namespace coil
{

  /*!
   * @if jp
   * @brief RXgN^
   * @else
   * @brief Constructor
   * @endif
   */
  Task::Task()
    : m_count(0)
  {
  }

  /*!
   * @if jp
   * @brief fXgN^
   * @else
   * @brief Destructor
   * @endif
   */
  Task::~Task()
  {
    m_count = 0;
  }

  /*!
   * @if jp
   * @brief ^XNI[v
   * @else
   * @brief Task open
   * @endif
   */
  int Task::open(void* args)
  {
    return 0;
  }

  /*!
   * @if jp
   * @brief ^XNN[Y
   * @else
   * @brief Task close
   * @endif
   */
  int Task::close(unsigned long flags)
  {
    return 0;
  }

  /*!
   * @if jp
   * @brief Xbhs
   * @else
   * @brief Execute thread
   * @endif
   */
  int Task::svc()
  {
    return 0;
  }

  /*!
   * @if jp
   * @brief Xbh𐶐
   * @else
   * @brief Create a thread
   * @endif
   */
  void Task::activate()
  {
    if (m_count == 0)
      {
		  m_thread =
			  (HANDLE)::_beginthreadex(NULL, // security
			  0, //stuck size
			  Task::svc_run, // func
			  (void*)this, // argument
			  0, // flag (0 or CREATE_SUSPEND)
			  NULL); //thread descripter
		  ++m_count;
      };
  }

  /*!
   * @if jp
   * @brief XbhI҂
   * @else
   * @brief Waiting for the thread terminate
   * @endif
   */
  int Task::wait(void)
  {
    if (m_count > 0)
      {
        DWORD retval;
	retval = ::WaitForSingleObject(m_thread, INFINITE);
      }
    return 0;
  }

  /*!
   * @if jp
   * @brief ^XNs𒆒f
   * @else
   * @brief Suspending the task
   * @endif
   */
  int Task::suspend(void)
  {
    return 0;
  }

  /*!
   * @if jp
   * @brief fĂ^XNĊJ
   * @else
   * @brief Resuming the suspended task
   * @endif
   */
  int Task::resume(void)
  {
    return 0;
  }

  /*!
   * @if jp
   * @brief ^XNZbg
   * @else
   * @brief Reset of task count
   * @endif
   */
  void Task::reset()
  {
    m_count = 0;
  }

  /*!
   * @if jp
   * @brief ^XNsI
   * @else
   * @brief Finalizing the task
   * @endif
   */
  void Task::finalize()
  {
    reset();
  }
 
  /*!
   * @if jp
   * @brief XbhsJn
   * @else
   * @brief Start thread Execution
   * @endif
   */
  unsigned int WINAPI Task::svc_run(void* args)
  {
    Task* t = (coil::Task*)args;
    int status;
    status = t->svc();
    t->finalize();
    return 0;
  }
};


