/*
    Copyright (C) 2014 Parrot SA
    
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
    * Neither the name of Parrot nor the names
    of its contributors may be used to endorse or promote products
    derived from this software without specific prior written
    permission.
    
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/**
 * @file libARCommands/ARCOMMANDS_Decoder.h
 * @brief libARCommands decoder header.
 * This file contains all declarations needed to decode commands
 * @note Autogenerated file
 **/
#ifndef _LIBARCOMMANDS_ARCOMMANDS_DECODER_H_
#define _LIBARCOMMANDS_ARCOMMANDS_DECODER_H_
#include <libARCommands/ARCOMMANDS_Types.h>
#include <inttypes.h>


/**
 * @brief Error codes for ARCOMMANDS_Decoder_DecodeBuffer function
 */
typedef enum {
    ARCOMMANDS_DECODER_OK = 0, ///< No error occured
    ARCOMMANDS_DECODER_ERROR_NO_CALLBACK, ///< No error, but no callback was set (so the call had no effect)
    ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND, ///< The command buffer contained an unknown command
    ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA, ///< The command buffer did not contain enough data for the specified command
    ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_SPACE, ///< The string buffer was not big enough for the command description
    ARCOMMANDS_DECODER_ERROR, ///< Any other error
} eARCOMMANDS_DECODER_ERROR;

/**
 * @brief Decode a comand buffer
 * On success, the callback set for the command will be called in the current thread.
 * @param buffer the command buffer to decode
 * @param buffLen the length of the command buffer
 * @return ARCOMMANDS_DECODER_OK on success, any error code otherwise
 */
eARCOMMANDS_DECODER_ERROR
ARCOMMANDS_Decoder_DecodeBuffer (uint8_t *buffer, int32_t buffLen);


/**
 * @brief Describe a comand buffer
 * @param buffer the command buffer to decode
 * @param buffLen the length of the command buffer
 * @param resString the string pointer in which the description will be stored
 * @param stringLen the length of the string pointer
 * @return ARCOMMANDS_DECODER_OK on success, any error code otherwise
 */
eARCOMMANDS_DECODER_ERROR
ARCOMMANDS_Decoder_DescribeBuffer (uint8_t *buffer, int32_t buffLen, char *resString, int32_t stringLen);

// Feature generic


/**
 * @brief callback type for the command generic.default
 */
typedef void (*ARCOMMANDS_Decoder_GenericDefaultCallback_t) (void *custom);
/**
 * @brief callback setter for the command generic.default
 * @param callback new callback for the command generic.default
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetGenericDefaultCallback (ARCOMMANDS_Decoder_GenericDefaultCallback_t callback, void *custom);

// Feature ARDrone3


/**
 * @brief callback type for the command ARDrone3.Piloting.FlatTrim
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCallback_t) (void *custom);
/**
 * @brief callback setter for the command ARDrone3.Piloting.FlatTrim
 * @param callback new callback for the command ARDrone3.Piloting.FlatTrim
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingFlatTrimCallback (ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Piloting.TakeOff
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCallback_t) (void *custom);
/**
 * @brief callback setter for the command ARDrone3.Piloting.TakeOff
 * @param callback new callback for the command ARDrone3.Piloting.TakeOff
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingTakeOffCallback (ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Piloting.PCMD
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCallback_t) (uint8_t flag, int8_t roll, int8_t pitch, int8_t yaw, int8_t gaz, uint32_t timestampAndSeqNum, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Piloting.PCMD
 * @param callback new callback for the command ARDrone3.Piloting.PCMD
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingPCMDCallback (ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Piloting.Landing
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingLandingCallback_t) (void *custom);
/**
 * @brief callback setter for the command ARDrone3.Piloting.Landing
 * @param callback new callback for the command ARDrone3.Piloting.Landing
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingLandingCallback (ARCOMMANDS_Decoder_ARDrone3PilotingLandingCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Piloting.Emergency
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCallback_t) (void *custom);
/**
 * @brief callback setter for the command ARDrone3.Piloting.Emergency
 * @param callback new callback for the command ARDrone3.Piloting.Emergency
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingEmergencyCallback (ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Piloting.NavigateHome
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCallback_t) (uint8_t start, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Piloting.NavigateHome
 * @param callback new callback for the command ARDrone3.Piloting.NavigateHome
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingNavigateHomeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Piloting.AutoTakeOffMode
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCallback_t) (uint8_t state, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Piloting.AutoTakeOffMode
 * @param callback new callback for the command ARDrone3.Piloting.AutoTakeOffMode
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingAutoTakeOffModeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Piloting.moveBy
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCallback_t) (float dX, float dY, float dZ, float dPsi, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Piloting.moveBy
 * @param callback new callback for the command ARDrone3.Piloting.moveBy
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingMoveByCallback (ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Piloting.UserTakeOff
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCallback_t) (uint8_t state, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Piloting.UserTakeOff
 * @param callback new callback for the command ARDrone3.Piloting.UserTakeOff
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingUserTakeOffCallback (ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Piloting.Circle
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingCircleCallback_t) (eARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION direction, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Piloting.Circle
 * @param callback new callback for the command ARDrone3.Piloting.Circle
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingCircleCallback (ARCOMMANDS_Decoder_ARDrone3PilotingCircleCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Animations.Flip
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCallback_t) (eARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION direction, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Animations.Flip
 * @param callback new callback for the command ARDrone3.Animations.Flip
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3AnimationsFlipCallback (ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Camera.Orientation
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3CameraOrientationCallback_t) (int8_t tilt, int8_t pan, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Camera.Orientation
 * @param callback new callback for the command ARDrone3.Camera.Orientation
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3CameraOrientationCallback (ARCOMMANDS_Decoder_ARDrone3CameraOrientationCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaRecord.Picture
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCallback_t) (uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaRecord.Picture
 * @param callback new callback for the command ARDrone3.MediaRecord.Picture
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordPictureCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaRecord.Video
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCallback_t) (eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD record, uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaRecord.Video
 * @param callback new callback for the command ARDrone3.MediaRecord.Video
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordVideoCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaRecord.PictureV2
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Callback_t) (void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaRecord.PictureV2
 * @param callback new callback for the command ARDrone3.MediaRecord.PictureV2
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordPictureV2Callback (ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Callback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaRecord.VideoV2
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Callback_t) (eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD record, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaRecord.VideoV2
 * @param callback new callback for the command ARDrone3.MediaRecord.VideoV2
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordVideoV2Callback (ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Callback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Network.WifiScan
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCallback_t) (eARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND band, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Network.WifiScan
 * @param callback new callback for the command ARDrone3.Network.WifiScan
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkWifiScanCallback (ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Network.WifiAuthChannel
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCallback_t) (void *custom);
/**
 * @brief callback setter for the command ARDrone3.Network.WifiAuthChannel
 * @param callback new callback for the command ARDrone3.Network.WifiAuthChannel
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkWifiAuthChannelCallback (ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.MaxAltitude
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.MaxAltitude
 * @param callback new callback for the command ARDrone3.PilotingSettings.MaxAltitude
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMaxAltitudeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.MaxTilt
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.MaxTilt
 * @param callback new callback for the command ARDrone3.PilotingSettings.MaxTilt
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMaxTiltCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.AbsolutControl
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCallback_t) (uint8_t on, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.AbsolutControl
 * @param callback new callback for the command ARDrone3.PilotingSettings.AbsolutControl
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsAbsolutControlCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.MaxDistance
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.MaxDistance
 * @param callback new callback for the command ARDrone3.PilotingSettings.MaxDistance
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMaxDistanceCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.NoFlyOverMaxDistance
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCallback_t) (uint8_t shouldNotFlyOver, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.NoFlyOverMaxDistance
 * @param callback new callback for the command ARDrone3.PilotingSettings.NoFlyOverMaxDistance
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsNoFlyOverMaxDistanceCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxHorizontalSpeed
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxHorizontalSpeed
 * @param callback new callback for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxHorizontalSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxVerticalSpeed
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxVerticalSpeed
 * @param callback new callback for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxVerticalSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxHorizontalAcceleration
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxHorizontalAcceleration
 * @param callback new callback for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxHorizontalAcceleration
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxVerticalAcceleration
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxVerticalAcceleration
 * @param callback new callback for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxVerticalAcceleration
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxRotationSpeed
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxRotationSpeed
 * @param callback new callback for the command ARDrone3.PilotingSettings.setAutonomousFlightMaxRotationSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.BankedTurn
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCallback_t) (uint8_t value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.BankedTurn
 * @param callback new callback for the command ARDrone3.PilotingSettings.BankedTurn
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsBankedTurnCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.MinAltitude
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.MinAltitude
 * @param callback new callback for the command ARDrone3.PilotingSettings.MinAltitude
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMinAltitudeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.CirclingDirection
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCallback_t) (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.CirclingDirection
 * @param callback new callback for the command ARDrone3.PilotingSettings.CirclingDirection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsCirclingDirectionCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.CirclingRadius
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCallback_t) (uint16_t value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.CirclingRadius
 * @param callback new callback for the command ARDrone3.PilotingSettings.CirclingRadius
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsCirclingRadiusCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.CirclingAltitude
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCallback_t) (uint16_t value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.CirclingAltitude
 * @param callback new callback for the command ARDrone3.PilotingSettings.CirclingAltitude
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsCirclingAltitudeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.PitchMode
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCallback_t) (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.PitchMode
 * @param callback new callback for the command ARDrone3.PilotingSettings.PitchMode
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsPitchModeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettings.LandingMode
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCallback_t) (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettings.LandingMode
 * @param callback new callback for the command ARDrone3.PilotingSettings.LandingMode
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsLandingModeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SpeedSettings.MaxVerticalSpeed
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SpeedSettings.MaxVerticalSpeed
 * @param callback new callback for the command ARDrone3.SpeedSettings.MaxVerticalSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsMaxVerticalSpeedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SpeedSettings.MaxRotationSpeed
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SpeedSettings.MaxRotationSpeed
 * @param callback new callback for the command ARDrone3.SpeedSettings.MaxRotationSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsMaxRotationSpeedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SpeedSettings.HullProtection
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCallback_t) (uint8_t present, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SpeedSettings.HullProtection
 * @param callback new callback for the command ARDrone3.SpeedSettings.HullProtection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsHullProtectionCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SpeedSettings.Outdoor
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCallback_t) (uint8_t outdoor, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SpeedSettings.Outdoor
 * @param callback new callback for the command ARDrone3.SpeedSettings.Outdoor
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsOutdoorCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SpeedSettings.MaxPitchRollRotationSpeed
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SpeedSettings.MaxPitchRollRotationSpeed
 * @param callback new callback for the command ARDrone3.SpeedSettings.MaxPitchRollRotationSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsMaxPitchRollRotationSpeedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.NetworkSettings.WifiSelection
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCallback_t) (eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND band, uint8_t channel, void *custom);
/**
 * @brief callback setter for the command ARDrone3.NetworkSettings.WifiSelection
 * @param callback new callback for the command ARDrone3.NetworkSettings.WifiSelection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsWifiSelectionCallback (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.NetworkSettings.wifiSecurity
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCallback_t) (eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE type, char * key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE keyType, void *custom);
/**
 * @brief callback setter for the command ARDrone3.NetworkSettings.wifiSecurity
 * @param callback new callback for the command ARDrone3.NetworkSettings.wifiSecurity
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsWifiSecurityCallback (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettings.PictureFormatSelection
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCallback_t) (eARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE type, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettings.PictureFormatSelection
 * @param callback new callback for the command ARDrone3.PictureSettings.PictureFormatSelection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsPictureFormatSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettings.AutoWhiteBalanceSelection
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCallback_t) (eARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE type, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettings.AutoWhiteBalanceSelection
 * @param callback new callback for the command ARDrone3.PictureSettings.AutoWhiteBalanceSelection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsAutoWhiteBalanceSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettings.ExpositionSelection
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettings.ExpositionSelection
 * @param callback new callback for the command ARDrone3.PictureSettings.ExpositionSelection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsExpositionSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettings.SaturationSelection
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettings.SaturationSelection
 * @param callback new callback for the command ARDrone3.PictureSettings.SaturationSelection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsSaturationSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettings.TimelapseSelection
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCallback_t) (uint8_t enabled, float interval, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettings.TimelapseSelection
 * @param callback new callback for the command ARDrone3.PictureSettings.TimelapseSelection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsTimelapseSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettings.VideoAutorecordSelection
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCallback_t) (uint8_t enabled, uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettings.VideoAutorecordSelection
 * @param callback new callback for the command ARDrone3.PictureSettings.VideoAutorecordSelection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsVideoAutorecordSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettings.VideoStabilizationMode
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCallback_t) (eARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE mode, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettings.VideoStabilizationMode
 * @param callback new callback for the command ARDrone3.PictureSettings.VideoStabilizationMode
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsVideoStabilizationModeCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaStreaming.VideoEnable
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCallback_t) (uint8_t enable, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaStreaming.VideoEnable
 * @param callback new callback for the command ARDrone3.MediaStreaming.VideoEnable
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaStreamingVideoEnableCallback (ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettings.SetHome
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCallback_t) (double latitude, double longitude, double altitude, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettings.SetHome
 * @param callback new callback for the command ARDrone3.GPSSettings.SetHome
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsSetHomeCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettings.ResetHome
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCallback_t) (void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettings.ResetHome
 * @param callback new callback for the command ARDrone3.GPSSettings.ResetHome
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsResetHomeCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettings.SendControllerGPS
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCallback_t) (double latitude, double longitude, double altitude, double horizontalAccuracy, double verticalAccuracy, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettings.SendControllerGPS
 * @param callback new callback for the command ARDrone3.GPSSettings.SendControllerGPS
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsSendControllerGPSCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettings.HomeType
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCallback_t) (eARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE type, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettings.HomeType
 * @param callback new callback for the command ARDrone3.GPSSettings.HomeType
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsHomeTypeCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettings.ReturnHomeDelay
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCallback_t) (uint16_t delay, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettings.ReturnHomeDelay
 * @param callback new callback for the command ARDrone3.GPSSettings.ReturnHomeDelay
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsReturnHomeDelayCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Antiflickering.electricFrequency
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCallback_t) (eARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY frequency, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Antiflickering.electricFrequency
 * @param callback new callback for the command ARDrone3.Antiflickering.electricFrequency
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3AntiflickeringElectricFrequencyCallback (ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.Antiflickering.setMode
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCallback_t) (eARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE mode, void *custom);
/**
 * @brief callback setter for the command ARDrone3.Antiflickering.setMode
 * @param callback new callback for the command ARDrone3.Antiflickering.setMode
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3AntiflickeringSetModeCallback (ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaRecordState.PictureStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCallback_t) (uint8_t state, uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaRecordState.PictureStateChanged
 * @param callback new callback for the command ARDrone3.MediaRecordState.PictureStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordStatePictureStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaRecordState.VideoStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCallback_t) (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE state, uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaRecordState.VideoStateChanged
 * @param callback new callback for the command ARDrone3.MediaRecordState.VideoStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordStateVideoStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaRecordState.PictureStateChangedV2
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Callback_t) (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR error, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaRecordState.PictureStateChangedV2
 * @param callback new callback for the command ARDrone3.MediaRecordState.PictureStateChangedV2
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordStatePictureStateChangedV2Callback (ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Callback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaRecordState.VideoStateChangedV2
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Callback_t) (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR error, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaRecordState.VideoStateChangedV2
 * @param callback new callback for the command ARDrone3.MediaRecordState.VideoStateChangedV2
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordStateVideoStateChangedV2Callback (ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Callback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaRecordEvent.PictureEventChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCallback_t) (eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR error, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaRecordEvent.PictureEventChanged
 * @param callback new callback for the command ARDrone3.MediaRecordEvent.PictureEventChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordEventPictureEventChangedCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaRecordEvent.VideoEventChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCallback_t) (eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR error, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaRecordEvent.VideoEventChanged
 * @param callback new callback for the command ARDrone3.MediaRecordEvent.VideoEventChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordEventVideoEventChangedCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingState.FlatTrimChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingState.FlatTrimChanged
 * @param callback new callback for the command ARDrone3.PilotingState.FlatTrimChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateFlatTrimChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingState.FlyingStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCallback_t) (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE state, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingState.FlyingStateChanged
 * @param callback new callback for the command ARDrone3.PilotingState.FlyingStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateFlyingStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingState.AlertStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCallback_t) (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE state, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingState.AlertStateChanged
 * @param callback new callback for the command ARDrone3.PilotingState.AlertStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateAlertStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingState.NavigateHomeStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCallback_t) (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE state, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON reason, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingState.NavigateHomeStateChanged
 * @param callback new callback for the command ARDrone3.PilotingState.NavigateHomeStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateNavigateHomeStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingState.PositionChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCallback_t) (double latitude, double longitude, double altitude, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingState.PositionChanged
 * @param callback new callback for the command ARDrone3.PilotingState.PositionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingStatePositionChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingState.SpeedChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCallback_t) (float speedX, float speedY, float speedZ, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingState.SpeedChanged
 * @param callback new callback for the command ARDrone3.PilotingState.SpeedChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateSpeedChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingState.AttitudeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCallback_t) (float roll, float pitch, float yaw, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingState.AttitudeChanged
 * @param callback new callback for the command ARDrone3.PilotingState.AttitudeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateAttitudeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingState.AutoTakeOffModeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCallback_t) (uint8_t state, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingState.AutoTakeOffModeChanged
 * @param callback new callback for the command ARDrone3.PilotingState.AutoTakeOffModeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateAutoTakeOffModeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingState.AltitudeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCallback_t) (double altitude, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingState.AltitudeChanged
 * @param callback new callback for the command ARDrone3.PilotingState.AltitudeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateAltitudeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingEvent.moveByEnd
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCallback_t) (float dX, float dY, float dZ, float dPsi, eARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR error, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingEvent.moveByEnd
 * @param callback new callback for the command ARDrone3.PilotingEvent.moveByEnd
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingEventMoveByEndCallback (ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.NetworkState.WifiScanListChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCallback_t) (char * ssid, int16_t rssi, eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND band, uint8_t channel, void *custom);
/**
 * @brief callback setter for the command ARDrone3.NetworkState.WifiScanListChanged
 * @param callback new callback for the command ARDrone3.NetworkState.WifiScanListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkStateWifiScanListChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.NetworkState.AllWifiScanChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command ARDrone3.NetworkState.AllWifiScanChanged
 * @param callback new callback for the command ARDrone3.NetworkState.AllWifiScanChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkStateAllWifiScanChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.NetworkState.WifiAuthChannelListChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCallback_t) (eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND band, uint8_t channel, uint8_t in_or_out, void *custom);
/**
 * @brief callback setter for the command ARDrone3.NetworkState.WifiAuthChannelListChanged
 * @param callback new callback for the command ARDrone3.NetworkState.WifiAuthChannelListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkStateWifiAuthChannelListChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.NetworkState.AllWifiAuthChannelChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command ARDrone3.NetworkState.AllWifiAuthChannelChanged
 * @param callback new callback for the command ARDrone3.NetworkState.AllWifiAuthChannelChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkStateAllWifiAuthChannelChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.MaxAltitudeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.MaxAltitudeChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.MaxAltitudeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxAltitudeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.MaxTiltChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.MaxTiltChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.MaxTiltChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxTiltChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.AbsolutControlChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCallback_t) (uint8_t on, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.AbsolutControlChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.AbsolutControlChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAbsolutControlChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.MaxDistanceChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.MaxDistanceChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.MaxDistanceChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxDistanceChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.NoFlyOverMaxDistanceChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback_t) (uint8_t shouldNotFlyOver, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.NoFlyOverMaxDistanceChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.NoFlyOverMaxDistanceChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxHorizontalSpeed
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxHorizontalSpeed
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxHorizontalSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxVerticalSpeed
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxVerticalSpeed
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxVerticalSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxHorizontalAcceleration
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxHorizontalAcceleration
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxHorizontalAcceleration
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxVerticalAcceleration
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxVerticalAcceleration
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxVerticalAcceleration
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxRotationSpeed
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback_t) (float value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxRotationSpeed
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.AutonomousFlightMaxRotationSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.BankedTurnChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCallback_t) (uint8_t state, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.BankedTurnChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.BankedTurnChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateBankedTurnChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.MinAltitudeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.MinAltitudeChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.MinAltitudeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMinAltitudeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.CirclingDirectionChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCallback_t) (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.CirclingDirectionChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.CirclingDirectionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingDirectionChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.CirclingRadiusChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCallback_t) (uint16_t current, uint16_t min, uint16_t max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.CirclingRadiusChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.CirclingRadiusChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingRadiusChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.CirclingAltitudeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCallback_t) (uint16_t current, uint16_t min, uint16_t max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.CirclingAltitudeChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.CirclingAltitudeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingAltitudeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.PitchModeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCallback_t) (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.PitchModeChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.PitchModeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStatePitchModeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PilotingSettingsState.LandingModeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCallback_t) (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE value, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PilotingSettingsState.LandingModeChanged
 * @param callback new callback for the command ARDrone3.PilotingSettingsState.LandingModeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateLandingModeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SpeedSettingsState.MaxVerticalSpeedChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SpeedSettingsState.MaxVerticalSpeedChanged
 * @param callback new callback for the command ARDrone3.SpeedSettingsState.MaxVerticalSpeedChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SpeedSettingsState.MaxRotationSpeedChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SpeedSettingsState.MaxRotationSpeedChanged
 * @param callback new callback for the command ARDrone3.SpeedSettingsState.MaxRotationSpeedChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxRotationSpeedChangedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SpeedSettingsState.HullProtectionChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCallback_t) (uint8_t present, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SpeedSettingsState.HullProtectionChanged
 * @param callback new callback for the command ARDrone3.SpeedSettingsState.HullProtectionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateHullProtectionChangedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SpeedSettingsState.OutdoorChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCallback_t) (uint8_t outdoor, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SpeedSettingsState.OutdoorChanged
 * @param callback new callback for the command ARDrone3.SpeedSettingsState.OutdoorChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateOutdoorChangedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SpeedSettingsState.MaxPitchRollRotationSpeedChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SpeedSettingsState.MaxPitchRollRotationSpeedChanged
 * @param callback new callback for the command ARDrone3.SpeedSettingsState.MaxPitchRollRotationSpeedChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.NetworkSettingsState.WifiSelectionChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCallback_t) (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND band, uint8_t channel, void *custom);
/**
 * @brief callback setter for the command ARDrone3.NetworkSettingsState.WifiSelectionChanged
 * @param callback new callback for the command ARDrone3.NetworkSettingsState.WifiSelectionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSelectionChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.NetworkSettingsState.wifiSecurityChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCallback_t) (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE type, void *custom);
/**
 * @brief callback setter for the command ARDrone3.NetworkSettingsState.wifiSecurityChanged
 * @param callback new callback for the command ARDrone3.NetworkSettingsState.wifiSecurityChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSecurityChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.NetworkSettingsState.wifiSecurity
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCallback_t) (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE type, char * key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE keyType, void *custom);
/**
 * @brief callback setter for the command ARDrone3.NetworkSettingsState.wifiSecurity
 * @param callback new callback for the command ARDrone3.NetworkSettingsState.wifiSecurity
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSecurityCallback (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SettingsState.ProductMotorVersionListChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCallback_t) (uint8_t motor_number, char * type, char * software, char * hardware, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SettingsState.ProductMotorVersionListChanged
 * @param callback new callback for the command ARDrone3.SettingsState.ProductMotorVersionListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateProductMotorVersionListChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SettingsState.ProductGPSVersionChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCallback_t) (char * software, char * hardware, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SettingsState.ProductGPSVersionChanged
 * @param callback new callback for the command ARDrone3.SettingsState.ProductGPSVersionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateProductGPSVersionChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SettingsState.MotorErrorStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCallback_t) (uint8_t motorIds, eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR motorError, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SettingsState.MotorErrorStateChanged
 * @param callback new callback for the command ARDrone3.SettingsState.MotorErrorStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorErrorStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SettingsState.MotorSoftwareVersionChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCallback_t) (char * version, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SettingsState.MotorSoftwareVersionChanged
 * @param callback new callback for the command ARDrone3.SettingsState.MotorSoftwareVersionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorSoftwareVersionChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SettingsState.MotorFlightsStatusChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCallback_t) (uint16_t nbFlights, uint16_t lastFlightDuration, uint32_t totalFlightDuration, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SettingsState.MotorFlightsStatusChanged
 * @param callback new callback for the command ARDrone3.SettingsState.MotorFlightsStatusChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorFlightsStatusChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SettingsState.MotorErrorLastErrorChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCallback_t) (eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR motorError, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SettingsState.MotorErrorLastErrorChanged
 * @param callback new callback for the command ARDrone3.SettingsState.MotorErrorLastErrorChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorErrorLastErrorChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.SettingsState.P7ID
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCallback_t) (char * serialID, void *custom);
/**
 * @brief callback setter for the command ARDrone3.SettingsState.P7ID
 * @param callback new callback for the command ARDrone3.SettingsState.P7ID
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateP7IDCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettingsState.PictureFormatChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCallback_t) (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE type, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettingsState.PictureFormatChanged
 * @param callback new callback for the command ARDrone3.PictureSettingsState.PictureFormatChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStatePictureFormatChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettingsState.AutoWhiteBalanceChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCallback_t) (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE type, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettingsState.AutoWhiteBalanceChanged
 * @param callback new callback for the command ARDrone3.PictureSettingsState.AutoWhiteBalanceChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateAutoWhiteBalanceChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettingsState.ExpositionChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCallback_t) (float value, float min, float max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettingsState.ExpositionChanged
 * @param callback new callback for the command ARDrone3.PictureSettingsState.ExpositionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateExpositionChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettingsState.SaturationChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCallback_t) (float value, float min, float max, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettingsState.SaturationChanged
 * @param callback new callback for the command ARDrone3.PictureSettingsState.SaturationChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateSaturationChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettingsState.TimelapseChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCallback_t) (uint8_t enabled, float interval, float minInterval, float maxInterval, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettingsState.TimelapseChanged
 * @param callback new callback for the command ARDrone3.PictureSettingsState.TimelapseChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateTimelapseChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettingsState.VideoAutorecordChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCallback_t) (uint8_t enabled, uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettingsState.VideoAutorecordChanged
 * @param callback new callback for the command ARDrone3.PictureSettingsState.VideoAutorecordChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateVideoAutorecordChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PictureSettingsState.VideoStabilizationModeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCallback_t) (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE mode, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PictureSettingsState.VideoStabilizationModeChanged
 * @param callback new callback for the command ARDrone3.PictureSettingsState.VideoStabilizationModeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateVideoStabilizationModeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.MediaStreamingState.VideoEnableChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCallback_t) (eARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED enabled, void *custom);
/**
 * @brief callback setter for the command ARDrone3.MediaStreamingState.VideoEnableChanged
 * @param callback new callback for the command ARDrone3.MediaStreamingState.VideoEnableChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3MediaStreamingStateVideoEnableChangedCallback (ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettingsState.HomeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCallback_t) (double latitude, double longitude, double altitude, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettingsState.HomeChanged
 * @param callback new callback for the command ARDrone3.GPSSettingsState.HomeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateHomeChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettingsState.ResetHomeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCallback_t) (double latitude, double longitude, double altitude, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettingsState.ResetHomeChanged
 * @param callback new callback for the command ARDrone3.GPSSettingsState.ResetHomeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateResetHomeChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettingsState.GPSFixStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCallback_t) (uint8_t fixed, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettingsState.GPSFixStateChanged
 * @param callback new callback for the command ARDrone3.GPSSettingsState.GPSFixStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateGPSFixStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettingsState.GPSUpdateStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCallback_t) (eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE state, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettingsState.GPSUpdateStateChanged
 * @param callback new callback for the command ARDrone3.GPSSettingsState.GPSUpdateStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateGPSUpdateStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettingsState.HomeTypeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCallback_t) (eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE type, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettingsState.HomeTypeChanged
 * @param callback new callback for the command ARDrone3.GPSSettingsState.HomeTypeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateHomeTypeChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSSettingsState.ReturnHomeDelayChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCallback_t) (uint16_t delay, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSSettingsState.ReturnHomeDelayChanged
 * @param callback new callback for the command ARDrone3.GPSSettingsState.ReturnHomeDelayChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateReturnHomeDelayChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.CameraState.Orientation
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCallback_t) (int8_t tilt, int8_t pan, void *custom);
/**
 * @brief callback setter for the command ARDrone3.CameraState.Orientation
 * @param callback new callback for the command ARDrone3.CameraState.Orientation
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3CameraStateOrientationCallback (ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.CameraState.defaultCameraOrientation
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCallback_t) (int8_t tilt, int8_t pan, void *custom);
/**
 * @brief callback setter for the command ARDrone3.CameraState.defaultCameraOrientation
 * @param callback new callback for the command ARDrone3.CameraState.defaultCameraOrientation
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3CameraStateDefaultCameraOrientationCallback (ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.AntiflickeringState.electricFrequencyChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCallback_t) (eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY frequency, void *custom);
/**
 * @brief callback setter for the command ARDrone3.AntiflickeringState.electricFrequencyChanged
 * @param callback new callback for the command ARDrone3.AntiflickeringState.electricFrequencyChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3AntiflickeringStateElectricFrequencyChangedCallback (ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.AntiflickeringState.modeChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCallback_t) (eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE mode, void *custom);
/**
 * @brief callback setter for the command ARDrone3.AntiflickeringState.modeChanged
 * @param callback new callback for the command ARDrone3.AntiflickeringState.modeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3AntiflickeringStateModeChangedCallback (ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSState.NumberOfSatelliteChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCallback_t) (uint8_t numberOfSatellite, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSState.NumberOfSatelliteChanged
 * @param callback new callback for the command ARDrone3.GPSState.NumberOfSatelliteChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSStateNumberOfSatelliteChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSState.HomeTypeAvailabilityChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCallback_t) (eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE type, uint8_t available, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSState.HomeTypeAvailabilityChanged
 * @param callback new callback for the command ARDrone3.GPSState.HomeTypeAvailabilityChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSStateHomeTypeAvailabilityChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.GPSState.HomeTypeChosenChanged
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCallback_t) (eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE type, void *custom);
/**
 * @brief callback setter for the command ARDrone3.GPSState.HomeTypeChosenChanged
 * @param callback new callback for the command ARDrone3.GPSState.HomeTypeChosenChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3GPSStateHomeTypeChosenChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command ARDrone3.PROState.Features
 */
typedef void (*ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCallback_t) (uint64_t features, void *custom);
/**
 * @brief callback setter for the command ARDrone3.PROState.Features
 * @param callback new callback for the command ARDrone3.PROState.Features
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetARDrone3PROStateFeaturesCallback (ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCallback_t callback, void *custom);

// Feature JumpingSumo


/**
 * @brief callback type for the command JumpingSumo.Piloting.PCMD
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCallback_t) (uint8_t flag, int8_t speed, int8_t turn, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.Piloting.PCMD
 * @param callback new callback for the command JumpingSumo.Piloting.PCMD
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingPCMDCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.Piloting.Posture
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCallback_t) (eARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE type, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.Piloting.Posture
 * @param callback new callback for the command JumpingSumo.Piloting.Posture
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingPostureCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.Piloting.addCapOffset
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCallback_t) (float offset, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.Piloting.addCapOffset
 * @param callback new callback for the command JumpingSumo.Piloting.addCapOffset
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingAddCapOffsetCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.Animations.JumpStop
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCallback_t) (void *custom);
/**
 * @brief callback setter for the command JumpingSumo.Animations.JumpStop
 * @param callback new callback for the command JumpingSumo.Animations.JumpStop
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsJumpStopCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.Animations.JumpCancel
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCallback_t) (void *custom);
/**
 * @brief callback setter for the command JumpingSumo.Animations.JumpCancel
 * @param callback new callback for the command JumpingSumo.Animations.JumpCancel
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsJumpCancelCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.Animations.JumpLoad
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCallback_t) (void *custom);
/**
 * @brief callback setter for the command JumpingSumo.Animations.JumpLoad
 * @param callback new callback for the command JumpingSumo.Animations.JumpLoad
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsJumpLoadCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.Animations.Jump
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCallback_t) (eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE type, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.Animations.Jump
 * @param callback new callback for the command JumpingSumo.Animations.Jump
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsJumpCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.Animations.SimpleAnimation
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCallback_t) (eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID id, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.Animations.SimpleAnimation
 * @param callback new callback for the command JumpingSumo.Animations.SimpleAnimation
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsSimpleAnimationCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaRecord.Picture
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCallback_t) (uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaRecord.Picture
 * @param callback new callback for the command JumpingSumo.MediaRecord.Picture
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordPictureCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaRecord.Video
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCallback_t) (eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD record, uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaRecord.Video
 * @param callback new callback for the command JumpingSumo.MediaRecord.Video
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordVideoCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaRecord.PictureV2
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Callback_t) (void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaRecord.PictureV2
 * @param callback new callback for the command JumpingSumo.MediaRecord.PictureV2
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordPictureV2Callback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Callback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaRecord.VideoV2
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Callback_t) (eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD record, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaRecord.VideoV2
 * @param callback new callback for the command JumpingSumo.MediaRecord.VideoV2
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordVideoV2Callback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Callback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.NetworkSettings.WifiSelection
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCallback_t) (eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND band, uint8_t channel, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.NetworkSettings.WifiSelection
 * @param callback new callback for the command JumpingSumo.NetworkSettings.WifiSelection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkSettingsWifiSelectionCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.Network.WifiScan
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCallback_t) (eARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND band, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.Network.WifiScan
 * @param callback new callback for the command JumpingSumo.Network.WifiScan
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkWifiScanCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.Network.WifiAuthChannel
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCallback_t) (void *custom);
/**
 * @brief callback setter for the command JumpingSumo.Network.WifiAuthChannel
 * @param callback new callback for the command JumpingSumo.Network.WifiAuthChannel
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkWifiAuthChannelCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.AudioSettings.MasterVolume
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCallback_t) (uint8_t volume, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.AudioSettings.MasterVolume
 * @param callback new callback for the command JumpingSumo.AudioSettings.MasterVolume
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsMasterVolumeCallback (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.AudioSettings.Theme
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCallback_t) (eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME theme, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.AudioSettings.Theme
 * @param callback new callback for the command JumpingSumo.AudioSettings.Theme
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsThemeCallback (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.RoadPlan.AllScriptsMetadata
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCallback_t) (void *custom);
/**
 * @brief callback setter for the command JumpingSumo.RoadPlan.AllScriptsMetadata
 * @param callback new callback for the command JumpingSumo.RoadPlan.AllScriptsMetadata
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanAllScriptsMetadataCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.RoadPlan.ScriptUploaded
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCallback_t) (char * uuid, char * md5Hash, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.RoadPlan.ScriptUploaded
 * @param callback new callback for the command JumpingSumo.RoadPlan.ScriptUploaded
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanScriptUploadedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.RoadPlan.ScriptDelete
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCallback_t) (char * uuid, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.RoadPlan.ScriptDelete
 * @param callback new callback for the command JumpingSumo.RoadPlan.ScriptDelete
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanScriptDeleteCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.RoadPlan.PlayScript
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCallback_t) (char * uuid, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.RoadPlan.PlayScript
 * @param callback new callback for the command JumpingSumo.RoadPlan.PlayScript
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanPlayScriptCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.SpeedSettings.Outdoor
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCallback_t) (uint8_t outdoor, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.SpeedSettings.Outdoor
 * @param callback new callback for the command JumpingSumo.SpeedSettings.Outdoor
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoSpeedSettingsOutdoorCallback (ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaStreaming.VideoEnable
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCallback_t) (uint8_t enable, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaStreaming.VideoEnable
 * @param callback new callback for the command JumpingSumo.MediaStreaming.VideoEnable
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaStreamingVideoEnableCallback (ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.VideoSettings.Autorecord
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCallback_t) (uint8_t enabled, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.VideoSettings.Autorecord
 * @param callback new callback for the command JumpingSumo.VideoSettings.Autorecord
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoVideoSettingsAutorecordCallback (ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.PilotingState.PostureChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE state, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.PilotingState.PostureChanged
 * @param callback new callback for the command JumpingSumo.PilotingState.PostureChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingStatePostureChangedCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.PilotingState.AlertStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE state, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.PilotingState.AlertStateChanged
 * @param callback new callback for the command JumpingSumo.PilotingState.AlertStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingStateAlertStateChangedCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.PilotingState.SpeedChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCallback_t) (int8_t speed, int16_t realSpeed, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.PilotingState.SpeedChanged
 * @param callback new callback for the command JumpingSumo.PilotingState.SpeedChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingStateSpeedChangedCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.AnimationsState.JumpLoadChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE state, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.AnimationsState.JumpLoadChanged
 * @param callback new callback for the command JumpingSumo.AnimationsState.JumpLoadChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpLoadChangedCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.AnimationsState.JumpTypeChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE state, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.AnimationsState.JumpTypeChanged
 * @param callback new callback for the command JumpingSumo.AnimationsState.JumpTypeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpTypeChangedCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.AnimationsState.JumpMotorProblemChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR error, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.AnimationsState.JumpMotorProblemChanged
 * @param callback new callback for the command JumpingSumo.AnimationsState.JumpMotorProblemChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpMotorProblemChangedCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.SettingsState.ProductGPSVersionChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCallback_t) (char * software, char * hardware, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.SettingsState.ProductGPSVersionChanged
 * @param callback new callback for the command JumpingSumo.SettingsState.ProductGPSVersionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoSettingsStateProductGPSVersionChangedCallback (ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaRecordState.PictureStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCallback_t) (uint8_t state, uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaRecordState.PictureStateChanged
 * @param callback new callback for the command JumpingSumo.MediaRecordState.PictureStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStatePictureStateChangedCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaRecordState.VideoStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE state, uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaRecordState.VideoStateChanged
 * @param callback new callback for the command JumpingSumo.MediaRecordState.VideoStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStateVideoStateChangedCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaRecordState.PictureStateChangedV2
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Callback_t) (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR error, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaRecordState.PictureStateChangedV2
 * @param callback new callback for the command JumpingSumo.MediaRecordState.PictureStateChangedV2
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStatePictureStateChangedV2Callback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Callback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaRecordState.VideoStateChangedV2
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Callback_t) (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR error, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaRecordState.VideoStateChangedV2
 * @param callback new callback for the command JumpingSumo.MediaRecordState.VideoStateChangedV2
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStateVideoStateChangedV2Callback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Callback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaRecordEvent.PictureEventChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR error, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaRecordEvent.PictureEventChanged
 * @param callback new callback for the command JumpingSumo.MediaRecordEvent.PictureEventChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordEventPictureEventChangedCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaRecordEvent.VideoEventChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR error, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaRecordEvent.VideoEventChanged
 * @param callback new callback for the command JumpingSumo.MediaRecordEvent.VideoEventChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordEventVideoEventChangedCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.NetworkSettingsState.WifiSelectionChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND band, uint8_t channel, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.NetworkSettingsState.WifiSelectionChanged
 * @param callback new callback for the command JumpingSumo.NetworkSettingsState.WifiSelectionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkSettingsStateWifiSelectionChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.NetworkState.WifiScanListChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCallback_t) (char * ssid, int16_t rssi, eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND band, uint8_t channel, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.NetworkState.WifiScanListChanged
 * @param callback new callback for the command JumpingSumo.NetworkState.WifiScanListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateWifiScanListChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.NetworkState.AllWifiScanChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command JumpingSumo.NetworkState.AllWifiScanChanged
 * @param callback new callback for the command JumpingSumo.NetworkState.AllWifiScanChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateAllWifiScanChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.NetworkState.WifiAuthChannelListChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND band, uint8_t channel, uint8_t in_or_out, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.NetworkState.WifiAuthChannelListChanged
 * @param callback new callback for the command JumpingSumo.NetworkState.WifiAuthChannelListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateWifiAuthChannelListChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.NetworkState.AllWifiAuthChannelChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command JumpingSumo.NetworkState.AllWifiAuthChannelChanged
 * @param callback new callback for the command JumpingSumo.NetworkState.AllWifiAuthChannelChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateAllWifiAuthChannelChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.NetworkState.LinkQualityChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCallback_t) (uint8_t quality, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.NetworkState.LinkQualityChanged
 * @param callback new callback for the command JumpingSumo.NetworkState.LinkQualityChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateLinkQualityChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.AudioSettingsState.MasterVolumeChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCallback_t) (uint8_t volume, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.AudioSettingsState.MasterVolumeChanged
 * @param callback new callback for the command JumpingSumo.AudioSettingsState.MasterVolumeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsStateMasterVolumeChangedCallback (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.AudioSettingsState.ThemeChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME theme, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.AudioSettingsState.ThemeChanged
 * @param callback new callback for the command JumpingSumo.AudioSettingsState.ThemeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsStateThemeChangedCallback (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.RoadPlanState.ScriptMetadataListChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCallback_t) (char * uuid, uint8_t version, char * product, char * name, uint64_t lastModified, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.RoadPlanState.ScriptMetadataListChanged
 * @param callback new callback for the command JumpingSumo.RoadPlanState.ScriptMetadataListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptMetadataListChangedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.RoadPlanState.AllScriptsMetadataChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command JumpingSumo.RoadPlanState.AllScriptsMetadataChanged
 * @param callback new callback for the command JumpingSumo.RoadPlanState.AllScriptsMetadataChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateAllScriptsMetadataChangedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.RoadPlanState.ScriptUploadChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE resultCode, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.RoadPlanState.ScriptUploadChanged
 * @param callback new callback for the command JumpingSumo.RoadPlanState.ScriptUploadChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptUploadChangedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.RoadPlanState.ScriptDeleteChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE resultCode, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.RoadPlanState.ScriptDeleteChanged
 * @param callback new callback for the command JumpingSumo.RoadPlanState.ScriptDeleteChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptDeleteChangedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.RoadPlanState.PlayScriptChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE resultCode, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.RoadPlanState.PlayScriptChanged
 * @param callback new callback for the command JumpingSumo.RoadPlanState.PlayScriptChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStatePlayScriptChangedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.SpeedSettingsState.OutdoorChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCallback_t) (uint8_t outdoor, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.SpeedSettingsState.OutdoorChanged
 * @param callback new callback for the command JumpingSumo.SpeedSettingsState.OutdoorChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoSpeedSettingsStateOutdoorChangedCallback (ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.MediaStreamingState.VideoEnableChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCallback_t) (eARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED enabled, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.MediaStreamingState.VideoEnableChanged
 * @param callback new callback for the command JumpingSumo.MediaStreamingState.VideoEnableChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoMediaStreamingStateVideoEnableChangedCallback (ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command JumpingSumo.VideoSettingsState.AutorecordChanged
 */
typedef void (*ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCallback_t) (uint8_t enabled, void *custom);
/**
 * @brief callback setter for the command JumpingSumo.VideoSettingsState.AutorecordChanged
 * @param callback new callback for the command JumpingSumo.VideoSettingsState.AutorecordChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetJumpingSumoVideoSettingsStateAutorecordChangedCallback (ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCallback_t callback, void *custom);

// Feature MiniDrone


/**
 * @brief callback type for the command MiniDrone.Piloting.FlatTrim
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCallback_t) (void *custom);
/**
 * @brief callback setter for the command MiniDrone.Piloting.FlatTrim
 * @param callback new callback for the command MiniDrone.Piloting.FlatTrim
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingFlatTrimCallback (ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.Piloting.TakeOff
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCallback_t) (void *custom);
/**
 * @brief callback setter for the command MiniDrone.Piloting.TakeOff
 * @param callback new callback for the command MiniDrone.Piloting.TakeOff
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingTakeOffCallback (ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.Piloting.PCMD
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingPCMDCallback_t) (uint8_t flag, int8_t roll, int8_t pitch, int8_t yaw, int8_t gaz, uint32_t timestamp, void *custom);
/**
 * @brief callback setter for the command MiniDrone.Piloting.PCMD
 * @param callback new callback for the command MiniDrone.Piloting.PCMD
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingPCMDCallback (ARCOMMANDS_Decoder_MiniDronePilotingPCMDCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.Piloting.Landing
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingLandingCallback_t) (void *custom);
/**
 * @brief callback setter for the command MiniDrone.Piloting.Landing
 * @param callback new callback for the command MiniDrone.Piloting.Landing
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingLandingCallback (ARCOMMANDS_Decoder_MiniDronePilotingLandingCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.Piloting.Emergency
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCallback_t) (void *custom);
/**
 * @brief callback setter for the command MiniDrone.Piloting.Emergency
 * @param callback new callback for the command MiniDrone.Piloting.Emergency
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingEmergencyCallback (ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.Piloting.AutoTakeOffMode
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCallback_t) (uint8_t state, void *custom);
/**
 * @brief callback setter for the command MiniDrone.Piloting.AutoTakeOffMode
 * @param callback new callback for the command MiniDrone.Piloting.AutoTakeOffMode
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingAutoTakeOffModeCallback (ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.Animations.Flip
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCallback_t) (eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION direction, void *custom);
/**
 * @brief callback setter for the command MiniDrone.Animations.Flip
 * @param callback new callback for the command MiniDrone.Animations.Flip
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneAnimationsFlipCallback (ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.Animations.Cap
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneAnimationsCapCallback_t) (int16_t offset, void *custom);
/**
 * @brief callback setter for the command MiniDrone.Animations.Cap
 * @param callback new callback for the command MiniDrone.Animations.Cap
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneAnimationsCapCallback (ARCOMMANDS_Decoder_MiniDroneAnimationsCapCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.MediaRecord.Picture
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCallback_t) (uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command MiniDrone.MediaRecord.Picture
 * @param callback new callback for the command MiniDrone.MediaRecord.Picture
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneMediaRecordPictureCallback (ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.MediaRecord.PictureV2
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Callback_t) (void *custom);
/**
 * @brief callback setter for the command MiniDrone.MediaRecord.PictureV2
 * @param callback new callback for the command MiniDrone.MediaRecord.PictureV2
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneMediaRecordPictureV2Callback (ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Callback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.PilotingSettings.MaxAltitude
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command MiniDrone.PilotingSettings.MaxAltitude
 * @param callback new callback for the command MiniDrone.PilotingSettings.MaxAltitude
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsMaxAltitudeCallback (ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.PilotingSettings.MaxTilt
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command MiniDrone.PilotingSettings.MaxTilt
 * @param callback new callback for the command MiniDrone.PilotingSettings.MaxTilt
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsMaxTiltCallback (ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SpeedSettings.MaxVerticalSpeed
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SpeedSettings.MaxVerticalSpeed
 * @param callback new callback for the command MiniDrone.SpeedSettings.MaxVerticalSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsMaxVerticalSpeedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SpeedSettings.MaxRotationSpeed
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SpeedSettings.MaxRotationSpeed
 * @param callback new callback for the command MiniDrone.SpeedSettings.MaxRotationSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsMaxRotationSpeedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SpeedSettings.Wheels
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCallback_t) (uint8_t present, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SpeedSettings.Wheels
 * @param callback new callback for the command MiniDrone.SpeedSettings.Wheels
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsWheelsCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SpeedSettings.MaxHorizontalSpeed
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCallback_t) (float current, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SpeedSettings.MaxHorizontalSpeed
 * @param callback new callback for the command MiniDrone.SpeedSettings.MaxHorizontalSpeed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsMaxHorizontalSpeedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.Settings.CutOutMode
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCallback_t) (uint8_t enable, void *custom);
/**
 * @brief callback setter for the command MiniDrone.Settings.CutOutMode
 * @param callback new callback for the command MiniDrone.Settings.CutOutMode
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSettingsCutOutModeCallback (ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.GPS.ControllerLatitudeForRun
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCallback_t) (double latitude, void *custom);
/**
 * @brief callback setter for the command MiniDrone.GPS.ControllerLatitudeForRun
 * @param callback new callback for the command MiniDrone.GPS.ControllerLatitudeForRun
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneGPSControllerLatitudeForRunCallback (ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.GPS.ControllerLongitudeForRun
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCallback_t) (double longitude, void *custom);
/**
 * @brief callback setter for the command MiniDrone.GPS.ControllerLongitudeForRun
 * @param callback new callback for the command MiniDrone.GPS.ControllerLongitudeForRun
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneGPSControllerLongitudeForRunCallback (ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.Configuration.ControllerType
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCallback_t) (char * type, void *custom);
/**
 * @brief callback setter for the command MiniDrone.Configuration.ControllerType
 * @param callback new callback for the command MiniDrone.Configuration.ControllerType
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneConfigurationControllerTypeCallback (ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.Configuration.ControllerName
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCallback_t) (char * name, void *custom);
/**
 * @brief callback setter for the command MiniDrone.Configuration.ControllerName
 * @param callback new callback for the command MiniDrone.Configuration.ControllerName
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneConfigurationControllerNameCallback (ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.PilotingState.FlatTrimChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command MiniDrone.PilotingState.FlatTrimChanged
 * @param callback new callback for the command MiniDrone.PilotingState.FlatTrimChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlatTrimChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.PilotingState.FlyingStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCallback_t) (eARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE state, void *custom);
/**
 * @brief callback setter for the command MiniDrone.PilotingState.FlyingStateChanged
 * @param callback new callback for the command MiniDrone.PilotingState.FlyingStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlyingStateChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.PilotingState.AlertStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCallback_t) (eARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE state, void *custom);
/**
 * @brief callback setter for the command MiniDrone.PilotingState.AlertStateChanged
 * @param callback new callback for the command MiniDrone.PilotingState.AlertStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingStateAlertStateChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.PilotingState.AutoTakeOffModeChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCallback_t) (uint8_t state, void *custom);
/**
 * @brief callback setter for the command MiniDrone.PilotingState.AutoTakeOffModeChanged
 * @param callback new callback for the command MiniDrone.PilotingState.AutoTakeOffModeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingStateAutoTakeOffModeChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.MediaRecordState.PictureStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCallback_t) (uint8_t state, uint8_t mass_storage_id, void *custom);
/**
 * @brief callback setter for the command MiniDrone.MediaRecordState.PictureStateChanged
 * @param callback new callback for the command MiniDrone.MediaRecordState.PictureStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneMediaRecordStatePictureStateChangedCallback (ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.MediaRecordState.PictureStateChangedV2
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Callback_t) (eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE state, eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR error, void *custom);
/**
 * @brief callback setter for the command MiniDrone.MediaRecordState.PictureStateChangedV2
 * @param callback new callback for the command MiniDrone.MediaRecordState.PictureStateChangedV2
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneMediaRecordStatePictureStateChangedV2Callback (ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Callback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.MediaRecordEvent.PictureEventChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCallback_t) (eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT event, eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR error, void *custom);
/**
 * @brief callback setter for the command MiniDrone.MediaRecordEvent.PictureEventChanged
 * @param callback new callback for the command MiniDrone.MediaRecordEvent.PictureEventChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneMediaRecordEventPictureEventChangedCallback (ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.PilotingSettingsState.MaxAltitudeChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command MiniDrone.PilotingSettingsState.MaxAltitudeChanged
 * @param callback new callback for the command MiniDrone.PilotingSettingsState.MaxAltitudeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxAltitudeChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.PilotingSettingsState.MaxTiltChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command MiniDrone.PilotingSettingsState.MaxTiltChanged
 * @param callback new callback for the command MiniDrone.PilotingSettingsState.MaxTiltChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxTiltChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SpeedSettingsState.MaxVerticalSpeedChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SpeedSettingsState.MaxVerticalSpeedChanged
 * @param callback new callback for the command MiniDrone.SpeedSettingsState.MaxVerticalSpeedChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SpeedSettingsState.MaxRotationSpeedChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SpeedSettingsState.MaxRotationSpeedChanged
 * @param callback new callback for the command MiniDrone.SpeedSettingsState.MaxRotationSpeedChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxRotationSpeedChangedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SpeedSettingsState.WheelsChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCallback_t) (uint8_t present, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SpeedSettingsState.WheelsChanged
 * @param callback new callback for the command MiniDrone.SpeedSettingsState.WheelsChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateWheelsChangedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SpeedSettingsState.MaxHorizontalSpeedChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCallback_t) (float current, float min, float max, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SpeedSettingsState.MaxHorizontalSpeedChanged
 * @param callback new callback for the command MiniDrone.SpeedSettingsState.MaxHorizontalSpeedChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SettingsState.ProductMotorsVersionChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCallback_t) (uint8_t motor, char * type, char * software, char * hardware, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SettingsState.ProductMotorsVersionChanged
 * @param callback new callback for the command MiniDrone.SettingsState.ProductMotorsVersionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductMotorsVersionChangedCallback (ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SettingsState.ProductInertialVersionChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCallback_t) (char * software, char * hardware, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SettingsState.ProductInertialVersionChanged
 * @param callback new callback for the command MiniDrone.SettingsState.ProductInertialVersionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductInertialVersionChangedCallback (ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.SettingsState.CutOutModeChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCallback_t) (uint8_t enable, void *custom);
/**
 * @brief callback setter for the command MiniDrone.SettingsState.CutOutModeChanged
 * @param callback new callback for the command MiniDrone.SettingsState.CutOutModeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneSettingsStateCutOutModeChangedCallback (ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command MiniDrone.FloodControlState.FloodControlChanged
 */
typedef void (*ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCallback_t) (uint16_t delay, void *custom);
/**
 * @brief callback setter for the command MiniDrone.FloodControlState.FloodControlChanged
 * @param callback new callback for the command MiniDrone.FloodControlState.FloodControlChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetMiniDroneFloodControlStateFloodControlChangedCallback (ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCallback_t callback, void *custom);

// Feature SkyController


/**
 * @brief callback type for the command SkyController.Wifi.RequestWifiList
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.Wifi.RequestWifiList
 * @param callback new callback for the command SkyController.Wifi.RequestWifiList
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerWifiRequestWifiListCallback (ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Wifi.RequestCurrentWifi
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.Wifi.RequestCurrentWifi
 * @param callback new callback for the command SkyController.Wifi.RequestCurrentWifi
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerWifiRequestCurrentWifiCallback (ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Wifi.ConnectToWifi
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCallback_t) (char * bssid, char * ssid, char * passphrase, void *custom);
/**
 * @brief callback setter for the command SkyController.Wifi.ConnectToWifi
 * @param callback new callback for the command SkyController.Wifi.ConnectToWifi
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerWifiConnectToWifiCallback (ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Wifi.ForgetWifi
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCallback_t) (char * ssid, void *custom);
/**
 * @brief callback setter for the command SkyController.Wifi.ForgetWifi
 * @param callback new callback for the command SkyController.Wifi.ForgetWifi
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerWifiForgetWifiCallback (ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Wifi.WifiAuthChannel
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.Wifi.WifiAuthChannel
 * @param callback new callback for the command SkyController.Wifi.WifiAuthChannel
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerWifiWifiAuthChannelCallback (ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Device.RequestDeviceList
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.Device.RequestDeviceList
 * @param callback new callback for the command SkyController.Device.RequestDeviceList
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerDeviceRequestDeviceListCallback (ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Device.RequestCurrentDevice
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.Device.RequestCurrentDevice
 * @param callback new callback for the command SkyController.Device.RequestCurrentDevice
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerDeviceRequestCurrentDeviceCallback (ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Device.ConnectToDevice
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCallback_t) (char * deviceName, void *custom);
/**
 * @brief callback setter for the command SkyController.Device.ConnectToDevice
 * @param callback new callback for the command SkyController.Device.ConnectToDevice
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerDeviceConnectToDeviceCallback (ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Settings.AllSettings
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.Settings.AllSettings
 * @param callback new callback for the command SkyController.Settings.AllSettings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerSettingsAllSettingsCallback (ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Settings.Reset
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerSettingsResetCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.Settings.Reset
 * @param callback new callback for the command SkyController.Settings.Reset
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerSettingsResetCallback (ARCOMMANDS_Decoder_SkyControllerSettingsResetCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Common.AllStates
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.Common.AllStates
 * @param callback new callback for the command SkyController.Common.AllStates
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerCommonAllStatesCallback (ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AccessPointSettings.AccessPointSSID
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCallback_t) (char * ssid, void *custom);
/**
 * @brief callback setter for the command SkyController.AccessPointSettings.AccessPointSSID
 * @param callback new callback for the command SkyController.AccessPointSettings.AccessPointSSID
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsAccessPointSSIDCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AccessPointSettings.AccessPointChannel
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCallback_t) (uint8_t channel, void *custom);
/**
 * @brief callback setter for the command SkyController.AccessPointSettings.AccessPointChannel
 * @param callback new callback for the command SkyController.AccessPointSettings.AccessPointChannel
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsAccessPointChannelCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AccessPointSettings.WifiSelection
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCallback_t) (eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND band, uint8_t channel, void *custom);
/**
 * @brief callback setter for the command SkyController.AccessPointSettings.WifiSelection
 * @param callback new callback for the command SkyController.AccessPointSettings.WifiSelection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsWifiSelectionCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Camera.ResetOrientation
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.Camera.ResetOrientation
 * @param callback new callback for the command SkyController.Camera.ResetOrientation
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerCameraResetOrientationCallback (ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.GamepadInfos.getGamepadControls
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.GamepadInfos.getGamepadControls
 * @param callback new callback for the command SkyController.GamepadInfos.getGamepadControls
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerGamepadInfosGetGamepadControlsCallback (ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.ButtonMappings.getCurrentButtonMappings
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.ButtonMappings.getCurrentButtonMappings
 * @param callback new callback for the command SkyController.ButtonMappings.getCurrentButtonMappings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsGetCurrentButtonMappingsCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.ButtonMappings.getAvailableButtonMappings
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.ButtonMappings.getAvailableButtonMappings
 * @param callback new callback for the command SkyController.ButtonMappings.getAvailableButtonMappings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsGetAvailableButtonMappingsCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.ButtonMappings.setButtonMapping
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCallback_t) (int32_t key_id, char * mapping_uid, void *custom);
/**
 * @brief callback setter for the command SkyController.ButtonMappings.setButtonMapping
 * @param callback new callback for the command SkyController.ButtonMappings.setButtonMapping
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsSetButtonMappingCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.ButtonMappings.defaultButtonMapping
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.ButtonMappings.defaultButtonMapping
 * @param callback new callback for the command SkyController.ButtonMappings.defaultButtonMapping
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsDefaultButtonMappingCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisMappings.getCurrentAxisMappings
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.AxisMappings.getCurrentAxisMappings
 * @param callback new callback for the command SkyController.AxisMappings.getCurrentAxisMappings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsGetCurrentAxisMappingsCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisMappings.getAvailableAxisMappings
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.AxisMappings.getAvailableAxisMappings
 * @param callback new callback for the command SkyController.AxisMappings.getAvailableAxisMappings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsGetAvailableAxisMappingsCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisMappings.setAxisMapping
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCallback_t) (int32_t axis_id, char * mapping_uid, void *custom);
/**
 * @brief callback setter for the command SkyController.AxisMappings.setAxisMapping
 * @param callback new callback for the command SkyController.AxisMappings.setAxisMapping
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsSetAxisMappingCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisMappings.defaultAxisMapping
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.AxisMappings.defaultAxisMapping
 * @param callback new callback for the command SkyController.AxisMappings.defaultAxisMapping
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsDefaultAxisMappingCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisFilters.getCurrentAxisFilters
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.AxisFilters.getCurrentAxisFilters
 * @param callback new callback for the command SkyController.AxisFilters.getCurrentAxisFilters
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersGetCurrentAxisFiltersCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisFilters.getPresetAxisFilters
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.AxisFilters.getPresetAxisFilters
 * @param callback new callback for the command SkyController.AxisFilters.getPresetAxisFilters
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersGetPresetAxisFiltersCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisFilters.setAxisFilter
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCallback_t) (int32_t axis_id, char * filter_uid_or_builder, void *custom);
/**
 * @brief callback setter for the command SkyController.AxisFilters.setAxisFilter
 * @param callback new callback for the command SkyController.AxisFilters.setAxisFilter
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersSetAxisFilterCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisFilters.defaultAxisFilters
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.AxisFilters.defaultAxisFilters
 * @param callback new callback for the command SkyController.AxisFilters.defaultAxisFilters
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersDefaultAxisFiltersCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.CoPiloting.setPilotingSource
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCallback_t) (eARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE source, void *custom);
/**
 * @brief callback setter for the command SkyController.CoPiloting.setPilotingSource
 * @param callback new callback for the command SkyController.CoPiloting.setPilotingSource
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerCoPilotingSetPilotingSourceCallback (ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.Calibration.enableMagnetoCalibrationQualityUpdates
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCallback_t) (uint8_t enable, void *custom);
/**
 * @brief callback setter for the command SkyController.Calibration.enableMagnetoCalibrationQualityUpdates
 * @param callback new callback for the command SkyController.Calibration.enableMagnetoCalibrationQualityUpdates
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCallback (ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.WifiState.WifiList
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCallback_t) (char * bssid, char * ssid, uint8_t secured, uint8_t saved, int32_t rssi, int32_t frequency, void *custom);
/**
 * @brief callback setter for the command SkyController.WifiState.WifiList
 * @param callback new callback for the command SkyController.WifiState.WifiList
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerWifiStateWifiListCallback (ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.WifiState.ConnexionChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCallback_t) (char * ssid, eARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS status, void *custom);
/**
 * @brief callback setter for the command SkyController.WifiState.ConnexionChanged
 * @param callback new callback for the command SkyController.WifiState.ConnexionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerWifiStateConnexionChangedCallback (ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.WifiState.WifiAuthChannelListChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCallback_t) (eARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND band, uint8_t channel, uint8_t in_or_out, void *custom);
/**
 * @brief callback setter for the command SkyController.WifiState.WifiAuthChannelListChanged
 * @param callback new callback for the command SkyController.WifiState.WifiAuthChannelListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerWifiStateWifiAuthChannelListChangedCallback (ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.WifiState.AllWifiAuthChannelChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.WifiState.AllWifiAuthChannelChanged
 * @param callback new callback for the command SkyController.WifiState.AllWifiAuthChannelChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerWifiStateAllWifiAuthChannelChangedCallback (ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.WifiState.WifiSignalChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCallback_t) (uint8_t level, void *custom);
/**
 * @brief callback setter for the command SkyController.WifiState.WifiSignalChanged
 * @param callback new callback for the command SkyController.WifiState.WifiSignalChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerWifiStateWifiSignalChangedCallback (ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.DeviceState.DeviceList
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCallback_t) (char * name, void *custom);
/**
 * @brief callback setter for the command SkyController.DeviceState.DeviceList
 * @param callback new callback for the command SkyController.DeviceState.DeviceList
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerDeviceStateDeviceListCallback (ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.DeviceState.ConnexionChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCallback_t) (eARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS status, char * deviceName, uint16_t deviceProductID, void *custom);
/**
 * @brief callback setter for the command SkyController.DeviceState.ConnexionChanged
 * @param callback new callback for the command SkyController.DeviceState.ConnexionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerDeviceStateConnexionChangedCallback (ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.SettingsState.AllSettingsChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.SettingsState.AllSettingsChanged
 * @param callback new callback for the command SkyController.SettingsState.AllSettingsChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerSettingsStateAllSettingsChangedCallback (ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.SettingsState.ResetChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.SettingsState.ResetChanged
 * @param callback new callback for the command SkyController.SettingsState.ResetChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerSettingsStateResetChangedCallback (ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.SettingsState.ProductSerialChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCallback_t) (char * serialNumber, void *custom);
/**
 * @brief callback setter for the command SkyController.SettingsState.ProductSerialChanged
 * @param callback new callback for the command SkyController.SettingsState.ProductSerialChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerSettingsStateProductSerialChangedCallback (ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.SettingsState.ProductVariantChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCallback_t) (eARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT variant, void *custom);
/**
 * @brief callback setter for the command SkyController.SettingsState.ProductVariantChanged
 * @param callback new callback for the command SkyController.SettingsState.ProductVariantChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerSettingsStateProductVariantChangedCallback (ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.CommonState.AllStatesChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.CommonState.AllStatesChanged
 * @param callback new callback for the command SkyController.CommonState.AllStatesChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerCommonStateAllStatesChangedCallback (ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.SkyControllerState.BatteryChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCallback_t) (uint8_t percent, void *custom);
/**
 * @brief callback setter for the command SkyController.SkyControllerState.BatteryChanged
 * @param callback new callback for the command SkyController.SkyControllerState.BatteryChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerSkyControllerStateBatteryChangedCallback (ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.SkyControllerState.GpsFixChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCallback_t) (uint8_t fixed, void *custom);
/**
 * @brief callback setter for the command SkyController.SkyControllerState.GpsFixChanged
 * @param callback new callback for the command SkyController.SkyControllerState.GpsFixChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerSkyControllerStateGpsFixChangedCallback (ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.SkyControllerState.GpsPositionChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCallback_t) (double latitude, double longitude, double altitude, float heading, void *custom);
/**
 * @brief callback setter for the command SkyController.SkyControllerState.GpsPositionChanged
 * @param callback new callback for the command SkyController.SkyControllerState.GpsPositionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerSkyControllerStateGpsPositionChangedCallback (ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AccessPointSettingsState.AccessPointSSIDChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCallback_t) (char * ssid, void *custom);
/**
 * @brief callback setter for the command SkyController.AccessPointSettingsState.AccessPointSSIDChanged
 * @param callback new callback for the command SkyController.AccessPointSettingsState.AccessPointSSIDChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsStateAccessPointSSIDChangedCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AccessPointSettingsState.AccessPointChannelChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCallback_t) (uint8_t channel, void *custom);
/**
 * @brief callback setter for the command SkyController.AccessPointSettingsState.AccessPointChannelChanged
 * @param callback new callback for the command SkyController.AccessPointSettingsState.AccessPointChannelChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsStateAccessPointChannelChangedCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AccessPointSettingsState.WifiSelectionChanged
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCallback_t) (eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE type, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND band, uint8_t channel, void *custom);
/**
 * @brief callback setter for the command SkyController.AccessPointSettingsState.WifiSelectionChanged
 * @param callback new callback for the command SkyController.AccessPointSettingsState.WifiSelectionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsStateWifiSelectionChangedCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.GamepadInfosState.gamepadControl
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCallback_t) (eARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE type, int32_t id, char * name, void *custom);
/**
 * @brief callback setter for the command SkyController.GamepadInfosState.gamepadControl
 * @param callback new callback for the command SkyController.GamepadInfosState.gamepadControl
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerGamepadInfosStateGamepadControlCallback (ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.GamepadInfosState.allGamepadControlsSent
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.GamepadInfosState.allGamepadControlsSent
 * @param callback new callback for the command SkyController.GamepadInfosState.allGamepadControlsSent
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerGamepadInfosStateAllGamepadControlsSentCallback (ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.ButtonMappingsState.currentButtonMappings
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCallback_t) (int32_t key_id, char * mapping_uid, void *custom);
/**
 * @brief callback setter for the command SkyController.ButtonMappingsState.currentButtonMappings
 * @param callback new callback for the command SkyController.ButtonMappingsState.currentButtonMappings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsStateCurrentButtonMappingsCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.ButtonMappingsState.allCurrentButtonMappingsSent
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.ButtonMappingsState.allCurrentButtonMappingsSent
 * @param callback new callback for the command SkyController.ButtonMappingsState.allCurrentButtonMappingsSent
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.ButtonMappingsState.availableButtonMappings
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCallback_t) (char * mapping_uid, char * name, void *custom);
/**
 * @brief callback setter for the command SkyController.ButtonMappingsState.availableButtonMappings
 * @param callback new callback for the command SkyController.ButtonMappingsState.availableButtonMappings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsStateAvailableButtonMappingsCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.ButtonMappingsState.allAvailableButtonsMappingsSent
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.ButtonMappingsState.allAvailableButtonsMappingsSent
 * @param callback new callback for the command SkyController.ButtonMappingsState.allAvailableButtonsMappingsSent
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisMappingsState.currentAxisMappings
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCallback_t) (int32_t axis_id, char * mapping_uid, void *custom);
/**
 * @brief callback setter for the command SkyController.AxisMappingsState.currentAxisMappings
 * @param callback new callback for the command SkyController.AxisMappingsState.currentAxisMappings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsStateCurrentAxisMappingsCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisMappingsState.allCurrentAxisMappingsSent
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.AxisMappingsState.allCurrentAxisMappingsSent
 * @param callback new callback for the command SkyController.AxisMappingsState.allCurrentAxisMappingsSent
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisMappingsState.availableAxisMappings
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCallback_t) (char * mapping_uid, char * name, void *custom);
/**
 * @brief callback setter for the command SkyController.AxisMappingsState.availableAxisMappings
 * @param callback new callback for the command SkyController.AxisMappingsState.availableAxisMappings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsStateAvailableAxisMappingsCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisMappingsState.allAvailableAxisMappingsSent
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.AxisMappingsState.allAvailableAxisMappingsSent
 * @param callback new callback for the command SkyController.AxisMappingsState.allAvailableAxisMappingsSent
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisFiltersState.currentAxisFilters
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCallback_t) (int32_t axis_id, char * filter_uid_or_builder, void *custom);
/**
 * @brief callback setter for the command SkyController.AxisFiltersState.currentAxisFilters
 * @param callback new callback for the command SkyController.AxisFiltersState.currentAxisFilters
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersStateCurrentAxisFiltersCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisFiltersState.allCurrentFiltersSent
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.AxisFiltersState.allCurrentFiltersSent
 * @param callback new callback for the command SkyController.AxisFiltersState.allCurrentFiltersSent
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersStateAllCurrentFiltersSentCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisFiltersState.presetAxisFilters
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCallback_t) (char * filter_uid, char * name, void *custom);
/**
 * @brief callback setter for the command SkyController.AxisFiltersState.presetAxisFilters
 * @param callback new callback for the command SkyController.AxisFiltersState.presetAxisFilters
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersStatePresetAxisFiltersCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.AxisFiltersState.allPresetFiltersSent
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.AxisFiltersState.allPresetFiltersSent
 * @param callback new callback for the command SkyController.AxisFiltersState.allPresetFiltersSent
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersStateAllPresetFiltersSentCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.CoPilotingState.pilotingSource
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCallback_t) (eARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE source, void *custom);
/**
 * @brief callback setter for the command SkyController.CoPilotingState.pilotingSource
 * @param callback new callback for the command SkyController.CoPilotingState.pilotingSource
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerCoPilotingStatePilotingSourceCallback (ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.CalibrationState.MagnetoCalibrationState
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCallback_t) (eARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS status, uint8_t X_Quality, uint8_t Y_Quality, uint8_t Z_Quality, void *custom);
/**
 * @brief callback setter for the command SkyController.CalibrationState.MagnetoCalibrationState
 * @param callback new callback for the command SkyController.CalibrationState.MagnetoCalibrationState
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerCalibrationStateMagnetoCalibrationStateCallback (ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.CalibrationState.MagnetoCalibrationQualityUpdatesState
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCallback_t) (uint8_t enabled, void *custom);
/**
 * @brief callback setter for the command SkyController.CalibrationState.MagnetoCalibrationQualityUpdatesState
 * @param callback new callback for the command SkyController.CalibrationState.MagnetoCalibrationQualityUpdatesState
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCallback (ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCallback_t callback, void *custom);

/**
 * @brief callback type for the command SkyController.ButtonEvents.Settings
 */
typedef void (*ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCallback_t) (void *custom);
/**
 * @brief callback setter for the command SkyController.ButtonEvents.Settings
 * @param callback new callback for the command SkyController.ButtonEvents.Settings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetSkyControllerButtonEventsSettingsCallback (ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCallback_t callback, void *custom);

// Feature unknown_feature_1


/**
 * @brief callback type for the command unknown_feature_1.geographic_run
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCallback_t) (uint8_t start, uint8_t distance_is_default, float distance, uint8_t elevation_is_default, float elevation, uint8_t azimuth_is_default, float azimuth, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.geographic_run
 * @param callback new callback for the command unknown_feature_1.geographic_run
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1GeographicRunCallback (ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.relative_run
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCallback_t) (uint8_t start, uint8_t distance_is_default, float distance, uint8_t elevation_is_default, float elevation, uint8_t azimuth_is_default, float azimuth, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.relative_run
 * @param callback new callback for the command unknown_feature_1.relative_run
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1RelativeRunCallback (ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.look_at_run
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCallback_t) (uint8_t start, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.look_at_run
 * @param callback new callback for the command unknown_feature_1.look_at_run
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1LookAtRunCallback (ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.spiral_anim_run
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCallback_t) (uint8_t start, uint8_t speed_is_default, float speed, uint8_t revolution_nb_is_default, float revolution_number, uint8_t vertical_distance_is_default, float vertical_distance, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.spiral_anim_run
 * @param callback new callback for the command unknown_feature_1.spiral_anim_run
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1SpiralAnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.swing_anim_run
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCallback_t) (uint8_t start, uint8_t speed_is_default, float speed, uint8_t vertical_distance_is_default, float vertical_distance, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.swing_anim_run
 * @param callback new callback for the command unknown_feature_1.swing_anim_run
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1SwingAnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.boomerang_anim_run
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCallback_t) (uint8_t start, uint8_t speed_is_default, float speed, uint8_t distance_is_default, float distance, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.boomerang_anim_run
 * @param callback new callback for the command unknown_feature_1.boomerang_anim_run
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1BoomerangAnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.candle_anim_run
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCallback_t) (uint8_t start, uint8_t speed_is_default, float speed, uint8_t vertical_distance_is_default, float vertical_distance, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.candle_anim_run
 * @param callback new callback for the command unknown_feature_1.candle_anim_run
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1CandleAnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.dolly_slide_anim_run
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCallback_t) (uint8_t start, uint8_t speed_is_default, float speed, uint8_t angle_is_default, float angle, uint8_t horizontal_distance_is_default, float horizontal_distance, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.dolly_slide_anim_run
 * @param callback new callback for the command unknown_feature_1.dolly_slide_anim_run
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1DollySlideAnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.user_framing_position
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCallback_t) (int8_t horizontal, int8_t vertical, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.user_framing_position
 * @param callback new callback for the command unknown_feature_1.user_framing_position
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1UserFramingPositionCallback (ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.user_GPS_data
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCallback_t) (double latitude, double longitude, float altitude, float horizontal_accuracy, float vertical_accuracy, float north_speed, float east_speed, float down_speed, double timestamp, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.user_GPS_data
 * @param callback new callback for the command unknown_feature_1.user_GPS_data
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1UserGPSDataCallback (ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.user_baro_data
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCallback_t) (float pressure, double timestamp, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.user_baro_data
 * @param callback new callback for the command unknown_feature_1.user_baro_data
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1UserBaroDataCallback (ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.lynx_detection
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCallback_t) (float target_pan, float target_tilt, float change_of_scale, uint8_t confidence_index, uint8_t is_new_selection, uint64_t timestamp, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.lynx_detection
 * @param callback new callback for the command unknown_feature_1.lynx_detection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1LynxDetectionCallback (ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.availability
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCallback_t) (eARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE type, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.availability
 * @param callback new callback for the command unknown_feature_1.availability
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1AvailabilityCallback (ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.run
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1RunCallback_t) (eARCOMMANDS_UNKNOWN_FEATURE_1_TYPE type, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.run
 * @param callback new callback for the command unknown_feature_1.run
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1RunCallback (ARCOMMANDS_Decoder_UnknownFeature1RunCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.geographic_config_changed
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCallback_t) (uint8_t distance_is_default, float distance, uint8_t elevation_is_default, float elevation, uint8_t azimuth_is_default, float azimuth, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.geographic_config_changed
 * @param callback new callback for the command unknown_feature_1.geographic_config_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1GeographicConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.relative_config_changed
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCallback_t) (uint8_t distance_is_default, float distance, uint8_t elevation_is_default, float elevation, uint8_t azimuth_is_default, float azimuth, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.relative_config_changed
 * @param callback new callback for the command unknown_feature_1.relative_config_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1RelativeConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.anim_run
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1AnimRunCallback_t) (eARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE type, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.anim_run
 * @param callback new callback for the command unknown_feature_1.anim_run
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1AnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1AnimRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.spiral_anim_config_changed
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCallback_t) (uint8_t speed_is_default, float speed, uint8_t revolution_nb_is_default, float revolution_nb, uint8_t vertical_distance_is_default, float vertical_distance, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.spiral_anim_config_changed
 * @param callback new callback for the command unknown_feature_1.spiral_anim_config_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1SpiralAnimConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.swing_anim_config_changed
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCallback_t) (uint8_t speed_is_default, float speed, uint8_t vertical_distance_is_default, float vertical_distance, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.swing_anim_config_changed
 * @param callback new callback for the command unknown_feature_1.swing_anim_config_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1SwingAnimConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.boomerang_anim_config_changed
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCallback_t) (uint8_t speed_is_default, float speed, uint8_t distance_is_default, float distance, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.boomerang_anim_config_changed
 * @param callback new callback for the command unknown_feature_1.boomerang_anim_config_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1BoomerangAnimConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.candle_anim_config_changed
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCallback_t) (uint8_t speed_is_default, float speed, uint8_t vertical_distance_is_default, float vertical_distance, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.candle_anim_config_changed
 * @param callback new callback for the command unknown_feature_1.candle_anim_config_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1CandleAnimConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.dolly_slide_anim_config_changed
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCallback_t) (uint8_t speed_is_default, float speed, uint8_t angle_is_default, float angle, uint8_t horizontal_distance_is_default, float horizontal_distance, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.dolly_slide_anim_config_changed
 * @param callback new callback for the command unknown_feature_1.dolly_slide_anim_config_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1DollySlideAnimConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command unknown_feature_1.user_framing_position_changed
 */
typedef void (*ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCallback_t) (int8_t horizontal, int8_t vertical, void *custom);
/**
 * @brief callback setter for the command unknown_feature_1.user_framing_position_changed
 * @param callback new callback for the command unknown_feature_1.user_framing_position_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetUnknownFeature1UserFramingPositionChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCallback_t callback, void *custom);

// Feature common


/**
 * @brief callback type for the command common.Network.Disconnect
 */
typedef void (*ARCOMMANDS_Decoder_CommonNetworkDisconnectCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.Network.Disconnect
 * @param callback new callback for the command common.Network.Disconnect
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonNetworkDisconnectCallback (ARCOMMANDS_Decoder_CommonNetworkDisconnectCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Settings.AllSettings
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsAllSettingsCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.Settings.AllSettings
 * @param callback new callback for the command common.Settings.AllSettings
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsAllSettingsCallback (ARCOMMANDS_Decoder_CommonSettingsAllSettingsCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Settings.Reset
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsResetCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.Settings.Reset
 * @param callback new callback for the command common.Settings.Reset
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsResetCallback (ARCOMMANDS_Decoder_CommonSettingsResetCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Settings.ProductName
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsProductNameCallback_t) (char * name, void *custom);
/**
 * @brief callback setter for the command common.Settings.ProductName
 * @param callback new callback for the command common.Settings.ProductName
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsProductNameCallback (ARCOMMANDS_Decoder_CommonSettingsProductNameCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Settings.Country
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsCountryCallback_t) (char * code, void *custom);
/**
 * @brief callback setter for the command common.Settings.Country
 * @param callback new callback for the command common.Settings.Country
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsCountryCallback (ARCOMMANDS_Decoder_CommonSettingsCountryCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Settings.AutoCountry
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsAutoCountryCallback_t) (uint8_t automatic, void *custom);
/**
 * @brief callback setter for the command common.Settings.AutoCountry
 * @param callback new callback for the command common.Settings.AutoCountry
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsAutoCountryCallback (ARCOMMANDS_Decoder_CommonSettingsAutoCountryCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Common.AllStates
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonAllStatesCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.Common.AllStates
 * @param callback new callback for the command common.Common.AllStates
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonAllStatesCallback (ARCOMMANDS_Decoder_CommonCommonAllStatesCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Common.CurrentDate
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonCurrentDateCallback_t) (char * date, void *custom);
/**
 * @brief callback setter for the command common.Common.CurrentDate
 * @param callback new callback for the command common.Common.CurrentDate
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonCurrentDateCallback (ARCOMMANDS_Decoder_CommonCommonCurrentDateCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Common.CurrentTime
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonCurrentTimeCallback_t) (char * time, void *custom);
/**
 * @brief callback setter for the command common.Common.CurrentTime
 * @param callback new callback for the command common.Common.CurrentTime
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonCurrentTimeCallback (ARCOMMANDS_Decoder_CommonCommonCurrentTimeCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Common.Reboot
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonRebootCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.Common.Reboot
 * @param callback new callback for the command common.Common.Reboot
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonRebootCallback (ARCOMMANDS_Decoder_CommonCommonRebootCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.OverHeat.SwitchOff
 */
typedef void (*ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.OverHeat.SwitchOff
 * @param callback new callback for the command common.OverHeat.SwitchOff
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonOverHeatSwitchOffCallback (ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.OverHeat.Ventilate
 */
typedef void (*ARCOMMANDS_Decoder_CommonOverHeatVentilateCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.OverHeat.Ventilate
 * @param callback new callback for the command common.OverHeat.Ventilate
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonOverHeatVentilateCallback (ARCOMMANDS_Decoder_CommonOverHeatVentilateCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Controller.isPiloting
 */
typedef void (*ARCOMMANDS_Decoder_CommonControllerIsPilotingCallback_t) (uint8_t piloting, void *custom);
/**
 * @brief callback setter for the command common.Controller.isPiloting
 * @param callback new callback for the command common.Controller.isPiloting
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonControllerIsPilotingCallback (ARCOMMANDS_Decoder_CommonControllerIsPilotingCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.WifiSettings.OutdoorSetting
 */
typedef void (*ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCallback_t) (uint8_t outdoor, void *custom);
/**
 * @brief callback setter for the command common.WifiSettings.OutdoorSetting
 * @param callback new callback for the command common.WifiSettings.OutdoorSetting
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonWifiSettingsOutdoorSettingCallback (ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Mavlink.Start
 */
typedef void (*ARCOMMANDS_Decoder_CommonMavlinkStartCallback_t) (char * filepath, eARCOMMANDS_COMMON_MAVLINK_START_TYPE type, void *custom);
/**
 * @brief callback setter for the command common.Mavlink.Start
 * @param callback new callback for the command common.Mavlink.Start
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonMavlinkStartCallback (ARCOMMANDS_Decoder_CommonMavlinkStartCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Mavlink.Pause
 */
typedef void (*ARCOMMANDS_Decoder_CommonMavlinkPauseCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.Mavlink.Pause
 * @param callback new callback for the command common.Mavlink.Pause
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonMavlinkPauseCallback (ARCOMMANDS_Decoder_CommonMavlinkPauseCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Mavlink.Stop
 */
typedef void (*ARCOMMANDS_Decoder_CommonMavlinkStopCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.Mavlink.Stop
 * @param callback new callback for the command common.Mavlink.Stop
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonMavlinkStopCallback (ARCOMMANDS_Decoder_CommonMavlinkStopCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Calibration.MagnetoCalibration
 */
typedef void (*ARCOMMANDS_Decoder_CommonCalibrationMagnetoCalibrationCallback_t) (uint8_t calibrate, void *custom);
/**
 * @brief callback setter for the command common.Calibration.MagnetoCalibration
 * @param callback new callback for the command common.Calibration.MagnetoCalibration
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCalibrationMagnetoCalibrationCallback (ARCOMMANDS_Decoder_CommonCalibrationMagnetoCalibrationCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.GPS.ControllerPositionForRun
 */
typedef void (*ARCOMMANDS_Decoder_CommonGPSControllerPositionForRunCallback_t) (double latitude, double longitude, void *custom);
/**
 * @brief callback setter for the command common.GPS.ControllerPositionForRun
 * @param callback new callback for the command common.GPS.ControllerPositionForRun
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonGPSControllerPositionForRunCallback (ARCOMMANDS_Decoder_CommonGPSControllerPositionForRunCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Audio.ControllerReadyForStreaming
 */
typedef void (*ARCOMMANDS_Decoder_CommonAudioControllerReadyForStreamingCallback_t) (uint8_t ready, void *custom);
/**
 * @brief callback setter for the command common.Audio.ControllerReadyForStreaming
 * @param callback new callback for the command common.Audio.ControllerReadyForStreaming
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonAudioControllerReadyForStreamingCallback (ARCOMMANDS_Decoder_CommonAudioControllerReadyForStreamingCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Headlights.intensity
 */
typedef void (*ARCOMMANDS_Decoder_CommonHeadlightsIntensityCallback_t) (uint8_t left, uint8_t right, void *custom);
/**
 * @brief callback setter for the command common.Headlights.intensity
 * @param callback new callback for the command common.Headlights.intensity
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonHeadlightsIntensityCallback (ARCOMMANDS_Decoder_CommonHeadlightsIntensityCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Animations.StartAnimation
 */
typedef void (*ARCOMMANDS_Decoder_CommonAnimationsStartAnimationCallback_t) (eARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM anim, void *custom);
/**
 * @brief callback setter for the command common.Animations.StartAnimation
 * @param callback new callback for the command common.Animations.StartAnimation
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonAnimationsStartAnimationCallback (ARCOMMANDS_Decoder_CommonAnimationsStartAnimationCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Animations.StopAnimation
 */
typedef void (*ARCOMMANDS_Decoder_CommonAnimationsStopAnimationCallback_t) (eARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM anim, void *custom);
/**
 * @brief callback setter for the command common.Animations.StopAnimation
 * @param callback new callback for the command common.Animations.StopAnimation
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonAnimationsStopAnimationCallback (ARCOMMANDS_Decoder_CommonAnimationsStopAnimationCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Animations.StopAllAnimations
 */
typedef void (*ARCOMMANDS_Decoder_CommonAnimationsStopAllAnimationsCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.Animations.StopAllAnimations
 * @param callback new callback for the command common.Animations.StopAllAnimations
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonAnimationsStopAllAnimationsCallback (ARCOMMANDS_Decoder_CommonAnimationsStopAllAnimationsCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Accessory.Config
 */
typedef void (*ARCOMMANDS_Decoder_CommonAccessoryConfigCallback_t) (eARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY accessory, void *custom);
/**
 * @brief callback setter for the command common.Accessory.Config
 * @param callback new callback for the command common.Accessory.Config
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonAccessoryConfigCallback (ARCOMMANDS_Decoder_CommonAccessoryConfigCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.Charger.SetMaxChargeRate
 */
typedef void (*ARCOMMANDS_Decoder_CommonChargerSetMaxChargeRateCallback_t) (eARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE rate, void *custom);
/**
 * @brief callback setter for the command common.Charger.SetMaxChargeRate
 * @param callback new callback for the command common.Charger.SetMaxChargeRate
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonChargerSetMaxChargeRateCallback (ARCOMMANDS_Decoder_CommonChargerSetMaxChargeRateCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.NetworkEvent.Disconnection
 */
typedef void (*ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCallback_t) (eARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE cause, void *custom);
/**
 * @brief callback setter for the command common.NetworkEvent.Disconnection
 * @param callback new callback for the command common.NetworkEvent.Disconnection
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonNetworkEventDisconnectionCallback (ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.SettingsState.AllSettingsChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.SettingsState.AllSettingsChanged
 * @param callback new callback for the command common.SettingsState.AllSettingsChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsStateAllSettingsChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.SettingsState.ResetChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.SettingsState.ResetChanged
 * @param callback new callback for the command common.SettingsState.ResetChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsStateResetChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.SettingsState.ProductNameChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCallback_t) (char * name, void *custom);
/**
 * @brief callback setter for the command common.SettingsState.ProductNameChanged
 * @param callback new callback for the command common.SettingsState.ProductNameChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsStateProductNameChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.SettingsState.ProductVersionChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCallback_t) (char * software, char * hardware, void *custom);
/**
 * @brief callback setter for the command common.SettingsState.ProductVersionChanged
 * @param callback new callback for the command common.SettingsState.ProductVersionChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsStateProductVersionChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.SettingsState.ProductSerialHighChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCallback_t) (char * high, void *custom);
/**
 * @brief callback setter for the command common.SettingsState.ProductSerialHighChanged
 * @param callback new callback for the command common.SettingsState.ProductSerialHighChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsStateProductSerialHighChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.SettingsState.ProductSerialLowChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCallback_t) (char * low, void *custom);
/**
 * @brief callback setter for the command common.SettingsState.ProductSerialLowChanged
 * @param callback new callback for the command common.SettingsState.ProductSerialLowChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsStateProductSerialLowChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.SettingsState.CountryChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCallback_t) (char * code, void *custom);
/**
 * @brief callback setter for the command common.SettingsState.CountryChanged
 * @param callback new callback for the command common.SettingsState.CountryChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsStateCountryChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.SettingsState.AutoCountryChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCallback_t) (uint8_t automatic, void *custom);
/**
 * @brief callback setter for the command common.SettingsState.AutoCountryChanged
 * @param callback new callback for the command common.SettingsState.AutoCountryChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonSettingsStateAutoCountryChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.AllStatesChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.CommonState.AllStatesChanged
 * @param callback new callback for the command common.CommonState.AllStatesChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateAllStatesChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.BatteryStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCallback_t) (uint8_t percent, void *custom);
/**
 * @brief callback setter for the command common.CommonState.BatteryStateChanged
 * @param callback new callback for the command common.CommonState.BatteryStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateBatteryStateChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.MassStorageStateListChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCallback_t) (uint8_t mass_storage_id, char * name, void *custom);
/**
 * @brief callback setter for the command common.CommonState.MassStorageStateListChanged
 * @param callback new callback for the command common.CommonState.MassStorageStateListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageStateListChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.MassStorageInfoStateListChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCallback_t) (uint8_t mass_storage_id, uint32_t size, uint32_t used_size, uint8_t plugged, uint8_t full, uint8_t internal, void *custom);
/**
 * @brief callback setter for the command common.CommonState.MassStorageInfoStateListChanged
 * @param callback new callback for the command common.CommonState.MassStorageInfoStateListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageInfoStateListChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.CurrentDateChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCallback_t) (char * date, void *custom);
/**
 * @brief callback setter for the command common.CommonState.CurrentDateChanged
 * @param callback new callback for the command common.CommonState.CurrentDateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateCurrentDateChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.CurrentTimeChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCallback_t) (char * time, void *custom);
/**
 * @brief callback setter for the command common.CommonState.CurrentTimeChanged
 * @param callback new callback for the command common.CommonState.CurrentTimeChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateCurrentTimeChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.MassStorageInfoRemainingListChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCallback_t) (uint32_t free_space, uint16_t rec_time, uint32_t photo_remaining, void *custom);
/**
 * @brief callback setter for the command common.CommonState.MassStorageInfoRemainingListChanged
 * @param callback new callback for the command common.CommonState.MassStorageInfoRemainingListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageInfoRemainingListChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.WifiSignalChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCallback_t) (int16_t rssi, void *custom);
/**
 * @brief callback setter for the command common.CommonState.WifiSignalChanged
 * @param callback new callback for the command common.CommonState.WifiSignalChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateWifiSignalChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.SensorsStatesListChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCallback_t) (eARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME sensorName, uint8_t sensorState, void *custom);
/**
 * @brief callback setter for the command common.CommonState.SensorsStatesListChanged
 * @param callback new callback for the command common.CommonState.SensorsStatesListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateSensorsStatesListChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.ProductModel
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateProductModelCallback_t) (eARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL model, void *custom);
/**
 * @brief callback setter for the command common.CommonState.ProductModel
 * @param callback new callback for the command common.CommonState.ProductModel
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateProductModelCallback (ARCOMMANDS_Decoder_CommonCommonStateProductModelCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CommonState.CountryListKnown
 */
typedef void (*ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCallback_t) (uint8_t listFlags, char * countryCodes, void *custom);
/**
 * @brief callback setter for the command common.CommonState.CountryListKnown
 * @param callback new callback for the command common.CommonState.CountryListKnown
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCommonStateCountryListKnownCallback (ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.OverHeatState.OverHeatChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.OverHeatState.OverHeatChanged
 * @param callback new callback for the command common.OverHeatState.OverHeatChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonOverHeatStateOverHeatChangedCallback (ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.OverHeatState.OverHeatRegulationChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCallback_t) (uint8_t regulationType, void *custom);
/**
 * @brief callback setter for the command common.OverHeatState.OverHeatRegulationChanged
 * @param callback new callback for the command common.OverHeatState.OverHeatRegulationChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonOverHeatStateOverHeatRegulationChangedCallback (ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.WifiSettingsState.outdoorSettingsChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonWifiSettingsStateOutdoorSettingsChangedCallback_t) (uint8_t outdoor, void *custom);
/**
 * @brief callback setter for the command common.WifiSettingsState.outdoorSettingsChanged
 * @param callback new callback for the command common.WifiSettingsState.outdoorSettingsChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonWifiSettingsStateOutdoorSettingsChangedCallback (ARCOMMANDS_Decoder_CommonWifiSettingsStateOutdoorSettingsChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.MavlinkState.MavlinkFilePlayingStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkFilePlayingStateChangedCallback_t) (eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE state, char * filepath, eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE type, void *custom);
/**
 * @brief callback setter for the command common.MavlinkState.MavlinkFilePlayingStateChanged
 * @param callback new callback for the command common.MavlinkState.MavlinkFilePlayingStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonMavlinkStateMavlinkFilePlayingStateChangedCallback (ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkFilePlayingStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.MavlinkState.MavlinkPlayErrorStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkPlayErrorStateChangedCallback_t) (eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR error, void *custom);
/**
 * @brief callback setter for the command common.MavlinkState.MavlinkPlayErrorStateChanged
 * @param callback new callback for the command common.MavlinkState.MavlinkPlayErrorStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonMavlinkStateMavlinkPlayErrorStateChangedCallback (ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkPlayErrorStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CalibrationState.MagnetoCalibrationStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStateChangedCallback_t) (uint8_t xAxisCalibration, uint8_t yAxisCalibration, uint8_t zAxisCalibration, uint8_t calibrationFailed, void *custom);
/**
 * @brief callback setter for the command common.CalibrationState.MagnetoCalibrationStateChanged
 * @param callback new callback for the command common.CalibrationState.MagnetoCalibrationStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationStateChangedCallback (ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CalibrationState.MagnetoCalibrationRequiredState
 */
typedef void (*ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationRequiredStateCallback_t) (uint8_t required, void *custom);
/**
 * @brief callback setter for the command common.CalibrationState.MagnetoCalibrationRequiredState
 * @param callback new callback for the command common.CalibrationState.MagnetoCalibrationRequiredState
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationRequiredStateCallback (ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationRequiredStateCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CalibrationState.MagnetoCalibrationAxisToCalibrateChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCallback_t) (eARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS axis, void *custom);
/**
 * @brief callback setter for the command common.CalibrationState.MagnetoCalibrationAxisToCalibrateChanged
 * @param callback new callback for the command common.CalibrationState.MagnetoCalibrationAxisToCalibrateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCallback (ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CalibrationState.MagnetoCalibrationStartedChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStartedChangedCallback_t) (uint8_t started, void *custom);
/**
 * @brief callback setter for the command common.CalibrationState.MagnetoCalibrationStartedChanged
 * @param callback new callback for the command common.CalibrationState.MagnetoCalibrationStartedChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationStartedChangedCallback (ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStartedChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.CameraSettingsState.CameraSettingsChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonCameraSettingsStateCameraSettingsChangedCallback_t) (float fov, float panMax, float panMin, float tiltMax, float tiltMin, void *custom);
/**
 * @brief callback setter for the command common.CameraSettingsState.CameraSettingsChanged
 * @param callback new callback for the command common.CameraSettingsState.CameraSettingsChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonCameraSettingsStateCameraSettingsChangedCallback (ARCOMMANDS_Decoder_CommonCameraSettingsStateCameraSettingsChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.FlightPlanState.AvailabilityStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonFlightPlanStateAvailabilityStateChangedCallback_t) (uint8_t AvailabilityState, void *custom);
/**
 * @brief callback setter for the command common.FlightPlanState.AvailabilityStateChanged
 * @param callback new callback for the command common.FlightPlanState.AvailabilityStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonFlightPlanStateAvailabilityStateChangedCallback (ARCOMMANDS_Decoder_CommonFlightPlanStateAvailabilityStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.FlightPlanState.ComponentStateListChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonFlightPlanStateComponentStateListChangedCallback_t) (eARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT component, uint8_t State, void *custom);
/**
 * @brief callback setter for the command common.FlightPlanState.ComponentStateListChanged
 * @param callback new callback for the command common.FlightPlanState.ComponentStateListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonFlightPlanStateComponentStateListChangedCallback (ARCOMMANDS_Decoder_CommonFlightPlanStateComponentStateListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.FlightPlanEvent.StartingErrorEvent
 */
typedef void (*ARCOMMANDS_Decoder_CommonFlightPlanEventStartingErrorEventCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.FlightPlanEvent.StartingErrorEvent
 * @param callback new callback for the command common.FlightPlanEvent.StartingErrorEvent
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonFlightPlanEventStartingErrorEventCallback (ARCOMMANDS_Decoder_CommonFlightPlanEventStartingErrorEventCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.FlightPlanEvent.SpeedBridleEvent
 */
typedef void (*ARCOMMANDS_Decoder_CommonFlightPlanEventSpeedBridleEventCallback_t) (void *custom);
/**
 * @brief callback setter for the command common.FlightPlanEvent.SpeedBridleEvent
 * @param callback new callback for the command common.FlightPlanEvent.SpeedBridleEvent
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonFlightPlanEventSpeedBridleEventCallback (ARCOMMANDS_Decoder_CommonFlightPlanEventSpeedBridleEventCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.ARLibsVersionsState.ControllerLibARCommandsVersion
 */
typedef void (*ARCOMMANDS_Decoder_CommonARLibsVersionsStateControllerLibARCommandsVersionCallback_t) (char * version, void *custom);
/**
 * @brief callback setter for the command common.ARLibsVersionsState.ControllerLibARCommandsVersion
 * @param callback new callback for the command common.ARLibsVersionsState.ControllerLibARCommandsVersion
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonARLibsVersionsStateControllerLibARCommandsVersionCallback (ARCOMMANDS_Decoder_CommonARLibsVersionsStateControllerLibARCommandsVersionCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.ARLibsVersionsState.SkyControllerLibARCommandsVersion
 */
typedef void (*ARCOMMANDS_Decoder_CommonARLibsVersionsStateSkyControllerLibARCommandsVersionCallback_t) (char * version, void *custom);
/**
 * @brief callback setter for the command common.ARLibsVersionsState.SkyControllerLibARCommandsVersion
 * @param callback new callback for the command common.ARLibsVersionsState.SkyControllerLibARCommandsVersion
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonARLibsVersionsStateSkyControllerLibARCommandsVersionCallback (ARCOMMANDS_Decoder_CommonARLibsVersionsStateSkyControllerLibARCommandsVersionCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.ARLibsVersionsState.DeviceLibARCommandsVersion
 */
typedef void (*ARCOMMANDS_Decoder_CommonARLibsVersionsStateDeviceLibARCommandsVersionCallback_t) (char * version, void *custom);
/**
 * @brief callback setter for the command common.ARLibsVersionsState.DeviceLibARCommandsVersion
 * @param callback new callback for the command common.ARLibsVersionsState.DeviceLibARCommandsVersion
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonARLibsVersionsStateDeviceLibARCommandsVersionCallback (ARCOMMANDS_Decoder_CommonARLibsVersionsStateDeviceLibARCommandsVersionCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.AudioState.AudioStreamingRunning
 */
typedef void (*ARCOMMANDS_Decoder_CommonAudioStateAudioStreamingRunningCallback_t) (uint8_t running, void *custom);
/**
 * @brief callback setter for the command common.AudioState.AudioStreamingRunning
 * @param callback new callback for the command common.AudioState.AudioStreamingRunning
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonAudioStateAudioStreamingRunningCallback (ARCOMMANDS_Decoder_CommonAudioStateAudioStreamingRunningCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.HeadlightsState.intensityChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonHeadlightsStateIntensityChangedCallback_t) (uint8_t left, uint8_t right, void *custom);
/**
 * @brief callback setter for the command common.HeadlightsState.intensityChanged
 * @param callback new callback for the command common.HeadlightsState.intensityChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonHeadlightsStateIntensityChangedCallback (ARCOMMANDS_Decoder_CommonHeadlightsStateIntensityChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.AnimationsState.List
 */
typedef void (*ARCOMMANDS_Decoder_CommonAnimationsStateListCallback_t) (eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM anim, eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE state, eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR error, void *custom);
/**
 * @brief callback setter for the command common.AnimationsState.List
 * @param callback new callback for the command common.AnimationsState.List
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonAnimationsStateListCallback (ARCOMMANDS_Decoder_CommonAnimationsStateListCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.AccessoryState.SupportedAccessoriesListChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonAccessoryStateSupportedAccessoriesListChangedCallback_t) (eARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY accessory, void *custom);
/**
 * @brief callback setter for the command common.AccessoryState.SupportedAccessoriesListChanged
 * @param callback new callback for the command common.AccessoryState.SupportedAccessoriesListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonAccessoryStateSupportedAccessoriesListChangedCallback (ARCOMMANDS_Decoder_CommonAccessoryStateSupportedAccessoriesListChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.AccessoryState.AccessoryConfigChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigChangedCallback_t) (eARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY newAccessory, eARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR error, void *custom);
/**
 * @brief callback setter for the command common.AccessoryState.AccessoryConfigChanged
 * @param callback new callback for the command common.AccessoryState.AccessoryConfigChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonAccessoryStateAccessoryConfigChangedCallback (ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.AccessoryState.AccessoryConfigModificationEnabled
 */
typedef void (*ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigModificationEnabledCallback_t) (uint8_t enabled, void *custom);
/**
 * @brief callback setter for the command common.AccessoryState.AccessoryConfigModificationEnabled
 * @param callback new callback for the command common.AccessoryState.AccessoryConfigModificationEnabled
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonAccessoryStateAccessoryConfigModificationEnabledCallback (ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigModificationEnabledCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.ChargerState.MaxChargeRateChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonChargerStateMaxChargeRateChangedCallback_t) (eARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE rate, void *custom);
/**
 * @brief callback setter for the command common.ChargerState.MaxChargeRateChanged
 * @param callback new callback for the command common.ChargerState.MaxChargeRateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonChargerStateMaxChargeRateChangedCallback (ARCOMMANDS_Decoder_CommonChargerStateMaxChargeRateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.ChargerState.CurrentChargeStateChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonChargerStateCurrentChargeStateChangedCallback_t) (eARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS status, eARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE phase, void *custom);
/**
 * @brief callback setter for the command common.ChargerState.CurrentChargeStateChanged
 * @param callback new callback for the command common.ChargerState.CurrentChargeStateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonChargerStateCurrentChargeStateChangedCallback (ARCOMMANDS_Decoder_CommonChargerStateCurrentChargeStateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.ChargerState.LastChargeRateChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonChargerStateLastChargeRateChangedCallback_t) (eARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE rate, void *custom);
/**
 * @brief callback setter for the command common.ChargerState.LastChargeRateChanged
 * @param callback new callback for the command common.ChargerState.LastChargeRateChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonChargerStateLastChargeRateChangedCallback (ARCOMMANDS_Decoder_CommonChargerStateLastChargeRateChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.ChargerState.ChargingInfo
 */
typedef void (*ARCOMMANDS_Decoder_CommonChargerStateChargingInfoCallback_t) (eARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE phase, eARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE rate, uint8_t intensity, uint8_t fullChargingTime, void *custom);
/**
 * @brief callback setter for the command common.ChargerState.ChargingInfo
 * @param callback new callback for the command common.ChargerState.ChargingInfo
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonChargerStateChargingInfoCallback (ARCOMMANDS_Decoder_CommonChargerStateChargingInfoCallback_t callback, void *custom);

/**
 * @brief callback type for the command common.RunState.RunIdChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonRunStateRunIdChangedCallback_t) (char * runId, void *custom);
/**
 * @brief callback setter for the command common.RunState.RunIdChanged
 * @param callback new callback for the command common.RunState.RunIdChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonRunStateRunIdChangedCallback (ARCOMMANDS_Decoder_CommonRunStateRunIdChangedCallback_t callback, void *custom);

// Feature commonDebug


/**
 * @brief callback type for the command commonDebug.Stats.SendPacket
 */
typedef void (*ARCOMMANDS_Decoder_CommonDebugStatsSendPacketCallback_t) (char * packet, void *custom);
/**
 * @brief callback setter for the command commonDebug.Stats.SendPacket
 * @param callback new callback for the command commonDebug.Stats.SendPacket
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonDebugStatsSendPacketCallback (ARCOMMANDS_Decoder_CommonDebugStatsSendPacketCallback_t callback, void *custom);

/**
 * @brief callback type for the command commonDebug.Stats.StartSendingPacketFromDrone
 */
typedef void (*ARCOMMANDS_Decoder_CommonDebugStatsStartSendingPacketFromDroneCallback_t) (uint8_t frequency, uint8_t packetSize, uint32_t date, void *custom);
/**
 * @brief callback setter for the command commonDebug.Stats.StartSendingPacketFromDrone
 * @param callback new callback for the command commonDebug.Stats.StartSendingPacketFromDrone
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonDebugStatsStartSendingPacketFromDroneCallback (ARCOMMANDS_Decoder_CommonDebugStatsStartSendingPacketFromDroneCallback_t callback, void *custom);

/**
 * @brief callback type for the command commonDebug.Stats.StopSendingPacketFromDrone
 */
typedef void (*ARCOMMANDS_Decoder_CommonDebugStatsStopSendingPacketFromDroneCallback_t) (void *custom);
/**
 * @brief callback setter for the command commonDebug.Stats.StopSendingPacketFromDrone
 * @param callback new callback for the command commonDebug.Stats.StopSendingPacketFromDrone
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonDebugStatsStopSendingPacketFromDroneCallback (ARCOMMANDS_Decoder_CommonDebugStatsStopSendingPacketFromDroneCallback_t callback, void *custom);

/**
 * @brief callback type for the command commonDebug.DebugSettings.GetAll
 */
typedef void (*ARCOMMANDS_Decoder_CommonDebugDebugSettingsGetAllCallback_t) (void *custom);
/**
 * @brief callback setter for the command commonDebug.DebugSettings.GetAll
 * @param callback new callback for the command commonDebug.DebugSettings.GetAll
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonDebugDebugSettingsGetAllCallback (ARCOMMANDS_Decoder_CommonDebugDebugSettingsGetAllCallback_t callback, void *custom);

/**
 * @brief callback type for the command commonDebug.DebugSettings.Set
 */
typedef void (*ARCOMMANDS_Decoder_CommonDebugDebugSettingsSetCallback_t) (uint16_t id, char * value, void *custom);
/**
 * @brief callback setter for the command commonDebug.DebugSettings.Set
 * @param callback new callback for the command commonDebug.DebugSettings.Set
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonDebugDebugSettingsSetCallback (ARCOMMANDS_Decoder_CommonDebugDebugSettingsSetCallback_t callback, void *custom);

/**
 * @brief callback type for the command commonDebug.StatsEvent.SendPacket
 */
typedef void (*ARCOMMANDS_Decoder_CommonDebugStatsEventSendPacketCallback_t) (char * packet, void *custom);
/**
 * @brief callback setter for the command commonDebug.StatsEvent.SendPacket
 * @param callback new callback for the command commonDebug.StatsEvent.SendPacket
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonDebugStatsEventSendPacketCallback (ARCOMMANDS_Decoder_CommonDebugStatsEventSendPacketCallback_t callback, void *custom);

/**
 * @brief callback type for the command commonDebug.DebugSettingsState.Info
 */
typedef void (*ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateInfoCallback_t) (uint8_t listFlags, uint16_t id, char * label, eARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE type, eARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE mode, char * range_min, char * range_max, char * range_step, char * value, void *custom);
/**
 * @brief callback setter for the command commonDebug.DebugSettingsState.Info
 * @param callback new callback for the command commonDebug.DebugSettingsState.Info
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonDebugDebugSettingsStateInfoCallback (ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateInfoCallback_t callback, void *custom);

/**
 * @brief callback type for the command commonDebug.DebugSettingsState.ListChanged
 */
typedef void (*ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateListChangedCallback_t) (uint16_t id, char * value, void *custom);
/**
 * @brief callback setter for the command commonDebug.DebugSettingsState.ListChanged
 * @param callback new callback for the command commonDebug.DebugSettingsState.ListChanged
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetCommonDebugDebugSettingsStateListChangedCallback (ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateListChangedCallback_t callback, void *custom);

// Feature pro


/**
 * @brief callback type for the command pro.Pro.BoughtFeatures
 */
typedef void (*ARCOMMANDS_Decoder_ProProBoughtFeaturesCallback_t) (uint64_t features, void *custom);
/**
 * @brief callback setter for the command pro.Pro.BoughtFeatures
 * @param callback new callback for the command pro.Pro.BoughtFeatures
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetProProBoughtFeaturesCallback (ARCOMMANDS_Decoder_ProProBoughtFeaturesCallback_t callback, void *custom);

/**
 * @brief callback type for the command pro.Pro.Response
 */
typedef void (*ARCOMMANDS_Decoder_ProProResponseCallback_t) (uint8_t listFlags, char * signedChallenge, void *custom);
/**
 * @brief callback setter for the command pro.Pro.Response
 * @param callback new callback for the command pro.Pro.Response
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetProProResponseCallback (ARCOMMANDS_Decoder_ProProResponseCallback_t callback, void *custom);

/**
 * @brief callback type for the command pro.Pro.ActivateFeatures
 */
typedef void (*ARCOMMANDS_Decoder_ProProActivateFeaturesCallback_t) (uint64_t features, void *custom);
/**
 * @brief callback setter for the command pro.Pro.ActivateFeatures
 * @param callback new callback for the command pro.Pro.ActivateFeatures
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetProProActivateFeaturesCallback (ARCOMMANDS_Decoder_ProProActivateFeaturesCallback_t callback, void *custom);

/**
 * @brief callback type for the command pro.ProState.SupportedFeatures
 */
typedef void (*ARCOMMANDS_Decoder_ProProStateSupportedFeaturesCallback_t) (eARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS status, uint64_t features, void *custom);
/**
 * @brief callback setter for the command pro.ProState.SupportedFeatures
 * @param callback new callback for the command pro.ProState.SupportedFeatures
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetProProStateSupportedFeaturesCallback (ARCOMMANDS_Decoder_ProProStateSupportedFeaturesCallback_t callback, void *custom);

/**
 * @brief callback type for the command pro.ProState.FeaturesActivated
 */
typedef void (*ARCOMMANDS_Decoder_ProProStateFeaturesActivatedCallback_t) (uint64_t features, void *custom);
/**
 * @brief callback setter for the command pro.ProState.FeaturesActivated
 * @param callback new callback for the command pro.ProState.FeaturesActivated
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetProProStateFeaturesActivatedCallback (ARCOMMANDS_Decoder_ProProStateFeaturesActivatedCallback_t callback, void *custom);

/**
 * @brief callback type for the command pro.ProEvent.ChallengeEvent
 */
typedef void (*ARCOMMANDS_Decoder_ProProEventChallengeEventCallback_t) (char * challenge, void *custom);
/**
 * @brief callback setter for the command pro.ProEvent.ChallengeEvent
 * @param callback new callback for the command pro.ProEvent.ChallengeEvent
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetProProEventChallengeEventCallback (ARCOMMANDS_Decoder_ProProEventChallengeEventCallback_t callback, void *custom);

// Feature wifi


/**
 * @brief callback type for the command wifi.scan
 */
typedef void (*ARCOMMANDS_Decoder_WifiScanCallback_t) (uint8_t band, void *custom);
/**
 * @brief callback setter for the command wifi.scan
 * @param callback new callback for the command wifi.scan
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiScanCallback (ARCOMMANDS_Decoder_WifiScanCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.update_authorized_channels
 */
typedef void (*ARCOMMANDS_Decoder_WifiUpdateAuthorizedChannelsCallback_t) (void *custom);
/**
 * @brief callback setter for the command wifi.update_authorized_channels
 * @param callback new callback for the command wifi.update_authorized_channels
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiUpdateAuthorizedChannelsCallback (ARCOMMANDS_Decoder_WifiUpdateAuthorizedChannelsCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.set_ap_channel
 */
typedef void (*ARCOMMANDS_Decoder_WifiSetApChannelCallback_t) (eARCOMMANDS_WIFI_SELECTION_TYPE type, eARCOMMANDS_WIFI_BAND band, uint8_t channel, void *custom);
/**
 * @brief callback setter for the command wifi.set_ap_channel
 * @param callback new callback for the command wifi.set_ap_channel
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiSetApChannelCallback (ARCOMMANDS_Decoder_WifiSetApChannelCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.set_security
 */
typedef void (*ARCOMMANDS_Decoder_WifiSetSecurityCallback_t) (eARCOMMANDS_WIFI_SECURITY_TYPE type, char * key, eARCOMMANDS_WIFI_SECURITY_KEY_TYPE key_type, void *custom);
/**
 * @brief callback setter for the command wifi.set_security
 * @param callback new callback for the command wifi.set_security
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiSetSecurityCallback (ARCOMMANDS_Decoder_WifiSetSecurityCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.set_country
 */
typedef void (*ARCOMMANDS_Decoder_WifiSetCountryCallback_t) (eARCOMMANDS_WIFI_COUNTRY_SELECTION selection_mode, char * code, void *custom);
/**
 * @brief callback setter for the command wifi.set_country
 * @param callback new callback for the command wifi.set_country
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiSetCountryCallback (ARCOMMANDS_Decoder_WifiSetCountryCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.set_environement
 */
typedef void (*ARCOMMANDS_Decoder_WifiSetEnvironementCallback_t) (eARCOMMANDS_WIFI_ENVIRONEMENT environement, void *custom);
/**
 * @brief callback setter for the command wifi.set_environement
 * @param callback new callback for the command wifi.set_environement
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiSetEnvironementCallback (ARCOMMANDS_Decoder_WifiSetEnvironementCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.scanned_item
 */
typedef void (*ARCOMMANDS_Decoder_WifiScannedItemCallback_t) (char * ssid, int16_t rssi, eARCOMMANDS_WIFI_BAND band, uint8_t channel, uint8_t list_flags, void *custom);
/**
 * @brief callback setter for the command wifi.scanned_item
 * @param callback new callback for the command wifi.scanned_item
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiScannedItemCallback (ARCOMMANDS_Decoder_WifiScannedItemCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.authorized_channel
 */
typedef void (*ARCOMMANDS_Decoder_WifiAuthorizedChannelCallback_t) (eARCOMMANDS_WIFI_BAND band, uint8_t channel, uint8_t environement, uint8_t list_flags, void *custom);
/**
 * @brief callback setter for the command wifi.authorized_channel
 * @param callback new callback for the command wifi.authorized_channel
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiAuthorizedChannelCallback (ARCOMMANDS_Decoder_WifiAuthorizedChannelCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.ap_channel_changed
 */
typedef void (*ARCOMMANDS_Decoder_WifiApChannelChangedCallback_t) (eARCOMMANDS_WIFI_SELECTION_TYPE type, eARCOMMANDS_WIFI_BAND band, uint8_t channel, void *custom);
/**
 * @brief callback setter for the command wifi.ap_channel_changed
 * @param callback new callback for the command wifi.ap_channel_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiApChannelChangedCallback (ARCOMMANDS_Decoder_WifiApChannelChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.security_changed
 */
typedef void (*ARCOMMANDS_Decoder_WifiSecurityChangedCallback_t) (char * key, eARCOMMANDS_WIFI_SECURITY_TYPE key_type, void *custom);
/**
 * @brief callback setter for the command wifi.security_changed
 * @param callback new callback for the command wifi.security_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiSecurityChangedCallback (ARCOMMANDS_Decoder_WifiSecurityChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.country_changed
 */
typedef void (*ARCOMMANDS_Decoder_WifiCountryChangedCallback_t) (eARCOMMANDS_WIFI_COUNTRY_SELECTION selection_mode, char * code, void *custom);
/**
 * @brief callback setter for the command wifi.country_changed
 * @param callback new callback for the command wifi.country_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiCountryChangedCallback (ARCOMMANDS_Decoder_WifiCountryChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.environement_changed
 */
typedef void (*ARCOMMANDS_Decoder_WifiEnvironementChangedCallback_t) (eARCOMMANDS_WIFI_ENVIRONEMENT environement, void *custom);
/**
 * @brief callback setter for the command wifi.environement_changed
 * @param callback new callback for the command wifi.environement_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiEnvironementChangedCallback (ARCOMMANDS_Decoder_WifiEnvironementChangedCallback_t callback, void *custom);

/**
 * @brief callback type for the command wifi.rssi_changed
 */
typedef void (*ARCOMMANDS_Decoder_WifiRssiChangedCallback_t) (int16_t rssi, void *custom);
/**
 * @brief callback setter for the command wifi.rssi_changed
 * @param callback new callback for the command wifi.rssi_changed
 * @param custom pointer that will be passed to all calls to the callback
 */
void ARCOMMANDS_Decoder_SetWifiRssiChangedCallback (ARCOMMANDS_Decoder_WifiRssiChangedCallback_t callback, void *custom);

#endif /* _LIBARCOMMANDS_ARCOMMANDS_DECODER_H_ */
