# Py Trees for ROS

Behaviours, trees and utilities that extend py_trees for use
with ROS.

## Sources, Builds & Docs

| | Melodic | Kinetic |
|:---:|:---:|:---:|
| Sources | [![0.5.x-Sources][0.5.x-sources-image]][0.5.x-sources] | [![0.5.x-Sources][0.5.x-sources-image]][0.5.x-sources] |
| Continuous Integration | [![melodic-Status][melodic-build-status-image]][melodic-build-status] | [![kinetic-Status][kinetic-build-status-image]][kinetic-build-status] | |
| Documentation | [![0.5.x-Docs][0.5.x-docs-image]][py-trees-ros-docs-melodic] | [![0.5.x-Docs][0.5.x-docs-image]][py-trees-ros-docs-kinetic] |

[0.5.x-sources-image]: http://img.shields.io/badge/sources-0.5.x-blue.svg?style=plastic
[0.5.x-sources]: https://github.com/splintered-reality/py_trees_ros/tree/release/0.5.x

[melodic-build-status-image]: http://build.ros.org/job/Mbin_uB64__py_trees_ros__ubuntu_bionic_amd64__binary/badge/icon?style=plastic
[melodic-build-status]: http://build.ros.org/job/Mbin_uB64__py_trees_ros__ubuntu_bionic_amd64__binary
[kinetic-build-status-image]: http://build.ros.org/job/Kbin_uX64__py_trees_ros__ubuntu_xenial_amd64__binary/badge/icon?style=plastic
[kinetic-build-status]: http://build.ros.org/job/Kbin_uX64__py_trees_ros__ubuntu_xenial_amd64__binary

[0.5.x-docs-image]: http://img.shields.io/badge/docs-0.5.x-brightgreen.svg?style=plastic
[py-trees-ros-docs-melodic]: http://docs.ros.org/melodic/api/py_trees_ros/html/
[py-trees-ros-docs-kinetic]: http://docs.ros.org/kinetic/api/py_trees_ros/html/

[py-trees-docs-melodic]: http://docs.ros.org/melodic/api/py_trees/html/
[py-trees-docs-kinetic]: http://docs.ros.org/kinetic/api/py_trees/html/

## Getting Started

Make sure to refer to the [py_trees](https://github.com/splintered-reality/py_trees) package and it's documentation [[melodic][py-trees-docs-melodic]], [[kinetic][py-trees-docs-kinetic]] for a primer on behaviour trees and then follow up with this package's tutorials [[melodic][py-trees-ros-docs-melodic]], [[kinetic][py-trees-ros-docs-kinetic]] for getting started with behaviour trees in ROS.

## The ROS 1 Py Trees Packages

* [py_trees](https://github.com/stonier/py_trees)
* [py_trees_msgs](https://github.com/stonier/py_trees_msgs)
* [py_trees_ros](https://github.com/stonier/py_trees_ros)
* [rqt_py_trees](https://github.com/stonier/rqt_py_trees)
