/**
 * @authors     Mike Karamousadakis
 * @affiliation BOTA SYS A.G.
 * @brief       Tests Reading
 */

#include <gtest/gtest.h>

#include <ros/package.h>
#include <rokubimini/setup/Rokubimini.hpp>

#include <rokubimini/setup/Setup.hpp>

namespace rokubimini
{
namespace setup
{
class RokubiminiSetupTest : public ::testing::Test
{
protected:
  rokubimini::setup::Setup* rokubiminiSetup;
  const std::string setupYaml = ros::package::getPath("rokubimini") + "/test/setup.yaml";
  RokubiminiSetupTest()
  {
    rokubiminiSetup = new rokubimini::setup::Setup();
  }

  ~RokubiminiSetupTest() override
  {
    delete rokubiminiSetup;
    // You can do clean-up work that doesn't throw exceptions here.
  }

  // If the constructor and destructor are not enough for setting up
  // and cleaning up each test, you can define the following methods:

  void SetUp() override
  {
    // Code here will be called immediately after the constructor (right
    // before each test).
  }

  void TearDown() override
  {
    // Code here will be called immediately after each test (right
    // before the destructor).
  }
};

TEST_F(RokubiminiSetupTest, FromFileWorksCorrectly)
{
  rokubiminiSetup->fromFile(setupYaml);
  EXPECT_EQ(rokubiminiSetup->rokubiminis_.empty(), false);
  EXPECT_EQ(rokubiminiSetup->rokubiminis_.size(), (uint32_t)4);

  EXPECT_STREQ(rokubiminiSetup->rokubiminis_[0]->name_.c_str(), "ROKUB_ETHERCAT_1");
  EXPECT_EQ(rokubiminiSetup->rokubiminis_[0]->productCode_, (uint32_t)2);

  EXPECT_STREQ(rokubiminiSetup->rokubiminis_[1]->name_.c_str(), "ROKUB_SERIAL_USB0");
  EXPECT_EQ(rokubiminiSetup->rokubiminis_[1]->productCode_, (uint32_t)1);

  EXPECT_STREQ(rokubiminiSetup->rokubiminis_[2]->name_.c_str(), "ROKUB_ETHERCAT_2");
  EXPECT_EQ(rokubiminiSetup->rokubiminis_[2]->productCode_, (uint32_t)2);

  EXPECT_STREQ(rokubiminiSetup->rokubiminis_[3]->name_.c_str(), "ROKUB_SERIAL_ACM0");
  EXPECT_EQ(rokubiminiSetup->rokubiminis_[3]->productCode_, (uint32_t)1);
}

TEST_F(RokubiminiSetupTest, CreateRokubiminiWorksCorrectly)
{
  //   EXPECT_EQ(rokubiminiSetup->rokubiminis_.empty(), true);
  for (int i = 1; i < 156000; i++)
  {
    rokubiminiSetup->rokubiminis_.push_back(rokubiminiSetup->createRokubimini());
  }
  EXPECT_EQ(rokubiminiSetup->rokubiminis_.size(), (uint32_t)156000);
}
}  // namespace setup
}  // namespace rokubimini
