roscompile is a tool for improving Catkin packages by fixing common errors and tweaking the style.
To run, simply navigate to a folder containing the packages you'd like to tweak, and type `roscompile`.
This will automatically apply all the fixes described below.
Certain rules can be ignored by tweaking the configuration.
If you want to interactively apply the rules, use the `-i` option.

You can also explicitly enumerate which fixes you want to run with the `roscompile_command` executable.

There are also some other useful scripts described at the bottom of this documentation.

# `roscompile` Features
## Dependencies
 * Checks for dependencies by looking in the source code, message, service, action and launch files.
 * `check_manifest_dependencies` - Inserts build/run/test dependencies into your `package.xml`
 * `check_python_dependencies` - Inserts run dependencies for external Python libraries
 * `check_cmake_dependencies` - Inserts dependencies into your `CMakeLists.txt` (in both the `find_package` and `catkin_package` commands)

## package.xml
 * `remove_empty_export_tag` - Remove the empty export tag
 * `remove_boilerplate_manifest_comments` - Remove boiler-plate comments
 * `remove_empty_manifest_lines` - Remove empty lines
 * `greedy_depend_tag` If a format 2 `package.xml`, collapses matching `build_depend/build_export_depend/exec_depend` commands into a single `depend` command
 * `enforce_manifest_tabbing` Ensure standard indentation of each tag
 * `enforce_manifest_ordering` - Sort all fo the tags by type and value
 * `update_people` - Reads the &lt;author> and &lt;maintainer> tags and allows you to programmatically replace them. (i.e. 'dlu', 'Dave Lu', 'David Lu'', 'dlu@TODO' can all become 'David V. Lu!!') (see configuration section below)
 * `update_license` - Updates TODO licenses to a configurable default license (see configuration section below)
 * `update_metapackage` - Update your metapackage dependencies
 * `misc_xml_formatting` - Remove extra whitespace from inside tags in package.xml (and plugin xmls)

## CMakeLists.txt
 * `check_generators` - Automatically looks for `msg`/`srv`/`action`/`dynamic_reconfigure` definitions and ensures they are properly built in the `CMakeLists.txt`
 * `enforce_cmake_ordering` - Enforces the ordering of the commands

### CMake Style
 * `remove_boilerplate_cmake_comments` - Removes boiler-plate comments
 * `remove_empty_cmake_lines` - Removes empty lines
 * `alphabetize_sections` - Alphabetizes the `COMPONENTS`, `DEPENDENCIES`, `FILES` and `CATKIN_DEPENDS` sections of CMake commands

 * `prettify_catkin_package_cmd` - Ensures standard indentation of `catkin_package`
 * `prettify_package_lists` - Ensures standard indentation of `find_package/COMPONENTS` and `catkin_package/CATKIN_DEPENDS`
 * `prettify_msgs_srvs` - Ensures standard indentation of `add_message_files` and `add_service_files`
 * `prettify_installs` - Ensures standard indentation of `install` commands

### CMake Installs
 * `update_cplusplus_installs` - Checks for install commands for C++ executables/libraries/header files
 * `update_python_installs` - Checks for install commands for Python executables
 * `update_misc_installs` - Checks for install commands for launch files, plugin configurations and other non-code files.
 * `fix_double_directory_installs` - Checks to make sure directory installs don't use the name of the directory twice, a la `$INSTALL_LOCATION/launch/launch/whatever.launch`

## C++
 * Examines the `add_library` and `add_executable` commands in the `CMakeLists.txt` and ensures that each is matched with the appropriate catkin variables.
    * `target_catkin_libraries` - Checks dependencies on `${catkin_LIBRARIES}`
    * `check_exported_dependencies` - Checks dependencies on `${catkin_EXPORTED_TARGETS}` and `${PKG_NAME_EXPORTED_TARGETS}`
    * `remove_old_style_cpp_dependencies` - Removes dependencies on the old style of C++ dependencies (i.e. `__generate_messages_cpp`, `_gencpp` and `_gencfg`) and replaces them with the above `EXPORTED_TARGETS`
 * `check_includes` - Sets up the `include_directories` command
 * `check_library_setup` - ensures your libraries are exported into the `catkin_package` command

## Python
 * `check_setup_py` - If you have python code, will automatically generate setup.py for you.

## Misc
 * `check_dynamic_reconfigure` - If there are `dynamic_reconfigure` configurations, ensure the package depends on `dynamic_reconfigure`, and the configurations are configured in the `CMake` and executable.
 * `remove_useless_files` - Removes autogenerated `mainpage.dox` file
 * `check_plugins` - If you use pluginlib, will search your code for `PLUGINLIB_EXPORT_CLASS` macros, and update your plugin xml accordingly.

# Configuration
 Located at `~/.ros/roscompile.yaml`

 * `skip_fixes`: An array of strings representing fixes that you'd like to always ignore when running `roscompile`
 * `cmake_style`: Can be either `test_first` or `install_first` to indicate whether to convert to having the tests or the installs first in the CMakeLists if the existing commands are improperly ordered.
 * `default_license` - String for the license you want your package manifest to have (if it is set to TODO originally).
 * `replace_rules`: An array of dictionaries representing users you'd like to have replaced in the `package.xml`. For example, one entry in the array could be:
 ```
 from: {email: dlu@todo.todo, name: dlu}
 to: {email: davidvlu@gmail.com, name: David V. Lu!!}
 ```
 The `to` name and email must be specified, but you only need to specify either the name or email for the `from`.

# Other Scripts
The other scripts work similarly to the main tool in that they run on all the packages found within your current folder.

### `upgrade_manifest`
Upgrade your `package.xml` to either format 2 or 3. Without any arguments, it will convert to format 2. `rosrun roscompile upgrade_manifest 3` will upgrade to format 3.

The deprecated version is `convert_to_format_2` which still exists and works, but is not preferred.

### `noetic_migration`
Migrates your package from a pre-Noetic version to be compatible with Noetic, invoked with `rosrun roscompile noetic_migration`. Adding the `-m` option is useful when using the same branch for Noetic and other distros AND you're using Python, as it will conditionally depend on the proper `python-` and `python3-` libraries.

### `add_compile_options`
This script will add C++ compile flags to your `CMakeLists.txt`.
 * `-1` will add `-std=c++11`
 * `-w` will add `-Wall`
 * `-e` will add `-Werror`
 * `-a` will add all of the above.

### `add_tests`
This script will add roslaunch and/or roslint tests to your package, updating both the `manifest.xml` and `CMakeLists.txt`.
 * `-r` will add `roslaunch` tests.
 * `-l` will add `roslint` tests.
 * `-a` will add both
