#ifndef rqt_gauges_my_plugin_H
#define rqt_gauges_my_plugin_H

#include <QWidget>
#include <ros/ros.h>
#include <rqt_gui_cpp/plugin.h>
#include <ui_my_plugin.h> // This is autogenerated by Qt
#include "rqt_gauges/qcgaugewidget.h"
#include <std_msgs/Float64.h>

namespace rqt_gauges {

class MyPlugin
  : public rqt_gui_cpp::Plugin
{
  Q_OBJECT
public:
  MyPlugin();
  virtual void initPlugin(qt_gui_cpp::PluginContext& context);
  void newDataCallback(const std_msgs::Float64& msg);
  virtual void restoreSettings(const qt_gui_cpp::Settings& plugin_settings, const qt_gui_cpp::Settings& instance_settings);
  virtual void saveSettings(qt_gui_cpp::Settings& plugin_settings, qt_gui_cpp::Settings& instance_settings) const;
  virtual void shutdownPlugin();

  // Comment in to signal that the plugin has a way to configure it
  // bool hasConfiguration() const;
  // void triggerConfiguration();
private:
  Ui::Gauge ui_;
  QWidget* widget_;
  QcGaugeWidget* mSpeedGauge_;
  QcNeedleItem *mSpeedNeedle_;
  ros::Subscriber needleSub_;
};
}  // namespace rqt_gauges
#endif  // rqt_gauges_my_plugin_H
