/*
 * Copyright (C) 2017, Osnabrück University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Osnabrück University nor the names of its
 *       contributors may be used to endorse or promote products derived from
 *       this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *      Author:
 *         Sebastian Pütz <spuetz@uos.de>
 *
 */

#ifndef SICK_MRS1000_COMMUNICATION_H
#define SICK_MRS1000_COMMUNICATION_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <boost/asio.hpp>
#include "sick_tim/scan_and_cloud_parser.h"
#include "sick_tim_common_tcp.h"
#include <sensor_msgs/point_cloud2_iterator.h>

namespace sick_tim
{

class SickMrs1000Communication : public SickTimCommonTcp
{
 public:
  SickMrs1000Communication(const std::string &hostname,
                           const std::string &port,
                           int &timelimit,
                           ScanAndCloudParser *parser);
  virtual ~SickMrs1000Communication();
  virtual int loopOnce();

 protected:
  ros::NodeHandle nh_;
  ros::Publisher cloud_pub_;
  diagnostic_updater::DiagnosedPublisher<sensor_msgs::PointCloud2>
      diagnosed_cloud_publisher_;
  virtual int init_scanner();
  ScanAndCloudParser *scan_and_cloud_parser_;
};

}

/* namespace sick_tim */
#endif /* SICK_MRS1000_COMMUNICATION_H */

