/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 61 generated on 2013-06-28 15:11:30.888996
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==61);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#define IKFAST_STRINGIZE2(s) #s
#define IKFAST_STRINGIZE(s) IKFAST_STRINGIZE2(s)

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef std::isnan
#define std::isnan _isnan
#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)0.000001)
#endif

// used to check input to atan2 for degenerate cases
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)2e-6)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2(float fy, float fx) {
    if( std::isnan(fy) ) {
        IKFAST_ASSERT(!std::isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( std::isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( std::isnan(fy) ) {
        IKFAST_ASSERT(!std::isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( std::isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30;
x0=IKcos(j[0]);
x1=IKcos(j[1]);
x2=IKsin(j[2]);
x3=IKcos(j[2]);
x4=IKsin(j[1]);
x5=IKcos(j[3]);
x6=IKsin(j[3]);
x7=IKsin(j[0]);
x8=IKcos(j[4]);
x9=IKsin(j[4]);
x10=((IkReal(0.139000000000000))*(x0));
x11=((IkReal(0.110000000000000))*(x6));
x12=((IkReal(1.00000000000000))*(x5));
x13=((IkReal(0.110000000000000))*(x5));
x14=((IkReal(1.00000000000000))*(x6));
x15=((IkReal(0.147300000000000))*(x0));
x16=((IkReal(1.00000000000000))*(x0));
x17=((IkReal(0.147300000000000))*(x7));
x18=((x3)*(x4));
x19=((x2)*(x4));
x20=((x7)*(x9));
x21=((x1)*(x7));
x22=((x1)*(x3));
x23=((x0)*(x9));
x24=((x1)*(x2));
x25=((((IkReal(-1.00000000000000))*(x22)))+(x19));
x26=((((IkReal(-1.00000000000000))*(x24)))+(((IkReal(-1.00000000000000))*(x18))));
x27=((x0)*(((x18)+(x24))));
x28=((((x18)*(x7)))+(((x2)*(x21))));
x29=((x16)*(((((IkReal(-1.00000000000000))*(x22)))+(x19))));
x30=((((IkReal(-1.00000000000000))*(x21)*(x3)))+(((IkReal(1.00000000000000))*(x19)*(x7))));
IkReal x31=((IkReal(1.00000000000000))*(x19));
eetrans[0]=((((IkReal(0.190000000000000))*(x0)*(x1)))+(((x8)*(((((IkReal(-1.00000000000000))*(x13)*(x27)))+(((IkReal(-1.00000000000000))*(x11)*(x29)))))))+(((IkReal(-1.00000000000000))*(x10)*(x31)))+(((IkReal(-0.110000000000000))*(x20)))+(((x6)*(((((x15)*(x18)))+(((x15)*(x24)))))))+(((x5)*(((((IkReal(-1.00000000000000))*(x15)*(x31)))+(((x15)*(x22)))))))+(((x10)*(x22))));
eetrans[1]=((((IkReal(0.190000000000000))*(x21)))+(((IkReal(0.110000000000000))*(x23)))+(((x5)*(((((IkReal(-1.00000000000000))*(x17)*(x19)))+(((x17)*(x22)))))))+(((IkReal(0.139000000000000))*(x21)*(x3)))+(((x6)*(((((x17)*(x18)))+(((x17)*(x24)))))))+(((IkReal(-0.139000000000000))*(x19)*(x7)))+(((x8)*(((((IkReal(-1.00000000000000))*(x13)*(x28)))+(((IkReal(-1.00000000000000))*(x11)*(x30))))))));
eetrans[2]=((IkReal(0.201500000000000))+(((x6)*(((((IkReal(-0.147300000000000))*(x22)))+(((IkReal(0.147300000000000))*(x19)))))))+(((x5)*(((((IkReal(0.147300000000000))*(x24)))+(((IkReal(0.147300000000000))*(x18)))))))+(((x8)*(((((IkReal(-1.00000000000000))*(x13)*(x25)))+(((IkReal(-1.00000000000000))*(x11)*(x26)))))))+(((IkReal(0.190000000000000))*(x4)))+(((IkReal(0.139000000000000))*(x24)))+(((IkReal(0.139000000000000))*(x18))));
eerot[0]=((((IkReal(-1.00000000000000))*(x20)))+(((x8)*(((((IkReal(-1.00000000000000))*(x12)*(x27)))+(((IkReal(-1.00000000000000))*(x14)*(x29))))))));
eerot[1]=((x23)+(((x8)*(((((IkReal(-1.00000000000000))*(x12)*(x28)))+(((IkReal(-1.00000000000000))*(x14)*(x30))))))));
eerot[2]=((x8)*(((((IkReal(-1.00000000000000))*(x12)*(x25)))+(((IkReal(-1.00000000000000))*(x14)*(x26))))));
}

IKFAST_API int GetNumFreeParameters() { return 0; }
IKFAST_API int* GetFreeParameters() { return NULL; }
IKFAST_API int GetNumJoints() { return 5; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x56000007; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j1,cj1,sj1,htj1,j2,cj2,sj2,htj2,j3,cj3,sj3,htj3,j4,cj4,sj4,htj4,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4;

bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1;
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

r00 = eerot[0];
r01 = eerot[1];
r02 = eerot[2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];
new_r00=r00;
new_px=px;
new_r01=r01;
new_py=py;
new_r02=r02;
new_pz=((IkReal(-0.201500000000000))+(pz));
r00 = new_r00; r01 = new_r01; r02 = new_r02; px = new_px; py = new_py; pz = new_pz;

pp=(((px)*(px))+((py)*(py))+((pz)*(pz)));
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
if( IKabs(((((IkReal(-0.110000000000000))*(r01)))+(py))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(px)))+(((IkReal(0.110000000000000))*(r00))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x32=IKatan2(((((IkReal(-0.110000000000000))*(r01)))+(py)), ((((IkReal(-1.00000000000000))*(px)))+(((IkReal(0.110000000000000))*(r00)))));
j0array[0]=((IkReal(-1.00000000000000))*(x32));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((IkReal(3.14159265358979))+(((IkReal(-1.00000000000000))*(x32))));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break;
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];

{
IkReal dummyeval[1];
dummyeval[0]=((IkReal(1.00000000000000))+(((IkReal(-434.971726837756))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-12.7364114832536))*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(47.8468899521531))*(pp)*(r01)*(sj0)))+(((IkReal(-2.41991818181818))*(cj0)*(r00)))+(((IkReal(165.289256198347))*(px)*(py)*(r00)*(r01)))+(((IkReal(115.785558938669))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(4578.64975618690))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(21.9992561983471))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(4578.64975618690))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(572.331219523363))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(21.9992561983471))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-503.651473180559))*(r02)*((pz)*(pz)*(pz))))+(((IkReal(115.785558938669))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-191.387559808612))*(cj0)*(r00)*((px)*(px))))+(((IkReal(572.331219523363))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-18.1818181818182))*(py)*(r01)))+(((IkReal(-2289.32487809345))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(9157.29951237380))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(-2289.32487809345))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(1739.88690735102))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(4578.64975618690))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-12.7364114832536))*(cj0)*(py)*(r00)*(sj0)))+(((IkReal(2289.32487809345))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(869.943453675511))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(47.8468899521531))*(cj0)*(pp)*(r00)))+(((IkReal(-503.651473180559))*(r00)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-12.7364114832536))*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(-503.651473180559))*(pz)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-12.7364114832536))*(cj0)*(px)*(r01)*(sj0)))+(((IkReal(-1007.30294636112))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-503.651473180559))*(px)*(r00)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-869.943453675511))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(-2289.32487809345))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(572.331219523363))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(-503.651473180559))*(py)*(r01)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-191.387559808612))*(px)*(py)*(r00)*(sj0)))+(((IkReal(4578.64975618690))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(4578.64975618690))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-2289.32487809345))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-503.651473180559))*(pz)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-95.6937799043062))*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(2289.32487809345))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-1007.30294636112))*(cj0)*(py)*(r00)*(sj0)*((px)*(px))))+(((IkReal(38.4125821295300))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-2.41991818181818))*(r01)*(sj0)))+(((IkReal(-57.8927794693345))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(38.9603946796090))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(251.825736590280))*(cj0)*(pp)*(py)*(r00)*(sj0)))+(((IkReal(1739.88690735102))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(4578.64975618690))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-7.40247498912571))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-503.651473180559))*(py)*(r01)*((pz)*(pz))))+(((IkReal(29.4017311874728))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-191.387559808612))*(r01)*(sj0)*((py)*(py))))+(((IkReal(115.785558938669))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-2289.32487809345))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(2.92800200334711))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-95.6937799043062))*(cj0)*(px)*(pz)*(r02)))+(((IkReal(76.8251642590600))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(1.46400100167355))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(24.7518486298391))*(pp)*((r02)*(r02))))+(((IkReal(4578.64975618690))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(869.943453675511))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(251.825736590280))*(pp)*(pz)*(r02)))+(((IkReal(-95.6937799043062))*(py)*(pz)*(r02)*(sj0)))+(((IkReal(434.971726837756))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(115.785558938669))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(251.825736590280))*(cj0)*(pp)*(px)*(r01)*(sj0)))+(((IkReal(82.6446280991736))*((px)*(px))*((r00)*(r00))))+(((IkReal(-434.971726837756))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(869.943453675511))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-2289.32487809345))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(869.943453675511))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(21.9992561983471))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(869.943453675511))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(869.943453675511))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(-2289.32487809345))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(9157.29951237380))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(10.5263157894737))*(py)*(sj0)))+(((IkReal(869.943453675511))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(115.785558938669))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(38.4125821295300))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(4578.64975618690))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-1007.30294636112))*(cj0)*(px)*(r01)*(sj0)*((py)*(py))))+(((IkReal(38.9603946796090))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(33.1409308394954))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(4578.64975618690))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(2289.32487809345))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(38.4125821295300))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-869.943453675511))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-191.387559808612))*(cj0)*(px)*(py)*(r01)))+(((IkReal(115.785558938669))*(py)*(pz)*(r01)*(r02)))+(((IkReal(-2289.32487809345))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(251.825736590280))*(pp)*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-2289.32487809345))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(869.943453675511))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(82.6446280991736))*((py)*(py))*((r01)*(r01))))+(((IkReal(2289.32487809345))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(869.943453675511))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-95.6937799043062))*(cj0)*(r00)*((pz)*(pz))))+(((IkReal(9157.29951237380))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(4578.64975618690))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(27.7008310249307))*((pz)*(pz))))+(((IkReal(251.825736590280))*(pp)*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(1.46400100167355))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(38.9603946796090))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(869.943453675511))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(115.785558938669))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(115.785558938669))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-434.971726837756))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-115.785558938669))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(-503.651473180559))*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-503.651473180559))*(px)*(r00)*((pz)*(pz))))+(((IkReal(-2289.32487809345))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(27.7008310249307))*((cj0)*(cj0))*((px)*(px))))+(((IkReal(76.8251642590600))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(2289.32487809345))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-434.971726837756))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-57.8927794693345))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-12.7364114832536))*(pz)*(r02)))+(((IkReal(1144.66243904673))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(2289.32487809345))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-1.32916346113636))*((r02)*(r02))))+(((IkReal(-2289.32487809345))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(38.4125821295300))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(2289.32487809345))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(4578.64975618690))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(2289.32487809345))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(115.785558938669))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(869.943453675511))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-2289.32487809345))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(55.4016620498615))*(cj0)*(px)*(py)*(sj0)))+(((IkReal(-2289.32487809345))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(29.4017311874728))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(869.943453675511))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(-2289.32487809345))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(38.9603946796090))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-2289.32487809345))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(869.943453675511))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(434.971726837756))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(21.9992561983471))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(-7.40247498912571))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(115.785558938669))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(27.7008310249307))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(10.5263157894737))*(cj0)*(px)))+(((IkReal(869.943453675511))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(4578.64975618690))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(2289.32487809345))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-18.1818181818182))*(px)*(r00))));
if( IKabs(dummyeval[0]) < 0.0000001000000000  )
{
continue;

} else
{
IkReal op[4+1], zeror[4];
int numroots;
IkReal j1evalpoly[2];
op[0]=((IkReal(0.00698896000000000))+(((IkReal(1.76000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(32.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-3.52000000000000))*(pz)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.205487523200000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.334400000000000))*(pp)*(r01)*(sj0)))+(((IkReal(0.577600000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-3.04000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(32.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.268464000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(0.0102318444406564))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.809220640000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(0.334400000000000))*(cj0)*(pp)*(r00)))+(((IkReal(-0.0169127113760000))*(r01)*(sj0)))+(((IkReal(1.76000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)))+(((IkReal(0.0735680000000000))*(py)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-6.08000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(16.0000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(12.1600000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(4.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.0517356016000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(0.153751921600000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(-0.0890142704000000))*(pz)*(r02)))+(((IkReal(16.0000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(4.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-3.04000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-16.0000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(1.15520000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(32.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(6.08000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-0.668800000000000))*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-0.0517356016000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-1.33760000000000))*(cj0)*(r00)*((px)*(px))))+(((IkReal(-3.04000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-3.52000000000000))*(py)*(r01)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.0204636888813128))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(6.08000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.268464000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(64.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(32.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-0.668800000000000))*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.577600000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(0.536928000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.00928947026334360))*((r02)*(r02))))+(((IkReal(16.0000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-3.52000000000000))*(pz)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(64.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(0.172989680000000))*(pp)*((r02)*(r02))))+(((IkReal(0.536928000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-7.04000000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(0.272292640000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(6.08000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(0.809220640000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(6.08000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(32.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(1.76000000000000))*(pp)*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(6.08000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(8.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(6.08000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-7.04000000000000))*(cj0)*(px)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.0169127113760000))*(cj0)*(r00)))+(((IkReal(-16.0000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.809220640000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.268464000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(6.08000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(32.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-0.404610320000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.272292640000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-7.04000000000000))*(cj0)*(py)*(r00)*(sj0)*((px)*(px))))+(((IkReal(0.205487523200000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-3.04000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-0.127072000000000))*(px)*(r00)))+(((IkReal(-0.668800000000000))*(cj0)*(px)*(pz)*(r02)))+(((IkReal(64.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-3.52000000000000))*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.153751921600000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(0.231620640000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.404610320000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(32.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(0.272292640000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(12.1600000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.809220640000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(6.08000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(0.809220640000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(6.08000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(32.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-3.52000000000000))*(py)*(r01)*((pz)*(pz))))+(((IkReal(-1.33760000000000))*(px)*(py)*(r00)*(sj0)))+(((IkReal(0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(1.76000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)))+(((IkReal(-1.33760000000000))*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.272292640000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.193600000000000))*((cj0)*(cj0))*((px)*(px))))+(((IkReal(16.0000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.809220640000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(16.0000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(3.04000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-3.52000000000000))*(px)*(r00)*((pz)*(pz))))+(((IkReal(3.04000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.809220640000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.0890142704000000))*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-0.0890142704000000))*(cj0)*(py)*(r00)*(sj0)))+(((IkReal(6.08000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(1.76000000000000))*(pp)*(pz)*(r02)))+(((IkReal(0.193600000000000))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.387200000000000))*(cj0)*(px)*(py)*(sj0)))+(((IkReal(0.268464000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.193600000000000))*((pz)*(pz))))+(((IkReal(0.0102318444406564))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-3.52000000000000))*(r00)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(32.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-3.52000000000000))*(px)*(r00)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.0890142704000000))*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(0.0735680000000000))*(cj0)*(px)))+(((IkReal(6.08000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-3.52000000000000))*(r02)*((pz)*(pz)*(pz))))+(((IkReal(0.153751921600000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(16.0000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(32.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.668800000000000))*(cj0)*(r00)*((pz)*(pz))))+(((IkReal(4.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(0.153751921600000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-0.127072000000000))*(py)*(r01)))+(((IkReal(6.08000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-1.33760000000000))*(cj0)*(px)*(py)*(r01)))+(((IkReal(0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-0.0890142704000000))*(cj0)*(px)*(r01)*(sj0))));
op[1]=((((IkReal(-2.31040000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-0.668800000000000))*(pp)*(r02)))+(((IkReal(-2.31040000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-12.1600000000000))*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(12.1600000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(12.1600000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.103471203200000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(6.08000000000000))*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-1.33760000000000))*(cj0)*(py)*(pz)*(r00)*(sj0)))+(((IkReal(2.67520000000000))*(px)*(pz)*(r00)))+(((IkReal(12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.103471203200000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.206942406400000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.0338254227520000))*(r02)))+(((IkReal(12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-1.33760000000000))*(cj0)*(px)*(pz)*(r01)*(sj0)))+(((IkReal(-1.33760000000000))*(px)*(pz)*(r00)*((cj0)*(cj0))))+(((IkReal(-12.1600000000000))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(2.67520000000000))*(r02)*((pz)*(pz))))+(((IkReal(-24.3200000000000))*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-24.3200000000000))*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-12.1600000000000))*(cj0)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(1.33760000000000))*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.254144000000000))*(cj0)*(pz)*(r00)))+(((IkReal(6.08000000000000))*(pp)*(py)*(r01)*(r02)))+(((IkReal(-0.103471203200000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-2.31040000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-0.103471203200000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-24.3200000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(1.33760000000000))*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(2.67520000000000))*(cj0)*(px)*(py)*(r02)*(sj0)))+(((IkReal(2.67520000000000))*(py)*(pz)*(r01)))+(((IkReal(12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-2.31040000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(6.08000000000000))*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(pp)*(pz)*((r02)*(r02))))+(((IkReal(-0.147136000000000))*(pz)))+(((IkReal(-2.31040000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-2.31040000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(6.08000000000000))*(pp)*(px)*(r00)*(r02)))+(((IkReal(12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.33760000000000))*(py)*(pz)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.307503843200000))*(px)*(r00)*(r02)))+(((IkReal(-0.0780852588160000))*(cj0)*(r00)*(r02)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-12.1600000000000))*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(-2.31040000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-12.1600000000000))*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-2.31040000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(2.31040000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(12.1600000000000))*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(0.254144000000000))*(py)*(r02)*(sj0)))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(-24.3200000000000))*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(-2.31040000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-24.3200000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-24.3200000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-12.1600000000000))*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-2.31040000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-0.307503843200000))*(pz)*((r02)*(r02))))+(((IkReal(-2.31040000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(12.1600000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(2.31040000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(-2.31040000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(0.254144000000000))*(pz)*(r01)*(sj0)))+(((IkReal(-12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(0.254144000000000))*(cj0)*(px)*(r02)))+(((IkReal(-0.307503843200000))*(py)*(r01)*(r02)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.103471203200000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.0780852588160000))*(r01)*(r02)*(sj0)))+(((IkReal(-12.1600000000000))*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.103471203200000))*(px)*(r00)*(r02)*((cj0)*(cj0)))));
op[2]=((IkReal(0.0139779200000000))+(((IkReal(32.0000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(64.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(6.23924128000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(32.0000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-7.04000000000000))*(py)*(r01)*((pz)*(pz))))+(((IkReal(-14.0800000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-4.07621472000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-32.0000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(3.52000000000000))*(pp)*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.0595063182893128))*((r02)*(r02))))+(((IkReal(-32.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(1.07385600000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(0.536928000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-32.0000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-4.07621472000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(3.52000000000000))*(pp)*(pz)*(r02)))+(((IkReal(-3.00235872000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.254144000000000))*(py)*(r01)))+(((IkReal(-32.0000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(3.52000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-7.04000000000000))*(pz)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.536928000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-32.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(128.000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-0.0576215699346872))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-4.07621472000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-14.0800000000000))*(cj0)*(px)*(r01)*(sj0)*((py)*(py))))+(((IkReal(64.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(1.15520000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-3.00235872000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(3.52000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)))+(((IkReal(64.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-3.00235872000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(32.0000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.254144000000000))*(px)*(r00)))+(((IkReal(2.31040000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(32.0000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(0.387200000000000))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(3.52000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)))+(((IkReal(-3.00235872000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-7.04000000000000))*(px)*(r00)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(1.15520000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(5.08404128000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(128.000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(64.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(0.330259459200000))*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-7.04000000000000))*(pz)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.115243139869374))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-7.04000000000000))*(py)*(r01)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-3.00235872000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(64.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.330259459200000))*(cj0)*(px)*(r01)*(sj0)))+(((IkReal(6.23924128000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(0.536928000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-0.686316540800000))*(pz)*(r02)))+(((IkReal(-14.0800000000000))*(cj0)*(py)*(r00)*(sj0)*((px)*(px))))+(((IkReal(-32.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(32.0000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-32.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.387200000000000))*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-3.00235872000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(64.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-4.07621472000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.387200000000000))*((pz)*(pz))))+(((IkReal(1.50117936000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(64.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-3.00235872000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.536928000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(1.50117936000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.330259459200000))*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(64.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.0576215699346872))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(128.000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-1.96442064000000))*(pp)*((r02)*(r02))))+(((IkReal(32.0000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(3.00235872000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(64.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(64.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-7.04000000000000))*(r00)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-32.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.330259459200000))*(cj0)*(py)*(r00)*(sj0)))+(((IkReal(64.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(64.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(1.07385600000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-7.04000000000000))*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-3.00235872000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-7.04000000000000))*(r02)*((pz)*(pz)*(pz))))+(((IkReal(0.774400000000000))*(cj0)*(px)*(py)*(sj0)))+(((IkReal(-7.04000000000000))*(px)*(r00)*((pz)*(pz)))));
op[3]=((((IkReal(-0.668800000000000))*(pp)*(r02)))+(((IkReal(-0.254144000000000))*(pz)*(r01)*(sj0)))+(((IkReal(2.31040000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(2.31040000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-12.1600000000000))*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(12.1600000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(12.1600000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.103471203200000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(6.08000000000000))*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.254144000000000))*(cj0)*(px)*(r02)))+(((IkReal(12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-1.33760000000000))*(cj0)*(py)*(pz)*(r00)*(sj0)))+(((IkReal(2.67520000000000))*(px)*(pz)*(r00)))+(((IkReal(12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.103471203200000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.206942406400000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(2.31040000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(2.31040000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(2.31040000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(0.0338254227520000))*(r02)))+(((IkReal(12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-1.33760000000000))*(cj0)*(px)*(pz)*(r01)*(sj0)))+(((IkReal(-1.33760000000000))*(px)*(pz)*(r00)*((cj0)*(cj0))))+(((IkReal(-12.1600000000000))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(2.67520000000000))*(r02)*((pz)*(pz))))+(((IkReal(-24.3200000000000))*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-24.3200000000000))*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-0.254144000000000))*(py)*(r02)*(sj0)))+(((IkReal(-12.1600000000000))*(cj0)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(1.33760000000000))*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(pp)*(py)*(r01)*(r02)))+(((IkReal(-0.103471203200000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-0.103471203200000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-24.3200000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(1.33760000000000))*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(2.67520000000000))*(cj0)*(px)*(py)*(r02)*(sj0)))+(((IkReal(2.67520000000000))*(py)*(pz)*(r01)))+(((IkReal(12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(2.31040000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(6.08000000000000))*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(pp)*(pz)*((r02)*(r02))))+(((IkReal(-0.147136000000000))*(pz)))+(((IkReal(6.08000000000000))*(pp)*(px)*(r00)*(r02)))+(((IkReal(12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.33760000000000))*(py)*(pz)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.307503843200000))*(px)*(r00)*(r02)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-12.1600000000000))*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(-12.1600000000000))*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(2.31040000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(12.1600000000000))*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(-2.31040000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(2.31040000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(2.31040000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(-24.3200000000000))*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(-24.3200000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-24.3200000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-12.1600000000000))*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-0.307503843200000))*(pz)*((r02)*(r02))))+(((IkReal(12.1600000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(0.0780852588160000))*(r01)*(r02)*(sj0)))+(((IkReal(-12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(2.31040000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.307503843200000))*(py)*(r01)*(r02)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.103471203200000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-12.1600000000000))*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(2.31040000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-2.31040000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(-12.1600000000000))*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.254144000000000))*(cj0)*(pz)*(r00)))+(((IkReal(0.0780852588160000))*(cj0)*(r00)*(r02)))+(((IkReal(-0.103471203200000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(2.31040000000000))*(px)*(py)*(r00)*(r02)*(sj0))));
op[4]=((IkReal(0.00698896000000000))+(((IkReal(1.76000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(32.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.153751921600000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(-3.52000000000000))*(pz)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.0735680000000000))*(cj0)*(px)))+(((IkReal(-3.04000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(0.577600000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(32.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.268464000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.334400000000000))*(pp)*(r01)*(sj0)))+(((IkReal(0.0102318444406564))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.0735680000000000))*(py)*(sj0)))+(((IkReal(0.809220640000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(1.76000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(16.0000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-6.08000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(4.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.0890142704000000))*(pz)*(r02)))+(((IkReal(16.0000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(4.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-6.08000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-12.1600000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.205487523200000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-16.0000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.668800000000000))*(cj0)*(px)*(pz)*(r02)))+(((IkReal(0.668800000000000))*(cj0)*(r00)*((pz)*(pz))))+(((IkReal(1.15520000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(32.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-3.52000000000000))*(py)*(r01)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.0204636888813128))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(0.0517356016000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(0.268464000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(64.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(32.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(0.577600000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(-6.08000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.536928000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.00928947026334360))*((r02)*(r02))))+(((IkReal(16.0000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-3.52000000000000))*(pz)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(64.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(0.172989680000000))*(pp)*((r02)*(r02))))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(0.536928000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-7.04000000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-0.153751921600000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(0.272292640000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.809220640000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(32.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-6.08000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(1.76000000000000))*(pp)*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(8.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(-7.04000000000000))*(cj0)*(px)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-6.08000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.809220640000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.268464000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(32.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-0.404610320000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.272292640000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-7.04000000000000))*(cj0)*(py)*(r00)*(sj0)*((px)*(px))))+(((IkReal(-0.127072000000000))*(px)*(r00)))+(((IkReal(64.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-3.52000000000000))*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.231620640000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-6.08000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(-0.334400000000000))*(cj0)*(pp)*(r00)))+(((IkReal(-0.404610320000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(3.04000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(32.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-6.08000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.272292640000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.0169127113760000))*(cj0)*(r00)))+(((IkReal(0.809220640000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(0.668800000000000))*(py)*(pz)*(r02)*(sj0)))+(((IkReal(0.809220640000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(3.04000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(1.33760000000000))*(px)*(py)*(r00)*(sj0)))+(((IkReal(32.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(3.04000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-3.52000000000000))*(py)*(r01)*((pz)*(pz))))+(((IkReal(1.33760000000000))*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.0517356016000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(-6.08000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(1.76000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)))+(((IkReal(-6.08000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.205487523200000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-0.153751921600000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.272292640000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.193600000000000))*((cj0)*(cj0))*((px)*(px))))+(((IkReal(16.0000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(32.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-6.08000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.809220640000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(16.0000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-3.52000000000000))*(px)*(r00)*((pz)*(pz))))+(((IkReal(0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.809220640000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.0890142704000000))*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-0.0890142704000000))*(cj0)*(py)*(r00)*(sj0)))+(((IkReal(-12.1600000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(1.76000000000000))*(pp)*(pz)*(r02)))+(((IkReal(3.04000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(0.193600000000000))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.387200000000000))*(cj0)*(px)*(py)*(sj0)))+(((IkReal(1.33760000000000))*(cj0)*(r00)*((px)*(px))))+(((IkReal(1.33760000000000))*(cj0)*(px)*(py)*(r01)))+(((IkReal(0.268464000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.193600000000000))*((pz)*(pz))))+(((IkReal(0.0102318444406564))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-3.52000000000000))*(r00)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-6.08000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(32.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-3.52000000000000))*(px)*(r00)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.0890142704000000))*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(0.668800000000000))*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.0169127113760000))*(r01)*(sj0)))+(((IkReal(-3.52000000000000))*(r02)*((pz)*(pz)*(pz))))+(((IkReal(16.0000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-3.04000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(32.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(4.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(6.08000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-6.08000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.127072000000000))*(py)*(r01)))+(((IkReal(-0.153751921600000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-0.0890142704000000))*(cj0)*(px)*(r01)*(sj0))));
polyroots4(op,zeror,numroots);
IkReal j1array[4], cj1array[4], sj1array[4], tempj1array[1];
int numsolutions = 0;
for(int ij1 = 0; ij1 < numroots; ++ij1)
{
IkReal htj1 = zeror[ij1];
tempj1array[0]=((IkReal(2.00000000000000))*(atan(htj1)));
for(int kj1 = 0; kj1 < 1; ++kj1)
{
j1array[numsolutions] = tempj1array[kj1];
if( j1array[numsolutions] > IKPI )
{
    j1array[numsolutions]-=IK2PI;
}
else if( j1array[numsolutions] < -IKPI )
{
    j1array[numsolutions]+=IK2PI;
}
sj1array[numsolutions] = IKsin(j1array[numsolutions]);
cj1array[numsolutions] = IKcos(j1array[numsolutions]);
numsolutions++;
}
}
bool j1valid[4]={true,true,true,true};
_nj1 = 4;
for(int ij1 = 0; ij1 < numsolutions; ++ij1)
    {
if( !j1valid[ij1] )
{
    continue;
}
    j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
htj1 = IKtan(j1/2);

j1evalpoly[0]=((IkReal(0.00698896000000000))+(((IkReal(1.76000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(32.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.153751921600000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(-3.52000000000000))*(pz)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.0735680000000000))*(cj0)*(px)))+(((IkReal(-3.04000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(0.577600000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(32.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.268464000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.334400000000000))*(pp)*(r01)*(sj0)))+(((IkReal(0.0102318444406564))*((r01)*(r01))*((sj0)*(sj0))))+((((htj1)*(htj1)*(htj1))*(((((IkReal(-2.31040000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-0.668800000000000))*(pp)*(r02)))+(((IkReal(-2.31040000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-12.1600000000000))*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(12.1600000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(12.1600000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.103471203200000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(6.08000000000000))*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-1.33760000000000))*(cj0)*(py)*(pz)*(r00)*(sj0)))+(((IkReal(2.67520000000000))*(px)*(pz)*(r00)))+(((IkReal(12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.103471203200000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.206942406400000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.0338254227520000))*(r02)))+(((IkReal(12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-1.33760000000000))*(cj0)*(px)*(pz)*(r01)*(sj0)))+(((IkReal(-1.33760000000000))*(px)*(pz)*(r00)*((cj0)*(cj0))))+(((IkReal(-12.1600000000000))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(2.67520000000000))*(r02)*((pz)*(pz))))+(((IkReal(-24.3200000000000))*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-24.3200000000000))*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-12.1600000000000))*(cj0)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(1.33760000000000))*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.254144000000000))*(cj0)*(pz)*(r00)))+(((IkReal(6.08000000000000))*(pp)*(py)*(r01)*(r02)))+(((IkReal(-0.103471203200000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-2.31040000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-0.103471203200000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-24.3200000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(1.33760000000000))*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(2.67520000000000))*(cj0)*(px)*(py)*(r02)*(sj0)))+(((IkReal(2.67520000000000))*(py)*(pz)*(r01)))+(((IkReal(12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-2.31040000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(6.08000000000000))*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(pp)*(pz)*((r02)*(r02))))+(((IkReal(-0.147136000000000))*(pz)))+(((IkReal(-2.31040000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-2.31040000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(6.08000000000000))*(pp)*(px)*(r00)*(r02)))+(((IkReal(12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.33760000000000))*(py)*(pz)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.307503843200000))*(px)*(r00)*(r02)))+(((IkReal(-0.0780852588160000))*(cj0)*(r00)*(r02)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-12.1600000000000))*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(-2.31040000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-12.1600000000000))*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-2.31040000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(2.31040000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(12.1600000000000))*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(0.254144000000000))*(py)*(r02)*(sj0)))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(-24.3200000000000))*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(-2.31040000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-24.3200000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-24.3200000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-12.1600000000000))*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-2.31040000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-0.307503843200000))*(pz)*((r02)*(r02))))+(((IkReal(-2.31040000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(12.1600000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(2.31040000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(-2.31040000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(0.254144000000000))*(pz)*(r01)*(sj0)))+(((IkReal(-12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(0.254144000000000))*(cj0)*(px)*(r02)))+(((IkReal(-0.307503843200000))*(py)*(r01)*(r02)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.103471203200000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.0780852588160000))*(r01)*(r02)*(sj0)))+(((IkReal(-12.1600000000000))*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.103471203200000))*(px)*(r00)*(r02)*((cj0)*(cj0))))))))+(((IkReal(-0.0735680000000000))*(py)*(sj0)))+(((IkReal(0.809220640000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(1.76000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(16.0000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-6.08000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(4.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.0890142704000000))*(pz)*(r02)))+(((IkReal(16.0000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(4.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-6.08000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-12.1600000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.205487523200000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-16.0000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.668800000000000))*(cj0)*(px)*(pz)*(r02)))+(((IkReal(0.668800000000000))*(cj0)*(r00)*((pz)*(pz))))+(((IkReal(1.15520000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(32.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+((((htj1)*(htj1)*(htj1)*(htj1))*(((IkReal(0.00698896000000000))+(((IkReal(1.76000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(32.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-3.52000000000000))*(pz)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.205487523200000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.334400000000000))*(pp)*(r01)*(sj0)))+(((IkReal(0.577600000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-3.04000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(32.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.268464000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(0.0102318444406564))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.809220640000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(0.334400000000000))*(cj0)*(pp)*(r00)))+(((IkReal(-0.0169127113760000))*(r01)*(sj0)))+(((IkReal(1.76000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)))+(((IkReal(0.0735680000000000))*(py)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-6.08000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(16.0000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(12.1600000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(4.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.0517356016000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(0.153751921600000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(-0.0890142704000000))*(pz)*(r02)))+(((IkReal(16.0000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(4.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-3.04000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-16.0000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(1.15520000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(32.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(6.08000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-0.668800000000000))*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-0.0517356016000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-1.33760000000000))*(cj0)*(r00)*((px)*(px))))+(((IkReal(-3.04000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-3.52000000000000))*(py)*(r01)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.0204636888813128))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(6.08000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.268464000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(64.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(32.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-0.668800000000000))*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.577600000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(0.536928000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.00928947026334360))*((r02)*(r02))))+(((IkReal(16.0000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-3.52000000000000))*(pz)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(64.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(0.172989680000000))*(pp)*((r02)*(r02))))+(((IkReal(0.536928000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-7.04000000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(0.272292640000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(6.08000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(0.809220640000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(6.08000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(32.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(1.76000000000000))*(pp)*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(6.08000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(8.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(6.08000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-7.04000000000000))*(cj0)*(px)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.0169127113760000))*(cj0)*(r00)))+(((IkReal(-16.0000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.809220640000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.268464000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(6.08000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(32.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-0.404610320000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.272292640000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-7.04000000000000))*(cj0)*(py)*(r00)*(sj0)*((px)*(px))))+(((IkReal(0.205487523200000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-3.04000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-0.127072000000000))*(px)*(r00)))+(((IkReal(-0.668800000000000))*(cj0)*(px)*(pz)*(r02)))+(((IkReal(64.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-3.52000000000000))*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.153751921600000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(0.231620640000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.404610320000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(32.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(0.272292640000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(12.1600000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.809220640000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(6.08000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(0.809220640000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(6.08000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(32.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-3.52000000000000))*(py)*(r01)*((pz)*(pz))))+(((IkReal(-1.33760000000000))*(px)*(py)*(r00)*(sj0)))+(((IkReal(0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(1.76000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)))+(((IkReal(-1.33760000000000))*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.272292640000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.193600000000000))*((cj0)*(cj0))*((px)*(px))))+(((IkReal(16.0000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.809220640000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(16.0000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(3.04000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-3.52000000000000))*(px)*(r00)*((pz)*(pz))))+(((IkReal(3.04000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.809220640000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.0890142704000000))*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-0.0890142704000000))*(cj0)*(py)*(r00)*(sj0)))+(((IkReal(6.08000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(1.76000000000000))*(pp)*(pz)*(r02)))+(((IkReal(0.193600000000000))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.387200000000000))*(cj0)*(px)*(py)*(sj0)))+(((IkReal(0.268464000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.193600000000000))*((pz)*(pz))))+(((IkReal(0.0102318444406564))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-3.52000000000000))*(r00)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(32.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-3.52000000000000))*(px)*(r00)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.0890142704000000))*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(0.0735680000000000))*(cj0)*(px)))+(((IkReal(6.08000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-3.52000000000000))*(r02)*((pz)*(pz)*(pz))))+(((IkReal(0.153751921600000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(16.0000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(32.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.668800000000000))*(cj0)*(r00)*((pz)*(pz))))+(((IkReal(4.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(0.153751921600000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-0.127072000000000))*(py)*(r01)))+(((IkReal(6.08000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-1.33760000000000))*(cj0)*(px)*(py)*(r01)))+(((IkReal(0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-0.0890142704000000))*(cj0)*(px)*(r01)*(sj0)))))))+(((IkReal(-3.52000000000000))*(py)*(r01)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.0204636888813128))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((htj1)*(((((IkReal(-0.668800000000000))*(pp)*(r02)))+(((IkReal(-0.254144000000000))*(pz)*(r01)*(sj0)))+(((IkReal(2.31040000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(2.31040000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-12.1600000000000))*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(12.1600000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(12.1600000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.103471203200000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(6.08000000000000))*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.254144000000000))*(cj0)*(px)*(r02)))+(((IkReal(12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-1.33760000000000))*(cj0)*(py)*(pz)*(r00)*(sj0)))+(((IkReal(2.67520000000000))*(px)*(pz)*(r00)))+(((IkReal(12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.103471203200000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.206942406400000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(2.31040000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(2.31040000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(2.31040000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(0.0338254227520000))*(r02)))+(((IkReal(12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-1.33760000000000))*(cj0)*(px)*(pz)*(r01)*(sj0)))+(((IkReal(-1.33760000000000))*(px)*(pz)*(r00)*((cj0)*(cj0))))+(((IkReal(-12.1600000000000))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(2.67520000000000))*(r02)*((pz)*(pz))))+(((IkReal(-24.3200000000000))*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-24.3200000000000))*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-0.254144000000000))*(py)*(r02)*(sj0)))+(((IkReal(-12.1600000000000))*(cj0)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(1.33760000000000))*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(pp)*(py)*(r01)*(r02)))+(((IkReal(-0.103471203200000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-0.103471203200000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-24.3200000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(1.33760000000000))*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(2.67520000000000))*(cj0)*(px)*(py)*(r02)*(sj0)))+(((IkReal(2.67520000000000))*(py)*(pz)*(r01)))+(((IkReal(12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(2.31040000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(6.08000000000000))*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(pp)*(pz)*((r02)*(r02))))+(((IkReal(-0.147136000000000))*(pz)))+(((IkReal(6.08000000000000))*(pp)*(px)*(r00)*(r02)))+(((IkReal(12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.33760000000000))*(py)*(pz)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.307503843200000))*(px)*(r00)*(r02)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-12.1600000000000))*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(-12.1600000000000))*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(2.31040000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(12.1600000000000))*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(-2.31040000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(2.31040000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(2.31040000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(-24.3200000000000))*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(-24.3200000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-24.3200000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-12.1600000000000))*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-0.307503843200000))*(pz)*((r02)*(r02))))+(((IkReal(12.1600000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(0.0780852588160000))*(r01)*(r02)*(sj0)))+(((IkReal(-12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(2.31040000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.307503843200000))*(py)*(r01)*(r02)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.103471203200000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-12.1600000000000))*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(2.31040000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-2.31040000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(-12.1600000000000))*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.254144000000000))*(cj0)*(pz)*(r00)))+(((IkReal(0.0780852588160000))*(cj0)*(r00)*(r02)))+(((IkReal(-0.103471203200000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(2.31040000000000))*(px)*(py)*(r00)*(r02)*(sj0)))))))+(((IkReal(0.0517356016000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(0.268464000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(64.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(32.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(0.577600000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(-6.08000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.536928000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.00928947026334360))*((r02)*(r02))))+((((htj1)*(htj1))*(((IkReal(0.0139779200000000))+(((IkReal(32.0000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(64.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(6.23924128000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(32.0000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-7.04000000000000))*(py)*(r01)*((pz)*(pz))))+(((IkReal(-14.0800000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-4.07621472000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-32.0000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(3.52000000000000))*(pp)*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.0595063182893128))*((r02)*(r02))))+(((IkReal(-32.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(1.07385600000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(0.536928000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-32.0000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-4.07621472000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(3.52000000000000))*(pp)*(pz)*(r02)))+(((IkReal(-3.00235872000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.254144000000000))*(py)*(r01)))+(((IkReal(-32.0000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(3.52000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-7.04000000000000))*(pz)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.536928000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-32.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(128.000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-0.0576215699346872))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-4.07621472000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-14.0800000000000))*(cj0)*(px)*(r01)*(sj0)*((py)*(py))))+(((IkReal(64.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(1.15520000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-3.00235872000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(3.52000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)))+(((IkReal(64.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-3.00235872000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(32.0000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.254144000000000))*(px)*(r00)))+(((IkReal(2.31040000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(32.0000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(0.387200000000000))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(3.52000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)))+(((IkReal(-3.00235872000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-7.04000000000000))*(px)*(r00)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(1.15520000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(5.08404128000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(128.000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(64.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(0.330259459200000))*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-7.04000000000000))*(pz)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.115243139869374))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-7.04000000000000))*(py)*(r01)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-3.00235872000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(64.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.330259459200000))*(cj0)*(px)*(r01)*(sj0)))+(((IkReal(6.23924128000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(0.536928000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-0.686316540800000))*(pz)*(r02)))+(((IkReal(-14.0800000000000))*(cj0)*(py)*(r00)*(sj0)*((px)*(px))))+(((IkReal(-32.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(32.0000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-32.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.387200000000000))*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-3.00235872000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(64.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-4.07621472000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.387200000000000))*((pz)*(pz))))+(((IkReal(1.50117936000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(64.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-3.00235872000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.536928000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(1.50117936000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.330259459200000))*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(64.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.0576215699346872))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(128.000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-1.96442064000000))*(pp)*((r02)*(r02))))+(((IkReal(32.0000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(3.00235872000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(64.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(64.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-7.04000000000000))*(r00)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-32.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.330259459200000))*(cj0)*(py)*(r00)*(sj0)))+(((IkReal(64.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(64.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-32.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(1.07385600000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-7.04000000000000))*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-3.00235872000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-7.04000000000000))*(r02)*((pz)*(pz)*(pz))))+(((IkReal(0.774400000000000))*(cj0)*(px)*(py)*(sj0)))+(((IkReal(-7.04000000000000))*(px)*(r00)*((pz)*(pz))))))))+(((IkReal(16.0000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-3.52000000000000))*(pz)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(64.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(0.172989680000000))*(pp)*((r02)*(r02))))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(0.536928000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-7.04000000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-0.153751921600000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(0.272292640000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.809220640000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(32.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-6.08000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(1.76000000000000))*(pp)*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(8.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(-7.04000000000000))*(cj0)*(px)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-6.08000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.809220640000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.268464000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(32.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-0.404610320000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.272292640000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-7.04000000000000))*(cj0)*(py)*(r00)*(sj0)*((px)*(px))))+(((IkReal(-0.127072000000000))*(px)*(r00)))+(((IkReal(64.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-3.52000000000000))*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.231620640000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-6.08000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(-0.334400000000000))*(cj0)*(pp)*(r00)))+(((IkReal(-0.404610320000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(3.04000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(32.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-6.08000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.272292640000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.0169127113760000))*(cj0)*(r00)))+(((IkReal(0.809220640000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(0.668800000000000))*(py)*(pz)*(r02)*(sj0)))+(((IkReal(0.809220640000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(3.04000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(1.33760000000000))*(px)*(py)*(r00)*(sj0)))+(((IkReal(32.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(3.04000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-3.52000000000000))*(py)*(r01)*((pz)*(pz))))+(((IkReal(1.33760000000000))*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.0517356016000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(-6.08000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(1.76000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)))+(((IkReal(-6.08000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.205487523200000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-0.153751921600000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.272292640000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.193600000000000))*((cj0)*(cj0))*((px)*(px))))+(((IkReal(16.0000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(32.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-6.08000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.809220640000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(16.0000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-3.52000000000000))*(px)*(r00)*((pz)*(pz))))+(((IkReal(0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.809220640000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.0890142704000000))*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-0.0890142704000000))*(cj0)*(py)*(r00)*(sj0)))+(((IkReal(-12.1600000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(1.76000000000000))*(pp)*(pz)*(r02)))+(((IkReal(3.04000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(0.193600000000000))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.387200000000000))*(cj0)*(px)*(py)*(sj0)))+(((IkReal(1.33760000000000))*(cj0)*(r00)*((px)*(px))))+(((IkReal(1.33760000000000))*(cj0)*(px)*(py)*(r01)))+(((IkReal(0.268464000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.193600000000000))*((pz)*(pz))))+(((IkReal(0.0102318444406564))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-3.52000000000000))*(r00)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-6.08000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(32.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-3.52000000000000))*(px)*(r00)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.0890142704000000))*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(0.668800000000000))*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.0169127113760000))*(r01)*(sj0)))+(((IkReal(-3.52000000000000))*(r02)*((pz)*(pz)*(pz))))+(((IkReal(16.0000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-3.04000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(32.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(4.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(6.08000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-6.08000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.127072000000000))*(py)*(r01)))+(((IkReal(-0.153751921600000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-0.0890142704000000))*(cj0)*(px)*(r01)*(sj0))));
j1evalpoly[1]=((IkReal(-0.00698896000000000))+(((IkReal(0.404610320000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.0890142704000000))*(pz)*(r02)))+(((IkReal(-0.809220640000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(-32.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.268464000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+((((htj1)*(htj1))*(((IkReal(-0.0139779200000000))+(((IkReal(-64.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-3.52000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)))+(((IkReal(-32.0000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.536928000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.330259459200000))*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(7.04000000000000))*(py)*(r01)*((pz)*(pz))))+(((IkReal(-0.330259459200000))*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(7.04000000000000))*(pz)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-64.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(3.00235872000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(3.00235872000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-2.31040000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(3.00235872000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-6.23924128000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(7.04000000000000))*(py)*(r01)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(7.04000000000000))*(px)*(r00)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-32.0000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(3.00235872000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-64.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(32.0000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(14.0800000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(0.115243139869374))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(14.0800000000000))*(cj0)*(py)*(r00)*(sj0)*((px)*(px))))+(((IkReal(-1.15520000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.387200000000000))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(4.07621472000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-0.0595063182893128))*((r02)*(r02))))+(((IkReal(3.00235872000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(3.00235872000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-1.15520000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(3.00235872000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.686316540800000))*(pz)*(r02)))+(((IkReal(-1.50117936000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-64.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-64.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-3.52000000000000))*(pp)*(pz)*(r02)))+(((IkReal(-128.000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-3.52000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)))+(((IkReal(-128.000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(4.07621472000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-64.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-5.08404128000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(32.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-0.330259459200000))*(cj0)*(py)*(r00)*(sj0)))+(((IkReal(32.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.536928000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(-32.0000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(32.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.387200000000000))*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-0.330259459200000))*(cj0)*(px)*(r01)*(sj0)))+(((IkReal(32.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.0576215699346872))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-64.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-0.387200000000000))*((pz)*(pz))))+(((IkReal(-3.00235872000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(-128.000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-1.50117936000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(-64.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(32.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(32.0000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-64.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(32.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(7.04000000000000))*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(4.07621472000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-32.0000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-1.07385600000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-32.0000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-64.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-0.536928000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(1.96442064000000))*(pp)*((r02)*(r02))))+(((IkReal(-0.536928000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(7.04000000000000))*(r00)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-3.52000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(32.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(32.0000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(32.0000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(7.04000000000000))*(px)*(r00)*((pz)*(pz))))+(((IkReal(0.254144000000000))*(px)*(r00)))+(((IkReal(-64.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.0576215699346872))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.254144000000000))*(py)*(r01)))+(((IkReal(-32.0000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(14.0800000000000))*(cj0)*(px)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-64.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-6.23924128000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(7.04000000000000))*(r02)*((pz)*(pz)*(pz))))+(((IkReal(4.07621472000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(32.0000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(3.00235872000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-0.774400000000000))*(cj0)*(px)*(py)*(sj0)))+(((IkReal(32.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-32.0000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-3.52000000000000))*(pp)*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(-32.0000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-1.07385600000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(7.04000000000000))*(pz)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))))))+(((IkReal(0.205487523200000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-0.536928000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.334400000000000))*(pp)*(r01)*(sj0)))+(((IkReal(-1.76000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-3.04000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.577600000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.231620640000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(16.0000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(0.334400000000000))*(cj0)*(pp)*(r00)))+(((IkReal(-0.0169127113760000))*(r01)*(sj0)))+(((IkReal(0.0735680000000000))*(py)*(sj0)))+(((IkReal(-0.809220640000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(12.1600000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.00928947026334360))*((r02)*(r02))))+(((IkReal(16.0000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-16.0000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-0.0517356016000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(0.153751921600000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(-1.76000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)))+(((IkReal(0.127072000000000))*(py)*(r01)))+(((IkReal(-0.193600000000000))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.809220640000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-0.0102318444406564))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-3.04000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-0.272292640000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+((((htj1)*(htj1)*(htj1))*(((((IkReal(1.33760000000000))*(py)*(pz)*(r01)*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(cj0)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-0.254144000000000))*(pz)*(r01)*(sj0)))+(((IkReal(0.103471203200000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(12.1600000000000))*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(2.31040000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(2.31040000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(24.3200000000000))*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(1.33760000000000))*(cj0)*(py)*(pz)*(r00)*(sj0)))+(((IkReal(-12.1600000000000))*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(24.3200000000000))*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(-0.254144000000000))*(cj0)*(px)*(r02)))+(((IkReal(12.1600000000000))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(1.33760000000000))*(px)*(pz)*(r00)*((cj0)*(cj0))))+(((IkReal(-1.33760000000000))*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(2.31040000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(2.31040000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(2.31040000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(24.3200000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-2.67520000000000))*(py)*(pz)*(r01)))+(((IkReal(0.147136000000000))*(pz)))+(((IkReal(12.1600000000000))*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-2.67520000000000))*(px)*(pz)*(r00)))+(((IkReal(-12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(-2.67520000000000))*(cj0)*(px)*(py)*(r02)*(sj0)))+(((IkReal(-0.254144000000000))*(py)*(r02)*(sj0)))+(((IkReal(-2.67520000000000))*(r02)*((pz)*(pz))))+(((IkReal(-12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(6.08000000000000))*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(12.1600000000000))*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.103471203200000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.668800000000000))*(pp)*(r02)))+(((IkReal(-12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(0.307503843200000))*(pz)*((r02)*(r02))))+(((IkReal(-0.206942406400000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*((r02)*(r02))))+(((IkReal(2.31040000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(-12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(12.1600000000000))*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.103471203200000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(2.31040000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(-2.31040000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(12.1600000000000))*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(24.3200000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(2.31040000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-6.08000000000000))*(pp)*(py)*(r01)*(r02)))+(((IkReal(0.307503843200000))*(py)*(r01)*(r02)))+(((IkReal(0.103471203200000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(2.31040000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(24.3200000000000))*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(24.3200000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-6.08000000000000))*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(12.1600000000000))*(cj0)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.0780852588160000))*(r01)*(r02)*(sj0)))+(((IkReal(12.1600000000000))*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(0.103471203200000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(2.31040000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(0.307503843200000))*(px)*(r00)*(r02)))+(((IkReal(-12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(1.33760000000000))*(cj0)*(px)*(pz)*(r01)*(sj0)))+(((IkReal(-1.33760000000000))*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(-0.0338254227520000))*(r02)))+(((IkReal(-6.08000000000000))*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(2.31040000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-6.08000000000000))*(cj0)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-2.31040000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(-6.08000000000000))*(pp)*(px)*(r00)*(r02)))+(((IkReal(-0.254144000000000))*(cj0)*(pz)*(r00)))+(((IkReal(-12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-0.103471203200000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.0780852588160000))*(cj0)*(r00)*(r02)))+(((IkReal(-12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(2.31040000000000))*(px)*(py)*(r00)*(r02)*(sj0)))))))+(((IkReal(-1.76000000000000))*(pp)*(pz)*(r02)))+(((IkReal(-0.809220640000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(0.0890142704000000))*(cj0)*(px)*(r01)*(sj0)))+(((IkReal(7.04000000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(3.52000000000000))*(py)*(r01)*((pz)*(pz))))+(((IkReal(6.08000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-0.668800000000000))*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-0.0517356016000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-32.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-1.33760000000000))*(cj0)*(r00)*((px)*(px))))+(((IkReal(-3.04000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-32.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.809220640000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(6.08000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.0890142704000000))*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.387200000000000))*(cj0)*(px)*(py)*(sj0)))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.0890142704000000))*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.668800000000000))*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-64.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-1.76000000000000))*(pp)*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(7.04000000000000))*(cj0)*(py)*(r00)*(sj0)*((px)*(px))))+(((IkReal(-32.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-0.193600000000000))*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-0.272292640000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(6.08000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-32.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-0.0102318444406564))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(6.08000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-4.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-0.268464000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(3.52000000000000))*(px)*(r00)*((pz)*(pz))))+(((IkReal(6.08000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(-32.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-8.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(-16.0000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-0.809220640000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(6.08000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.0169127113760000))*(cj0)*(r00)))+(((IkReal(16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(7.04000000000000))*(cj0)*(px)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-16.0000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(6.08000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.272292640000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.268464000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.127072000000000))*(px)*(r00)))+(((IkReal(0.205487523200000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-0.172989680000000))*(pp)*((r02)*(r02))))+(((IkReal(3.52000000000000))*(pz)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-3.04000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-0.668800000000000))*(cj0)*(px)*(pz)*(r02)))+(((IkReal(16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.153751921600000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(0.404610320000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-32.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(3.52000000000000))*(py)*(r01)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(3.52000000000000))*(px)*(r00)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(12.1600000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+((((htj1)*(htj1)*(htj1)*(htj1))*(((IkReal(-0.00698896000000000))+(((IkReal(0.404610320000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.0890142704000000))*(pz)*(r02)))+(((IkReal(-0.809220640000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(-32.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.268464000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-0.153751921600000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(-0.536928000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.0735680000000000))*(cj0)*(px)))+(((IkReal(-3.04000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-1.76000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-0.577600000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-0.334400000000000))*(pp)*(r01)*(sj0)))+(((IkReal(-32.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.231620640000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0735680000000000))*(py)*(sj0)))+(((IkReal(16.0000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-0.809220640000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(0.00928947026334360))*((r02)*(r02))))+(((IkReal(16.0000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-16.0000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-1.76000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)))+(((IkReal(-6.08000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(0.127072000000000))*(py)*(r01)))+(((IkReal(-0.193600000000000))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.809220640000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-0.0102318444406564))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.205487523200000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-0.272292640000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-1.76000000000000))*(pp)*(pz)*(r02)))+(((IkReal(0.668800000000000))*(cj0)*(px)*(pz)*(r02)))+(((IkReal(-0.809220640000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(0.668800000000000))*(cj0)*(r00)*((pz)*(pz))))+(((IkReal(0.0890142704000000))*(cj0)*(px)*(r01)*(sj0)))+(((IkReal(7.04000000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(3.52000000000000))*(py)*(r01)*((pz)*(pz))))+(((IkReal(-32.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-32.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.809220640000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(0.0890142704000000))*(px)*(r00)*((cj0)*(cj0))))+(((IkReal(-16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.0517356016000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.387200000000000))*(cj0)*(px)*(py)*(sj0)))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.0890142704000000))*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-6.08000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-64.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-1.76000000000000))*(pp)*(py)*(r01)*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(7.04000000000000))*(cj0)*(py)*(r00)*(sj0)*((px)*(px))))+(((IkReal(-32.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-0.193600000000000))*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-0.272292640000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-32.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-0.153751921600000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.0102318444406564))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-4.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.268464000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-6.08000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(3.52000000000000))*(px)*(r00)*((pz)*(pz))))+(((IkReal(-32.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-8.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(-16.0000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-0.809220640000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-0.809220640000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-6.08000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(16.0000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(7.04000000000000))*(cj0)*(px)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-16.0000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.272292640000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.268464000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.127072000000000))*(px)*(r00)))+(((IkReal(-0.172989680000000))*(pp)*((r02)*(r02))))+(((IkReal(3.52000000000000))*(pz)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.404610320000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-6.08000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(-0.334400000000000))*(cj0)*(pp)*(r00)))+(((IkReal(3.04000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-32.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-6.08000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(3.52000000000000))*(py)*(r01)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(3.52000000000000))*(px)*(r00)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.0169127113760000))*(cj0)*(r00)))+(((IkReal(0.668800000000000))*(py)*(pz)*(r02)*(sj0)))+(((IkReal(3.04000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(1.33760000000000))*(px)*(py)*(r00)*(sj0)))+(((IkReal(-0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(3.04000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-32.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-1.15520000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(1.33760000000000))*(r01)*(sj0)*((py)*(py))))+(((IkReal(16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(0.0517356016000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(-6.08000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-6.08000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.205487523200000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-0.153751921600000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(3.52000000000000))*(pz)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-6.08000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(-0.193600000000000))*((pz)*(pz))))+(((IkReal(-0.268464000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-1.76000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)))+(((IkReal(-0.577600000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.0204636888813128))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-0.272292640000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-32.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-12.1600000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(3.04000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(1.33760000000000))*(cj0)*(r00)*((px)*(px))))+(((IkReal(-0.809220640000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(1.33760000000000))*(cj0)*(px)*(py)*(r01)))+(((IkReal(-16.0000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-64.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-6.08000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(3.52000000000000))*(r00)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-64.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(0.668800000000000))*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.0169127113760000))*(r01)*(sj0)))+(((IkReal(0.0890142704000000))*(cj0)*(py)*(r00)*(sj0)))+(((IkReal(-4.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(3.52000000000000))*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.536928000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-3.04000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(6.08000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(16.0000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-6.08000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.153751921600000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(3.52000000000000))*(r02)*((pz)*(pz)*(pz))))))))+(((IkReal(6.08000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(6.08000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.809220640000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-32.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(6.08000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-1.15520000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(16.0000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-1.33760000000000))*(px)*(py)*(r00)*(sj0)))+(((IkReal(16.0000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(-1.33760000000000))*(r01)*(sj0)*((py)*(py))))+(((IkReal(3.52000000000000))*(pz)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.193600000000000))*((pz)*(pz))))+(((IkReal(-0.268464000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-1.76000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)))+(((IkReal(-0.577600000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(3.04000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.0204636888813128))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-0.272292640000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-32.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(3.04000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(6.08000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(16.0000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-32.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-0.809220640000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-64.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(3.52000000000000))*(r00)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-64.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(0.0735680000000000))*(cj0)*(px)))+(((IkReal(6.08000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.0890142704000000))*(cj0)*(py)*(r00)*(sj0)))+(((IkReal(0.153751921600000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(-4.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(3.52000000000000))*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.536928000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.668800000000000))*(cj0)*(r00)*((pz)*(pz))))+(((IkReal(0.153751921600000))*(py)*(sj0)*((r01)*(r01))))+(((htj1)*(((((IkReal(-2.31040000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(1.33760000000000))*(py)*(pz)*(r01)*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-6.08000000000000))*(cj0)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-2.31040000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(0.103471203200000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(12.1600000000000))*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(24.3200000000000))*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(1.33760000000000))*(cj0)*(py)*(pz)*(r00)*(sj0)))+(((IkReal(-12.1600000000000))*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(24.3200000000000))*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(12.1600000000000))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(1.33760000000000))*(px)*(pz)*(r00)*((cj0)*(cj0))))+(((IkReal(-1.33760000000000))*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(24.3200000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-2.67520000000000))*(py)*(pz)*(r01)))+(((IkReal(0.147136000000000))*(pz)))+(((IkReal(12.1600000000000))*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-2.67520000000000))*(px)*(pz)*(r00)))+(((IkReal(-12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(-2.67520000000000))*(cj0)*(px)*(py)*(r02)*(sj0)))+(((IkReal(-2.67520000000000))*(r02)*((pz)*(pz))))+(((IkReal(-12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(6.08000000000000))*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(12.1600000000000))*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.103471203200000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.254144000000000))*(cj0)*(pz)*(r00)))+(((IkReal(0.668800000000000))*(pp)*(r02)))+(((IkReal(-2.31040000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(-12.1600000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(0.307503843200000))*(pz)*((r02)*(r02))))+(((IkReal(-0.206942406400000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-6.08000000000000))*(pp)*(pz)*((r02)*(r02))))+(((IkReal(-2.31040000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-2.31040000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-2.31040000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.0780852588160000))*(cj0)*(r00)*(r02)))+(((IkReal(-12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(12.1600000000000))*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.103471203200000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-2.31040000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-2.31040000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(2.31040000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(12.1600000000000))*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(24.3200000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-6.08000000000000))*(pp)*(py)*(r01)*(r02)))+(((IkReal(0.307503843200000))*(py)*(r01)*(r02)))+(((IkReal(0.103471203200000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(0.254144000000000))*(py)*(r02)*(sj0)))+(((IkReal(-2.31040000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(24.3200000000000))*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-12.1600000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-2.31040000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(24.3200000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-6.08000000000000))*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(12.1600000000000))*(cj0)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-2.31040000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(2.31040000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(12.1600000000000))*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(0.103471203200000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-2.31040000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(0.254144000000000))*(pz)*(r01)*(sj0)))+(((IkReal(0.254144000000000))*(cj0)*(px)*(r02)))+(((IkReal(0.307503843200000))*(px)*(r00)*(r02)))+(((IkReal(-12.1600000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(1.33760000000000))*(cj0)*(px)*(pz)*(r01)*(sj0)))+(((IkReal(-1.33760000000000))*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(-0.0780852588160000))*(r01)*(r02)*(sj0)))+(((IkReal(-0.0338254227520000))*(r02)))+(((IkReal(-6.08000000000000))*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-6.08000000000000))*(cj0)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-6.08000000000000))*(pp)*(px)*(r00)*(r02)))+(((IkReal(-12.1600000000000))*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-0.103471203200000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-12.1600000000000))*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))))))+(((IkReal(16.0000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(6.08000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-1.33760000000000))*(cj0)*(px)*(py)*(r01)))+(((IkReal(3.52000000000000))*(r02)*((pz)*(pz)*(pz)))));
if( IKabs(j1evalpoly[0]) > 0.0000001000000000  || IKabs(j1evalpoly[1]) > 0.0000001000000000  )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < numsolutions; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break;
}
}
{
IkReal dummyeval[1];
IkReal gconst0;
gconst0=IKsign(((((IkReal(0.105640000000000))*(cj1)*(pp)*(sj1)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.0281204172400000))*(cj1)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.211280000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(-0.0232408000000000))*(cj0)*(px)*(r02)))+(((IkReal(0.0401432000000000))*(px)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-1.11200000000000))*(cj1)*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(0.0232408000000000))*(cj1)*(px)*(r00)*(sj1)*((cj0)*(cj0))))+(((IkReal(-0.211280000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.556000000000000))*(cj1)*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(0.211280000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(0.211280000000000))*(cj1)*(py)*(pz)*(r01)*(r02)*(sj1)))+(((IkReal(0.0232408000000000))*(pz)*(r01)*(sj0)))+(((IkReal(-0.211280000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(1.11200000000000))*(cj1)*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.105640000000000))*(cj0)*(pp)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(0.244640000000000))*(cj0)*(cj1)*(px)*(py)*(r02)*(sj0)))+(((IkReal(-0.122320000000000))*(cj0)*(cj1)*(px)*(pz)*(r01)*(sj0)))+(((IkReal(1.11200000000000))*(cj0)*(py)*(r00)*(r01)*(sj1)*((pz)*(pz))))+(((IkReal(0.0401432000000000))*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(1.11200000000000))*(cj1)*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.211280000000000))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(-0.211280000000000))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)*((r00)*(r00))))+(((IkReal(-2.22400000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-0.211280000000000))*(cj1)*(px)*(pz)*(r00)*(r02)*(sj1)*((cj0)*(cj0))))+(((IkReal(0.211280000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-1.11200000000000))*(py)*(sj0)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.122320000000000))*(r01)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(-1.11200000000000))*(cj1)*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-0.00534287927560000))*(cj1)*(sj1)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.556000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(0.556000000000000))*(pp)*(py)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(-0.00441575200000000))*(cj0)*(r00)*(sj1)))+(((IkReal(-0.211280000000000))*(cj1)*(sj1)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.122320000000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(sj0)))+(((IkReal(0.105640000000000))*(cj1)*(pp)*(sj1)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.00534287927560000))*(cj1)*(sj1)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.556000000000000))*(cj1)*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.122320000000000))*(cj1)*(py)*(pz)*(r01)*((sj0)*(sj0))))+(((IkReal(-1.11200000000000))*(cj1)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(1.11200000000000))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-2.22400000000000))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(1.11200000000000))*(cj0)*(px)*(sj1)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-0.211280000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(0.211280000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(1.11200000000000))*(cj1)*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(0.211280000000000))*(cj1)*(px)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(0.211280000000000))*(cj0)*(r00)*(r02)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(0.00441575200000000))*(cj1)*(r02)))+(((IkReal(0.0401432000000000))*(cj0)*(py)*(r00)*(r01)*(sj1)))+(((IkReal(1.11200000000000))*(r01)*(r02)*(sj0)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(0.0232408000000000))*(cj1)*(py)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(-0.211280000000000))*(cj0)*(cj1)*(px)*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.0232408000000000))*(cj0)*(px)*(r02)*((cj1)*(cj1))))+(((IkReal(-1.11200000000000))*(cj1)*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(1.11200000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-0.211280000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-1.11200000000000))*(cj0)*(px)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.00534287927560000))*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(0.211280000000000))*(cj0)*(cj1)*(pp)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(0.556000000000000))*(cj0)*(pp)*(px)*(sj1)*((r02)*(r02))))+(((IkReal(-0.211280000000000))*(cj1)*(px)*(py)*(r00)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(-0.211280000000000))*(cj0)*(py)*(pz)*(r00)*(r01)*((sj1)*(sj1))))+(((IkReal(1.11200000000000))*(py)*(sj0)*(sj1)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-0.211280000000000))*(cj1)*(py)*(pz)*(r01)*(r02)*(sj1)*((sj0)*(sj0))))+(((IkReal(0.0682636172400000))*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(0.211280000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-0.211280000000000))*(px)*(pz)*(r00)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(-0.0232408000000000))*(py)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.211280000000000))*(cj1)*(px)*(py)*(r00)*(r01)*(sj1)*((cj0)*(cj0))))+(((IkReal(-0.211280000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(1.11200000000000))*(cj0)*(r00)*(r02)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(0.211280000000000))*(cj0)*(px)*(py)*(r01)*(r02)*((cj1)*(cj1))))+(((IkReal(0.122320000000000))*(py)*(pz)*(r02)*(sj0)*(sj1)))+(((IkReal(0.0232408000000000))*(cj0)*(cj1)*(py)*(r00)*(sj0)*(sj1)))+(((IkReal(0.556000000000000))*(cj0)*(cj1)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-0.0281204172400000))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-1.11200000000000))*(cj1)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.0401432000000000))*(cj1)*(px)*(r00)*(r02)))+(((IkReal(-0.0106857585512000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(0.105640000000000))*(pp)*(r01)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(0.211280000000000))*(cj0)*(px)*(pz)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(-0.0401432000000000))*(cj1)*(pz)*((r02)*(r02))))+(((IkReal(0.0281204172400000))*(cj1)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.105640000000000))*(cj1)*(pp)*(sj1)*((r02)*(r02))))+(((IkReal(-1.11200000000000))*(cj0)*(cj1)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-0.211280000000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(0.0232408000000000))*(cj0)*(pz)*(r00)*((sj1)*(sj1))))+(((IkReal(0.0232408000000000))*(cj0)*(cj1)*(px)*(r01)*(sj0)*(sj1)))+(((IkReal(0.211280000000000))*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(-1.11200000000000))*(pz)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-0.211280000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-0.211280000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(-0.0281204172400000))*(cj1)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.211280000000000))*(cj1)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0232408000000000))*(py)*(r02)*(sj0)))+(((IkReal(0.211280000000000))*(px)*(py)*(r00)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-1.11200000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.211280000000000))*(cj0)*(px)*(pz)*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(-0.00534287927560000))*(cj0)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(1.11200000000000))*(px)*(r00)*(r01)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(-0.0281204172400000))*(py)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(1.11200000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.00534287927560000))*(cj0)*(r00)*(r02)*((cj1)*(cj1))))+(((IkReal(-0.556000000000000))*(cj1)*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.122320000000000))*(cj1)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-1.11200000000000))*(cj0)*(pz)*(r00)*(r02)*(sj1)*((px)*(px))))+(((IkReal(-0.211280000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-0.211280000000000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((px)*(px))))+(((IkReal(-0.00441575200000000))*(r01)*(sj0)*(sj1)))+(((IkReal(0.211280000000000))*(py)*(pz)*(sj0)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(-0.105640000000000))*(pp)*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.211280000000000))*(py)*(pz)*(sj0)*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(0.122320000000000))*(cj0)*(px)*(pz)*(r02)*(sj1)))+(((IkReal(0.122320000000000))*(cj1)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(1.11200000000000))*(cj1)*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(-1.11200000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)*(sj1)))+(((IkReal(-0.211280000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-0.122320000000000))*(cj0)*(r00)*(sj1)*((pz)*(pz))))+(((IkReal(0.0232408000000000))*(cj0)*(pz)*(r00)))+(((IkReal(0.0232408000000000))*(pz)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(1.11200000000000))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-0.0281204172400000))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(1.11200000000000))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.211280000000000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-0.0232408000000000))*(cj1)*(pz)*(r02)*(sj1)))+(((IkReal(0.0562408344800000))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-0.0281204172400000))*(cj0)*(px)*(sj1)*((r02)*(r02))))+(((IkReal(-2.22400000000000))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(0.0682636172400000))*(cj0)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(-0.0401432000000000))*(cj1)*(py)*(r01)*(r02)))+(((IkReal(0.556000000000000))*(cj0)*(cj1)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(0.211280000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-1.11200000000000))*(cj1)*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-0.105640000000000))*(cj0)*(pp)*(r00)*(r02)*((cj1)*(cj1))))+(((IkReal(-0.556000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.00534287927560000))*(r01)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(-0.0281204172400000))*(cj1)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-0.556000000000000))*(cj1)*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(1.11200000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(0.00534287927560000))*(cj1)*(sj1)*((r02)*(r02))))+(((IkReal(-0.122320000000000))*(cj1)*(px)*(pz)*(r00)*((cj0)*(cj0))))+(((IkReal(0.0401432000000000))*(cj0)*(px)*(sj1)*((r00)*(r00))))+(((IkReal(1.11200000000000))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(1.11200000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))));
dummyeval[0]=((((IkReal(-47.8468899521531))*(r01)*(r02)*(sj0)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(47.8468899521531))*(cj1)*(py)*(pz)*(r01)*(r02)*(sj1)))+(((IkReal(-1.20995909090909))*(r01)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(-125.912868295140))*(cj1)*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(5.26315789473684))*(cj0)*(pz)*(r00)*((sj1)*(sj1))))+(((IkReal(-251.825736590280))*(cj1)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(23.9234449760766))*(pp)*(r01)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(-27.7008310249307))*(cj0)*(cj1)*(py)*(pz)*(r00)*(sj0)))+(((IkReal(-47.8468899521531))*(cj0)*(cj1)*(px)*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(-23.9234449760766))*(cj0)*(pp)*(r00)*(r02)*((cj1)*(cj1))))+(((IkReal(-23.9234449760766))*(cj1)*(pp)*(sj1)*((r02)*(r02))))+(((IkReal(-6.36820574162679))*(py)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(-23.9234449760766))*(pp)*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(47.8468899521531))*(cj0)*(px)*(pz)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(-251.825736590280))*(cj1)*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-251.825736590280))*(cj0)*(cj1)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(23.9234449760766))*(cj1)*(pp)*(sj1)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-47.8468899521531))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(-5.26315789473684))*(cj0)*(px)*(r02)*((cj1)*(cj1))))+(((IkReal(-5.26315789473684))*(py)*(r02)*(sj0)))+(((IkReal(251.825736590280))*(py)*(sj0)*(sj1)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(251.825736590280))*(cj0)*(r00)*(r02)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(47.8468899521531))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-47.8468899521531))*(cj1)*(px)*(py)*(r00)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(47.8468899521531))*(cj0)*(r00)*(r02)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(1.20995909090909))*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-251.825736590280))*(cj1)*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-251.825736590280))*(py)*(sj0)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(47.8468899521531))*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(-125.912868295140))*(cj1)*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(27.7008310249307))*(cj0)*(px)*(pz)*(r02)*(sj1)))+(((IkReal(-251.825736590280))*(cj0)*(px)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(9.09090909090909))*(cj0)*(py)*(r00)*(r01)*(sj1)))+(((IkReal(47.8468899521531))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(125.912868295140))*(cj0)*(cj1)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-1.20995909090909))*(cj0)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(-47.8468899521531))*(cj1)*(px)*(py)*(r00)*(r01)*(sj1)*((cj0)*(cj0))))+(((IkReal(251.825736590280))*(cj1)*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(-6.36820574162679))*(cj1)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-125.912868295140))*(pp)*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(251.825736590280))*(cj1)*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(27.7008310249307))*(cj1)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-47.8468899521531))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(47.8468899521531))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(5.26315789473684))*(cj0)*(cj1)*(px)*(r01)*(sj0)*(sj1)))+(((IkReal(251.825736590280))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(-47.8468899521531))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(125.912868295140))*(cj0)*(cj1)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-251.825736590280))*(cj1)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(251.825736590280))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-47.8468899521531))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(1.20995909090909))*(cj1)*(sj1)*((r02)*(r02))))+(((IkReal(-251.825736590280))*(pz)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))))+(((cj1)*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(sj1)))+(((IkReal(23.9234449760766))*(cj0)*(pp)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(5.26315789473684))*(cj0)*(pz)*(r00)))+(((IkReal(-47.8468899521531))*(cj0)*(py)*(pz)*(r00)*(r01)*((sj1)*(sj1))))+(((IkReal(251.825736590280))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(251.825736590280))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(251.825736590280))*(px)*(r00)*(r01)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(-27.7008310249307))*(r01)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(6.36820574162679))*(cj1)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-251.825736590280))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)*(sj1)))+(((IkReal(1.20995909090909))*(cj0)*(r00)*(r02)*((cj1)*(cj1))))+(((IkReal(9.09090909090909))*(cj0)*(px)*(sj1)*((r00)*(r00))))+(((IkReal(-47.8468899521531))*(cj0)*(r00)*(r02)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(9.09090909090909))*(px)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(27.7008310249307))*(cj1)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-503.651473180559))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(15.4591148325359))*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(27.7008310249307))*(py)*(pz)*(r02)*(sj0)*(sj1)))+(((IkReal(-503.651473180559))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(47.8468899521531))*(cj1)*(px)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(-27.7008310249307))*(cj1)*(py)*(pz)*(r01)*((sj0)*(sj0))))+(((IkReal(251.825736590280))*(cj1)*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(23.9234449760766))*(cj1)*(pp)*(sj1)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-47.8468899521531))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)*((r00)*(r00))))+(((IkReal(-27.7008310249307))*(cj0)*(r00)*(sj1)*((pz)*(pz))))+(((IkReal(125.912868295140))*(pp)*(py)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(47.8468899521531))*(cj0)*(cj1)*(pp)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-5.26315789473684))*(cj0)*(px)*(r02)))+(((IkReal(251.825736590280))*(cj0)*(py)*(r00)*(r01)*(sj1)*((pz)*(pz))))+(((IkReal(-47.8468899521531))*(cj1)*(py)*(pz)*(r01)*(r02)*(sj1)*((sj0)*(sj0))))+(((IkReal(-2.41991818181818))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-47.8468899521531))*(cj1)*(sj1)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-47.8468899521531))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(251.825736590280))*(cj0)*(px)*(sj1)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-6.36820574162679))*(cj1)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(12.7364114832536))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(47.8468899521531))*(cj0)*(px)*(py)*(r01)*(r02)*((cj1)*(cj1))))+(((IkReal(251.825736590280))*(cj1)*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(-47.8468899521531))*(cj1)*(px)*(pz)*(r00)*(r02)*(sj1)*((cj0)*(cj0))))+(((IkReal(-6.36820574162679))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(5.26315789473684))*(cj0)*(cj1)*(py)*(r00)*(sj0)*(sj1)))+(((IkReal(-47.8468899521531))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(251.825736590280))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-47.8468899521531))*(cj0)*(cj1)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(-47.8468899521531))*(py)*(pz)*(sj0)*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(-27.7008310249307))*(cj1)*(px)*(pz)*(r00)*((cj0)*(cj0))))+(((IkReal(-47.8468899521531))*(px)*(pz)*(r00)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(55.4016620498615))*(cj0)*(cj1)*(px)*(py)*(r02)*(sj0)))+(((IkReal(-251.825736590280))*(cj0)*(pz)*(r00)*(r02)*(sj1)*((px)*(px))))+(((IkReal(15.4591148325359))*(cj0)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(5.26315789473684))*(cj1)*(py)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(251.825736590280))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(47.8468899521531))*(px)*(py)*(r00)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(251.825736590280))*(r01)*(r02)*(sj0)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(-251.825736590280))*(cj1)*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-47.8468899521531))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-503.651473180559))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(125.912868295140))*(cj1)*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-1.20995909090909))*(cj1)*(sj1)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-6.36820574162679))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(5.26315789473684))*(cj1)*(px)*(r00)*(sj1)*((cj0)*(cj0))))+(((IkReal(5.26315789473684))*(pz)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(-9.09090909090909))*(cj1)*(pz)*((r02)*(r02))))+(((IkReal(251.825736590280))*(cj1)*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-5.26315789473684))*(cj1)*(pz)*(r02)*(sj1)))+(((IkReal(-9.09090909090909))*(cj1)*(py)*(r01)*(r02)))+(((IkReal(125.912868295140))*(cj0)*(pp)*(px)*(sj1)*((r02)*(r02))))+(((IkReal(-1.00000000000000))*(r01)*(sj0)*(sj1)))+(((IkReal(-27.7008310249307))*(cj0)*(cj1)*(px)*(pz)*(r01)*(sj0)))+(((IkReal(-47.8468899521531))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(125.912868295140))*(cj1)*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-47.8468899521531))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-125.912868295140))*(cj0)*(pp)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(-47.8468899521531))*(cj0)*(px)*(pz)*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(47.8468899521531))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-1.20995909090909))*(cj1)*(sj1)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-251.825736590280))*(cj1)*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-251.825736590280))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(47.8468899521531))*(py)*(pz)*(sj0)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(-47.8468899521531))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((px)*(px))))+(((IkReal(-9.09090909090909))*(cj1)*(px)*(r00)*(r02)))+(((IkReal(-6.36820574162679))*(cj0)*(px)*(sj1)*((r02)*(r02))))+(((IkReal(5.26315789473684))*(pz)*(r01)*(sj0)))+(((IkReal(9.09090909090909))*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(47.8468899521531))*(cj1)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-5.26315789473684))*(py)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(47.8468899521531))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(47.8468899521531))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(251.825736590280))*(cj1)*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(6.36820574162679))*(cj1)*(pz)*((r01)*(r01))*((sj0)*(sj0)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
if( IKabs(((gconst0)*(((IkReal(-0.00349448000000000))+(((IkReal(-0.193600000000000))*(cj0)*(px)*(py)*(sj0)*((cj1)*(cj1))))+(((IkReal(0.0445071352000000))*(cj0)*(px)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.668800000000000))*(cj1)*(px)*(py)*(r00)*(sj0)))+(((IkReal(0.0635360000000000))*(pz)*(r02)))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(px)*(pz)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.404610320000000))*(cj0)*(px)*(py)*(sj0)*((cj1)*(cj1))*((r01)*(r01))))+(((IkReal(0.0445071352000000))*(pz)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(r01)*(sj1)))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(px)*(py)*(r01)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-16.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px)*(px))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(sj0)*((cj1)*(cj1))*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-8.00000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-0.0102318444406564))*(cj1)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(8.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj1)*(sj1))))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(r00)*(r02)*(sj1)*((px)*(px))*((pz)*(pz))))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.668800000000000))*(cj0)*(cj1)*(px)*(py)*(r01)))+(((IkReal(3.04000000000000))*(pz)*(sj1)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.668800000000000))*(cj0)*(cj1)*(px)*(pz)*(r02)))+(((IkReal(-32.0000000000000))*(cj1)*(px)*(py)*(r00)*(r02)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(1.76000000000000))*(r01)*((cj1)*(cj1))*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.202305160000000))*(pp)*((cj1)*(cj1))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(0.0445071352000000))*(py)*(r01)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(px)*(py)*(pz)*(r00)*(r01)*(sj1)))+(((IkReal(-0.00511592222032820))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(px)*(py)*(r01)*(r02)*(sj1)))+(((IkReal(-0.404610320000000))*(py)*(pz)*(r01)*(r02)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(-0.668800000000000))*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-0.404610320000000))*(cj0)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-8.00000000000000))*((cj1)*(cj1))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(px)*(pz)*(sj1)*((py)*(py))*((r01)*(r01))))+(((IkReal(0.167200000000000))*(pp)*(r02)*(sj1)))+(((IkReal(6.08000000000000))*(cj1)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-0.880000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(py)*(r01)*(r02)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((cj1)*(cj1))*((r01)*(r01))))+(((IkReal(-0.00511592222032820))*((cj1)*(cj1))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(3.52000000000000))*(cj1)*(py)*(r02)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(0.0445071352000000))*(cj0)*(cj1)*(pz)*(r00)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(0.0768759608000000))*(py)*(r01)*(r02)*(sj1)))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(6.08000000000000))*(cj0)*(cj1)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.0635360000000000))*(py)*(r01)))+(((IkReal(-8.00000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(0.0367840000000000))*(cj0)*(cj1)*(px)))+(((IkReal(-0.404610320000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(8.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(1.76000000000000))*(px)*(r00)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-0.404610320000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(px)*(sj1)*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-32.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(0.0445071352000000))*(cj0)*(py)*(r00)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.404610320000000))*(cj1)*(px)*(py)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(-16.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px)*(px))))+(((IkReal(0.0445071352000000))*(px)*(r00)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(0.0768759608000000))*(pz)*(sj1)*((r02)*(r02))))+(((IkReal(-0.404610320000000))*(cj0)*(px)*(py)*(sj0)*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((px)*(px))*((py)*(py))))+(((IkReal(1.76000000000000))*(py)*(r01)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-0.288800000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))*((sj1)*(sj1))))+(((IkReal(3.52000000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(sj0)*(sj1)))+(((IkReal(3.52000000000000))*(cj0)*(py)*(r00)*(sj0)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-16.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(py)*(pz)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(8.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(0.0768759608000000))*(cj0)*(cj1)*(py)*(r00)*(r01)))+(((IkReal(-1.52000000000000))*(pp)*(py)*(r01)*(r02)*(sj1)))+(((IkReal(0.0445071352000000))*(cj1)*(py)*(r02)*(sj0)*(sj1)))+(((IkReal(0.167200000000000))*(cj0)*(cj1)*(pp)*(r00)))+(((IkReal(8.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(px)*(r00)*(r01)*((cj1)*(cj1))*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.880000000000000))*(cj1)*(pp)*(pz)*(r01)*(sj0)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(pz)*(sj1)*((r00)*(r00))))+(((IkReal(-0.404610320000000))*(cj1)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(0.404610320000000))*(cj1)*(pp)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(px)*(pz)*(sj1)*((r02)*(r02))))+(((IkReal(-0.404610320000000))*(py)*(pz)*(r01)*(r02)*((sj1)*(sj1))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*(px)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.668800000000000))*(cj1)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.52000000000000))*(cj1)*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-0.404610320000000))*(cj1)*(py)*(pz)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(1.76000000000000))*(r00)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px)*(px))))+(((IkReal(8.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(3.04000000000000))*(cj1)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(px)*(pz)*(r00)*(r02)*((cj1)*(cj1))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj1)*(pz)*(sj0)*(sj1)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-0.0102318444406564))*(cj0)*(cj1)*(r00)*(r02)*(sj1)))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(px)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-8.00000000000000))*((cj1)*(cj1))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-2.00000000000000))*((pp)*(pp))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-0.0102318444406564))*(cj0)*(r00)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.577600000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(py)*(pz)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(r01)*(sj1)))+(((IkReal(-0.00845635568800000))*(cj1)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(pz)*(r01)*(r02)*((cj1)*(cj1))*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-0.404610320000000))*(cj1)*(r01)*(r02)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(-4.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((pp)*(pp))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(r01)*(r02)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(-0.668800000000000))*(py)*(pz)*(r01)*(sj1)))+(((IkReal(1.76000000000000))*(r02)*((pz)*(pz)*(pz))*((sj1)*(sj1))))+(((IkReal(3.52000000000000))*(cj1)*(pz)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-0.880000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)*((cj1)*(cj1))))+(((IkReal(0.0445071352000000))*(cj1)*(pz)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.880000000000000))*(cj0)*(cj1)*(pp)*(pz)*(r00)*(sj1)))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(r00)*(r02)*(sj1)*((px)*(px))))+(((IkReal(-0.193600000000000))*(cj1)*(py)*(pz)*(sj0)*(sj1)))+(((IkReal(0.404610320000000))*(cj0)*(cj1)*(pp)*(r00)*(r02)*(sj1)))+(((IkReal(-0.577600000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-0.404610320000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-4.00000000000000))*(cj0)*(cj1)*(r00)*(r02)*(sj1)*((pp)*(pp))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(0.0768759608000000))*(cj1)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-0.880000000000000))*(cj1)*(pp)*(py)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.404610320000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(-32.0000000000000))*(cj1)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))*((pz)*(pz))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(r02)*(sj1)*((px)*(px))))+(((IkReal(-0.880000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(px)*(pz)*(sj1)*((r00)*(r00))))+(((IkReal(-0.668800000000000))*(cj0)*(cj1)*(r00)*((px)*(px))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-0.404610320000000))*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.0968000000000000))*((cj1)*(cj1))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.0768759608000000))*(cj1)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.00511592222032820))*((cj0)*(cj0))*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(pz)*(sj1)*((r02)*(r02))))+(((IkReal(0.0635360000000000))*(px)*(r00)))+(((IkReal(-0.880000000000000))*(cj0)*(cj1)*(pp)*(px)*(r02)*(sj1)))+(((IkReal(-0.404610320000000))*(px)*(pz)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.668800000000000))*(cj1)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-0.288800000000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(cj0)*(py)*(sj0)*((cj1)*(cj1))*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.0968000000000000))*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))))+(((IkReal(6.08000000000000))*(cj1)*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(3.52000000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(px)*(py)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.404610320000000))*(cj0)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(6.08000000000000))*(px)*(r00)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-1.52000000000000))*(cj1)*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-0.288800000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj1)*(py)*(pz)*(sj0)*(sj1)*((px)*(px))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*((cj1)*(cj1))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.0367840000000000))*(pz)*(sj1)))+(((IkReal(-0.880000000000000))*(pp)*(pz)*(r02)*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(6.08000000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(py)*(pz)*(r00)*(r01)*(sj1)))+(((IkReal(-2.00000000000000))*((cj1)*(cj1))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.577600000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(3.04000000000000))*(sj1)*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(0.0445071352000000))*(cj0)*(cj1)*(px)*(r02)*(sj1)))+(((IkReal(1.76000000000000))*(px)*(r00)*((cj1)*(cj1))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj1)*(py)*(sj0)*(sj1)*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(3.04000000000000))*(cj1)*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(0.0367840000000000))*(cj1)*(py)*(sj0)))+(((IkReal(-0.0968000000000000))*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(r00)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(0.202305160000000))*(pp)*((cj0)*(cj0))*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(-1.52000000000000))*(cj1)*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(6.08000000000000))*(py)*(r01)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(0.0768759608000000))*(cj1)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-0.880000000000000))*(pp)*(py)*(r01)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*(pp)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(pp)*((cj1)*(cj1))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(r01)*(sj1)*((px)*(px))))+(((IkReal(1.76000000000000))*(pz)*(r02)*((cj1)*(cj1))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(3.04000000000000))*(pz)*(sj1)*((py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(pz)*(sj1)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(3.04000000000000))*(cj1)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-0.193600000000000))*(cj0)*(cj1)*(px)*(pz)*(sj1)))+(((IkReal(-1.52000000000000))*(pp)*(px)*(r00)*(r02)*(sj1)))+(((IkReal(-0.00845635568800000))*(cj0)*(cj1)*(r00)))+(((IkReal(-8.00000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-2.00000000000000))*((cj0)*(cj0))*((cj1)*(cj1))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-0.404610320000000))*(cj1)*(py)*(pz)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(0.167200000000000))*(cj1)*(pp)*(r01)*(sj0)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(py)*(sj0)*((cj1)*(cj1))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-1.52000000000000))*(pp)*(pz)*(sj1)*((r02)*(r02))))+(((IkReal(-0.404610320000000))*(px)*(py)*(r00)*(r01)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(0.0768759608000000))*(px)*(r00)*(r02)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-4.00000000000000))*(cj1)*(r01)*(r02)*(sj0)*(sj1)*((pp)*(pp))))+(((IkReal(-16.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(cj1)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(0.404610320000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.668800000000000))*(px)*(pz)*(r00)*(sj1)))+(((IkReal(-0.00845635568800000))*(r02)*(sj1)))+(((IkReal(-16.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))*((sj1)*(sj1))))+(((IkReal(3.52000000000000))*(cj0)*(px)*(r01)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(1.76000000000000))*(pz)*(r02)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-0.404610320000000))*((cj1)*(cj1))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.0768759608000000))*(cj0)*(cj1)*(pz)*(r00)*(r02)))+(((IkReal(-0.404610320000000))*((pz)*(pz))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(pz)*(r00)*(sj1)*((px)*(px))))+(((IkReal(0.202305160000000))*(pp)*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(0.0768759608000000))*(cj0)*(cj1)*(px)*((r00)*(r00))))+(((IkReal(1.76000000000000))*(py)*(r01)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-0.404610320000000))*(cj1)*(px)*(pz)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-32.0000000000000))*(cj1)*(px)*(pz)*(r00)*(r01)*(sj0)*(sj1)*((py)*(py)))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst0)*(((((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(0.0579051600000000))*(cj0)*(pp)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.0183920000000000))*(cj1)*(pz)))+(((IkReal(1.76000000000000))*(cj0)*(px)*(r02)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-0.880000000000000))*(cj0)*(cj1)*(pp)*(px)*(r01)*(sj0)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(sj1)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.00951443240000000))*(py)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-8.00000000000000))*(cj0)*(pz)*((px)*(px)*(px))*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj0)*(px)*((cj1)*(cj1))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0222535676000000))*(cj0)*(pz)*(r00)*((cj1)*(cj1))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(px)*(py)*(r00)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(0.288800000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-1.52000000000000))*(px)*(r00)*(r01)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(16.0000000000000))*(cj1)*(px)*(py)*(r00)*(r01)*(sj1)*((pz)*(pz))))+(((IkReal(-1.52000000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.00218729405567180))*(cj0)*(r00)*(r02)*((cj1)*(cj1))))+(((IkReal(-1.52000000000000))*(cj1)*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(16.0000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(0.00218729405567180))*(cj1)*(sj1)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.760000000000000))*(cj1)*(pp)*(py)*(r01)*(r02)))+(((IkReal(0.0317680000000000))*(cj0)*(px)*(r02)))+(((IkReal(16.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-16.0000000000000))*(cj1)*(py)*(pz)*(r01)*(r02)*(sj1)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-16.0000000000000))*(cj1)*(pz)*(r01)*(r02)*(sj1)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.880000000000000))*(cj1)*(pp)*(px)*(r00)*(sj1)*((cj0)*(cj0))))+(((IkReal(-0.115810320000000))*(cj1)*(sj1)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(1.76000000000000))*(cj1)*(r01)*(sj1)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.760000000000000))*(cj1)*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.0384379804000000))*(py)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(-0.202305160000000))*(cj0)*(px)*(pz)*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(r00)*(r02)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(2.00000000000000))*(cj0)*(r00)*(r02)*((cj1)*(cj1))*((pp)*(pp))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-0.0864948400000000))*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(0.167200000000000))*(r01)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(1.52000000000000))*(cj1)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-0.0164340196000000))*(px)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.760000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-16.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)*((px)*(px))*((sj1)*(sj1))))+(((IkReal(0.115810320000000))*(cj0)*(cj1)*(pp)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.0968000000000000))*(cj0)*(px)*(pz)*((sj1)*(sj1))))+(((IkReal(1.76000000000000))*(cj1)*(pz)*(r02)*(sj1)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.760000000000000))*(cj1)*(pp)*(px)*(r00)*(r02)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(pz)*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-4.00000000000000))*(pp)*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((px)*(px))*((py)*(py))))+(((IkReal(0.440000000000000))*(cj0)*(pp)*(px)*(r02)*((cj1)*(cj1))))+(((IkReal(-1.52000000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-16.0000000000000))*(cj1)*(px)*(pz)*(r00)*(r02)*(sj1)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(r02)*((pp)*(pp))*((sj1)*(sj1))))+(((IkReal(4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(-1.52000000000000))*(cj0)*(px)*(sj1)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)*((r00)*(r00))))+(((IkReal(-0.501600000000000))*(cj0)*(px)*(pz)*(r02)*(sj1)))+(((IkReal(-0.0768759608000000))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.167200000000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(sj0)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r02)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(sj0)*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-1.52000000000000))*(cj1)*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-0.760000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)*(sj1)))+(((IkReal(0.760000000000000))*(cj1)*(pp)*(pz)*((r02)*(r02))))+(((IkReal(-4.00000000000000))*(pp)*(px)*(py)*(r00)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(16.0000000000000))*(cj0)*(r00)*(r02)*((cj1)*(cj1))*((px)*(px))*((pz)*(pz))))+(((IkReal(-0.00218729405567180))*(cj1)*(sj1)*((r02)*(r02))))+(((IkReal(-0.880000000000000))*(cj1)*(pp)*(py)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(0.0384379804000000))*(cj1)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-16.0000000000000))*(r01)*(r02)*(sj0)*((py)*(py))*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(0.440000000000000))*(pp)*(py)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-8.00000000000000))*(cj1)*(pp)*(px)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(1.76000000000000))*(cj1)*(r00)*(sj1)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(0.288800000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(1.52000000000000))*(cj1)*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-8.00000000000000))*(cj0)*(px)*((pz)*(pz)*(pz))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-3.04000000000000))*(cj1)*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-0.0864948400000000))*(cj0)*(r00)*(r02)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-0.760000000000000))*(cj0)*(pp)*(px)*(sj1)*((r02)*(r02))))+(((IkReal(-0.00951443240000000))*(pz)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(0.334400000000000))*(cj1)*(py)*(pz)*(r01)))+(((IkReal(-1.76000000000000))*(px)*(py)*(pz)*(r00)*(sj0)*((cj1)*(cj1))))+(((IkReal(-16.0000000000000))*(cj1)*(py)*(r00)*(r01)*(sj1)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(px)*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(-1.52000000000000))*(py)*(sj0)*(sj1)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-0.0127391352000000))*(cj1)*(pz)*(r02)*(sj1)))+(((IkReal(-2.00000000000000))*(cj1)*(sj1)*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.00180774215600000))*(cj0)*(r00)*(sj1)))+(((IkReal(-0.0384379804000000))*(cj1)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-1.76000000000000))*(py)*(r02)*(sj0)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(1.52000000000000))*(cj1)*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-8.00000000000000))*(cj1)*(pp)*(py)*(pz)*(r01)*(r02)*(sj1)))+(((IkReal(0.288800000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(-1.52000000000000))*(cj0)*(py)*(r00)*(r01)*(sj1)*((pz)*(pz))))+(((IkReal(4.56000000000000))*(pz)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-4.00000000000000))*(pp)*(py)*(pz)*(sj0)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(-0.501600000000000))*(py)*(pz)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.0864948400000000))*(cj0)*(px)*(pz)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(-1.52000000000000))*(cj1)*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.760000000000000))*(cj0)*(cj1)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(0.288800000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r01)*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(sj1)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r02)*((px)*(px))*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj1)*(sj1)*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-0.00218729405567180))*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(1.52000000000000))*(sj0)*(sj1)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(1.76000000000000))*(cj0)*(pz)*(r00)*((px)*(px))*((sj1)*(sj1))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(0.0164340196000000))*(cj1)*(py)*(r01)*(r02)))+(((IkReal(16.0000000000000))*(cj1)*(px)*(r00)*(r02)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(py)*(r00)*(sj0)*(sj1)*((px)*(px))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(0.0183920000000000))*(py)*(sj0)*(sj1)))+(((IkReal(2.00000000000000))*(cj1)*(sj1)*((pp)*(pp))*((r02)*(r02))))+(((IkReal(-1.76000000000000))*(cj1)*(px)*(r00)*(sj1)*((pz)*(pz))))+(((IkReal(1.76000000000000))*(cj1)*(px)*(r00)*(sj1)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(1.52000000000000))*(cj1)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((px)*(px))))+(((IkReal(1.76000000000000))*(py)*(r02)*(sj0)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(0.0864948400000000))*(cj0)*(r00)*(r02)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-8.00000000000000))*(py)*(sj0)*((pz)*(pz)*(pz))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj1)*(sj1)*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.115810320000000))*(cj1)*(px)*(pz)*(r00)*(r02)*(sj1)*((cj0)*(cj0))))+(((IkReal(0.0127391352000000))*(cj0)*(cj1)*(px)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.0579051600000000))*(cj1)*(pp)*(sj1)*((r02)*(r02))))+(((IkReal(-3.04000000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-0.0317680000000000))*(cj0)*(pz)*(r00)))+(((IkReal(0.0127391352000000))*(cj0)*(cj1)*(py)*(r00)*(sj0)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-1.52000000000000))*(cj0)*(r00)*(r02)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(0.0579051600000000))*(cj1)*(pp)*(sj1)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.0968000000000000))*(cj1)*(sj1)*((pz)*(pz))))+(((IkReal(-0.115810320000000))*(cj1)*(py)*(pz)*(r01)*(r02)*(sj1)*((sj0)*(sj0))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(1.52000000000000))*(cj0)*(px)*(sj1)*((py)*(py))*((r01)*(r01))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-0.288800000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-0.880000000000000))*(cj0)*(cj1)*(pp)*(py)*(r00)*(sj0)*(sj1)))+(((IkReal(1.76000000000000))*(px)*(py)*(pz)*(r00)*(sj0)*((sj1)*(sj1))))+(((IkReal(0.202305160000000))*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(py)*(r01)*(r02)*((sj1)*(sj1))))+(((IkReal(0.880000000000000))*(cj1)*(pp)*(pz)*(r02)*(sj1)))+(((IkReal(0.00218729405567180))*(r01)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(-1.52000000000000))*(cj1)*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.167200000000000))*(cj1)*(px)*(pz)*(r00)*((cj0)*(cj0))))+(((IkReal(3.04000000000000))*(cj0)*(px)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(py)*(sj0)*(sj1)*((r00)*(r00))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(pz)*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(-8.00000000000000))*(cj1)*(pp)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.0384379804000000))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.288800000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-4.00000000000000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((pp)*(pp))))+(((IkReal(-0.440000000000000))*(pp)*(py)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(-0.167200000000000))*(cj1)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-0.0864948400000000))*(py)*(pz)*(sj0)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(0.0127391352000000))*(cj1)*(px)*(r00)*(sj1)*((cj0)*(cj0))))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(px)*(py)*(r01)*(r02)*((cj1)*(cj1))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(px)*(pz)*(r00)*(r02)*(sj1)*((cj0)*(cj0))))+(((IkReal(-0.288800000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(py)*(r01)*(r02)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(0.202305160000000))*(cj0)*(px)*(pz)*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(-0.760000000000000))*(cj0)*(pp)*(px)*(sj1)*((r00)*(r00))))+(((IkReal(-0.202305160000000))*(px)*(py)*(r00)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(0.0864948400000000))*(cj0)*(px)*(pz)*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(-0.440000000000000))*(cj0)*(pp)*(pz)*(r00)*((sj1)*(sj1))))+(((IkReal(-0.0968000000000000))*(cj1)*(sj1)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.0864948400000000))*(px)*(py)*(r00)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.202305160000000))*(cj0)*(px)*(py)*(r01)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.440000000000000))*(cj0)*(pp)*(px)*(r02)*((sj1)*(sj1))))+(((IkReal(-4.00000000000000))*(pp)*(py)*(pz)*(sj0)*((cj1)*(cj1))*((r01)*(r01))))+(((IkReal(0.0384379804000000))*(cj0)*(px)*(sj1)*((r02)*(r02))))+(((IkReal(-1.76000000000000))*(cj0)*(pz)*(r00)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(8.00000000000000))*(cj0)*(pz)*((cj1)*(cj1))*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(2.00000000000000))*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((pp)*(pp))))+(((IkReal(-2.00000000000000))*(r01)*(r02)*(sj0)*((pp)*(pp))*((sj1)*(sj1))))+(((IkReal(-0.334400000000000))*(cj0)*(px)*(py)*(r01)*(sj1)))+(((IkReal(0.0864948400000000))*(py)*(pz)*(sj0)*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(-3.04000000000000))*(cj1)*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(0.0968000000000000))*(py)*(pz)*(sj0)*((cj1)*(cj1))))+(((IkReal(0.0222535676000000))*(py)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(-1.76000000000000))*(cj1)*(py)*(r01)*(sj1)*((pz)*(pz))))+(((IkReal(0.288800000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(px)*(pz)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(4.00000000000000))*(pp)*(px)*(py)*(r00)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(4.56000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)*(sj1)))+(((IkReal(0.0579051600000000))*(cj1)*(pp)*(sj1)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.0164340196000000))*(cj0)*(px)*(sj1)*((r00)*(r00))))+(((IkReal(-4.00000000000000))*(pp)*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(-0.760000000000000))*(pp)*(py)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(r02)*(sj0)*(sj1)))+(((IkReal(0.00180774215600000))*(r01)*(sj0)*(sj1)))+(((IkReal(-0.288800000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(1.52000000000000))*(py)*(sj0)*(sj1)*((px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj1)*(sj1)*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.0164340196000000))*(cj1)*(pz)*((r02)*(r02))))+(((IkReal(-0.440000000000000))*(pp)*(pz)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(-0.202305160000000))*(py)*(pz)*(sj0)*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-0.760000000000000))*(cj1)*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(0.00218729405567180))*(cj1)*(sj1)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.202305160000000))*(cj0)*(py)*(pz)*(r00)*(r01)*((cj1)*(cj1))))+(((IkReal(1.76000000000000))*(cj1)*(py)*(r01)*(sj1)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.00951443240000000))*(cj0)*(px)*(r02)*((cj1)*(cj1))))+(((IkReal(0.0864948400000000))*(cj0)*(py)*(pz)*(r00)*(r01)*((sj1)*(sj1))))+(((IkReal(-0.760000000000000))*(cj1)*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.202305160000000))*(cj0)*(r00)*(r02)*((px)*(px))*((sj1)*(sj1))))+(((IkReal(16.0000000000000))*(px)*(py)*(r00)*(r02)*(sj0)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(1.52000000000000))*(cj1)*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(0.0836000000000000))*(pp)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.00180774215600000))*(cj1)*(r02)))+(((IkReal(-0.334400000000000))*(px)*(py)*(r00)*(sj0)*(sj1)))+(((IkReal(0.202305160000000))*(py)*(pz)*(sj0)*((cj1)*(cj1))*((r01)*(r01))))+(((IkReal(-1.76000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*((cj1)*(cj1))))+(((IkReal(-0.760000000000000))*(pp)*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(py)*(sj0)*(sj1)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.00218729405567180))*(cj0)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.334400000000000))*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(3.04000000000000))*(cj0)*(py)*(r00)*(r01)*(sj1)*((px)*(px))))+(((IkReal(-0.115810320000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(1.76000000000000))*(pz)*(r01)*(sj0)*((py)*(py))*((sj1)*(sj1))))+(((IkReal(-0.288800000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(1.52000000000000))*(cj0)*(sj1)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.0579051600000000))*(pp)*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-1.52000000000000))*(cj1)*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(0.0127391352000000))*(cj1)*(py)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(1.76000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*((sj1)*(sj1))))+(((IkReal(0.0317680000000000))*(py)*(r02)*(sj0)))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-1.52000000000000))*(cj1)*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.00951443240000000))*(cj0)*(pz)*(r00)*((sj1)*(sj1))))+(((IkReal(3.04000000000000))*(py)*(sj0)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0384379804000000))*(cj1)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.0222535676000000))*(cj0)*(px)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.202305160000000))*(r01)*(r02)*(sj0)*((py)*(py))*((sj1)*(sj1))))+(((IkReal(-0.0164340196000000))*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(0.0968000000000000))*(cj0)*(px)*(pz)*((cj1)*(cj1))))+(((IkReal(-0.0548720000000000))*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(4.00000000000000))*(pp)*(r01)*(r02)*(sj0)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(0.288800000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-0.334400000000000))*(cj0)*(r00)*(sj1)*((px)*(px))))+(((IkReal(-0.167200000000000))*(cj1)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(px)*(sj0)*(sj1)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj1)*(pz)*(r00)*(r02)*(sj1)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(sj0)*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)*((px)*(px))))+(((IkReal(4.56000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(0.334400000000000))*(cj1)*(r02)*((pz)*(pz))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(px)*(py)*(r00)*(r01)*(sj1)*((cj0)*(cj0))))+(((IkReal(-1.76000000000000))*(cj0)*(px)*(r02)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(py)*(pz)*(r01)*(r02)*(sj1)*((sj0)*(sj0))))+(((IkReal(-0.115810320000000))*(cj1)*(px)*(py)*(r00)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(0.760000000000000))*(cj1)*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.334400000000000))*(cj1)*(px)*(pz)*(r00)))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(r00)*(r02)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(0.0864948400000000))*(r01)*(r02)*(sj0)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-8.00000000000000))*(cj0)*(px)*(pz)*((py)*(py))*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.0579051600000000))*(pp)*(r01)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(0.167200000000000))*(cj1)*(py)*(pz)*(r01)*((sj0)*(sj0))))+(((IkReal(0.115810320000000))*(cj1)*(py)*(pz)*(r01)*(r02)*(sj1)))+(((IkReal(0.440000000000000))*(pp)*(pz)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.0968000000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(8.00000000000000))*(pz)*(sj0)*((cj1)*(cj1))*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(0.202305160000000))*(px)*(pz)*(r00)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-1.52000000000000))*(r01)*(r02)*(sj0)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(-0.334400000000000))*(cj0)*(cj1)*(px)*(py)*(r02)*(sj0)))+(((IkReal(-2.00000000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(cj0)*(r00)*(r02)*((px)*(px))*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-1.76000000000000))*(pz)*(r01)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(4.00000000000000))*(pp)*(r01)*(r02)*(sj0)*((py)*(py))*((sj1)*(sj1))))+(((IkReal(0.440000000000000))*(cj0)*(pp)*(pz)*(r00)*((cj1)*(cj1))))+(((IkReal(-0.115810320000000))*(cj1)*(px)*(py)*(r00)*(r01)*(sj1)*((cj0)*(cj0))))+(((IkReal(-0.0317680000000000))*(pz)*(r01)*(sj0)))+(((IkReal(16.0000000000000))*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((py)*(py))*((pz)*(pz))))+(((IkReal(-8.00000000000000))*(pz)*(sj0)*((py)*(py)*(py))*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(r01)*(sj0)*(sj1)*((px)*(px))))+(((IkReal(0.0384379804000000))*(cj1)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(1.52000000000000))*(cj1)*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.202305160000000))*(cj0)*(r00)*(r02)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(-0.288800000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.0384379804000000))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-0.193600000000000))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)))+(((IkReal(-0.0579051600000000))*(cj0)*(pp)*(r00)*(r02)*((cj1)*(cj1))))+(((IkReal(-1.76000000000000))*(cj1)*(r02)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(-0.0548720000000000))*(cj0)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-0.760000000000000))*(cj0)*(cj1)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(0.0183920000000000))*(cj0)*(px)*(sj1)))+(((IkReal(0.0164340196000000))*(cj1)*(px)*(r00)*(r02)))+(((IkReal(4.56000000000000))*(cj0)*(pz)*(r00)*(r02)*(sj1)*((px)*(px))))+(((IkReal(0.0864948400000000))*(px)*(pz)*(r00)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(3.04000000000000))*(px)*(r00)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(px)*(pz)*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(py)*(pz)*(sj0)*((px)*(px))*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(0.167200000000000))*(cj0)*(r00)*(sj1)*((pz)*(pz))))+(((IkReal(0.115810320000000))*(cj1)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-16.0000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))*((sj1)*(sj1))))+(((IkReal(1.76000000000000))*(cj1)*(pz)*(r02)*(sj1)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.115810320000000))*(cj1)*(px)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(px)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(8.00000000000000))*(py)*(pz)*(sj0)*((cj1)*(cj1))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.0836000000000000))*(cj1)*(pp)*(r02)))+(((IkReal(0.167200000000000))*(cj0)*(cj1)*(px)*(pz)*(r01)*(sj0)))+(((IkReal(-0.0164340196000000))*(cj0)*(py)*(r00)*(r01)*(sj1)))+(((IkReal(-0.0968000000000000))*(py)*(pz)*(sj0)*((sj1)*(sj1))))+(((IkReal(-0.0864948400000000))*(cj0)*(px)*(py)*(r01)*(r02)*((cj1)*(cj1))))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(px)*(pz)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r01)*((cj1)*(cj1))))+(((IkReal(0.00437458811134360))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(px)*(pz)*((cj1)*(cj1))*((py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(px)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(1.52000000000000))*(cj0)*(cj1)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-1.52000000000000))*(cj1)*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0222535676000000))*(pz)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-16.0000000000000))*(cj1)*(px)*(r00)*(r01)*(sj1)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*(cj0)*(px)*(py)*(r01)*(r02)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(16.0000000000000))*(cj1)*(py)*(r01)*(r02)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(8.00000000000000))*(py)*(sj0)*((cj1)*(cj1))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(0.0836000000000000))*(cj0)*(pp)*(r00)*(sj1))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst0)*(((IkReal(-0.00349448000000000))+(((IkReal(-0.193600000000000))*(cj0)*(px)*(py)*(sj0)*((cj1)*(cj1))))+(((IkReal(0.0445071352000000))*(cj0)*(px)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.668800000000000))*(cj1)*(px)*(py)*(r00)*(sj0)))+(((IkReal(0.0635360000000000))*(pz)*(r02)))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(px)*(pz)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.404610320000000))*(cj0)*(px)*(py)*(sj0)*((cj1)*(cj1))*((r01)*(r01))))+(((IkReal(0.0445071352000000))*(pz)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(r01)*(sj1)))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(px)*(py)*(r01)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-16.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px)*(px))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(sj0)*((cj1)*(cj1))*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-8.00000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-0.0102318444406564))*(cj1)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(8.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj1)*(sj1))))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(r00)*(r02)*(sj1)*((px)*(px))*((pz)*(pz))))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.668800000000000))*(cj0)*(cj1)*(px)*(py)*(r01)))+(((IkReal(3.04000000000000))*(pz)*(sj1)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.668800000000000))*(cj0)*(cj1)*(px)*(pz)*(r02)))+(((IkReal(-32.0000000000000))*(cj1)*(px)*(py)*(r00)*(r02)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(1.76000000000000))*(r01)*((cj1)*(cj1))*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.202305160000000))*(pp)*((cj1)*(cj1))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(0.0445071352000000))*(py)*(r01)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(6.08000000000000))*(px)*(py)*(pz)*(r00)*(r01)*(sj1)))+(((IkReal(-0.00511592222032820))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(px)*(py)*(r01)*(r02)*(sj1)))+(((IkReal(-0.404610320000000))*(py)*(pz)*(r01)*(r02)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(-0.668800000000000))*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-0.404610320000000))*(cj0)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-8.00000000000000))*((cj1)*(cj1))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(px)*(pz)*(sj1)*((py)*(py))*((r01)*(r01))))+(((IkReal(0.167200000000000))*(pp)*(r02)*(sj1)))+(((IkReal(6.08000000000000))*(cj1)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-0.880000000000000))*(pp)*(px)*(r00)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(py)*(r01)*(r02)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((cj1)*(cj1))*((r01)*(r01))))+(((IkReal(-0.00511592222032820))*((cj1)*(cj1))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(3.52000000000000))*(cj1)*(py)*(r02)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(0.0445071352000000))*(cj0)*(cj1)*(pz)*(r00)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(0.0768759608000000))*(py)*(r01)*(r02)*(sj1)))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(6.08000000000000))*(cj0)*(cj1)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.0635360000000000))*(py)*(r01)))+(((IkReal(-8.00000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(0.0367840000000000))*(cj0)*(cj1)*(px)))+(((IkReal(-0.404610320000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(8.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(1.76000000000000))*(px)*(r00)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-0.404610320000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(px)*(sj1)*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-32.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(0.0445071352000000))*(cj0)*(py)*(r00)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.404610320000000))*(cj1)*(px)*(py)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(-16.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px)*(px))))+(((IkReal(0.0445071352000000))*(px)*(r00)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(0.0768759608000000))*(pz)*(sj1)*((r02)*(r02))))+(((IkReal(-0.404610320000000))*(cj0)*(px)*(py)*(sj0)*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((px)*(px))*((py)*(py))))+(((IkReal(1.76000000000000))*(py)*(r01)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-0.288800000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))*((sj1)*(sj1))))+(((IkReal(3.52000000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(sj0)*(sj1)))+(((IkReal(3.52000000000000))*(cj0)*(py)*(r00)*(sj0)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-16.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(py)*(pz)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(8.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(0.0768759608000000))*(cj0)*(cj1)*(py)*(r00)*(r01)))+(((IkReal(-1.52000000000000))*(pp)*(py)*(r01)*(r02)*(sj1)))+(((IkReal(0.0445071352000000))*(cj1)*(py)*(r02)*(sj0)*(sj1)))+(((IkReal(0.167200000000000))*(cj0)*(cj1)*(pp)*(r00)))+(((IkReal(8.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(px)*(r00)*(r01)*((cj1)*(cj1))*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.880000000000000))*(cj1)*(pp)*(pz)*(r01)*(sj0)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(pz)*(sj1)*((r00)*(r00))))+(((IkReal(-0.404610320000000))*(cj1)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(0.404610320000000))*(cj1)*(pp)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(px)*(pz)*(sj1)*((r02)*(r02))))+(((IkReal(-0.404610320000000))*(py)*(pz)*(r01)*(r02)*((sj1)*(sj1))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*(px)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.668800000000000))*(cj1)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.52000000000000))*(cj1)*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-0.404610320000000))*(cj1)*(py)*(pz)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(1.76000000000000))*(r00)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px)*(px))))+(((IkReal(8.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(3.04000000000000))*(cj1)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(px)*(pz)*(r00)*(r02)*((cj1)*(cj1))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj1)*(pz)*(sj0)*(sj1)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-0.0102318444406564))*(cj0)*(cj1)*(r00)*(r02)*(sj1)))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(px)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-8.00000000000000))*((cj1)*(cj1))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-2.00000000000000))*((pp)*(pp))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-0.0102318444406564))*(cj0)*(r00)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.577600000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(py)*(pz)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(r01)*(sj1)))+(((IkReal(-0.00845635568800000))*(cj1)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(pz)*(r01)*(r02)*((cj1)*(cj1))*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-0.404610320000000))*(cj1)*(r01)*(r02)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(-4.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((pp)*(pp))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(r01)*(r02)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(-0.668800000000000))*(py)*(pz)*(r01)*(sj1)))+(((IkReal(1.76000000000000))*(r02)*((pz)*(pz)*(pz))*((sj1)*(sj1))))+(((IkReal(3.52000000000000))*(cj1)*(pz)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-0.880000000000000))*(cj0)*(pp)*(py)*(r00)*(sj0)*((cj1)*(cj1))))+(((IkReal(0.0445071352000000))*(cj1)*(pz)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.880000000000000))*(cj0)*(cj1)*(pp)*(pz)*(r00)*(sj1)))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(r00)*(r02)*(sj1)*((px)*(px))))+(((IkReal(-0.193600000000000))*(cj1)*(py)*(pz)*(sj0)*(sj1)))+(((IkReal(0.404610320000000))*(cj0)*(cj1)*(pp)*(r00)*(r02)*(sj1)))+(((IkReal(-0.577600000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-0.404610320000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-4.00000000000000))*(cj0)*(cj1)*(r00)*(r02)*(sj1)*((pp)*(pp))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(0.0768759608000000))*(cj1)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-0.880000000000000))*(cj1)*(pp)*(py)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.404610320000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))*((cj1)*(cj1))))+(((IkReal(-32.0000000000000))*(cj1)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))*((pz)*(pz))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(r02)*(sj1)*((px)*(px))))+(((IkReal(-0.880000000000000))*(cj0)*(pp)*(px)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(px)*(pz)*(sj1)*((r00)*(r00))))+(((IkReal(-0.668800000000000))*(cj0)*(cj1)*(r00)*((px)*(px))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-0.404610320000000))*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.0968000000000000))*((cj1)*(cj1))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.0768759608000000))*(cj1)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.00511592222032820))*((cj0)*(cj0))*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(pz)*(sj1)*((r02)*(r02))))+(((IkReal(0.0635360000000000))*(px)*(r00)))+(((IkReal(-0.880000000000000))*(cj0)*(cj1)*(pp)*(px)*(r02)*(sj1)))+(((IkReal(-0.404610320000000))*(px)*(pz)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.668800000000000))*(cj1)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-0.288800000000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(cj0)*(py)*(sj0)*((cj1)*(cj1))*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.0968000000000000))*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))))+(((IkReal(6.08000000000000))*(cj1)*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(3.52000000000000))*(cj0)*(px)*(py)*(pz)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(px)*(py)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.404610320000000))*(cj0)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(6.08000000000000))*(px)*(r00)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-1.52000000000000))*(cj1)*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-0.288800000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj1)*(py)*(pz)*(sj0)*(sj1)*((px)*(px))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*((cj1)*(cj1))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.0367840000000000))*(pz)*(sj1)))+(((IkReal(-0.880000000000000))*(pp)*(pz)*(r02)*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(6.08000000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(py)*(pz)*(r00)*(r01)*(sj1)))+(((IkReal(-2.00000000000000))*((cj1)*(cj1))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.577600000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(3.04000000000000))*(sj1)*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(0.0445071352000000))*(cj0)*(cj1)*(px)*(r02)*(sj1)))+(((IkReal(1.76000000000000))*(px)*(r00)*((cj1)*(cj1))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj1)*(py)*(sj0)*(sj1)*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(3.04000000000000))*(cj1)*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(0.0367840000000000))*(cj1)*(py)*(sj0)))+(((IkReal(-0.0968000000000000))*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-0.404610320000000))*(cj0)*(cj1)*(r00)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(0.202305160000000))*(pp)*((cj0)*(cj0))*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(-1.52000000000000))*(cj1)*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(6.08000000000000))*(py)*(r01)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(0.0768759608000000))*(cj1)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-0.880000000000000))*(pp)*(py)*(r01)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*(pp)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(pp)*((cj1)*(cj1))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(r01)*(sj1)*((px)*(px))))+(((IkReal(1.76000000000000))*(pz)*(r02)*((cj1)*(cj1))*((py)*(py))*((sj0)*(sj0))))+(((IkReal(3.04000000000000))*(pz)*(sj1)*((py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(pz)*(sj1)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(3.04000000000000))*(cj1)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-0.193600000000000))*(cj0)*(cj1)*(px)*(pz)*(sj1)))+(((IkReal(-1.52000000000000))*(pp)*(px)*(r00)*(r02)*(sj1)))+(((IkReal(-0.00845635568800000))*(cj0)*(cj1)*(r00)))+(((IkReal(-8.00000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-2.00000000000000))*((cj0)*(cj0))*((cj1)*(cj1))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-0.404610320000000))*(cj1)*(py)*(pz)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(0.167200000000000))*(cj1)*(pp)*(r01)*(sj0)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(py)*(sj0)*((cj1)*(cj1))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-1.52000000000000))*(pp)*(pz)*(sj1)*((r02)*(r02))))+(((IkReal(-0.404610320000000))*(px)*(py)*(r00)*(r01)*((cj1)*(cj1))*((sj0)*(sj0))))+(((IkReal(0.0768759608000000))*(px)*(r00)*(r02)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-4.00000000000000))*(cj1)*(r01)*(r02)*(sj0)*(sj1)*((pp)*(pp))))+(((IkReal(-16.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(cj1)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(0.404610320000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.668800000000000))*(px)*(pz)*(r00)*(sj1)))+(((IkReal(-0.00845635568800000))*(r02)*(sj1)))+(((IkReal(-16.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))*((sj1)*(sj1))))+(((IkReal(3.52000000000000))*(cj0)*(px)*(r01)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(1.76000000000000))*(pz)*(r02)*((cj0)*(cj0))*((cj1)*(cj1))*((px)*(px))))+(((IkReal(6.08000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-0.404610320000000))*((cj1)*(cj1))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.0768759608000000))*(cj0)*(cj1)*(pz)*(r00)*(r02)))+(((IkReal(-0.404610320000000))*((pz)*(pz))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(pz)*(r00)*(sj1)*((px)*(px))))+(((IkReal(0.202305160000000))*(pp)*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(0.0768759608000000))*(cj0)*(cj1)*(px)*((r00)*(r00))))+(((IkReal(1.76000000000000))*(py)*(r01)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-0.404610320000000))*(cj1)*(px)*(pz)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-32.0000000000000))*(cj1)*(px)*(pz)*(r00)*(r01)*(sj0)*(sj1)*((py)*(py))))))), ((gconst0)*(((((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(0.0579051600000000))*(cj0)*(pp)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.0183920000000000))*(cj1)*(pz)))+(((IkReal(1.76000000000000))*(cj0)*(px)*(r02)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-0.880000000000000))*(cj0)*(cj1)*(pp)*(px)*(r01)*(sj0)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(sj1)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.00951443240000000))*(py)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-8.00000000000000))*(cj0)*(pz)*((px)*(px)*(px))*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj0)*(px)*((cj1)*(cj1))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0222535676000000))*(cj0)*(pz)*(r00)*((cj1)*(cj1))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(px)*(py)*(r00)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(0.288800000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-1.52000000000000))*(px)*(r00)*(r01)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(16.0000000000000))*(cj1)*(px)*(py)*(r00)*(r01)*(sj1)*((pz)*(pz))))+(((IkReal(-1.52000000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-0.00218729405567180))*(cj0)*(r00)*(r02)*((cj1)*(cj1))))+(((IkReal(-1.52000000000000))*(cj1)*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(16.0000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(0.00218729405567180))*(cj1)*(sj1)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.760000000000000))*(cj1)*(pp)*(py)*(r01)*(r02)))+(((IkReal(0.0317680000000000))*(cj0)*(px)*(r02)))+(((IkReal(16.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-16.0000000000000))*(cj1)*(py)*(pz)*(r01)*(r02)*(sj1)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-16.0000000000000))*(cj1)*(pz)*(r01)*(r02)*(sj1)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.880000000000000))*(cj1)*(pp)*(px)*(r00)*(sj1)*((cj0)*(cj0))))+(((IkReal(-0.115810320000000))*(cj1)*(sj1)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(1.76000000000000))*(cj1)*(r01)*(sj1)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.760000000000000))*(cj1)*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.0384379804000000))*(py)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(-0.202305160000000))*(cj0)*(px)*(pz)*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(r00)*(r02)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(2.00000000000000))*(cj0)*(r00)*(r02)*((cj1)*(cj1))*((pp)*(pp))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-0.0864948400000000))*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(0.167200000000000))*(r01)*(sj0)*(sj1)*((pz)*(pz))))+(((IkReal(1.52000000000000))*(cj1)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-0.0164340196000000))*(px)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.760000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-16.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)*((px)*(px))*((sj1)*(sj1))))+(((IkReal(0.115810320000000))*(cj0)*(cj1)*(pp)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.0968000000000000))*(cj0)*(px)*(pz)*((sj1)*(sj1))))+(((IkReal(1.76000000000000))*(cj1)*(pz)*(r02)*(sj1)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.760000000000000))*(cj1)*(pp)*(px)*(r00)*(r02)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(pz)*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-4.00000000000000))*(pp)*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((px)*(px))*((py)*(py))))+(((IkReal(0.440000000000000))*(cj0)*(pp)*(px)*(r02)*((cj1)*(cj1))))+(((IkReal(-1.52000000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-16.0000000000000))*(cj1)*(px)*(pz)*(r00)*(r02)*(sj1)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(r02)*((pp)*(pp))*((sj1)*(sj1))))+(((IkReal(4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(-1.52000000000000))*(cj0)*(px)*(sj1)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)*((r00)*(r00))))+(((IkReal(-0.501600000000000))*(cj0)*(px)*(pz)*(r02)*(sj1)))+(((IkReal(-0.0768759608000000))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.167200000000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(sj0)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r02)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(sj0)*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-1.52000000000000))*(cj1)*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-0.760000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)*(sj1)))+(((IkReal(0.760000000000000))*(cj1)*(pp)*(pz)*((r02)*(r02))))+(((IkReal(-4.00000000000000))*(pp)*(px)*(py)*(r00)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(16.0000000000000))*(cj0)*(r00)*(r02)*((cj1)*(cj1))*((px)*(px))*((pz)*(pz))))+(((IkReal(-0.00218729405567180))*(cj1)*(sj1)*((r02)*(r02))))+(((IkReal(-0.880000000000000))*(cj1)*(pp)*(py)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(0.0384379804000000))*(cj1)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-16.0000000000000))*(r01)*(r02)*(sj0)*((py)*(py))*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(0.440000000000000))*(pp)*(py)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-8.00000000000000))*(cj1)*(pp)*(px)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(1.76000000000000))*(cj1)*(r00)*(sj1)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(0.288800000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(1.52000000000000))*(cj1)*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-8.00000000000000))*(cj0)*(px)*((pz)*(pz)*(pz))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-3.04000000000000))*(cj1)*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-0.0864948400000000))*(cj0)*(r00)*(r02)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(-0.760000000000000))*(cj0)*(pp)*(px)*(sj1)*((r02)*(r02))))+(((IkReal(-0.00951443240000000))*(pz)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(0.334400000000000))*(cj1)*(py)*(pz)*(r01)))+(((IkReal(-1.76000000000000))*(px)*(py)*(pz)*(r00)*(sj0)*((cj1)*(cj1))))+(((IkReal(-16.0000000000000))*(cj1)*(py)*(r00)*(r01)*(sj1)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(px)*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(-1.52000000000000))*(py)*(sj0)*(sj1)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-0.0127391352000000))*(cj1)*(pz)*(r02)*(sj1)))+(((IkReal(-2.00000000000000))*(cj1)*(sj1)*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.00180774215600000))*(cj0)*(r00)*(sj1)))+(((IkReal(-0.0384379804000000))*(cj1)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-1.76000000000000))*(py)*(r02)*(sj0)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(1.52000000000000))*(cj1)*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-8.00000000000000))*(cj1)*(pp)*(py)*(pz)*(r01)*(r02)*(sj1)))+(((IkReal(0.288800000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(-1.52000000000000))*(cj0)*(py)*(r00)*(r01)*(sj1)*((pz)*(pz))))+(((IkReal(4.56000000000000))*(pz)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-4.00000000000000))*(pp)*(py)*(pz)*(sj0)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(-0.501600000000000))*(py)*(pz)*(r02)*(sj0)*(sj1)))+(((IkReal(-0.0864948400000000))*(cj0)*(px)*(pz)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(-1.52000000000000))*(cj1)*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.760000000000000))*(cj0)*(cj1)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(0.288800000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r01)*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(sj1)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r02)*((px)*(px))*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj1)*(sj1)*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-0.00218729405567180))*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(1.52000000000000))*(sj0)*(sj1)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(1.76000000000000))*(cj0)*(pz)*(r00)*((px)*(px))*((sj1)*(sj1))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(0.0164340196000000))*(cj1)*(py)*(r01)*(r02)))+(((IkReal(16.0000000000000))*(cj1)*(px)*(r00)*(r02)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(py)*(r00)*(sj0)*(sj1)*((px)*(px))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(0.0183920000000000))*(py)*(sj0)*(sj1)))+(((IkReal(2.00000000000000))*(cj1)*(sj1)*((pp)*(pp))*((r02)*(r02))))+(((IkReal(-1.76000000000000))*(cj1)*(px)*(r00)*(sj1)*((pz)*(pz))))+(((IkReal(1.76000000000000))*(cj1)*(px)*(r00)*(sj1)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(1.52000000000000))*(cj1)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((px)*(px))))+(((IkReal(1.76000000000000))*(py)*(r02)*(sj0)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(0.0864948400000000))*(cj0)*(r00)*(r02)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-8.00000000000000))*(py)*(sj0)*((pz)*(pz)*(pz))*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj1)*(sj1)*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.115810320000000))*(cj1)*(px)*(pz)*(r00)*(r02)*(sj1)*((cj0)*(cj0))))+(((IkReal(0.0127391352000000))*(cj0)*(cj1)*(px)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.0579051600000000))*(cj1)*(pp)*(sj1)*((r02)*(r02))))+(((IkReal(-3.04000000000000))*(cj1)*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-0.0317680000000000))*(cj0)*(pz)*(r00)))+(((IkReal(0.0127391352000000))*(cj0)*(cj1)*(py)*(r00)*(sj0)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-1.52000000000000))*(cj0)*(r00)*(r02)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(0.0579051600000000))*(cj1)*(pp)*(sj1)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.0968000000000000))*(cj1)*(sj1)*((pz)*(pz))))+(((IkReal(-0.115810320000000))*(cj1)*(py)*(pz)*(r01)*(r02)*(sj1)*((sj0)*(sj0))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(1.52000000000000))*(cj0)*(px)*(sj1)*((py)*(py))*((r01)*(r01))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-0.288800000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-0.880000000000000))*(cj0)*(cj1)*(pp)*(py)*(r00)*(sj0)*(sj1)))+(((IkReal(1.76000000000000))*(px)*(py)*(pz)*(r00)*(sj0)*((sj1)*(sj1))))+(((IkReal(0.202305160000000))*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(py)*(r01)*(r02)*((sj1)*(sj1))))+(((IkReal(0.880000000000000))*(cj1)*(pp)*(pz)*(r02)*(sj1)))+(((IkReal(0.00218729405567180))*(r01)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(-1.52000000000000))*(cj1)*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.167200000000000))*(cj1)*(px)*(pz)*(r00)*((cj0)*(cj0))))+(((IkReal(3.04000000000000))*(cj0)*(px)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(py)*(sj0)*(sj1)*((r00)*(r00))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(pz)*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(-8.00000000000000))*(cj1)*(pp)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.0384379804000000))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.288800000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-4.00000000000000))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)*((pp)*(pp))))+(((IkReal(-0.440000000000000))*(pp)*(py)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(-0.167200000000000))*(cj1)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-0.0864948400000000))*(py)*(pz)*(sj0)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(0.0127391352000000))*(cj1)*(px)*(r00)*(sj1)*((cj0)*(cj0))))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(px)*(py)*(r01)*(r02)*((cj1)*(cj1))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(px)*(pz)*(r00)*(r02)*(sj1)*((cj0)*(cj0))))+(((IkReal(-0.288800000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(py)*(r01)*(r02)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(0.202305160000000))*(cj0)*(px)*(pz)*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(-0.760000000000000))*(cj0)*(pp)*(px)*(sj1)*((r00)*(r00))))+(((IkReal(-0.202305160000000))*(px)*(py)*(r00)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(0.0864948400000000))*(cj0)*(px)*(pz)*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(-0.440000000000000))*(cj0)*(pp)*(pz)*(r00)*((sj1)*(sj1))))+(((IkReal(-0.0968000000000000))*(cj1)*(sj1)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.0864948400000000))*(px)*(py)*(r00)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.202305160000000))*(cj0)*(px)*(py)*(r01)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.440000000000000))*(cj0)*(pp)*(px)*(r02)*((sj1)*(sj1))))+(((IkReal(-4.00000000000000))*(pp)*(py)*(pz)*(sj0)*((cj1)*(cj1))*((r01)*(r01))))+(((IkReal(0.0384379804000000))*(cj0)*(px)*(sj1)*((r02)*(r02))))+(((IkReal(-1.76000000000000))*(cj0)*(pz)*(r00)*((cj1)*(cj1))*((px)*(px))))+(((IkReal(8.00000000000000))*(cj0)*(pz)*((cj1)*(cj1))*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(2.00000000000000))*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((pp)*(pp))))+(((IkReal(-2.00000000000000))*(r01)*(r02)*(sj0)*((pp)*(pp))*((sj1)*(sj1))))+(((IkReal(-0.334400000000000))*(cj0)*(px)*(py)*(r01)*(sj1)))+(((IkReal(0.0864948400000000))*(py)*(pz)*(sj0)*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(-3.04000000000000))*(cj1)*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(0.0968000000000000))*(py)*(pz)*(sj0)*((cj1)*(cj1))))+(((IkReal(0.0222535676000000))*(py)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(-1.76000000000000))*(cj1)*(py)*(r01)*(sj1)*((pz)*(pz))))+(((IkReal(0.288800000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(px)*(pz)*(r01)*(r02)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(4.00000000000000))*(pp)*(px)*(py)*(r00)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(4.56000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)*(sj1)))+(((IkReal(0.0579051600000000))*(cj1)*(pp)*(sj1)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.0164340196000000))*(cj0)*(px)*(sj1)*((r00)*(r00))))+(((IkReal(-4.00000000000000))*(pp)*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(-0.760000000000000))*(pp)*(py)*(sj0)*(sj1)*((r02)*(r02))))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(r02)*(sj0)*(sj1)))+(((IkReal(0.00180774215600000))*(r01)*(sj0)*(sj1)))+(((IkReal(-0.288800000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(1.52000000000000))*(py)*(sj0)*(sj1)*((px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj1)*(sj1)*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.0164340196000000))*(cj1)*(pz)*((r02)*(r02))))+(((IkReal(-0.440000000000000))*(pp)*(pz)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(-0.202305160000000))*(py)*(pz)*(sj0)*((r02)*(r02))*((sj1)*(sj1))))+(((IkReal(-0.760000000000000))*(cj1)*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(0.00218729405567180))*(cj1)*(sj1)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.202305160000000))*(cj0)*(py)*(pz)*(r00)*(r01)*((cj1)*(cj1))))+(((IkReal(1.76000000000000))*(cj1)*(py)*(r01)*(sj1)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.00951443240000000))*(cj0)*(px)*(r02)*((cj1)*(cj1))))+(((IkReal(0.0864948400000000))*(cj0)*(py)*(pz)*(r00)*(r01)*((sj1)*(sj1))))+(((IkReal(-0.760000000000000))*(cj1)*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.202305160000000))*(cj0)*(r00)*(r02)*((px)*(px))*((sj1)*(sj1))))+(((IkReal(16.0000000000000))*(px)*(py)*(r00)*(r02)*(sj0)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(1.52000000000000))*(cj1)*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(0.0836000000000000))*(pp)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.00180774215600000))*(cj1)*(r02)))+(((IkReal(-0.334400000000000))*(px)*(py)*(r00)*(sj0)*(sj1)))+(((IkReal(0.202305160000000))*(py)*(pz)*(sj0)*((cj1)*(cj1))*((r01)*(r01))))+(((IkReal(-1.76000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*((cj1)*(cj1))))+(((IkReal(-0.760000000000000))*(pp)*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(py)*(sj0)*(sj1)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.00218729405567180))*(cj0)*(r00)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.334400000000000))*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(3.04000000000000))*(cj0)*(py)*(r00)*(r01)*(sj1)*((px)*(px))))+(((IkReal(-0.115810320000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(1.76000000000000))*(pz)*(r01)*(sj0)*((py)*(py))*((sj1)*(sj1))))+(((IkReal(-0.288800000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(1.52000000000000))*(cj0)*(sj1)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.0579051600000000))*(pp)*(r01)*(r02)*(sj0)*((cj1)*(cj1))))+(((IkReal(-1.52000000000000))*(cj1)*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(0.0127391352000000))*(cj1)*(py)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(1.76000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*((sj1)*(sj1))))+(((IkReal(0.0317680000000000))*(py)*(r02)*(sj0)))+(((IkReal(-8.00000000000000))*(cj1)*(sj1)*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-1.52000000000000))*(cj1)*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.00951443240000000))*(cj0)*(pz)*(r00)*((sj1)*(sj1))))+(((IkReal(3.04000000000000))*(py)*(sj0)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0384379804000000))*(cj1)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.0222535676000000))*(cj0)*(px)*(r02)*((sj1)*(sj1))))+(((IkReal(-0.202305160000000))*(r01)*(r02)*(sj0)*((py)*(py))*((sj1)*(sj1))))+(((IkReal(-0.0164340196000000))*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(0.0968000000000000))*(cj0)*(px)*(pz)*((cj1)*(cj1))))+(((IkReal(-0.0548720000000000))*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(4.00000000000000))*(pp)*(r01)*(r02)*(sj0)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(0.288800000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-0.334400000000000))*(cj0)*(r00)*(sj1)*((px)*(px))))+(((IkReal(-0.167200000000000))*(cj1)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(cj1)*(px)*(sj0)*(sj1)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj1)*(pz)*(r00)*(r02)*(sj1)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(sj0)*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(-32.0000000000000))*(cj0)*(cj1)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)*((px)*(px))))+(((IkReal(4.56000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)*(sj1)))+(((IkReal(0.334400000000000))*(cj1)*(r02)*((pz)*(pz))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(px)*(py)*(r00)*(r01)*(sj1)*((cj0)*(cj0))))+(((IkReal(-1.76000000000000))*(cj0)*(px)*(r02)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(8.00000000000000))*(cj1)*(pp)*(py)*(pz)*(r01)*(r02)*(sj1)*((sj0)*(sj0))))+(((IkReal(-0.115810320000000))*(cj1)*(px)*(py)*(r00)*(r01)*(sj1)*((sj0)*(sj0))))+(((IkReal(0.760000000000000))*(cj1)*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.334400000000000))*(cj1)*(px)*(pz)*(r00)))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(r00)*(r02)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(0.0864948400000000))*(r01)*(r02)*(sj0)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-8.00000000000000))*(cj0)*(px)*(pz)*((py)*(py))*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(3.04000000000000))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.0579051600000000))*(pp)*(r01)*(r02)*(sj0)*((sj1)*(sj1))))+(((IkReal(0.167200000000000))*(cj1)*(py)*(pz)*(r01)*((sj0)*(sj0))))+(((IkReal(0.115810320000000))*(cj1)*(py)*(pz)*(r01)*(r02)*(sj1)))+(((IkReal(0.440000000000000))*(pp)*(pz)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-0.115810320000000))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)*((r01)*(r01))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.0968000000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(8.00000000000000))*(pz)*(sj0)*((cj1)*(cj1))*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(0.202305160000000))*(px)*(pz)*(r00)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-1.52000000000000))*(r01)*(r02)*(sj0)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(-0.334400000000000))*(cj0)*(cj1)*(px)*(py)*(r02)*(sj0)))+(((IkReal(-2.00000000000000))*(cj1)*(sj1)*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(cj0)*(r00)*(r02)*((px)*(px))*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(-1.76000000000000))*(pz)*(r01)*(sj0)*((cj1)*(cj1))*((py)*(py))))+(((IkReal(4.00000000000000))*(pp)*(r01)*(r02)*(sj0)*((py)*(py))*((sj1)*(sj1))))+(((IkReal(0.440000000000000))*(cj0)*(pp)*(pz)*(r00)*((cj1)*(cj1))))+(((IkReal(-0.115810320000000))*(cj1)*(px)*(py)*(r00)*(r01)*(sj1)*((cj0)*(cj0))))+(((IkReal(-0.0317680000000000))*(pz)*(r01)*(sj0)))+(((IkReal(16.0000000000000))*(r01)*(r02)*(sj0)*((cj1)*(cj1))*((py)*(py))*((pz)*(pz))))+(((IkReal(-8.00000000000000))*(pz)*(sj0)*((py)*(py)*(py))*((r01)*(r01))*((sj1)*(sj1))))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(r01)*(sj0)*(sj1)*((px)*(px))))+(((IkReal(0.0384379804000000))*(cj1)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*(cj0)*(cj1)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)*(sj1)))+(((IkReal(1.52000000000000))*(cj1)*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.202305160000000))*(cj0)*(r00)*(r02)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(-0.288800000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.0384379804000000))*(cj0)*(cj1)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-0.193600000000000))*(cj0)*(cj1)*(px)*(py)*(sj0)*(sj1)))+(((IkReal(-0.0579051600000000))*(cj0)*(pp)*(r00)*(r02)*((cj1)*(cj1))))+(((IkReal(-1.76000000000000))*(cj1)*(r02)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(-0.0548720000000000))*(cj0)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-0.760000000000000))*(cj0)*(cj1)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(0.0183920000000000))*(cj0)*(px)*(sj1)))+(((IkReal(0.0164340196000000))*(cj1)*(px)*(r00)*(r02)))+(((IkReal(4.56000000000000))*(cj0)*(pz)*(r00)*(r02)*(sj1)*((px)*(px))))+(((IkReal(0.0864948400000000))*(px)*(pz)*(r00)*(r01)*(sj0)*((sj1)*(sj1))))+(((IkReal(3.04000000000000))*(px)*(r00)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(px)*(pz)*((cj1)*(cj1))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(py)*(pz)*(sj0)*((px)*(px))*((r00)*(r00))*((sj1)*(sj1))))+(((IkReal(0.167200000000000))*(cj0)*(r00)*(sj1)*((pz)*(pz))))+(((IkReal(0.115810320000000))*(cj1)*(sj1)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-16.0000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))*((sj1)*(sj1))))+(((IkReal(1.76000000000000))*(cj1)*(pz)*(r02)*(sj1)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.115810320000000))*(cj1)*(px)*(pz)*(r00)*(r02)*(sj1)))+(((IkReal(3.52000000000000))*(cj0)*(cj1)*(px)*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(8.00000000000000))*(py)*(pz)*(sj0)*((cj1)*(cj1))*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.0836000000000000))*(cj1)*(pp)*(r02)))+(((IkReal(0.167200000000000))*(cj0)*(cj1)*(px)*(pz)*(r01)*(sj0)))+(((IkReal(-0.0164340196000000))*(cj0)*(py)*(r00)*(r01)*(sj1)))+(((IkReal(-0.0968000000000000))*(py)*(pz)*(sj0)*((sj1)*(sj1))))+(((IkReal(-0.0864948400000000))*(cj0)*(px)*(py)*(r01)*(r02)*((cj1)*(cj1))))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(px)*(pz)*((cj1)*(cj1))*((r02)*(r02))))+(((IkReal(-4.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r01)*((cj1)*(cj1))))+(((IkReal(0.00437458811134360))*(cj0)*(cj1)*(r00)*(r01)*(sj0)*(sj1)))+(((IkReal(8.00000000000000))*(cj0)*(px)*(pz)*((cj1)*(cj1))*((py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(px)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))*((sj1)*(sj1))))+(((IkReal(1.52000000000000))*(cj0)*(cj1)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-1.52000000000000))*(cj1)*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0222535676000000))*(pz)*(r01)*(sj0)*((cj1)*(cj1))))+(((IkReal(-16.0000000000000))*(cj1)*(px)*(r00)*(r01)*(sj1)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(16.0000000000000))*(cj0)*(px)*(py)*(r01)*(r02)*((cj1)*(cj1))*((pz)*(pz))))+(((IkReal(-1.52000000000000))*(cj0)*(cj1)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(16.0000000000000))*(cj1)*(py)*(r01)*(r02)*(sj1)*((pz)*(pz)*(pz))))+(((IkReal(8.00000000000000))*(py)*(sj0)*((cj1)*(cj1))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(0.0836000000000000))*(cj0)*(pp)*(r00)*(sj1)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break;
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
evalcond[0]=((IkReal(-0.0418000000000000))+(((IkReal(-0.658000000000000))*(pz)*(r01)*(sj0)*(IKsin(j2))))+(((IkReal(-0.380000000000000))*(py)*(r01)*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(px)*(pz)*(r02)*(sj1)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(cj1)*(px)*(py)*(r01)))+(((IkReal(-2.00000000000000))*(py)*(pz)*(r02)*(sj0)*(sj1)*(IKsin(j2))))+(((IkReal(0.658000000000000))*(cj0)*(px)*(r02)*(IKsin(j2))))+(((IkReal(2.00000000000000))*(cj1)*(py)*(pz)*(r01)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj1)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.00000000000000))*(cj1)*(pp)*(r01)*(sj0)*(IKcos(j2))))+(((cj0)*(pp)*(r00)*(sj1)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(cj1)*(px)*(pz)*(r02)))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(px)*(py)*(r01)*(IKcos(j2))))+(((IkReal(-0.380000000000000))*(px)*(r00)*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(px)*(py)*(r01)*(sj1)*(IKsin(j2))))+(((IkReal(0.0505762900000000))*(cj1)*(r01)*(sj0)*(IKcos(j2))))+(((IkReal(0.0505762900000000))*(r02)*(sj1)*(IKcos(j2))))+(((IkReal(0.220000000000000))*(pz)*(sj1)))+(((IkReal(0.0744437100000000))*(r01)*(sj0)*(sj1)*(IKsin(j2))))+(((IkReal(0.220000000000000))*(cj1)*(py)*(sj0)))+(((IkReal(-0.0505762900000000))*(cj1)*(r01)*(sj0)))+(((IkReal(-0.0505762900000000))*(r02)*(sj1)))+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(IKcos(j2))))+(((cj1)*(pp)*(r01)*(sj0)))+(((IkReal(0.0744437100000000))*(cj0)*(r00)*(sj1)*(IKsin(j2))))+(((pp)*(r02)*(sj1)))+(((IkReal(2.00000000000000))*(cj1)*(py)*(pz)*(r02)*(sj0)*(IKcos(j2))))+(((IkReal(-0.220000000000000))*(pz)*(sj1)*(IKcos(j2))))+(((pp)*(r01)*(sj0)*(sj1)*(IKsin(j2))))+(((IkReal(0.0505762900000000))*(cj0)*(cj1)*(r00)*(IKcos(j2))))+(((IkReal(-0.0505762900000000))*(cj0)*(cj1)*(r00)))+(((IkReal(-2.00000000000000))*(r01)*(sj0)*(sj1)*((py)*(py))*(IKsin(j2))))+(((IkReal(-0.220000000000000))*(cj0)*(cj1)*(px)*(IKcos(j2))))+(((IkReal(-0.380000000000000))*(pz)*(r02)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(px)*(pz)*(r00)*(sj1)*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(pp)*(r02)*(sj1)*(IKcos(j2))))+(((IkReal(0.658000000000000))*(py)*(r02)*(sj0)*(IKsin(j2))))+(((IkReal(0.380000000000000))*(px)*(r00)))+(((IkReal(-0.220000000000000))*(cj1)*(py)*(sj0)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(r00)*((px)*(px))*(IKcos(j2))))+(((cj0)*(cj1)*(pp)*(r00)))+(((IkReal(2.00000000000000))*(py)*(pz)*(r01)*(sj1)*(IKcos(j2))))+(((IkReal(0.220000000000000))*(py)*(sj0)*(sj1)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(px)*(py)*(r00)*(sj0)*(sj1)*(IKsin(j2))))+(((IkReal(2.00000000000000))*(cj1)*(r02)*((pz)*(pz))*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(px)*(pz)*(r00)*(sj1)))+(((IkReal(-2.00000000000000))*(py)*(pz)*(r01)*(sj1)))+(((IkReal(2.00000000000000))*(r02)*(sj1)*((pz)*(pz))*(IKcos(j2))))+(((IkReal(0.220000000000000))*(cj0)*(px)*(sj1)*(IKsin(j2))))+(((IkReal(0.220000000000000))*(cj0)*(cj1)*(px)))+(((IkReal(-0.220000000000000))*(cj1)*(pz)*(IKsin(j2))))+(((IkReal(-0.658000000000000))*(cj0)*(pz)*(r00)*(IKsin(j2))))+(((IkReal(0.0418000000000000))*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(px)*(py)*(r00)*(sj0)*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(cj1)*(px)*(py)*(r00)*(sj0)))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(px)*(pz)*(r02)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(r01)*(sj0)*((py)*(py))*(IKcos(j2))))+(((IkReal(0.380000000000000))*(py)*(r01)))+(((IkReal(-0.0744437100000000))*(cj1)*(r02)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj1)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(-2.00000000000000))*(cj0)*(cj1)*(r00)*((px)*(px))))+(((IkReal(2.00000000000000))*(cj1)*(px)*(pz)*(r00)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-1.00000000000000))*(cj1)*(pp)*(r02)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(sj1)*((px)*(px))*(IKsin(j2))))+(((IkReal(0.380000000000000))*(pz)*(r02))));
evalcond[1]=((IkReal(0.0418000000000000))+(((IkReal(-0.380000000000000))*(py)*(r01)*(IKcos(j2))))+(((IkReal(0.0505762900000000))*(cj1)*(r01)*(sj0)))+(((IkReal(-2.00000000000000))*(cj0)*(px)*(pz)*(r02)*(sj1)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(py)*(pz)*(r02)*(sj0)*(sj1)*(IKsin(j2))))+(((IkReal(0.0505762900000000))*(cj0)*(cj1)*(r00)))+(((IkReal(2.00000000000000))*(cj1)*(py)*(pz)*(r01)*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(cj1)*(pp)*(r01)*(sj0)*(IKcos(j2))))+(((cj0)*(pp)*(r00)*(sj1)*(IKsin(j2))))+(((IkReal(2.00000000000000))*(cj1)*(py)*(pz)*(r02)*(sj0)))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(px)*(py)*(r01)*(IKcos(j2))))+(((IkReal(-0.0311962900000000))*(cj0)*(r00)*(sj1)*(IKsin(j2))))+(((IkReal(2.00000000000000))*(r02)*(sj1)*((pz)*(pz))))+(((IkReal(-0.380000000000000))*(px)*(r00)*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(px)*(py)*(r01)*(sj1)*(IKsin(j2))))+(((IkReal(0.0505762900000000))*(cj1)*(r01)*(sj0)*(IKcos(j2))))+(((IkReal(0.0311962900000000))*(cj1)*(r02)*(IKsin(j2))))+(((IkReal(0.0505762900000000))*(r02)*(sj1)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(px)*(pz)*(r02)))+(((IkReal(2.00000000000000))*(cj1)*(py)*(pz)*(r02)*(sj0)*(IKcos(j2))))+(((IkReal(-0.220000000000000))*(pz)*(sj1)*(IKcos(j2))))+(((IkReal(-0.380000000000000))*(py)*(r01)))+(((pp)*(r01)*(sj0)*(sj1)*(IKsin(j2))))+(((IkReal(0.102000000000000))*(cj0)*(px)*(r02)*(IKsin(j2))))+(((IkReal(0.0505762900000000))*(cj0)*(cj1)*(r00)*(IKcos(j2))))+(((IkReal(0.0505762900000000))*(r02)*(sj1)))+(((IkReal(-2.00000000000000))*(r01)*(sj0)*(sj1)*((py)*(py))*(IKsin(j2))))+(((IkReal(-0.220000000000000))*(cj0)*(cj1)*(px)*(IKcos(j2))))+(((IkReal(-0.380000000000000))*(pz)*(r02)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(px)*(pz)*(r00)*(sj1)*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(pp)*(r02)*(sj1)*(IKcos(j2))))+(((IkReal(-0.220000000000000))*(cj1)*(py)*(sj0)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(r00)*((px)*(px))*(IKcos(j2))))+(((IkReal(2.00000000000000))*(py)*(pz)*(r01)*(sj1)*(IKcos(j2))))+(((IkReal(0.220000000000000))*(py)*(sj0)*(sj1)*(IKsin(j2))))+(((IkReal(-0.380000000000000))*(pz)*(r02)))+(((IkReal(2.00000000000000))*(py)*(pz)*(r01)*(sj1)))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(px)*(py)*(r01)))+(((IkReal(-2.00000000000000))*(px)*(py)*(r00)*(sj0)*(sj1)*(IKsin(j2))))+(((IkReal(-0.220000000000000))*(cj0)*(cj1)*(px)))+(((IkReal(-0.220000000000000))*(pz)*(sj1)))+(((IkReal(2.00000000000000))*(cj1)*(r02)*((pz)*(pz))*(IKsin(j2))))+(((IkReal(2.00000000000000))*(r02)*(sj1)*((pz)*(pz))*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(r00)*((px)*(px))))+(((IkReal(-0.102000000000000))*(cj0)*(pz)*(r00)*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(pp)*(r00)))+(((IkReal(0.220000000000000))*(cj0)*(px)*(sj1)*(IKsin(j2))))+(((IkReal(-0.220000000000000))*(cj1)*(pz)*(IKsin(j2))))+(((IkReal(-0.102000000000000))*(pz)*(r01)*(sj0)*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(pp)*(r02)*(sj1)))+(((IkReal(0.102000000000000))*(py)*(r02)*(sj0)*(IKsin(j2))))+(((IkReal(0.0418000000000000))*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(px)*(py)*(r00)*(sj0)))+(((IkReal(2.00000000000000))*(cj1)*(px)*(py)*(r00)*(sj0)*(IKcos(j2))))+(((IkReal(-0.220000000000000))*(cj1)*(py)*(sj0)))+(((IkReal(-0.0311962900000000))*(r01)*(sj0)*(sj1)*(IKsin(j2))))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(px)*(pz)*(r02)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(r01)*(sj0)*((py)*(py))*(IKcos(j2))))+(((IkReal(2.00000000000000))*(px)*(pz)*(r00)*(sj1)))+(((IkReal(2.00000000000000))*(cj1)*(px)*(pz)*(r00)*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(cj1)*(pp)*(r02)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(sj1)*((px)*(px))*(IKsin(j2))))+(((IkReal(-0.380000000000000))*(px)*(r00)))+(((IkReal(-1.00000000000000))*(cj1)*(pp)*(r01)*(sj0))));
evalcond[2]=((((IkReal(-2.00000000000000))*(cj0)*(px)*(py)*(r01)*(sj1)))+(((IkReal(0.0744437100000000))*(r01)*(sj0)*(sj1)*(IKcos(j2))))+(((IkReal(-0.0744437100000000))*(cj1)*(r02)*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(px)*(pz)*(r02)*(sj1)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(py)*(pz)*(r01)))+(((IkReal(0.0744437100000000))*(cj0)*(r00)*(sj1)*(IKcos(j2))))+(((IkReal(0.658000000000000))*(cj0)*(px)*(r02)*(IKcos(j2))))+(((IkReal(0.220000000000000))*(py)*(sj0)*(sj1)*(IKcos(j2))))+(((IkReal(0.220000000000000))*(cj1)*(py)*(sj0)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(py)*(pz)*(r02)*(sj0)*(sj1)*(IKcos(j2))))+(((IkReal(0.220000000000000))*(cj0)*(px)*(sj1)*(IKcos(j2))))+(((IkReal(0.380000000000000))*(pz)*(r02)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(-2.00000000000000))*(cj1)*(px)*(py)*(r00)*(sj0)*(IKsin(j2))))+(((pp)*(r02)*(sj1)*(IKsin(j2))))+(((cj0)*(pp)*(r00)*(sj1)))+(((IkReal(0.0744437100000000))*(r01)*(sj0)*(sj1)))+(((IkReal(-0.658000000000000))*(cj0)*(pz)*(r00)))+(((IkReal(-2.00000000000000))*(r02)*(sj1)*((pz)*(pz))*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(sj1)*((px)*(px))))+(((IkReal(-0.0505762900000000))*(cj1)*(r01)*(sj0)*(IKsin(j2))))+(((IkReal(0.658000000000000))*(py)*(r02)*(sj0)))+(((IkReal(2.00000000000000))*(cj1)*(r02)*((pz)*(pz))*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(py)*(pz)*(r02)*(sj0)*(sj1)))+(((IkReal(0.220000000000000))*(py)*(sj0)*(sj1)))+(((pp)*(r01)*(sj0)*(sj1)*(IKcos(j2))))+(((IkReal(0.220000000000000))*(pz)*(sj1)*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(cj1)*(pp)*(r02)*(IKcos(j2))))+(((IkReal(0.0744437100000000))*(cj0)*(r00)*(sj1)))+(((cj0)*(pp)*(r00)*(sj1)*(IKcos(j2))))+(((IkReal(0.658000000000000))*(cj0)*(px)*(r02)))+(((IkReal(-0.220000000000000))*(cj1)*(pz)*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(cj1)*(px)*(pz)*(r02)*(IKsin(j2))))+(((IkReal(-0.0505762900000000))*(cj0)*(cj1)*(r00)*(IKsin(j2))))+(((pp)*(r01)*(sj0)*(sj1)))+(((cj1)*(pp)*(r01)*(sj0)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(py)*(pz)*(r01)*(sj1)*(IKsin(j2))))+(((cj0)*(cj1)*(pp)*(r00)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(cj1)*(px)*(py)*(r01)*(IKsin(j2))))+(((IkReal(-0.0744437100000000))*(cj1)*(r02)))+(((IkReal(-0.0418000000000000))*(IKsin(j2))))+(((IkReal(-0.220000000000000))*(cj1)*(pz)))+(((IkReal(-2.00000000000000))*(px)*(py)*(r00)*(sj0)*(sj1)))+(((IkReal(2.00000000000000))*(cj1)*(px)*(pz)*(r00)*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(cj1)*(r00)*((px)*(px))*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(px)*(pz)*(r00)*(sj1)*(IKsin(j2))))+(((IkReal(0.380000000000000))*(py)*(r01)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj1)*(py)*(pz)*(r02)*(sj0)*(IKsin(j2))))+(((IkReal(-0.0505762900000000))*(r02)*(sj1)*(IKsin(j2))))+(((IkReal(-0.658000000000000))*(cj0)*(pz)*(r00)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(py)*(pz)*(r01)*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(sj1)*((px)*(px))*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(px)*(py)*(r00)*(sj0)*(sj1)*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(cj1)*(pp)*(r02)))+(((IkReal(2.00000000000000))*(cj1)*(px)*(pz)*(r00)))+(((IkReal(0.658000000000000))*(py)*(r02)*(sj0)*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(cj1)*(r01)*(sj0)*((py)*(py))*(IKsin(j2))))+(((IkReal(-0.658000000000000))*(pz)*(r01)*(sj0)))+(((IkReal(-2.00000000000000))*(cj0)*(px)*(py)*(r01)*(sj1)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(r02)*((pz)*(pz))))+(((IkReal(-2.00000000000000))*(cj0)*(px)*(pz)*(r02)*(sj1)))+(((IkReal(-2.00000000000000))*(r01)*(sj0)*(sj1)*((py)*(py))*(IKcos(j2))))+(((IkReal(-0.658000000000000))*(pz)*(r01)*(sj0)*(IKcos(j2))))+(((IkReal(0.220000000000000))*(cj0)*(cj1)*(px)*(IKsin(j2))))+(((IkReal(0.380000000000000))*(px)*(r00)*(IKsin(j2))))+(((IkReal(0.220000000000000))*(cj0)*(px)*(sj1))));
evalcond[3]=((((IkReal(2.00000000000000))*(r01)*(sj0)*(sj1)*((py)*(py))*(IKcos(j2))))+(((IkReal(0.0505762900000000))*(r02)*(sj1)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(px)*(py)*(r01)*(sj1)))+(((IkReal(0.0418000000000000))*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj1)*(py)*(pz)*(r01)*(IKcos(j2))))+(((IkReal(0.102000000000000))*(pz)*(r01)*(sj0)*(IKcos(j2))))+(((cj1)*(pp)*(r02)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(py)*(pz)*(r01)))+(((IkReal(2.00000000000000))*(px)*(py)*(r00)*(sj0)*(sj1)*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(cj0)*(pp)*(r00)*(sj1)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(r02)*(sj1)*((pz)*(pz))*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(r01)*(sj0)*(sj1)*((py)*(py))))+(((IkReal(0.102000000000000))*(cj0)*(px)*(r02)))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(r00)*((px)*(px))*(IKsin(j2))))+(((cj0)*(pp)*(r00)*(sj1)))+(((IkReal(2.00000000000000))*(cj0)*(px)*(py)*(r01)*(sj1)*(IKcos(j2))))+(((IkReal(-0.102000000000000))*(pz)*(r01)*(sj0)))+(((IkReal(-2.00000000000000))*(cj1)*(r02)*((pz)*(pz))*(IKcos(j2))))+(((IkReal(-0.380000000000000))*(pz)*(r02)*(IKsin(j2))))+(((IkReal(-0.102000000000000))*(py)*(r02)*(sj0)*(IKcos(j2))))+(((IkReal(0.0311962900000000))*(cj0)*(r00)*(sj1)*(IKcos(j2))))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(sj1)*((px)*(px))))+(((IkReal(2.00000000000000))*(px)*(pz)*(r00)*(sj1)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(py)*(pz)*(r02)*(sj0)*(sj1)))+(((IkReal(0.220000000000000))*(py)*(sj0)*(sj1)))+(((IkReal(0.0505762900000000))*(cj0)*(cj1)*(r00)*(IKsin(j2))))+(((IkReal(0.0505762900000000))*(cj1)*(r01)*(sj0)*(IKsin(j2))))+(((IkReal(-0.220000000000000))*(cj1)*(py)*(sj0)*(IKsin(j2))))+(((IkReal(-0.102000000000000))*(cj0)*(pz)*(r00)))+(((IkReal(0.220000000000000))*(cj1)*(pz)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(px)*(py)*(r00)*(sj0)*(IKsin(j2))))+(((IkReal(2.00000000000000))*(cj1)*(py)*(pz)*(r02)*(sj0)*(IKsin(j2))))+(((pp)*(r01)*(sj0)*(sj1)))+(((IkReal(-0.380000000000000))*(py)*(r01)*(IKsin(j2))))+(((IkReal(0.102000000000000))*(cj0)*(pz)*(r00)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(px)*(pz)*(r02)*(IKsin(j2))))+(((IkReal(0.0311962900000000))*(cj1)*(r02)))+(((IkReal(-0.102000000000000))*(cj0)*(px)*(r02)*(IKcos(j2))))+(((IkReal(-0.220000000000000))*(cj1)*(pz)))+(((IkReal(-2.00000000000000))*(px)*(py)*(r00)*(sj0)*(sj1)))+(((IkReal(-0.0311962900000000))*(cj0)*(r00)*(sj1)))+(((IkReal(-0.220000000000000))*(cj0)*(px)*(sj1)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(r01)*(sj0)*((py)*(py))*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(pp)*(r01)*(sj0)*(sj1)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj0)*(px)*(pz)*(r02)*(sj1)*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(cj1)*(pp)*(r01)*(sj0)*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(pp)*(r00)*(IKsin(j2))))+(((IkReal(-0.220000000000000))*(cj0)*(cj1)*(px)*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(pp)*(r02)*(sj1)*(IKsin(j2))))+(((IkReal(2.00000000000000))*(py)*(pz)*(r02)*(sj0)*(sj1)*(IKcos(j2))))+(((IkReal(0.102000000000000))*(py)*(r02)*(sj0)))+(((IkReal(2.00000000000000))*(cj0)*(r00)*(sj1)*((px)*(px))*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(cj1)*(pp)*(r02)))+(((IkReal(-0.0311962900000000))*(r01)*(sj0)*(sj1)))+(((IkReal(2.00000000000000))*(cj1)*(px)*(pz)*(r00)))+(((IkReal(2.00000000000000))*(cj0)*(cj1)*(px)*(py)*(r01)*(IKsin(j2))))+(((IkReal(-0.220000000000000))*(py)*(sj0)*(sj1)*(IKcos(j2))))+(((IkReal(-0.0311962900000000))*(cj1)*(r02)*(IKcos(j2))))+(((IkReal(0.0311962900000000))*(r01)*(sj0)*(sj1)*(IKcos(j2))))+(((IkReal(2.00000000000000))*(cj1)*(r02)*((pz)*(pz))))+(((IkReal(-2.00000000000000))*(cj0)*(px)*(pz)*(r02)*(sj1)))+(((IkReal(2.00000000000000))*(py)*(pz)*(r01)*(sj1)*(IKsin(j2))))+(((IkReal(-0.380000000000000))*(px)*(r00)*(IKsin(j2))))+(((IkReal(-0.220000000000000))*(pz)*(sj1)*(IKsin(j2))))+(((IkReal(-2.00000000000000))*(cj1)*(px)*(pz)*(r00)*(IKcos(j2))))+(((IkReal(0.220000000000000))*(cj0)*(px)*(sj1))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst1;
gconst1=IKsign(((((IkReal(2169729.00000000))*((sj2)*(sj2)*(sj2)*(sj2))))+(((IkReal(2169729.00000000))*((cj2)*(cj2))*((sj2)*(sj2))))));
dummyeval[0]=(((sj2)*(sj2)*(sj2)*(sj2))+((((cj2)*(cj2))*((sj2)*(sj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
sj4array[0]=((((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01))));
if( sj4array[0] >= -1-IKFAST_SINCOS_THRESH && sj4array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j4valid[0] = j4valid[1] = true;
    j4array[0] = IKasin(sj4array[0]);
    cj4array[0] = IKcos(j4array[0]);
    sj4array[1] = sj4array[0];
    j4array[1] = j4array[0] > 0 ? (IKPI-j4array[0]) : (-IKPI-j4array[0]);
    cj4array[1] = -cj4array[0];
}
else if( std::isnan(sj4array[0]) )
{
    // probably any value will work
    j4valid[0] = true;
    cj4array[0] = 1; sj4array[0] = 0; j4array[0] = 0;
}
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break;
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[1];
evalcond[0]=((((IkReal(0.110000000000000))*(IKsin(j4))))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(py))));
if( IKabs(evalcond[0]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst2;
gconst2=IKsign(((((cj4)*((cj2)*(cj2))))+(((cj4)*((sj2)*(sj2))))));
dummyeval[0]=((((cj4)*((cj2)*(cj2))))+(((cj4)*((sj2)*(sj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x33=((IkReal(0.147300000000000))*(cj4));
gconst3=IKsign(((((IkReal(-1.00000000000000))*(x33)*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*(x33)*((cj2)*(cj2))))));
IkReal x34=((IkReal(1.00000000000000))*(cj4));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x34)*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*(x34)*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x35=((IkReal(1.00000000000000))*(cj0));
IkReal x36=((r01)*(sj0));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(1.00000000000000))+(((r00)*(sj0)))+(((IkReal(-1.00000000000000))*(r01)*(x35))));
evalcond[2]=((IkReal(0.110000000000000))+(((IkReal(-1.00000000000000))*(py)*(x35)))+(((px)*(sj0))));
evalcond[3]=((((cj1)*(x36)))+(((cj0)*(cj1)*(r00)))+(((r02)*(sj1))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(sj1)*(x35)))+(((cj1)*(r02)))+(((IkReal(-1.00000000000000))*(sj1)*(x36))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign(((((IkReal(1473.00000000000))*((sj2)*(sj2))))+(((IkReal(1473.00000000000))*((cj2)*(cj2))))));
dummyeval[0]=(((sj2)*(sj2))+((cj2)*(cj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x37=((IkReal(10000.0000000000))*(pz));
IkReal x38=((sj1)*(sj2));
IkReal x39=((cj1)*(cj2));
IkReal x40=((cj1)*(sj2));
IkReal x41=((cj2)*(sj1));
IkReal x42=((IkReal(10000.0000000000))*(py)*(sj0));
IkReal x43=((IkReal(10000.0000000000))*(cj0)*(px));
if( IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(x37)*(x39)))+(((x41)*(x42)))+(((x41)*(x43)))+(((x37)*(x38)))+(((x40)*(x42)))+(((x40)*(x43)))+(((IkReal(-1900.00000000000))*(sj2))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((IkReal(-1390.00000000000))*((cj2)*(cj2))))+(((IkReal(-1900.00000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(x38)*(x42)))+(((IkReal(-1.00000000000000))*(x38)*(x43)))+(((x37)*(x40)))+(((x37)*(x41)))+(((x39)*(x42)))+(((x39)*(x43)))+(((IkReal(-1390.00000000000))*((sj2)*(sj2)))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst4)*(((((IkReal(-1.00000000000000))*(x37)*(x39)))+(((x41)*(x42)))+(((x41)*(x43)))+(((x37)*(x38)))+(((x40)*(x42)))+(((x40)*(x43)))+(((IkReal(-1900.00000000000))*(sj2)))))), ((gconst4)*(((((IkReal(-1390.00000000000))*((cj2)*(cj2))))+(((IkReal(-1900.00000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(x38)*(x42)))+(((IkReal(-1.00000000000000))*(x38)*(x43)))+(((x37)*(x40)))+(((x37)*(x41)))+(((x39)*(x42)))+(((x39)*(x43)))+(((IkReal(-1390.00000000000))*((sj2)*(sj2))))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break;
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x44=IKsin(j3);
IkReal x45=IKcos(j3);
IkReal x46=((py)*(sj0));
IkReal x47=((IkReal(1.00000000000000))*(sj1));
IkReal x48=((cj0)*(px));
IkReal x49=((IkReal(0.147300000000000))*(x45));
IkReal x50=((IkReal(0.147300000000000))*(x44));
evalcond[0]=((IkReal(-0.190000000000000))+(((cj1)*(x48)))+(((cj1)*(x46)))+(((IkReal(-1.00000000000000))*(cj2)*(x49)))+(((IkReal(-1.00000000000000))*(sj2)*(x50)))+(((pz)*(sj1)))+(((IkReal(-0.139000000000000))*(cj2))));
evalcond[1]=((((cj2)*(x50)))+(((cj1)*(pz)))+(((IkReal(-0.139000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(sj2)*(x49)))+(((IkReal(-1.00000000000000))*(x47)*(x48)))+(((IkReal(-1.00000000000000))*(x46)*(x47))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x51=((IkReal(1.00000000000000))*(cj0));
IkReal x52=((r01)*(sj0));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(-1.00000000000000))+(((r00)*(sj0)))+(((IkReal(-1.00000000000000))*(r01)*(x51))));
evalcond[2]=((IkReal(-0.110000000000000))+(((px)*(sj0)))+(((IkReal(-1.00000000000000))*(py)*(x51))));
evalcond[3]=((((cj1)*(x52)))+(((cj0)*(cj1)*(r00)))+(((r02)*(sj1))));
evalcond[4]=((((cj1)*(r02)))+(((IkReal(-1.00000000000000))*(sj1)*(x52)))+(((IkReal(-1.00000000000000))*(r00)*(sj1)*(x51))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst5;
gconst5=IKsign(((((IkReal(1473.00000000000))*((sj2)*(sj2))))+(((IkReal(1473.00000000000))*((cj2)*(cj2))))));
dummyeval[0]=(((sj2)*(sj2))+((cj2)*(cj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x53=((IkReal(10000.0000000000))*(pz));
IkReal x54=((sj1)*(sj2));
IkReal x55=((cj1)*(cj2));
IkReal x56=((cj1)*(sj2));
IkReal x57=((cj2)*(sj1));
IkReal x58=((IkReal(10000.0000000000))*(py)*(sj0));
IkReal x59=((IkReal(10000.0000000000))*(cj0)*(px));
if( IKabs(((gconst5)*(((((IkReal(-1.00000000000000))*(x53)*(x55)))+(((x57)*(x58)))+(((x57)*(x59)))+(((x53)*(x54)))+(((x56)*(x58)))+(((x56)*(x59)))+(((IkReal(-1900.00000000000))*(sj2))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((((IkReal(-1390.00000000000))*((cj2)*(cj2))))+(((IkReal(-1900.00000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(x54)*(x59)))+(((IkReal(-1.00000000000000))*(x54)*(x58)))+(((IkReal(-1390.00000000000))*((sj2)*(sj2))))+(((x53)*(x56)))+(((x53)*(x57)))+(((x55)*(x58)))+(((x55)*(x59))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst5)*(((((IkReal(-1.00000000000000))*(x53)*(x55)))+(((x57)*(x58)))+(((x57)*(x59)))+(((x53)*(x54)))+(((x56)*(x58)))+(((x56)*(x59)))+(((IkReal(-1900.00000000000))*(sj2)))))), ((gconst5)*(((((IkReal(-1390.00000000000))*((cj2)*(cj2))))+(((IkReal(-1900.00000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(x54)*(x59)))+(((IkReal(-1.00000000000000))*(x54)*(x58)))+(((IkReal(-1390.00000000000))*((sj2)*(sj2))))+(((x53)*(x56)))+(((x53)*(x57)))+(((x55)*(x58)))+(((x55)*(x59)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break;
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x60=IKsin(j3);
IkReal x61=IKcos(j3);
IkReal x62=((py)*(sj0));
IkReal x63=((IkReal(1.00000000000000))*(sj1));
IkReal x64=((cj0)*(px));
IkReal x65=((IkReal(0.147300000000000))*(x61));
IkReal x66=((IkReal(0.147300000000000))*(x60));
evalcond[0]=((IkReal(-0.190000000000000))+(((cj1)*(x62)))+(((cj1)*(x64)))+(((IkReal(-1.00000000000000))*(sj2)*(x66)))+(((pz)*(sj1)))+(((IkReal(-1.00000000000000))*(cj2)*(x65)))+(((IkReal(-0.139000000000000))*(cj2))));
evalcond[1]=((((cj1)*(pz)))+(((IkReal(-0.139000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(sj2)*(x65)))+(((IkReal(-1.00000000000000))*(x63)*(x64)))+(((cj2)*(x66)))+(((IkReal(-1.00000000000000))*(x62)*(x63))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x67=((cj1)*(cj4));
IkReal x68=((IkReal(0.110000000000000))*(sj2));
IkReal x69=((cj0)*(r00));
IkReal x70=((cj2)*(sj0));
IkReal x71=((IkReal(1.00000000000000))*(py));
IkReal x72=((cj2)*(cj4));
IkReal x73=((r02)*(sj1));
IkReal x74=((IkReal(0.147300000000000))*(cj1));
IkReal x75=((cj4)*(sj2));
IkReal x76=((sj0)*(sj2));
IkReal x77=((IkReal(1.00000000000000))*(pz)*(sj1));
IkReal x78=((IkReal(1.00000000000000))*(cj0)*(px));
if( IKabs(((gconst3)*(((((IkReal(-1.00000000000000))*(sj2)*(x67)*(x78)))+(((r01)*(sj0)*(x67)*(x68)))+(((IkReal(-0.147300000000000))*(cj2)*(x73)))+(((IkReal(-1.00000000000000))*(r01)*(x70)*(x74)))+(((cj4)*(x68)*(x73)))+(((IkReal(0.139000000000000))*(sj2)*(x72)))+(((IkReal(-1.00000000000000))*(x67)*(x71)*(x76)))+(((IkReal(0.190000000000000))*(x75)))+(((IkReal(-1.00000000000000))*(cj2)*(x69)*(x74)))+(((x67)*(x68)*(x69)))+(((IkReal(-1.00000000000000))*(x75)*(x77))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((sj2)*(x69)*(x74)))+(((IkReal(0.110000000000000))*(x72)*(x73)))+(((r01)*(x74)*(x76)))+(((IkReal(0.110000000000000))*(r01)*(x67)*(x70)))+(((IkReal(0.139000000000000))*(cj2)*(x72)))+(((IkReal(-1.00000000000000))*(x67)*(x70)*(x71)))+(((IkReal(0.110000000000000))*(cj2)*(x67)*(x69)))+(((IkReal(-1.00000000000000))*(cj2)*(x67)*(x78)))+(((IkReal(0.147300000000000))*(sj2)*(x73)))+(((IkReal(-1.00000000000000))*(x72)*(x77)))+(((IkReal(0.190000000000000))*(x72))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst3)*(((((IkReal(-1.00000000000000))*(sj2)*(x67)*(x78)))+(((r01)*(sj0)*(x67)*(x68)))+(((IkReal(-0.147300000000000))*(cj2)*(x73)))+(((IkReal(-1.00000000000000))*(r01)*(x70)*(x74)))+(((cj4)*(x68)*(x73)))+(((IkReal(0.139000000000000))*(sj2)*(x72)))+(((IkReal(-1.00000000000000))*(x67)*(x71)*(x76)))+(((IkReal(0.190000000000000))*(x75)))+(((IkReal(-1.00000000000000))*(cj2)*(x69)*(x74)))+(((x67)*(x68)*(x69)))+(((IkReal(-1.00000000000000))*(x75)*(x77)))))), ((gconst3)*(((((sj2)*(x69)*(x74)))+(((IkReal(0.110000000000000))*(x72)*(x73)))+(((r01)*(x74)*(x76)))+(((IkReal(0.110000000000000))*(r01)*(x67)*(x70)))+(((IkReal(0.139000000000000))*(cj2)*(x72)))+(((IkReal(-1.00000000000000))*(x67)*(x70)*(x71)))+(((IkReal(0.110000000000000))*(cj2)*(x67)*(x69)))+(((IkReal(-1.00000000000000))*(cj2)*(x67)*(x78)))+(((IkReal(0.147300000000000))*(sj2)*(x73)))+(((IkReal(-1.00000000000000))*(x72)*(x77)))+(((IkReal(0.190000000000000))*(x72)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break;
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x79=IKcos(j3);
IkReal x80=IKsin(j3);
IkReal x81=((IkReal(0.147300000000000))*(sj2));
IkReal x82=((r01)*(sj0));
IkReal x83=((IkReal(1.00000000000000))*(sj1));
IkReal x84=((cj0)*(cj1));
IkReal x85=((IkReal(0.110000000000000))*(cj4));
IkReal x86=((py)*(sj0));
IkReal x87=((IkReal(1.00000000000000))*(cj4));
IkReal x88=((cj2)*(x79));
IkReal x89=((cj2)*(x80));
IkReal x90=((sj2)*(x79));
IkReal x91=((x80)*(x85));
evalcond[0]=((((r00)*(x84)))+(((r02)*(sj1)))+(((IkReal(-1.00000000000000))*(x87)*(x89)))+(((cj4)*(x90)))+(((cj1)*(x82))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x82)*(x83)))+(((cj1)*(r02)))+(((IkReal(-1.00000000000000))*(sj2)*(x80)*(x87)))+(((IkReal(-1.00000000000000))*(x87)*(x88)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x83))));
evalcond[2]=((IkReal(-0.190000000000000))+(((IkReal(-1.00000000000000))*(x80)*(x81)))+(((x85)*(x90)))+(((px)*(x84)))+(((IkReal(-0.147300000000000))*(x88)))+(((pz)*(sj1)))+(((cj1)*(x86)))+(((IkReal(-1.00000000000000))*(x85)*(x89)))+(((IkReal(-0.139000000000000))*(cj2))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj2)*(x91)))+(((IkReal(-1.00000000000000))*(cj0)*(px)*(x83)))+(((IkReal(-1.00000000000000))*(x83)*(x86)))+(((cj1)*(pz)))+(((IkReal(-1.00000000000000))*(x79)*(x81)))+(((IkReal(-0.139000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(x85)*(x88)))+(((IkReal(0.147300000000000))*(x89))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x92=((IkReal(1.00000000000000))*(sj1));
IkReal x93=((r02)*(sj2));
IkReal x94=((r01)*(sj0));
IkReal x95=((IkReal(1.00000000000000))*(sj2));
IkReal x96=((cj0)*(r00));
IkReal x97=((cj2)*(r02));
IkReal x98=((cj1)*(x96));
if( IKabs(((gconst2)*(((((cj2)*(x98)))+(((sj1)*(x97)))+(((IkReal(-1.00000000000000))*(sj2)*(x92)*(x94)))+(((IkReal(-1.00000000000000))*(sj2)*(x92)*(x96)))+(((cj1)*(x93)))+(((cj1)*(cj2)*(x94))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(x95)*(x98)))+(((IkReal(-1.00000000000000))*(cj2)*(x92)*(x96)))+(((IkReal(-1.00000000000000))*(cj2)*(x92)*(x94)))+(((IkReal(-1.00000000000000))*(cj1)*(x94)*(x95)))+(((IkReal(-1.00000000000000))*(x92)*(x93)))+(((cj1)*(x97))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst2)*(((((cj2)*(x98)))+(((sj1)*(x97)))+(((IkReal(-1.00000000000000))*(sj2)*(x92)*(x94)))+(((IkReal(-1.00000000000000))*(sj2)*(x92)*(x96)))+(((cj1)*(x93)))+(((cj1)*(cj2)*(x94)))))), ((gconst2)*(((((IkReal(-1.00000000000000))*(x95)*(x98)))+(((IkReal(-1.00000000000000))*(cj2)*(x92)*(x96)))+(((IkReal(-1.00000000000000))*(cj2)*(x92)*(x94)))+(((IkReal(-1.00000000000000))*(cj1)*(x94)*(x95)))+(((IkReal(-1.00000000000000))*(x92)*(x93)))+(((cj1)*(x97)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break;
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x99=IKcos(j3);
IkReal x100=IKsin(j3);
IkReal x101=((IkReal(0.147300000000000))*(sj2));
IkReal x102=((r01)*(sj0));
IkReal x103=((IkReal(1.00000000000000))*(sj1));
IkReal x104=((cj0)*(cj1));
IkReal x105=((IkReal(0.110000000000000))*(cj4));
IkReal x106=((py)*(sj0));
IkReal x107=((IkReal(1.00000000000000))*(cj4));
IkReal x108=((cj2)*(x99));
IkReal x109=((cj2)*(x100));
IkReal x110=((sj2)*(x99));
IkReal x111=((x100)*(x105));
evalcond[0]=((((cj1)*(x102)))+(((IkReal(-1.00000000000000))*(x107)*(x109)))+(((r02)*(sj1)))+(((r00)*(x104)))+(((cj4)*(x110))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x107)*(x108)))+(((cj1)*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x103)))+(((IkReal(-1.00000000000000))*(x102)*(x103)))+(((IkReal(-1.00000000000000))*(sj2)*(x100)*(x107))));
evalcond[2]=((IkReal(-0.190000000000000))+(((cj1)*(x106)))+(((IkReal(-1.00000000000000))*(x100)*(x101)))+(((px)*(x104)))+(((IkReal(-0.147300000000000))*(x108)))+(((pz)*(sj1)))+(((x105)*(x110)))+(((IkReal(-1.00000000000000))*(x105)*(x109)))+(((IkReal(-0.139000000000000))*(cj2))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj0)*(px)*(x103)))+(((IkReal(0.147300000000000))*(x109)))+(((cj1)*(pz)))+(((IkReal(-0.139000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(x101)*(x99)))+(((IkReal(-1.00000000000000))*(x103)*(x106)))+(((IkReal(-1.00000000000000))*(x105)*(x108)))+(((IkReal(-1.00000000000000))*(sj2)*(x111))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x112=(sj2)*(sj2);
IkReal x113=((IkReal(1.00000000000000))*(sj2));
IkReal x114=((cj0)*(px));
IkReal x115=((py)*(sj0));
IkReal x116=((cj2)*(sj2));
IkReal x117=((cj1)*(sj2));
IkReal x118=((IkReal(0.110000000000000))*(r02));
IkReal x119=((sj1)*(sj2));
IkReal x120=((IkReal(14730000.0000000))*(x112));
IkReal x121=((IkReal(0.110000000000000))*(cj0)*(r00));
IkReal x122=((IkReal(0.110000000000000))*(r01)*(sj0));
IkReal x123=((((IkReal(-1.00000000000000))*(x117)*(x118)))+(((pz)*(x117)))+(((IkReal(-0.139000000000000))*(x112)))+(((IkReal(-1.00000000000000))*(sj1)*(x113)*(x115)))+(((IkReal(-1.00000000000000))*(sj1)*(x113)*(x114)))+(((x119)*(x121)))+(((x119)*(x122))));
IkReal x124=((IkReal(14730000.0000000))*(x123));
IkReal x125=((((x117)*(x122)))+(((x117)*(x121)))+(((IkReal(0.139000000000000))*(x116)))+(((IkReal(-1.00000000000000))*(pz)*(sj1)*(x113)))+(((IkReal(-1.00000000000000))*(cj1)*(x113)*(x115)))+(((IkReal(-1.00000000000000))*(cj1)*(x113)*(x114)))+(((IkReal(0.190000000000000))*(sj2)))+(((x118)*(x119))));
if( IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(x120)*(x125)))+(((IkReal(-1.00000000000000))*(x116)*(x124))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst1)*(((((x120)*(x123)))+(((IkReal(-14730000.0000000))*(x116)*(((((x117)*(x122)))+(((x117)*(x121)))+(((IkReal(-1.00000000000000))*(pz)*(sj1)*(x113)))+(((IkReal(-1.00000000000000))*(cj1)*(x113)*(x115)))+(((IkReal(-1.00000000000000))*(cj1)*(x113)*(x114)))+(((IkReal(0.190000000000000))*(sj2)))+(((IkReal(0.139000000000000))*(cj2)*(sj2)))+(((x118)*(x119))))))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst1)*(((((IkReal(-1.00000000000000))*(x120)*(x125)))+(((IkReal(-1.00000000000000))*(x116)*(x124)))))), ((gconst1)*(((((x120)*(x123)))+(((IkReal(-14730000.0000000))*(x116)*(((((x117)*(x122)))+(((x117)*(x121)))+(((IkReal(-1.00000000000000))*(pz)*(sj1)*(x113)))+(((IkReal(-1.00000000000000))*(cj1)*(x113)*(x115)))+(((IkReal(-1.00000000000000))*(cj1)*(x113)*(x114)))+(((IkReal(0.190000000000000))*(sj2)))+(((IkReal(0.139000000000000))*(cj2)*(sj2)))+(((x118)*(x119)))))))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break;
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x126=(sj2)*(sj2);
IkReal x127=IKsin(j3);
IkReal x128=IKcos(j3);
IkReal x129=(cj2)*(cj2);
IkReal x130=((cj1)*(cj2));
IkReal x131=((IkReal(0.110000000000000))*(r02));
IkReal x132=((py)*(sj0));
IkReal x133=((cj1)*(sj2));
IkReal x134=((sj1)*(sj2));
IkReal x135=((cj2)*(sj2));
IkReal x136=((cj2)*(sj1));
IkReal x137=((IkReal(0.139000000000000))*(x135));
IkReal x138=((IkReal(0.147300000000000))*(x128));
IkReal x139=((IkReal(0.110000000000000))*(cj0)*(r00));
IkReal x140=((IkReal(0.110000000000000))*(r01)*(sj0));
IkReal x141=((IkReal(1.00000000000000))*(cj0)*(px));
IkReal x142=((IkReal(0.147300000000000))*(x127));
IkReal x143=((x135)*(x142));
IkReal x144=((x135)*(x138));
IkReal x145=((x144)+(x137));
evalcond[0]=((((IkReal(-0.139000000000000))*(x126)))+(((IkReal(-1.00000000000000))*(x134)*(x141)))+(((pz)*(x133)))+(((IkReal(-1.00000000000000))*(x126)*(x138)))+(x143)+(((x134)*(x139)))+(((IkReal(-1.00000000000000))*(x132)*(x134)))+(((x134)*(x140)))+(((IkReal(-1.00000000000000))*(x131)*(x133))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x145)))+(((x136)*(x140)))+(((pz)*(x130)))+(((x136)*(x139)))+(((x129)*(x142)))+(((IkReal(-1.00000000000000))*(x132)*(x136)))+(((IkReal(-1.00000000000000))*(x130)*(x131)))+(((IkReal(-1.00000000000000))*(x136)*(x141))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x143)))+(((IkReal(-0.139000000000000))*(x129)))+(((IkReal(-0.190000000000000))*(cj2)))+(((pz)*(x136)))+(((x130)*(x132)))+(((IkReal(-1.00000000000000))*(x129)*(x138)))+(((cj0)*(px)*(x130)))+(((IkReal(-1.00000000000000))*(x131)*(x136)))+(((IkReal(-1.00000000000000))*(x130)*(x139)))+(((IkReal(-1.00000000000000))*(x130)*(x140))));
evalcond[3]=((((x126)*(x142)))+(((IkReal(0.190000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(x133)*(x141)))+(x145)+(((x131)*(x134)))+(((IkReal(-1.00000000000000))*(pz)*(x134)))+(((IkReal(-1.00000000000000))*(x132)*(x133)))+(((x133)*(x139)))+(((x133)*(x140))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
dummyeval[0]=((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=((((IkReal(-1.00000000000000))*(cj2)*(sj3)))+(((cj3)*(sj2))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((((IkReal(-9.09090909090909))*(px)*(sj0)))+(((IkReal(9.09090909090909))*(cj0)*(py))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3))))) != 0)?((IkReal)1/(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3)))))):(IkReal)1.0e30))*(((((cj0)*(r00)*(sj1)))+(((r01)*(sj0)*(sj1)))+(((IkReal(-1.00000000000000))*(cj1)*(r02))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-9.09090909090909))*(px)*(sj0)))+(((IkReal(9.09090909090909))*(cj0)*(py)))))+IKsqr(((((IKabs(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3))))) != 0)?((IkReal)1/(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3)))))):(IkReal)1.0e30))*(((((cj0)*(r00)*(sj1)))+(((r01)*(sj0)*(sj1)))+(((IkReal(-1.00000000000000))*(cj1)*(r02)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j4array[0]=IKatan2(((((IkReal(-9.09090909090909))*(px)*(sj0)))+(((IkReal(9.09090909090909))*(cj0)*(py)))), ((((IKabs(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3))))) != 0)?((IkReal)1/(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3)))))):(IkReal)1.0e30))*(((((cj0)*(r00)*(sj1)))+(((r01)*(sj0)*(sj1)))+(((IkReal(-1.00000000000000))*(cj1)*(r02)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break;
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x146=IKsin(j4);
IkReal x147=IKcos(j4);
IkReal x148=((cj2)*(sj3));
IkReal x149=((IkReal(0.147300000000000))*(cj3));
IkReal x150=((IkReal(1.00000000000000))*(r01));
IkReal x151=((sj0)*(sj1));
IkReal x152=((IkReal(1.00000000000000))*(py));
IkReal x153=((cj0)*(r00));
IkReal x154=((sj2)*(sj3));
IkReal x155=((cj2)*(cj3));
IkReal x156=((cj1)*(sj0));
IkReal x157=((IkReal(1.00000000000000))*(sj1));
IkReal x158=((cj0)*(px));
IkReal x159=((cj3)*(sj2));
IkReal x160=((IkReal(0.110000000000000))*(x147));
IkReal x161=((IkReal(1.00000000000000))*(x147));
evalcond[0]=((((r00)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(x150)))+(x146));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj0)*(x152)))+(((IkReal(0.110000000000000))*(x146)))+(((px)*(sj0))));
evalcond[2]=((((r01)*(x156)))+(((r02)*(sj1)))+(((IkReal(-1.00000000000000))*(x148)*(x161)))+(((x147)*(x159)))+(((cj1)*(x153))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x154)*(x161)))+(((IkReal(-1.00000000000000))*(x153)*(x157)))+(((IkReal(-1.00000000000000))*(x150)*(x151)))+(((cj1)*(r02)))+(((IkReal(-1.00000000000000))*(x155)*(x161))));
evalcond[4]=((IkReal(-0.190000000000000))+(((IkReal(-0.147300000000000))*(x154)))+(((IkReal(-1.00000000000000))*(cj2)*(x149)))+(((IkReal(-1.00000000000000))*(x148)*(x160)))+(((pz)*(sj1)))+(((cj1)*(x158)))+(((x159)*(x160)))+(((IkReal(-0.139000000000000))*(cj2)))+(((py)*(x156))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x154)*(x160)))+(((IkReal(-1.00000000000000))*(x157)*(x158)))+(((IkReal(-1.00000000000000))*(x151)*(x152)))+(((cj1)*(pz)))+(((IkReal(0.147300000000000))*(x148)))+(((IkReal(-0.139000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(sj2)*(x149)))+(((IkReal(-1.00000000000000))*(x155)*(x160))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x162=((IkReal(1.00000000000000))*(cj1));
if( IKabs(((((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((((IkReal(-1.00000000000000))*(cj2)*(sj3)))+(((cj3)*(sj2))))) != 0)?((IkReal)1/(((((IkReal(-1.00000000000000))*(cj2)*(sj3)))+(((cj3)*(sj2)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r01)*(sj0)*(x162)))+(((IkReal(-1.00000000000000))*(r02)*(sj1)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x162))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01)))))+IKsqr(((((IKabs(((((IkReal(-1.00000000000000))*(cj2)*(sj3)))+(((cj3)*(sj2))))) != 0)?((IkReal)1/(((((IkReal(-1.00000000000000))*(cj2)*(sj3)))+(((cj3)*(sj2)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r01)*(sj0)*(x162)))+(((IkReal(-1.00000000000000))*(r02)*(sj1)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x162)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j4array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01)))), ((((IKabs(((((IkReal(-1.00000000000000))*(cj2)*(sj3)))+(((cj3)*(sj2))))) != 0)?((IkReal)1/(((((IkReal(-1.00000000000000))*(cj2)*(sj3)))+(((cj3)*(sj2)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r01)*(sj0)*(x162)))+(((IkReal(-1.00000000000000))*(r02)*(sj1)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x162)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break;
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x163=IKsin(j4);
IkReal x164=IKcos(j4);
IkReal x165=((cj2)*(sj3));
IkReal x166=((IkReal(0.147300000000000))*(cj3));
IkReal x167=((IkReal(1.00000000000000))*(r01));
IkReal x168=((sj0)*(sj1));
IkReal x169=((IkReal(1.00000000000000))*(py));
IkReal x170=((cj0)*(r00));
IkReal x171=((sj2)*(sj3));
IkReal x172=((cj2)*(cj3));
IkReal x173=((cj1)*(sj0));
IkReal x174=((IkReal(1.00000000000000))*(sj1));
IkReal x175=((cj0)*(px));
IkReal x176=((cj3)*(sj2));
IkReal x177=((IkReal(0.110000000000000))*(x164));
IkReal x178=((IkReal(1.00000000000000))*(x164));
evalcond[0]=((((r00)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(x167)))+(x163));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj0)*(x169)))+(((IkReal(0.110000000000000))*(x163)))+(((px)*(sj0))));
evalcond[2]=((((r01)*(x173)))+(((r02)*(sj1)))+(((x164)*(x176)))+(((cj1)*(x170)))+(((IkReal(-1.00000000000000))*(x165)*(x178))));
evalcond[3]=((((cj1)*(r02)))+(((IkReal(-1.00000000000000))*(x170)*(x174)))+(((IkReal(-1.00000000000000))*(x171)*(x178)))+(((IkReal(-1.00000000000000))*(x172)*(x178)))+(((IkReal(-1.00000000000000))*(x167)*(x168))));
evalcond[4]=((IkReal(-0.190000000000000))+(((py)*(x173)))+(((x176)*(x177)))+(((IkReal(-0.147300000000000))*(x171)))+(((IkReal(-1.00000000000000))*(cj2)*(x166)))+(((cj1)*(x175)))+(((pz)*(sj1)))+(((IkReal(-0.139000000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(x165)*(x177))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x174)*(x175)))+(((cj1)*(pz)))+(((IkReal(-1.00000000000000))*(x168)*(x169)))+(((IkReal(-1.00000000000000))*(x171)*(x177)))+(((IkReal(-0.139000000000000))*(sj2)))+(((IkReal(0.147300000000000))*(x165)))+(((IkReal(-1.00000000000000))*(sj2)*(x166)))+(((IkReal(-1.00000000000000))*(x172)*(x177))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3))))) != 0)?((IkReal)1/(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3)))))):(IkReal)1.0e30))*(((((cj0)*(r00)*(sj1)))+(((r01)*(sj0)*(sj1)))+(((IkReal(-1.00000000000000))*(cj1)*(r02))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01)))))+IKsqr(((((IKabs(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3))))) != 0)?((IkReal)1/(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3)))))):(IkReal)1.0e30))*(((((cj0)*(r00)*(sj1)))+(((r01)*(sj0)*(sj1)))+(((IkReal(-1.00000000000000))*(cj1)*(r02)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j4array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01)))), ((((IKabs(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3))))) != 0)?((IkReal)1/(((((IkReal(-1.00000000000000))*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(sj2)*(sj3)))))):(IkReal)1.0e30))*(((((cj0)*(r00)*(sj1)))+(((r01)*(sj0)*(sj1)))+(((IkReal(-1.00000000000000))*(cj1)*(r02)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break;
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x179=IKsin(j4);
IkReal x180=IKcos(j4);
IkReal x181=((cj2)*(sj3));
IkReal x182=((IkReal(0.147300000000000))*(cj3));
IkReal x183=((IkReal(1.00000000000000))*(r01));
IkReal x184=((sj0)*(sj1));
IkReal x185=((IkReal(1.00000000000000))*(py));
IkReal x186=((cj0)*(r00));
IkReal x187=((sj2)*(sj3));
IkReal x188=((cj2)*(cj3));
IkReal x189=((cj1)*(sj0));
IkReal x190=((IkReal(1.00000000000000))*(sj1));
IkReal x191=((cj0)*(px));
IkReal x192=((cj3)*(sj2));
IkReal x193=((IkReal(0.110000000000000))*(x180));
IkReal x194=((IkReal(1.00000000000000))*(x180));
evalcond[0]=((((r00)*(sj0)))+(((IkReal(-1.00000000000000))*(cj0)*(x183)))+(x179));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj0)*(x185)))+(((IkReal(0.110000000000000))*(x179)))+(((px)*(sj0))));
evalcond[2]=((((r01)*(x189)))+(((x180)*(x192)))+(((r02)*(sj1)))+(((cj1)*(x186)))+(((IkReal(-1.00000000000000))*(x181)*(x194))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x188)*(x194)))+(((IkReal(-1.00000000000000))*(x186)*(x190)))+(((cj1)*(r02)))+(((IkReal(-1.00000000000000))*(x187)*(x194)))+(((IkReal(-1.00000000000000))*(x183)*(x184))));
evalcond[4]=((IkReal(-0.190000000000000))+(((IkReal(-0.147300000000000))*(x187)))+(((x192)*(x193)))+(((cj1)*(x191)))+(((pz)*(sj1)))+(((IkReal(-1.00000000000000))*(cj2)*(x182)))+(((IkReal(-1.00000000000000))*(x181)*(x193)))+(((py)*(x189)))+(((IkReal(-0.139000000000000))*(cj2))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x188)*(x193)))+(((IkReal(-1.00000000000000))*(x190)*(x191)))+(((IkReal(-1.00000000000000))*(x187)*(x193)))+(((cj1)*(pz)))+(((IkReal(-1.00000000000000))*(x184)*(x185)))+(((IkReal(0.147300000000000))*(x181)))+(((IkReal(-0.139000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(sj2)*(x182))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}

}

}
    }

}

}
}
}
}
return solutions.GetNumSolutions()>0;
}
static inline void polyroots4(IkReal rawcoeffs[4+1], IkReal rawroots[4], int& numroots)
{
    using std::complex;
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[4];
    const int maxsteps = 110;
    for(int i = 0; i < 4; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[4];
    IkReal err[4];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 4; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 4; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 4; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 4; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[4] = {false};
    for(int i = 0; i < 4; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 4; ++j) {
                if( abs(roots[i]-roots[j]) < 8*tolsqrt ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "<robot:genericrobot - katana_450_6m90a (0ae658000dba03e5e2af5e0545d8ad48)>"; }

IKFAST_API const char* GetIkFastVersion() { return IKFAST_STRINGIZE(IKFAST_VERSION); }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
