// *****************************************************************************
//
// Copyright (c) 2014, Southwest Research Institute® (SwRI®)
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Southwest Research Institute® (SwRI®) nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// *****************************************************************************

#ifndef MAPVIZ_PLUGINS_PLAN_ROUTE_PLUGIN_H_
#define MAPVIZ_PLUGINS_PLAN_ROUTE_PLUGIN_H_

// C++ standard libraries
#include <string>
#include <vector>

#include <mapviz/mapviz_plugin.h>

// QT libraries
#include <QGLWidget>
#include <QObject>
#include <QWidget>

// ROS libraries
#include <ros/ros.h>
#include <tf/transform_datatypes.h>

// Mapviz libraries
#include <mapviz/map_canvas.h>
#include <swri_route_util/route.h>

// Messages
#include <geometry_msgs/Pose.h>
#include <marti_nav_msgs/Route.h>

// QT autogenerated files
#include "ui_plan_route_config.h"

namespace mapviz_plugins
{
  class PlanRoutePlugin : public mapviz::MapvizPlugin
  {
    Q_OBJECT

   public:

    PlanRoutePlugin();
    virtual ~PlanRoutePlugin();

    bool Initialize(QGLWidget* canvas);
    void Shutdown()
    {
    }

    void Draw(double x, double y, double scale);
    void Paint(QPainter* painter, double x, double y, double scale);

    void Transform() {};

    void LoadConfig(const YAML::Node& node, const std::string& path);
    void SaveConfig(YAML::Emitter& emitter, const std::string& path);

    QWidget* GetConfigWidget(QWidget* parent);

    bool SupportsPainting()
    {
      return true;
    }

   protected:
    void PrintError(const std::string& message);
    void PrintInfo(const std::string& message);
    void PrintWarning(const std::string& message);
    bool eventFilter(QObject *object, QEvent* event);
    bool handleMousePress(QMouseEvent *);
    bool handleMouseRelease(QMouseEvent *);
    bool handleMouseMove(QMouseEvent *);

   protected Q_SLOTS:
    void PublishRoute();
    void PlanRoute();
    void Clear();

   private:
    void Retry(const ros::TimerEvent& e);

    Ui::plan_route_config ui_;
    QWidget* config_widget_;
    mapviz::MapCanvas* map_canvas_;

    std::string route_topic_;

    ros::Publisher route_pub_;
    ros::Timer retry_timer_;

    bool failed_service_;
    swri_route_util::RoutePtr route_preview_;

    std::vector<geometry_msgs::Pose> waypoints_;

    int selected_point_;
    bool is_mouse_down_;
    QPointF mouse_down_pos_;
    qint64 mouse_down_time_;

    qint64 max_ms_;
    qreal max_distance_;
  };
}

#endif  // MAPVIZ_PLUGINS_PLAN_ROUTE_PLUGIN_H_
