/*******************************************************************************
 * Copyright (c) 2017 Nerian Vision Technologies
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *******************************************************************************/

#include <visiontransfer/imagetransfer.h>
#include <visiontransfer/imagepair.h>
#include <iostream>
#include <exception>
#include <stdio.h>

#ifdef _MSC_VER
// Visual studio does not come with snprintf
#define snprintf _snprintf_s
#endif

int main() {
    try {
        // Create an image transfer object that receives data from
        // the SP1 on the default port using UDP
        ImageTransfer imageTransfer(ImageTransfer::UDP, NULL, NULL,
            NULL, "7681");

        // Receive 100 images
        for(int i=0; i<100; i++) {
            std::cout << "Receiving image " << i << std::endl;

            // Receive image
            ImagePair imagePair;
            while(!imageTransfer.receiveImagePair(imagePair, true)) {
                // Keep on trying until reception is successful
            }

            // Write both images one after another
            for(int imageNumber = 0; imageNumber <=1; imageNumber++) {
                // Create PGM file
                char fileName[100];
                snprintf(fileName, sizeof(fileName), "image%03d_%d.pgm", i,
                    imageNumber);

                imagePair.writePgmFile(imageNumber, fileName);
            }
        }
    } catch(const std::exception& ex) {
        std::cerr << "Exception occurred: " << ex.what() << std::endl;
    }

    return 0;
}
