/*******************************************************************************
 * Copyright (c) 2019 Nerian Vision GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *******************************************************************************/

#ifndef VISIONTRANSFER_INTERNALINFORMATION_H
#define VISIONTRANSFER_INTERNALINFORMATION_H

namespace visiontransfer {
namespace internal {

/**
 * \brief Information that is required internally by different program
 * parts.
 */
struct InternalInformation {
#pragma pack(push,1)
    struct DiscoveryMessage {
        unsigned char protocolVersion;
        unsigned char proVersion;
        unsigned char useTcp;
        char firmwareVersion[14];
    };
#pragma pack(pop)

    static const char DISCOVERY_BROADCAST_MSG[16];
    static constexpr int DISCOVERY_BROADCAST_PORT = 7680;
    static constexpr unsigned char CURRENT_PROTOCOL_VERSION = 0x06;
};

}} // namespace

#endif
