/*******************************************************************************
 * Copyright (c) 2019 Nerian Vision GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *******************************************************************************/

#ifndef NVSHARED_FILEQUEUE_H
#define NVSHARED_FILEQUEUE_H

#include "imagequeue.h"
#include <vector>
#include <string>
#include <opencv2/opencv.hpp>


// Base class for all queues reading from image files
template <class T, typename U>
class BaseFileQueue: public ImageQueue<T> {
public:
    BaseFileQueue(const char* directory, int maxQueueSize, bool multiThreaded);
    virtual ~BaseFileQueue();

protected:
    virtual cv::Mat_<U> readNextFile();
    const char* getNextFileName();

private:
    bool threadInitialized;
    unsigned fileIndex;
    std::vector<std::string> imageFiles;
};

// Template for monocular image queues
template <class T>
class MonoFileQueue: public BaseFileQueue<typename MonoFrame<T>::Type, T > {
public:
    MonoFileQueue(const char* directory,
        int maxQueueSize = 1, bool multiThreaded = true)
        : BaseFileQueue<typename MonoFrame<T>::Type, T >(directory, maxQueueSize, multiThreaded) {}
    virtual ~MonoFileQueue();

protected:
    virtual void queueFrame();
};

// Template for stereo image queues
template <class T>
class StereoFileQueue: public BaseFileQueue<typename StereoFrame<T>::Type, T > {
public:
    StereoFileQueue(const char* directory,
        int maxQueueSize = 1, bool multiThreaded = true)
        : BaseFileQueue<typename StereoFrame<T>::Type, T >(directory, maxQueueSize, multiThreaded)
    {}

    virtual ~StereoFileQueue();

protected:
    virtual void queueFrame();
};


typedef MonoFileQueue<unsigned char> MonoFileQueue8U;
typedef MonoFileQueue<unsigned short> MonoFileQueue16U;
typedef StereoFileQueue<unsigned char> StereoFileQueue8U;
typedef StereoFileQueue<unsigned short> StereoFileQueue16U;

#endif
