/*******************************************************************************
 * Copyright (c) 2019 Nerian Vision GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *******************************************************************************/

#include "pointclouddialog.h"
#include "ui_pointclouddialog.h"
#include <iostream>

PointCloudDialog::PointCloudDialog(QWidget *parent, const Settings& settings) :
    QDialog(parent), ui(new Ui::PointCloudDialog), settings(settings)
{
    ui->setupUi(this);
    resize(width(), 1);

    ui->maxDist->setValue(settings.pointCloudMaxDist);
    ui->formatBinary->setChecked(settings.binaryPointCloud);
    ui->formatText->setChecked(!settings.binaryPointCloud);

    QObject::connect(this, &QDialog::accepted, this, &PointCloudDialog::dialogAccepted);

    this->settings.writePointCloud = false;
}

PointCloudDialog::~PointCloudDialog() {
    delete ui;
}

const Settings& PointCloudDialog::getSettings() {
    return settings;
}

void PointCloudDialog::dialogAccepted() {
    settings.writePointCloud = true;
    settings.pointCloudMaxDist = ui->maxDist->value();
    settings.binaryPointCloud = ui->formatBinary->isChecked();
}
