/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleManager {
    private final String CONFIG_EXT = "manager.modules.config_ext";
    private final String CONFIG_PATH = "manager.modules.config_path";
    private final String DETECT_MOD = "manager.modules.detect_loadable";
    private final String MOD_LOADPTH = "manager.modules.load_path";
    private final String INITFUNC_SFX = "manager.modules.init_func_suffix";
    private final String INITFUNC_PFX = "manager.modules.init_func_prefix";
    private final String ALLOW_ABSPATH = "manager.modules.abs_path_allowed";
    private final String ALLOW_URL = "manager.modules.download_allowed";
    private final String MOD_DWNDIR = "manager.modules.download_dir";
    private final String MOD_DELMOD = "manager.modules.download_cleanup";
    private final String MOD_PRELOAD = "manager.modules.preload";
    protected Properties m_properties;
    protected Map<String, String> m_modules = new HashMap<String, String>();
    protected Vector<String> m_loadPath = new Vector();
    protected Vector<String> m_configPath = new Vector();
    protected boolean m_downloadAllowed;
    protected boolean m_absoluteAllowed;
    protected String m_initFuncSuffix = new String();
    protected String m_initFuncPrefix = new String();

    public ModuleManager(Properties properties) {
        this.m_properties = properties;
        this.m_configPath = new Vector();
        String[] configPath = properties.getProperty("manager.modules.config_path").split(",");
        int i = 0;
        while (i < configPath.length) {
            this.m_configPath.add(configPath[i].trim());
            ++i;
        }
        this.m_loadPath = new Vector();
        String[] loadPath = properties.getProperty("manager.modules.load_path").split(",");
        int i2 = 0;
        while (i2 < configPath.length) {
            this.m_loadPath.add(loadPath[i2].trim());
            ++i2;
        }
        this.m_absoluteAllowed = StringUtil.toBool(properties.getProperty("manager.modules.abs_path_allowed"), "yes", "no", false);
        this.m_downloadAllowed = StringUtil.toBool(properties.getProperty("manager.modules.download_allowed"), "yes", "no", false);
        this.m_initFuncSuffix = properties.getProperty("manager.modules.init_func_suffix");
        this.m_initFuncPrefix = properties.getProperty("manager.modules.init_func_prefix");
    }

    public void destruct() {
        this.unloadAll();
    }

    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Unable to fully structure code
     */
    public String load(String moduleName, String methodName) throws Exception {
        block19: {
            if (moduleName == null || moduleName.length() == 0) {
                throw new IllegalArgumentException("moduleName is empty.:load()");
            }
            if (methodName == null || methodName.length() == 0) {
                throw new IllegalArgumentException("methodName is empty.:load()");
            }
            try {
                new URL(moduleName);
                if (!this.m_downloadAllowed) {
                    throw new IllegalArgumentException("Downloading module is not allowed.");
                }
                throw new IllegalArgumentException("Not implemented.");
            }
            catch (MalformedURLException var3_3) {
                target = null;
                if (this.m_absoluteAllowed) {
                    try {
                        target = Class.forName(moduleName);
                        break block19;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        throw new ClassNotFoundException("Not implemented.", e);
                    }
                }
                i = 0;
                ** while (i < this.m_loadPath.size())
            }
lbl-1000:
            // 1 sources

            {
                fullClassName = String.valueOf(this.m_loadPath.elementAt(i)) + "." + moduleName;
                try {
                    target = Class.forName(fullClassName);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                ++i;
                continue;
            }
        }
        try {
            initMethod = target.getMethod(methodName, new Class[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw e;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw e;
        }
        try {
            initMethod.invoke(target.newInstance(), new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw e;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw e;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw e;
        }
        return moduleName;
    }

    public void unload(String moduleName) {
    }

    public void unloadAll() {
    }

    public void setLoadpath(Vector<String> loadPath) {
        this.m_loadPath = new Vector<String>(loadPath);
    }

    public Vector<String> getLoadPath() {
        return new Vector<String>(this.m_loadPath);
    }

    public void addLoadPath(Vector<String> loadPath) {
        this.m_loadPath.addAll(loadPath);
    }

    public Vector<String> getLoadedModules() {
        return new Vector<String>(this.m_modules.values());
    }

    public Vector<String> getLoadableModules() {
        return new Vector<String>();
    }

    public void allowAbsolutePath() {
        this.m_absoluteAllowed = true;
    }

    public void disallowAbsolutePath() {
        this.m_absoluteAllowed = false;
    }

    public void allowModuleDownload() {
        this.m_downloadAllowed = true;
    }

    public void disallowModuleDownload() {
        this.m_downloadAllowed = false;
    }
}

