/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.buffer.RingBuffer;
import jp.go.aist.rtm.RTC.port.OnOverflow;
import jp.go.aist.rtm.RTC.port.OnRead;
import jp.go.aist.rtm.RTC.port.OnReadConvert;
import jp.go.aist.rtm.RTC.port.OnUnderflow;
import jp.go.aist.rtm.RTC.port.OnWrite;
import jp.go.aist.rtm.RTC.port.OnWriteConvert;
import jp.go.aist.rtm.RTC.util.DataRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InPort<DataType>
implements BufferBase<DataType> {
    private static final long TIMEOUT_TICK_USEC = 10L;
    private static final long TIMEOUT_TICK_MSEC_PART = 0L;
    private static final int TIMEOUT_TICK_NSEC_PART = 10000;
    private BufferBase<DataType> m_superClass;
    private String m_name;
    private DataRef<DataType> m_value;
    private boolean m_readBlock;
    private long m_readTimeout;
    private boolean m_writeBlock;
    private long m_writeTimeout;
    private OnWrite<DataType> m_OnWrite;
    private OnWriteConvert<DataType> m_OnWriteConvert;
    private OnRead<DataType> m_OnRead;
    private OnReadConvert<DataType> m_OnReadConvert;
    private OnOverflow<DataType> m_OnOverflow;
    private OnUnderflow<DataType> m_OnUnderflow;

    public InPort(BufferBase<DataType> superClass, String name, DataRef<DataType> value, boolean read_block, boolean write_block, long read_timeout, long write_timeout) {
        this.m_superClass = superClass;
        this.m_name = name;
        this.m_value = value;
        this.m_readBlock = read_block;
        this.m_writeBlock = write_block;
        this.m_readTimeout = read_timeout;
        this.m_writeTimeout = write_timeout;
        this.m_OnWrite = null;
        this.m_OnWriteConvert = null;
        this.m_OnRead = null;
        this.m_OnReadConvert = null;
        this.m_OnOverflow = null;
        this.m_OnUnderflow = null;
    }

    public InPort(String name, DataRef<DataType> value) {
        this(new RingBuffer(64), name, value);
    }

    public InPort(BufferBase<DataType> superClass, String name, DataRef<DataType> value) {
        this(superClass, name, value, false, false, 0L, 0L);
    }

    public String name() {
        return this.m_name;
    }

    @Override
    public boolean write(DataType value) {
        if (this.m_OnWrite != null) {
            this.m_OnWrite.run(value);
        }
        long timeout = this.m_writeTimeout;
        long tm_pre = System.nanoTime();
        while (this.m_writeBlock && this.isFull()) {
            if (this.m_writeTimeout < 0L) {
                try {
                    Thread.sleep(0L, 10000);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            long tm_cur = System.nanoTime();
            long tm_diff = tm_cur - tm_pre;
            if ((timeout -= tm_diff / 1000L) < 0L) break;
            tm_pre = tm_cur;
            try {
                Thread.sleep(0L, 10000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isFull() && this.m_OnOverflow != null) {
            this.m_OnOverflow.run(value);
        }
        if (this.m_OnWriteConvert == null) {
            this.put(value);
        } else {
            this.put(this.m_OnWriteConvert.run(value));
        }
        return true;
    }

    public DataType read() {
        if (this.m_OnRead != null) {
            this.m_OnRead.run();
        }
        long timeout = this.m_readTimeout * 1000L;
        long tm_pre = System.nanoTime();
        while (this.m_readBlock && this.isEmpty()) {
            long tm_cur;
            long tm_diff;
            if (this.m_readTimeout < 0L) {
                try {
                    Thread.sleep(0L, 10000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if ((timeout -= (tm_diff = (tm_cur = System.nanoTime()) - tm_pre)) < 0L) break;
            tm_pre = tm_cur;
            try {
                Thread.sleep(0L, 10000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.isEmpty() && this.m_OnUnderflow != null) {
            this.m_value.v = this.m_OnUnderflow.run();
            return (DataType)this.m_value.v;
        }
        if (this.m_OnReadConvert == null) {
            this.m_value.v = this.get();
            return (DataType)this.m_value.v;
        }
        this.m_value.v = this.m_OnReadConvert.run(this.get());
        return (DataType)this.m_value.v;
    }

    public void init(DataType value) {
    }

    public void update() {
        block2: {
            try {
                this.m_value.v = this.get();
            }
            catch (Exception e) {
                if (this.m_OnUnderflow == null) break block2;
                this.m_OnUnderflow.run();
            }
        }
    }

    public void setOnWrite(OnWrite<DataType> onWrite) {
        this.m_OnWrite = onWrite;
    }

    public void setOnWriteConvert(OnWriteConvert<DataType> onWriteConvert) {
        this.m_OnWriteConvert = onWriteConvert;
    }

    public void setOnRead(OnRead<DataType> onRead) {
        this.m_OnRead = onRead;
    }

    public void setOnReadConvert(OnReadConvert<DataType> onReadConvert) {
        this.m_OnReadConvert = onReadConvert;
    }

    public void setOnOverflow(OnOverflow<DataType> onOverflow) {
        this.m_OnOverflow = onOverflow;
    }

    public void setOnUnderflow(OnUnderflow<DataType> onUnderflow) {
        this.m_OnUnderflow = onUnderflow;
    }

    @Override
    public int length() {
        return this.m_superClass.length();
    }

    @Override
    public boolean read(DataRef<DataType> valueRef) {
        return this.m_superClass.read(valueRef);
    }

    @Override
    public boolean isFull() {
        return this.m_superClass.isFull();
    }

    @Override
    public boolean isEmpty() {
        return this.m_superClass.isEmpty();
    }

    @Override
    public void put(DataType data) {
        this.m_superClass.put(data);
    }

    @Override
    public DataType get() {
        return this.m_superClass.get();
    }

    @Override
    public boolean isNew() {
        return this.m_superClass.isNew();
    }
}

