#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file  OutPortProvider.py
# @brief OutPortProvider class
# @date  $Date: 2007/09/05$
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2006-2008
#     Noriaki Ando
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.



import OpenRTM_aist

##
# @if jp
#
# @class OutPortProvider
# @brief OutPortProvider
#
# - Port ФƲ󶡤Ƥ뤫롣
#   PortProfile  properties  Provider ˴ؤɲä롣
#
# () OutPort  Provide 
#
# OutPortCorbaProvider ʲ
#  - dataport.interface_type = CORBA_Any
#  - dataport.dataflow_type = Push, Pull
#  - dataport.subscription_type = Once, New, Periodic
# 
# @since 0.4.0
#
# @else
#
#
# @endif
class OutPortProvider(OpenRTM_aist.DataPortStatus):
  """
  """



  ##
  # @if jp
  # @brief 󥿡եץե뤿Υե󥯥
  # @else
  # @brief Functor to publish interface profile
  # @endif
  #
  class publishInterfaceProfileFunc:
    def __init__(self, prop):
      self._prop = prop

    def __call__(self, provider):
      provider.publishInterfaceProfile(self._prop)


  ##
  # @if jp
  # @brief 󥹥ȥ饯
  #
  # 󥹥ȥ饯
  #
  # @param self
  #
  # @else
  # @brief Constructor
  # @endif
  def __init__(self):
    self._properties = []
    self._portType         = ""
    self._dataType         = ""
    self._interfaceType    = ""
    self._dataflowType     = ""
    self._subscriptionType = ""
    self._rtcout = OpenRTM_aist.Manager.instance().getLogbuf("OutPortProvider")


  ##
  # @if jp
  # @brief InterfaceProfile
  #
  # InterfaceProfile롣
  # ǻꤹץѥƥ NameValue ֥Ȥ
  # dataport.interface_type ͤĴ١ݡȤꤵƤ
  # 󥿡եפȰפΤ߾롣
  #
  # @param self
  # @param prop InterfaceProfileץѥƥ
  #
  # @else
  #
  # @endif
  # virtual void publishInterfaceProfile(SDOPackage::NVList& properties);
  def publishInterfaceProfile(self, prop):
    OpenRTM_aist.NVUtil.appendStringValue(prop, "dataport.interface_type", self._interfaceType)
    OpenRTM_aist.NVUtil.append(prop, self._properties)

  ##
  # @if jp
  # @brief Interface
  #
  # Interface롣
  # ǻꤹץѥƥ NameValue ֥Ȥ
  # dataport.interface_type ͤĴ١ݡȤꤵƤʤ
  # NameValue ˾ɲä롣
  # ǤƱ쥤󥿡եϿѤߤξϲԤʤ
  #
  # @param self
  # @param prop InterfaceProfileץѥƥ
  #
  # @else
  #
  # @endif
  # virtual bool publishInterface(SDOPackage::NVList& properties);
  def publishInterface(self, prop):
    if not OpenRTM_aist.NVUtil.isStringValue(prop,"dataport.interface_type",self._interfaceType):
      return False

    OpenRTM_aist.NVUtil.append(prop,self._properties)
    return True


  ##
  # @if jp
  # @brief ݡȥפꤹ
  #
  # ǻꤷݡȥפꤹ롣
  #
  # @param self
  # @param port_type оݥݡȥ
  #
  # @else
  #
  # @endif
  def setPortType(self, port_type):
    self._portType = port_type


  ##
  # @if jp
  # @brief ǡפꤹ
  #
  # ǻꤷǡפꤹ롣
  #
  # @param self
  # @param data_type оݥǡ
  #
  # @else
  #
  # @endif
  def setDataType(self, data_type):
    self._dataType = data_type


  ##
  # @if jp
  # @brief 󥿡եפꤹ
  #
  # ǻꤷ󥿡եפꤹ롣
  #
  # @param self
  # @param interface_type оݥ󥿡ե
  #
  # @else
  #
  # @endif
  def setInterfaceType(self, interface_type):
    self._interfaceType = interface_type


  ##
  # @if jp
  # @brief ǡեפꤹ
  #
  # ǻꤷǡեפꤹ롣
  #
  # @param self
  # @param dataflow_type оݥǡե
  #
  # @else
  #
  # @endif
  def setDataFlowType(self, dataflow_type):
    self._dataflowType = dataflow_type


  ##
  # @if jp
  # @brief ֥ץ󥿥פꤹ
  #
  # ǻꤷ֥ץ󥿥פꤹ롣
  #
  # @param self
  # @param subs_type оݥ֥ץ󥿥
  #
  # @else
  #
  # @endif
  def setSubscriptionType(self, subs_type):
    self._subscriptionType = subs_type



outportproviderfactory = None

class OutPortProviderFactory(OpenRTM_aist.Factory,OutPortProvider):
  def __init__(self):
    OpenRTM_aist.Factory.__init__(self)
    pass


  def __del__(self):
    pass


  def instance():
    global outportproviderfactory
    
    if outportproviderfactory is None:
      outportproviderfactory = OutPortProviderFactory()
      
    return outportproviderfactory

  instance = staticmethod(instance)
