// -*- C++ -*-
/*!
 * @file SdoServiceConsumerBase.h
 * @brief SDO service consumer base class and its factory
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2011
 *     Noriaki Ando
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */


#ifndef RTC_SDOSERVICECONSUMERBASE_H
#define RTC_SDOSERVICECONSUMERBASE_H

#include <coil/Mutex.h>
#include <coil/Factory.h>
#include <coil/Timer.h>
#include <rtm/RTObject.h>
#include <rtm/idl/SDOPackageStub.h>

namespace RTC
{
  /*!
   * @if jp
   *
   * @brief SdoServiceConsumer쥯饹
   *
   * SDOƤSDOӥΥ󥷥塼ޤ뤿δ쥯
   * 饹SDOӥˤϡ󶡥ӥRTC(SDO)¦Ѥ
   * SDOӥ󥷥塼ޤȡRTC(SDO)ȤSDOӥ󶡤SDO
   * ӥץХ롣٤ƤSDOӥ󥷥塼ޤϤδ
   * 쥯饹ѾƼ롣
   *
   * Υ֥ȤΥ饤եϰʲ̤ꡣ
   *
   * -# ֥Ȥ̾֥ͭ (so, DLL) Ȥƥѥ롦
   *    󥯤롣
   * -# ޥ͡Фƥɤȥ⥸塼ؿˤꥪ
   *    ȥեȥ꤬SdoServiceConsumerFactory ФϿ
   *    롣ϿΥˤϥӥ󥿡ե IFR (interface
   *    repository) ID Ѥ졢ˤꥵӥ̤롣
   * -# Υġʤɤ饵ӥץХå줿硢
   *    ӥ󥿡ե IFR ID ƱǤ SDO 󥷥塼ޤ
   *    󥹥󥹲졢󶡤줿SDOӥ ServiceProfile (
   *    ¤ΤϥӥΥ֥ȥե󥹤ޤ) 󥷥塼
   *    ޤ˥å롣
   * -# ΤȤΥå󥹤ϰʲ̤ꡣ
   *   -# SDO::get_configuration() ˤ Configuration ֥Ȥ
   *   -# Configuration::add_service_profile() ˤ곰¦
   *      SdoServiceProvider  ServiceProfile ˤ RTC Ϳ롣
   *   -# RTC¦ǥӥƤӽФɬפͭä硢
   *      SdoServiceConsumer ݻƤ륵ӥ֥ȥץ
   *      ФƸƤӽФԤ
   * -# ǽŪ SdoServiceConsumer פˤʤäˤϡ
   *     Configuration::remove_service_profile()  id ȤȤ˸ƤӽФ
   *     SDOӥ󥷥塼ޤ RTC 롣
   *
   * <pre>
   * 
   *   [RTC] [SDO consumer] [Configuration]  [SDO service]    [Other]
   *     |          :             |                 |            |
   *     |          :         get_configuration()   |            |
   *     |<---------:-------------------------------|------------|
   *     |          :             |                 |            |
   *     |          :             |   add_service_profile(prof)  |
   *     |          :  create()   |<----------------|------------|
   *     |          |<------------|                 |            |
   *     |          |         call_sdo_service()    |            |
   *     |          |-------------|---------------->|            |
   *     |          |         call_sdo_service2()   |            |
   *     |          |-------------|---------------->|            |
   *     |          |             |       :         |            |
   *     |          |             |                 |            |
   *     |          |             | remove_service_profile(id)   |
   *     |          |  delete()   |<----------------|------------|
   *     |          x<------------|                 |            |
   *     |                        |                 x            x
   *
   * </pre>
   *
   * Υ饹μäƤϡʤȤʲν貾۴ؿ
   * ɬפ롣
   *
   * - init(): ؿͿ줿 RTObject  ServiceProfile 
   *   顢֥Ȥ롣
   * - reinit(): ƽؿServiceProfile 󹹿ΤƱ
   *   IDǸƤӽФ뤳Ȥͭ뤬κݤˤδؿ
   *   ServiceProfile ȤȤ˸ƤӽФ롣ؿǤϡѹʤ
   *   ƽ롣
   * - getProfile(): ꤵ줿ץե֤ؿ
   * - finalize(): λ󥷥塼ޤǥåݤ˸ƤӽФ
   *   ؿؿǤϽλ롣
   *
   * SdoServiceConsumer ̾ﶦ֥ͭȤȤƥѥ롦
   * 롣֥ͭȤΥȥݥȤ̾拾ѥ뤵줿ե
   * ̾ basename + "Init" ˤƤʲˡ饹̾ե
   * ̾ȥݥȴؿ̾ο侩򼨤
   *
   * - 饹̾: MySdoServiceConusmer 
   * - ե̾: MySdoServiceConsumer.h. MySdoServiceConsumer.cpp
   * - ֥ͭ̾: MySdoServiceConsumer.so (or DLL)
   * - ȥݥȴؿ̾: MySdoServiceConsumerInit()
   *
   * ȥݥȴؿ̾ʲΤ褦ˡSdoServiceConsumerFactory
   * 󥷥塼ޤΥեȥ (ȲΥե󥯥) Ͽʲ
   * 褦ʴؿˤʤ롣
   *
   * <pre>
   * extern "C"
   * {
   *   void MySdoServiceConsumerInit()
   *   {
   *     RTC::SdoServiceConsumerFactory& factory
   *       = RTC::SdoServiceConsumerFactory::instance();
   *     factory.addFactory(CORBA_Util::toRepositoryId<OpenRTM::MySdoService>(),
   *                        ::coil::Creator< ::RTC::SdoServiceConsumerBase,
   *                        ::RTC::MySdoServiceConsumer>,
   *                        ::coil::Destructor< ::RTC::SdoServiceConsumerBase,
   *                        ::RTC::MySdoServiceConsumer>);
   *   }
   * };
   * </pre>
   * 
   * @else
   *
   * @endif
   *
   */
  class SdoServiceConsumerBase
  {
  public:
    /*!
     * @if jp
     * @brief ۥǥȥ饯
     * @else
     * @brief virtual destructor
     * @endif
     */
    virtual ~SdoServiceConsumerBase() {};

    /*!
     * @if jp
     * @brief 󥷥塼ޥ饹νؿ
     *
     * Υ֥ȤνԤSDOӥ
     * ServiceProfile ȤȤ˥åȡSDO󥷥塼ޤ
     * 󥹲졢ľ SDO ӥå줿 RTC Ϳ
     * 줿 ServiceProfile ȤƤδؿƤФ롣
     *
     * ؿǤϡServiceProfile  SDO ӥե󥹤
     * CorbaConsumer 饹Ѥ֥ݻȤȤˡ
     * properties Ƥɤ߹ߥӥͭԤͿ
     * 줿ӥΥ֥ȥե󥹤뤤
     * properties Ƥξͤ false ֤
     *
     * @param rtobj Υ֥Ȥ󥹥󥹲줿 RTC
     * @param profile Ϳ줿 SDO ServiceProfile
     * @return Ϳ줿 SDO Service  ServiceProfile ξ false
     *
     * @else
     * @brief Initialization function of the consumer class
     *
     * @endif
     */
    virtual bool init(RTObject_impl& rtobj,
                      const SDOPackage::ServiceProfile& profile) = 0;
    /*!
     * @if jp
     * @brief 󥷥塼ޥ饹κƽؿ
     *
     * Υ֥ȤκƽԤServiceProfile ˤ id ե
     * ɤ˥åͭ UUID åȤƤ뤬Ʊ id ξ
     * 硢properties ꤵ줿ѹ䡢service ե
     * ΥӥλȤѹԤ롣κݤ˸ƤФΤ
     * reinit() ؿǤ롣Ǥϡservice եɤΥ֥
     * ե󥹤ƱǧۤʤäƤݻƤե
     * 󥹤򹹿ɬפ롣ޤ properties ˤϿ꤬Ϳ
     * ƤǽΤǡƤɤ߹򹹿롣
     *
     * @param profile Ϳ줿 SDO ServiceProfile
     * @return  ServiceProfile Ϳ줿 false
     *
     * @else
     * @brief Reinitialization function of the consumer class
     *
     * @endif
     */
    virtual bool reinit(const SDOPackage::ServiceProfile& profile) = 0;

    /*!
     * @if jp
     * @brief ServiceProfile ֤
     *
     * init()/reinit()Ϳ줿 ServiceProfile ̾索֥
     * ݻ롣SDO Service ե졼ϴ夳Υ֥
     * Ȥб ServiceProfile ɬפȤΤǡδؿǤݻ
     * Ƥ ServiceProfile ֤
     * 
     * @return Υ֥ȤݻƤ ServiceProfile
     *
     * @else
     * @brief Getting ServiceProfile
     * @endif
     */
    virtual const SDOPackage::ServiceProfile& getProfile() const = 0;

    /*!
     * @if jp
     * @brief λ
     *
     * SDOӥǥåݤ˸ƤӽФ뽪λѴؿ
     * ӥΤǥå˺ݤơ֥Ȥݻ꥽
     * ʤɤνԤ
     *
     * @else
     * @brief Finalization
     *
     * @endif
     */
    virtual void finalize() = 0;
  };

    /*!
     * @if jp
     * @brief SdoServiceConsumerFactory  typedef
     * @else
     * @brief typedef of sdoServiceConsumerFactory
     * @endif
     */
  typedef ::coil::GlobalFactory<
    ::RTC::SdoServiceConsumerBase > SdoServiceConsumerFactory;

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
    /*!
     * @if jp
     * @brief 饹ƥץ졼ȤŪ󥹥󥹲
     * @else
     * @brief Explicit instantiation of class template
     * @endif
     */
  EXTERN template class DLL_PLUGIN 
                     ::coil::GlobalFactory< ::RTC::SdoServiceConsumerBase >;
#endif  
}; // namespace RTC

#endif // RTC_SDOSERVICECONSUMERBASE_H
