#!/usr/bin/env python

'''
    Copyright (C) 2014 Parrot SA

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the 
      distribution.
    * Neither the name of Parrot nor the names
      of its contributors may be used to endorse or promote products
      derived from this software without specific prior written
      permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
'''

import sys
import os
import re
import arsdkparser

MYDIR=os.path.abspath(os.path.dirname(__file__))
PACKAGES_DIR=os.path.realpath(os.path.join(MYDIR, "../.."))
sys.path.append('%(PACKAGES_DIR)s/ARSDKBuildUtils/Utils/Python' % locals())
sys.path.append('%(PACKAGES_DIR)s/libARCommands/Tools' % locals())

from ARFuncs import *
from libARCommandsgen import *
from ARControllerUtils import *
from arsdkparser import *

_LIST_FLAG = 'list_flags'

CTRL_FTR_H_NAME = 'ARCONTROLLER_Feature.h'
CTRL_FTR_PRIV_H_NAME = 'ARCONTROLLER_Feature.h'
CTRL_FTR_C_NAME = 'ARCONTROLLER_Feature.c'
CTRL_FTR_JNI_C_NAME = 'ARCONTROLLER_JNI_Features.c'

def getGenericListFlagsEnum(ctx):
    ftr_gen = ctx.featuresByName['generic']
    return ftr_gen.enumsByName[_LIST_FLAG]

def generateFeatureControllers (ctx, SRC_DIR, INC_DIR):
    allFeatures = ctx.features

    ARPrint ('generateFeatureControllers ...')

    #########################################
    # Write Feature controller header file  #
    #########################################

    #for feature in allFeatures: # see automake all source of folder !!!!

    #className = ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), '')  # see automake all source of folder !!!!
    includeDefine = '_' + MODULE_FEATURE + '_H_' #includeDefine = '_' + ARMacroName (MODULE_FEATURE, get_ftr_old_name(feature), 'H') + '_'  # see automake all source of folder !!!!

    headerFileName = CTRL_FTR_H_NAME #headerFileName = className + '.h'!!!!
    filepath = INC_DIR + headerFileName
    hfile = open (filepath, 'w')

    hfile.write ('/**********************************************************\n')
    hfile.write (' *            AUTOGENERATED FILE                          *\n')
    hfile.write (' *             DO NOT MODIFY IT                           *\n')
    hfile.write (' *                                                        *\n')
    hfile.write (' * To add new commands :                                  *\n')
    hfile.write (' *  - Modify ../Xml/commands.xml file                     *\n')
    hfile.write (' *  - Re-run generateFeatureControllers.py script         *\n')
    hfile.write (' *                                                        *\n')
    hfile.write (' **********************************************************/\n')
    hfile.write ('\n')

    hfile.write ('/**\n')
    hfile.write ('* @file '+headerFileName+'\n')
    hfile.write ('* @brief Feature controller allow to send command related of a Feature.\n') #hfile.write ('* @brief Feature controller allow to send command related of '+get_ftr_old_name(feature)+' Feature.\n')
    hfile.write ('*/\n')
    hfile.write ('\n')

    hfile.write ('#ifndef '+includeDefine+'\n')
    hfile.write ('#define '+includeDefine+'\n')
    hfile.write ('\n')

    hfile.write ('#include <stdlib.h>\n')
    hfile.write ('\n')
    hfile.write ('#include <libARSAL/ARSAL_Print.h>\n')
    hfile.write ('#include <libARSAL/ARSAL_Mutex.h>\n')
    hfile.write ('#include <libARCommands/ARCommands.h>\n')
    hfile.write ('#include <uthash/uthash.h>\n')
    hfile.write ('\n')
    hfile.write ('#include <libARController/ARCONTROLLER_Error.h>\n')
    hfile.write ('#include <libARController/ARCONTROLLER_Network.h>\n')
    hfile.write ('#include <libARController/ARCONTROLLER_DICTIONARY_Key.h>\n')
    hfile.write ('#include <libARController/ARCONTROLLER_Dictionary.h>\n')
    hfile.write ('\n')

    for feature in ctx.features: # see automake all source of folder !!!!!!!!!!!!!!
        className = ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), '')  # see automake all source of folder !!!!
        classPrivName = ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), 'Private')  # see automake all source of folder !!!!
        
        hfile.write ('/*******************************\n') # see automake all source of folder !!!!!!!!
        hfile.write (' * --- FEATURE '+get_ftr_old_name(feature)+' --- \n') # see automake all source of folder !!!!!!!!
        hfile.write (' ******************************/\n') # see automake all source of folder !!!!!!!!
        hfile.write ('\n')
        
        hfile.write ('/**\n')
        hfile.write (' * @brief Private part of '+className+'.\n')
        hfile.write (' */\n')
        hfile.write ('typedef struct '+classPrivName+' '+classPrivName+';\n')
        hfile.write ('\n')
        
        hfile.write ('/**\n')
        hfile.write (' * @brief Feature controller allow to send command related of '+get_ftr_old_name(feature)+' Feature.\n')
        hfile.write (' * ' + feature.doc.replace('\n', '\n * ')+'\n')
        hfile.write (' */\n')
        hfile.write ('typedef struct '+className+' '+className+';\n')
        hfile.write ('\n')
        
        hfile.write ('/**\n')
        hfile.write (' * @brief Create a new '+get_ftr_old_name(feature)+' Feature Controller\n')
        hfile.write (' * @warning This function allocate memory\n')
        hfile.write (' * @post ' + ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'Delete')+'() must be called to delete the Feature Controller and free the memory allocated.\n')
        hfile.write (' * @param[in] networkController The networkController used to send commands ; can be NULL and defind later with '+ARFunctionName(MODULE_FEATURE, get_ftr_old_name(feature), 'SetNetworkController')+'().\n')
        hfile.write (' * @param[out] error executing error.\n')
        hfile.write (' * @return the new '+get_ftr_old_name(feature)+' Feature Controller\n')
        hfile.write (' * @see ' + ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'Delete')+'\n')
        hfile.write (' */\n')
        hfile.write (''+className+' *' + ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'New')+' (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error);\n')
        hfile.write ('\n')
        
        hfile.write ('/**\n')
        hfile.write (' * @brief Delete the '+get_ftr_old_name(feature)+' Feature Controller\n')
        hfile.write (' * @warning This function free memory\n')
        hfile.write (' * @param feature The feature controller to delete\n')
        hfile.write (' * @see ' + ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'New')+'\n')
        hfile.write (' */\n')
        hfile.write ('void ' + ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'Delete')+' ('+className+' **feature);\n')
        hfile.write ('\n')
        
        hfile.write ('/**\n')
        hfile.write (' * @brief Register the feature controller to be called when the commands are decoded.\n')
        hfile.write (' * @param feature The feature controller to register\n')
        hfile.write (' * return executing error\n')
        hfile.write (' */\n')
        hfile.write ('eARCONTROLLER_ERROR '+ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'RegisterARCommands')+' ('+className+' *feature);\n')
        hfile.write ('\n')
        
        hfile.write ('/**\n')
        hfile.write (' * @brief Unegister the feature controller to be called when the commands are decoded.\n')
        hfile.write (' * @param feature The feature controller to unregister\n')
        hfile.write (' * return executing error\n')
        hfile.write (' */\n')
        hfile.write ('eARCONTROLLER_ERROR '+ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'UnregisterARCommands')+' ('+className+' *feature);\n')
        hfile.write ('\n')
        
        hfile.write ('/**\n')
        hfile.write (' * @brief Get the dictionay of the '+get_ftr_old_name(feature)+' Feature Controller\n')
        hfile.write (' * @param feature The feature controller owning the dictionary to get\n')
        hfile.write (' * @param[out] error executing error.\n')
        hfile.write (' */\n')
        hfile.write (''+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *' + ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'GetDictionary')+' ('+className+' *feature, eARCONTROLLER_ERROR *error);\n')
        hfile.write ('\n')
            
        hfile.write ('/**\n')
        hfile.write (' * @brief Add a callback to use when a command in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> is received\n')
        hfile.write (' * @param feature The feature controller receiving the command.\n')
        hfile.write (' * @param[in] callback the callback to add.\n')
        hfile.write (' * @param[in] commandKey Key of the command which the callback must be associated.\n')
        hfile.write (' * @param[out] error executing error.\n')
        hfile.write (' * @param[int] customData custom data given as parameter to the callback.\n')
        hfile.write (' * @see '+ARFunctionName(MODULE_FEATURE, get_ftr_old_name(feature), 'removeCallback')+'.\n')
        hfile.write (' */\n')
        hfile.write ('eARCONTROLLER_ERROR '+ARFunctionName(MODULE_FEATURE, get_ftr_old_name(feature), 'addCallback')+' ('+className+' *feature, '+defineNotificationDef()+' commandKey, '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'CALLBACK')+' callback, void *customData);\n')
        hfile.write ('\n')
        
        hfile.write ('/**\n')
        hfile.write (' * @brief Remove a callback used when a command in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> is received\n')
        hfile.write (' * @param feature The feature controller receiving the command.\n')
        hfile.write (' * @param[in] commandKey Key of the command which the callback must be unassociated.\n')
        hfile.write (' * @param[in] callback the callback to remove.\n')
        hfile.write (' * @param[int] customData The custom data given to the register.\n')
        hfile.write (' * @param[out] error executing error.\n')
        hfile.write (' */\n')
        hfile.write ('eARCONTROLLER_ERROR '+ARFunctionName(MODULE_FEATURE, get_ftr_old_name(feature), 'removeCallback')+' ('+className+' *feature, '+defineNotificationDef()+' commandKey, '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'CALLBACK')+' callback, void *customData);\n')
        hfile.write ('\n')
        
        for evt in feature.evts:
            for arg in [arg1 for arg1 in evt.args if arg1.name != _LIST_FLAG]:
                hfile.write ('extern const char *' + defineNotification(feature, evt, arg) + '; /**< Key of the argument </code>'+ arg.name+'</code> of event <code>' + ARCapitalize (format_cmd_name(evt)) + '</code> in feature <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> */\n')
            hfile.write('\n');
            
        for cmd in feature.cmds:
            hfile.write ('/**\n')
            hfile.write (' * @brief Send a command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in feature <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code>\n')
            if cmd.isDeprecated:
                hfile.write (' * @deprecated\n')
            hfile.write (' * ' + cmd.doc.desc.replace('\n', '\n * ')+'\n')
            hfile.write (' * @param feature feature owning the commands\n')
            for arg in cmd.args:
                hfile.write (' * @param ' + arg.name + ' ' + get_arg_doc(arg).replace('\n', ' ') + '\n')
            hfile.write (' * return executing error\n')
            hfile.write (' */\n')
            hfile.write ('typedef eARCONTROLLER_ERROR (*'+ sendingFunctionType (MODULE_FEATURE, feature, cmd)+') ('+className+' *feature')
            for arg in cmd.args:
                hfile.write (', ' + xmlToC (MODULE_ARCOMMANDS, feature, cmd, arg) + ' ' + arg.name)
            hfile.write (');\n')
            hfile.write ('\n')
            
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                hfile.write ('/**\n')
                hfile.write (' * @brief Set the parameters to send through the command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code>\n')
                if cmd.isDeprecated:
                    hfile.write (' * @deprecated\n')
                hfile.write (' * ' + cmd.doc.desc.replace('\n', '\n * ')+'\n')
                hfile.write (' * @param feature feature owning the commands\n')
                for arg in cmd.args:
                    hfile.write (' * @param ' + arg.name + ' ' + get_arg_doc(arg).replace('\n', ' ') + '\n')
                hfile.write (' * return executing error\n')
                hfile.write (' */\n')
                hfile.write ('typedef eARCONTROLLER_ERROR (*' + setNAckFunctionType (feature, cmd)+') ('+className+' *feature')
                for arg in cmd.args:
                    hfile.write (', ' + xmlToC (MODULE_ARCOMMANDS, feature, cmd, arg) + ' ' + arg.name)
                hfile.write (');\n')
                hfile.write ('\n')
                
                hfile.write ('/**\n')
                hfile.write (' * @brief Send the a command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> with the parame set beforehand \n')
                if cmd.isDeprecated:
                    hfile.write (' * @deprecated\n')
                hfile.write (' * ' + cmd.doc.desc.replace('\n', '\n * ')+'\n')
                hfile.write (' * @param feature feature owning the commands\n')
                hfile.write (' * @param cmdBuffer buffer to store the command\n')
                hfile.write (' * @param cmdBufferSize size of the buffer\n')
                hfile.write (' * return executing error\n')
                hfile.write (' */\n')
                hfile.write ('eARCONTROLLER_ERROR '+ sendNAckFunctionName (feature, cmd)+' ('+className+' *feature, u_int8_t *cmdBuffer, int32_t cmdBufferSize);\n')
                hfile.write ('\n')
                
                for arg in cmd.args:
                    hfile.write ('/**\n')
                    hfile.write (' * @brief Set '+arg.name+' sent through the command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code>\n')
                    if cmd.isDeprecated:
                        hfile.write (' * @deprecated\n')
                    hfile.write (' * ' + cmd.doc.desc.replace('\n', '\n * ')+'\n')
                    hfile.write (' * @param feature feature owning the commands\n')
                    hfile.write (' * @param ' + arg.name + ' ' + get_arg_doc(arg).replace('\n', ' ') + '\n')
                    hfile.write (' * return executing error\n')
                    hfile.write (' */\n')
                    hfile.write ('typedef eARCONTROLLER_ERROR (*' + setNAckFunctionType (feature, cmd, arg)+') ('+className+' *feature, ' + xmlToC (MODULE_ARCOMMANDS, feature, cmd, arg) + ' ' + arg.name+');\n')
                    hfile.write ('\n')

        hfile.write ('/**\n')
        hfile.write (' * @brief Feature controller allow to send command related of '+get_ftr_old_name(feature)+' Feature.\n')
        hfile.write (' * ' + feature.doc.replace('\n', '\n * ')+'\n')
        hfile.write (' */\n')
        hfile.write ('struct '+className+'\n')
        hfile.write ('{\n')
        for cmd in feature.cmds:
            hfile.write ('    '+sendingFunctionType (MODULE_FEATURE, feature, cmd)+' '+sendingFunction(cmd)+';\n')
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                hfile.write ('    '+setNAckFunctionType (feature, cmd)+' '+setNAckFunction(cmd)+';\n')
                for arg in cmd.args:
                    hfile.write ('    ' + setNAckFunctionType (feature, cmd, arg)+' '+setNAckFunction(cmd, arg)+'; /**< Send a command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in feature <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code>. */\n')
                        
        hfile.write ('    '+classPrivName+' *privatePart; /**< Private part of '+className+' */\n')
        hfile.write ('};\n')
        hfile.write ('\n')
        
        hfile.write ('/**\n')
        hfile.write (' * @brief Set a NetworkController to use to send commands.\n')
        hfile.write (' * @param feature The feature controller receiving the command.\n')
        hfile.write (' * @param[in] commandKey Key of the command which the callback must be unassociated.\n')
        hfile.write (' * @param[in] networkController The networkController used to send commands ; must be not NULL.\n')
        hfile.write (' * @return error executing error.\n')
        hfile.write (' */\n')
        hfile.write ('eARCONTROLLER_ERROR '+ARFunctionName(MODULE_FEATURE, get_ftr_old_name(feature), 'SetNetworkController')+' ('+className+' *feature, ARCONTROLLER_Network_t *networkController);\n')
        hfile.write ('\n')
        
        hfile.write ('/**\n')
        hfile.write (' * @brief Get the elements of a command received.\n')
        hfile.write (' * @param feature The feature controller receiving the command.\n')
        hfile.write (' * @param[in] commandKey Key of the command.\n')
        hfile.write (' * @param[out] error executing error.\n')
        hfile.write (' * @return Element dictionary of the command ; Can be null if an error is occurred.\n')
        hfile.write (' */\n')
        hfile.write ('ARCONTROLLER_DICTIONARY_ELEMENT_t *' + ARFunctionName (MODULE_ARCONTROLLER, get_ftr_old_name(feature), 'GetCommandElements')+' ('+className+' *feature, '+defineNotificationDef()+' commandKey, eARCONTROLLER_ERROR *error);\n')
        hfile.write ('\n')
        
        
    hfile.write ('#endif /* '+includeDefine+' */\n')
    hfile.write ('\n')
    hfile.write ('// END GENERATED CODE\n')
    hfile.close () # see automake all source of folder !!!!!!!!
        
    #################################################
    # Write Feature controller private header file  #
    #################################################
        
    #for feature in allFeatures: # see automake all source of folder !!!!!!!

    #className = ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), '')  # see automake all source of folder !!!!
    includeDefine = '_' + MODULE_FEATURE + '_PRIVATE_H_' #includeDefine = '_' + ARMacroName (MODULE_FEATURE, get_ftr_old_name(feature), 'PRIVATE_H') + '_'  # see automake all source of folder !!!!

    headerPrivateFileName = CTRL_FTR_PRIV_H_NAME #headerPrivateFileName = className + '.h' # see automake all source of folder !!!!
    filepath = SRC_DIR + headerPrivateFileName
    hPrivFile = open (filepath, 'w')

    hPrivFile.write ('/**********************************************************\n')
    hPrivFile.write (' *            AUTOGENERATED FILE                          *\n')
    hPrivFile.write (' *             DO NOT MODIFY IT                           *\n')
    hPrivFile.write (' *                                                        *\n')
    hPrivFile.write (' * To add new commands :                                  *\n')
    hPrivFile.write (' *  - Modify ../Xml/commands.xml file                     *\n')
    hPrivFile.write (' *  - Re-run generateFeatureControllers.py script         *\n')
    hPrivFile.write (' *                                                        *\n')
    hPrivFile.write (' **********************************************************/\n')
    hPrivFile.write ('\n')

    hPrivFile.write ('/**\n')
    hPrivFile.write ('* @file '+headerPrivateFileName+'\n')
    hPrivFile.write ('* @brief Feature controller allow to send command related of '+get_ftr_old_name(feature)+' Feature.\n')
    hPrivFile.write ('*/\n')
    hPrivFile.write ('\n')

    hPrivFile.write ('#ifndef '+includeDefine+'\n')
    hPrivFile.write ('#define '+includeDefine+'\n')
    hPrivFile.write ('\n')
    hPrivFile.write ('#include <libARSAL/ARSAL_Mutex.h>\n')
    hPrivFile.write ('#include <libARCommands/ARCommands.h>\n')
    hPrivFile.write ('#include <libARController/ARCONTROLLER_Feature.h>\n')
    hPrivFile.write ('\n')

    hPrivFile.write ('void ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteCommandsDictionary')+' ('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' **dictionary);\n')
    hPrivFile.write ('\n')
    
    hPrivFile.write (ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'NewCommandsElement')+' (int commandKey, eARCONTROLLER_ERROR *error);\n')
    hPrivFile.write ('void ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteCommandsElement')+' ('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' **dictCmdElement);\n')
    hPrivFile.write ('\n')
    
    hPrivFile.write ('void ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteElement')+' ('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' **element);\n')
    hPrivFile.write ('\n')
    
    hPrivFile.write ('void ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteArgumentsDictionary')+' ('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ARG')+' **dictionary);\n')
    hPrivFile.write ('\n')
    
    #TODO sup
    '''
    hPrivFile.write (''+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'FindCmdElements')+' ('+className+' *feature, int commandKey);\n')
    hPrivFile.write ('\n')
    '''
    
    hPrivFile.write ('void ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'AddElement')+' ('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' **elementDict, '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *newElement);\n')
    hPrivFile.write ('\n')
        
    for feature in ctx.features: # see automake all source of folder !!!!!!!!
        
        className = ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), '')  # see automake all source of folder !!!!
        classPrivName = ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), 'Private')  # see automake all source of folder !!!!
        
        hPrivFile.write ('/*******************************\n') # see automake all source of folder !!!!!!!!
        hPrivFile.write (' * --- FEATURE '+get_ftr_old_name(feature)+' --- \n') # see automake all source of folder !!!!!!!!
        hPrivFile.write (' ******************************/\n') # see automake all source of folder !!!!!!!!
        
        for cmd in feature.cmds:
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                hPrivFile.write ('/**\n')
                hPrivFile.write (' * @brief Parameters to send through the command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code>\n')
                hPrivFile.write (' */\n')
                hPrivFile.write ('typedef struct\n')
                hPrivFile.write ('{\n')
                for arg in cmd.args:
                    hPrivFile.write ('    ' + xmlToC (MODULE_ARCOMMANDS, feature, cmd, arg) + ' '+arg.name+'; /**< */\n')
                hPrivFile.write ('}'+structNAckType (feature, cmd)+';\n')
                hPrivFile.write ('\n')

        
        
        hPrivFile.write ('/**\n')
        hPrivFile.write (' * @brief Private part of '+className+'.\n')
        hPrivFile.write (' */\n')
        hPrivFile.write ('struct '+classPrivName+'\n')
        hPrivFile.write ('{\n')
        hPrivFile.write ('    ARCONTROLLER_Network_t *networkController; /**<the networkController to send commands */\n')
        hPrivFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *dictionary; /**< stores states and settings of the device */\n')
        hPrivFile.write ('    ARCONTROLLER_Dictionary_t *commandCallbacks; /**< dictionary storing callbacks to use when the command is received. */\n')
        hPrivFile.write ('    ARSAL_Mutex_t mutex; /**< Mutex for multihreading */\n')

        for cmd in feature.cmds:
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                hPrivFile.write ('    '+structNAckType (feature, cmd)+' *'+structNAckName (cmd)+'; /**< */\n')
                    
        hPrivFile.write ('};\n')
        hPrivFile.write ('\n')

        for cmd in feature.cmds:
            hPrivFile.write ('/**\n')
            hPrivFile.write (' * @brief Send a command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code>\n')
            if cmd.isDeprecated:
                hPrivFile.write (' * @deprecated\n')
            hPrivFile.write (' * ' + cmd.doc.desc.replace('\n', '\n * ')+'\n')
            hPrivFile.write (' * @param feature feature owning the commands\n')
            for arg in cmd.args:
                hPrivFile.write (' * @param ' + arg.name + ' ' + get_arg_doc(arg).replace('\n', ' ') + '\n')
            hPrivFile.write (' * return executing error\n')
            hPrivFile.write (' */\n')
            hPrivFile.write ('eARCONTROLLER_ERROR ' + sendingFunctionName (MODULE_FEATURE, feature, cmd)+' ('+className+' *feature')
            for arg in cmd.args:
                hPrivFile.write (', ' + xmlToC (MODULE_ARCOMMANDS, feature, cmd, arg) + ' ' + arg.name)
            hPrivFile.write (');\n')
            hPrivFile.write ('\n')
            
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                hPrivFile.write ('/**\n')
                hPrivFile.write (' * @brief Set the parameters to send through the command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code>\n')
                if cmd.isDeprecated:
                    hPrivFile.write (' * @deprecated\n')
                hPrivFile.write (' * ' + cmd.doc.desc.replace('\n', '\n * ')+'\n')
                hPrivFile.write (' * @param feature feature owning the commands\n')
                for arg in cmd.args:
                    hPrivFile.write (' * @param ' + arg.name + ' ' + get_arg_doc(arg).replace('\n', ' ') + '\n')
                hPrivFile.write (' * return executing error\n')
                hPrivFile.write (' */\n')
                hPrivFile.write ('eARCONTROLLER_ERROR ' + setNAckFunctionName (feature, cmd)+' ('+className+' *feature')
                for arg in cmd.args:
                    hPrivFile.write (', ' + xmlToC (MODULE_ARCOMMANDS, feature, cmd, arg) + ' _' + arg.name)
                hPrivFile.write (');\n')
                hPrivFile.write ('\n')
                
                for arg in cmd.args:
                    hPrivFile.write ('/**\n')
                    hPrivFile.write (' * @brief Set '+arg.name+' sent through the command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code>\n')
                    if cmd.isDeprecated:
                        hPrivFile.write (' * @deprecated\n')
                    hPrivFile.write (' * ' + cmd.doc.desc.replace('\n', '\n * ')+'\n')
                    hPrivFile.write (' * @param feature feature owning the commands\n')
                    hPrivFile.write (' * @param ' + arg.name + ' ' + get_arg_doc(arg).replace('\n', ' ') + '\n')
                    hPrivFile.write (' * return executing error\n')
                    hPrivFile.write (' */\n')
                    hPrivFile.write ('eARCONTROLLER_ERROR ' + setNAckFunctionName (feature, cmd, arg)+' ('+className+' *feature, ' + xmlToC (MODULE_ARCOMMANDS, feature, cmd, arg) + ' ' + arg.name +');\n')
                    hPrivFile.write ('\n')
                    
        for evt in feature.evts:
            hPrivFile.write ('/**\n')
            hPrivFile.write (' * @brief callback used when the command <code>' + ARCapitalize (format_cmd_name(evt)) + '</code> is decoded\n')
            hPrivFile.write (' * @param feature The feature controller registred\n')
            for arg in evt.args:
                hPrivFile.write (' * @param ' + arg.name + ' ' + get_arg_doc(arg).replace('\n', ' ') + '\n')
            hPrivFile.write (' * @param customData customData set by the register\n')
            hPrivFile.write (' */\n')
            hPrivFile.write ('void '+decodeCallback (feature, evt)+' (')
            for arg in evt.args:
                hPrivFile.write (xmlToC (MODULE_ARCOMMANDS, feature, evt, arg) + ' _' + arg.name + ', ')
            hPrivFile.write ('void *customData);\n')
            hPrivFile.write ('\n')
        
        for evt in feature.evts:
            hPrivFile.write (''+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *'+ ARFunctionName (MODULE_ARCONTROLLER, get_ftr_old_name(feature), 'newCmdElement'+ARCapitalize(format_cmd_name(evt)))+' ('+className+' *feature, ')
            for arg in evt.args:
                hPrivFile.write (xmlToC (MODULE_ARCOMMANDS, feature, evt, arg) + ' _' + arg.name + ', ')
            if evt.listType == ArCmdListType.LIST:
                hPrivFile.write ('int listIndex, ')
            hPrivFile.write ('eARCONTROLLER_ERROR *error);\n')
            hPrivFile.write ('\n')
        
        
        hPrivFile.write ('\n')
        
    hPrivFile.write ('#endif /* '+includeDefine+' */\n')
    hPrivFile.write ('\n')
    hPrivFile.write ('// END GENERATED CODE\n')
    hPrivFile.close () # see automake all source of folder !!!!!!!!
        
    #################################################
    # Write Feature controller c file               #
    #################################################
        
    #for feature in allFeatures: # see automake all source of folder !!!!!!!!!!!
        
    #className = ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), '') # see automake all source of folder !!!!!!!!!!
    classTag = 'ARCONTROLLER_Feature' #classTag = ARMacroName (MODULE_FEATURE, get_ftr_old_name(feature), '') # see automake all source of folder !!!!!!!!!!

    cFileName = CTRL_FTR_C_NAME #cFileName = className + '.c' # see automake all source of folder !!!!!!!!!!
    filepath = SRC_DIR + CTRL_FTR_C_NAME
    cFile = open (filepath, 'w')

    cFile.write ('/**********************************************************\n')
    cFile.write (' *            AUTOGENERATED FILE                          *\n')
    cFile.write (' *             DO NOT MODIFY IT                           *\n')
    cFile.write (' *                                                        *\n')
    cFile.write (' * To add new commands :                                  *\n')
    cFile.write (' *  - Modify ../Xml/commands.xml file                     *\n')
    cFile.write (' *  - Re-run generateFeatureControllers.py script         *\n')
    cFile.write (' *                                                        *\n')
    cFile.write (' **********************************************************/\n')
    cFile.write ('\n')

    cFile.write ('/**\n')
    cFile.write ('* @file '+cFileName+'\n')
    cFile.write ('* @brief Feature controller allow to send command related of a Feature.\n') #cFile.write ('* @brief Feature controller allow to send command related of '+get_ftr_old_name(feature)+' Feature.\n') # see automake all source of folder !!!!!!!!!!
    cFile.write ('*/\n')
    cFile.write ('\n')

    cFile.write ('#include <stdio.h>\n')

    cFile.write ('#include <libARSAL/ARSAL_Mutex.h>\n')
    cFile.write ('#include <libARCommands/ARCommands.h>\n')
    cFile.write ('#include <libARController/ARCONTROLLER_Network.h>\n')
    cFile.write ('#include <libARController/ARCONTROLLER_Feature.h>\n')
    cFile.write ('#include <libARController/ARCONTROLLER_Stream.h>\n')
    cFile.write ('\n')

    cFile.write ('#include "ARCONTROLLER_Stream.h"\n')
    cFile.write ('#include "ARCONTROLLER_StreamSender.h"\n')
    cFile.write ('#include "ARCONTROLLER_Feature.h"\n')
    cFile.write ('#include "ARCONTROLLER_Network.h"\n')
    cFile.write ('\n')
    cFile.write ('#define '+MODULE_FEATURE+'_TAG "'+classTag+'"\n')
    cFile.write ('\n')
    
    cFile.write ('void ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteCommandsDictionary')+' ('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' **dictionary)\n')
    cFile.write ('{\n')
    cFile.write ('    // -- Delete a commands dictionary --\n')
    
    cFile.write ('    \n')
    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *dictCmdElement = NULL;\n')
    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *dictCmdTmp = NULL;\n')
    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *dictElement = NULL;\n')
    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *dictTmp = NULL;\n')
    cFile.write ('    \n')

    cFile.write ('    if (dictionary != NULL)\n')
    cFile.write ('    {\n')
    cFile.write ('        if ((*dictionary) != NULL)\n')
    cFile.write ('        {\n')
    cFile.write ('            // Free the hash table contents\n')
    cFile.write ('            HASH_ITER(hh, (*dictionary), dictCmdElement, dictCmdTmp)\n')
    cFile.write ('            {\n')
    
    cFile.write ('                // Free the hash table contents\n')
    cFile.write ('                HASH_ITER(hh, dictCmdElement->elements, dictElement, dictTmp)\n')
    cFile.write ('                {\n')
    cFile.write ('                    // for each element\n')
    cFile.write ('                    \n')
    
    cFile.write ('                    if (dictElement->arguments != NULL)\n')
    cFile.write ('                    {\n')
    cFile.write ('                        // delete all arguments\n')
    cFile.write ('                        ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteArgumentsDictionary')+' (&(dictElement->arguments));\n')
    cFile.write ('                    }\n')
    cFile.write ('                    \n')
    
    cFile.write ('                    if (dictElement->key != NULL)\n')
    cFile.write ('                    {\n')
    cFile.write ('                        // free the key of the element\n')
    cFile.write ('                        free (dictElement->key);\n')
    cFile.write ('                        dictElement->key = NULL;\n')
    cFile.write ('                    }\n')
    cFile.write ('                    \n')
    
    cFile.write ('                    HASH_DEL (dictCmdElement->elements, dictElement);\n')
    cFile.write ('                    free (dictElement);\n')
    cFile.write ('                    dictElement = NULL;\n')
    cFile.write ('                }\n')
    cFile.write ('                \n')

    cFile.write ('                HASH_DEL ((*dictionary), dictCmdElement);\n')
    cFile.write ('                free (dictCmdElement);\n')
    cFile.write ('                dictCmdElement = NULL;\n')
    cFile.write ('            }\n')
    cFile.write ('            \n')

    cFile.write ('            free (*dictionary);\n')
    cFile.write ('            (*dictionary) = NULL;\n')
    cFile.write ('        }\n')
    cFile.write ('    }\n')
    
    cFile.write ('}\n')
    cFile.write ('\n')
    
    cFile.write (ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'NewCommandsElement')+' (int commandKey, eARCONTROLLER_ERROR *error)\n')
    cFile.write ('{\n')
    cFile.write ('    // -- New Commands Element --\n')
    cFile.write ('    \n')
    
    
    
    cFile.write ('    //local declarations\n')
    cFile.write ('    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;\n')
    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *dictCmdElement = malloc (sizeof('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+'));\n')
    cFile.write ('    \n')
    
    cFile.write ('    if (dictCmdElement != NULL)\n')
    cFile.write ('    {\n')
    cFile.write ('        dictCmdElement->command = commandKey;\n')
    cFile.write ('        dictCmdElement->elements = NULL;\n')
    cFile.write ('    }\n')
    cFile.write ('    else\n')
    cFile.write ('    {\n')
    cFile.write ('        localError = ARCONTROLLER_ERROR_ALLOC;\n')
    cFile.write ('    }\n')
    cFile.write ('    \n')
    
    cFile.write ('    // Return the error\n')
    cFile.write ('    if (error != NULL)\n')
    cFile.write ('    {\n')
    cFile.write ('        *error = localError;\n')
    cFile.write ('    }\n')
    cFile.write ('    // No else: error is not returned \n')
    cFile.write ('    \n')
    
    cFile.write ('    return dictCmdElement;\n')
    cFile.write ('}\n')
    cFile.write ('\n')
    
    cFile.write ('void ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteCommandsElement')+' ('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' **dictCmdElement)\n')
    cFile.write ('{\n')
    cFile.write ('    // -- Delete a commands Element --\n')
    
    cFile.write ('    \n')
    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *dictElement = NULL;\n')
    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *dictTmp = NULL;\n')
    cFile.write ('    \n')

    cFile.write ('    if (dictCmdElement != NULL)\n')
    cFile.write ('    {\n')
    cFile.write ('        if ((*dictCmdElement) != NULL)\n')
    cFile.write ('        {\n')
    cFile.write ('            // Free the hash table contents\n')
    cFile.write ('            HASH_ITER(hh, (*dictCmdElement)->elements, dictElement, dictTmp)\n')
    cFile.write ('            {\n')
    cFile.write ('                // for each element\n')
    cFile.write ('                \n')
    cFile.write ('                HASH_DEL ((*dictCmdElement)->elements, dictElement);\n')
    cFile.write ('                ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteElement')+' (&dictElement);\n')
    cFile.write ('            }\n')
    cFile.write ('            \n')

    cFile.write ('            free (*dictCmdElement);\n')
    cFile.write ('            (*dictCmdElement) = NULL;\n')
    cFile.write ('        }\n')
    cFile.write ('    }\n')
    
    cFile.write ('}\n')
    cFile.write ('\n')
    
    cFile.write ('void ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteElement')+' ('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' **element)\n')
    cFile.write ('{\n')
    cFile.write ('    // -- Delete an element --\n')
    cFile.write ('    \n')

    cFile.write ('    if (element != NULL)\n')
    cFile.write ('    {\n')
    cFile.write ('        if ((*element) != NULL)\n')
    cFile.write ('        {\n')
    
    cFile.write ('            if ((*element)->arguments != NULL)\n')
    cFile.write ('            {\n')
    cFile.write ('                // delete all arguments\n')
    cFile.write ('                ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteArgumentsDictionary')+' (&((*element)->arguments));\n')
    cFile.write ('            }\n')
    cFile.write ('            \n')
    
    cFile.write ('            if ((*element)->key != NULL)\n')
    cFile.write ('            {\n')
    cFile.write ('                // free the key of the element\n')
    cFile.write ('                free ((*element)->key);\n')
    cFile.write ('                (*element)->key = NULL;\n')
    cFile.write ('            }\n')
    cFile.write ('            \n')

    cFile.write ('            free (*element);\n')
    cFile.write ('            (*element) = NULL;\n')
    cFile.write ('        }\n')
    cFile.write ('    }\n')
    
    cFile.write ('}\n')
    cFile.write ('\n')

    cFile.write ('void ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteArgumentsDictionary')+' ('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ARG')+' **dictionary)\n')
    cFile.write ('{\n')
    cFile.write ('    // -- Delete arguments dictionary --\n')
    cFile.write ('    \n')
    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ARG')+' *dictElement = NULL;\n')
    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ARG')+' *dictTmp = NULL;\n')
    cFile.write ('    \n')

    cFile.write ('    if (dictionary != NULL)\n')
    cFile.write ('    {\n')
    cFile.write ('        if ((*dictionary) != NULL)\n')
    cFile.write ('        {\n')
    cFile.write ('            // Free the hash table contents\n')
    cFile.write ('            HASH_ITER(hh, (*dictionary), dictElement, dictTmp)\n')
    cFile.write ('            {\n')
    cFile.write ('                /* for each element of the arguments dictionary */\n')
    cFile.write ('                if ((dictElement->valueType == '+AREnumValue(MODULE_ARCONTROLLER, 'DICTIONARY', 'VALUE_TYPE', 'string')+') && (dictElement->value.'+ARCapitalize('string')+' != NULL))\n')
    cFile.write ('                {\n')
    cFile.write ('                    free (dictElement->value.'+ARCapitalize('string')+');\n')
    cFile.write ('                    dictElement->value.'+ARCapitalize('string')+' = NULL;\n')
    cFile.write ('                }\n')
    cFile.write ('                \n')
    
    cFile.write ('                HASH_DEL((*dictionary), dictElement);\n')
    cFile.write ('                free(dictElement);\n')
    cFile.write ('                dictElement = NULL;\n')
    cFile.write ('            }\n')
    cFile.write ('            \n')

    cFile.write ('            free (*dictionary);\n')
    cFile.write ('            (*dictionary) = NULL;\n')
    cFile.write ('        }\n')
    cFile.write ('    }\n')
    
    cFile.write ('}\n')
    cFile.write ('\n')
    
    #TODO sup
    '''
    cFile.write (''+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'FindCmdElements')+' ('+className+' *feature, int commandKey)\n')
    cFile.write ('{\n')
    cFile.write ('    // -- Find command elements --\n')
    cFile.write ('    \n')
    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *dictCmdElement = NULL;\n')
 
    cFile.write ('    ARSAL_Mutex_Lock (&(feature->privatePart->mutex));\n')
    cFile.write ('    \n')
    cFile.write ('    // Find command elements\n')
    cFile.write ('    HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);\n')
    cFile.write ('    \n')
    cFile.write ('    ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));\n')
    cFile.write ('    \n')
    cFile.write ('    return dictCmdElement;\n')
    cFile.write ('}\n')
    cFile.write ('\n')
    '''
    
    cFile.write ('void ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'AddElement')+' ('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' **elementDict, '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *newElement)\n')
    cFile.write ('{\n')
    cFile.write ('    // -- Set new element in CommandElements --\n')

    cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *oldElement = NULL;\n')
    cFile.write ('    \n')
    
    cFile.write ('    // Find if the element already exist\n')
    cFile.write ('    HASH_FIND_STR ((*elementDict), newElement->key, oldElement);\n')

    cFile.write ('    if (oldElement != NULL)\n')
    cFile.write ('    {\n')
    cFile.write ('        HASH_REPLACE_STR ((*elementDict), key, newElement, oldElement);\n')
    cFile.write ('        \n')
    cFile.write ('        ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteArgumentsDictionary')+' (&(oldElement->arguments));\n')
    cFile.write ('        free (oldElement);\n')
    cFile.write ('        oldElement = NULL;\n')
    cFile.write ('    }\n')
    cFile.write ('    else\n')
    cFile.write ('    {\n')
    cFile.write ('        HASH_ADD_KEYPTR (hh, (*elementDict), newElement->key, strlen(newElement->key), newElement);\n')
    cFile.write ('    }\n')
    cFile.write ('    \n')
    cFile.write ('}\n')
    cFile.write ('\n')
    

    for feature in ctx.features: # see automake all source of folder !!!!!!!!
        
        className = ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), '')  # see automake all source of folder !!!!
        classPrivName = ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), 'Private')  # see automake all source of folder !!!!
        
        cFile.write ('/*******************************\n') # see automake all source of folder !!!!!!!!
        cFile.write (' * --- FEATURE '+get_ftr_old_name(feature)+' --- \n') # see automake all source of folder !!!!!!!!
        cFile.write (' ******************************/\n') # see automake all source of folder !!!!!!!!
        cFile.write ('\n')
        
        cFile.write ('/*************************\n')
        cFile.write (' * Private header\n')
        cFile.write (' *************************/\n')
        cFile.write ('\n')
        
        cFile.write ('/*************************\n')
        cFile.write (' * Implementation\n')
        cFile.write (' *************************/\n')
        cFile.write ('\n')
        
        for evt in feature.evts:
            for arg in [arg1 for arg1 in evt.args if arg1.name != _LIST_FLAG]:
                cFile.write ('const char *' + defineNotification(feature, evt, arg) + ' = "' + defineNotification(feature, evt, arg).lower() + '";\n')
            cFile.write('\n');
        
        cFile.write (''+className+' *' + ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'New')+' (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error)\n')
        cFile.write ('{\n')
        cFile.write ('    // -- Create a new Feature Controller --\n')
        cFile.write ('    \n')
        
        cFile.write ('    //local declarations\n')
        cFile.write ('    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;\n')
        cFile.write ('   '+className+' *featureController =  NULL;\n')
        cFile.write ('    \n')
        
        cFile.write ('    if (localError == ARCONTROLLER_OK)\n')
        cFile.write ('    {\n')
        cFile.write ('        // Create the Feature Controller\n')
        cFile.write ('        featureController = malloc (sizeof ('+className+'));\n')
        cFile.write ('        if (featureController != NULL)\n')
        cFile.write ('        {\n')

        for cmd in feature.cmds:
            cFile.write ('            featureController->'+sendingFunction(cmd)+' = '+sendingFunctionName (MODULE_FEATURE, feature, cmd)+';\n')
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                cFile.write ('            featureController->'+setNAckFunction(cmd)+' = '+setNAckFunctionName (feature, cmd)+';\n')
                for arg in cmd.args:
                    cFile.write ('            featureController->'+setNAckFunction (cmd, arg)+' = '+setNAckFunctionName(feature, cmd, arg)+';\n')
        cFile.write ('            \n')
        cFile.write ('            featureController->privatePart = NULL;\n')
        cFile.write ('        }\n')
        cFile.write ('        else\n')
        cFile.write ('        {\n')
        cFile.write ('            localError = ARCONTROLLER_ERROR_ALLOC;\n')
        cFile.write ('        }\n')
        cFile.write ('    }\n')
        cFile.write ('    // No else: skipped by an error \n')
        cFile.write ('    \n')
        
        cFile.write ('    if (localError == ARCONTROLLER_OK)\n')
        cFile.write ('    {\n')
        cFile.write ('        // Create the Feature Controller private part\n')
        cFile.write ('        featureController->privatePart = malloc (sizeof ('+classPrivName+'));\n')
        cFile.write ('        if (featureController->privatePart != NULL)\n')
        cFile.write ('        {\n')
        cFile.write ('            featureController->privatePart->networkController = networkController;\n')
        cFile.write ('            featureController->privatePart->dictionary = NULL;\n')
        cFile.write ('            featureController->privatePart->commandCallbacks = NULL;\n')
        for cmd in feature.cmds:
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                cFile.write ('            featureController->privatePart->'+structNAckName (cmd)+' = NULL;\n')
                    
        cFile.write ('            // Create the mutex \n')
        cFile.write ('            if (ARSAL_Mutex_Init (&(featureController->privatePart->mutex)) != 0)\n')
        cFile.write ('            {\n')
        cFile.write ('                localError = ARCONTROLLER_ERROR_INIT_MUTEX;\n')
        cFile.write ('            }\n')
        cFile.write ('        }\n')
        cFile.write ('        else\n')
        cFile.write ('        {\n')
        cFile.write ('            localError = ARCONTROLLER_ERROR_ALLOC;\n')
        cFile.write ('        }\n')
        cFile.write ('    }\n')
        cFile.write ('    // No else: skipped by an error \n')
        cFile.write ('    \n')
        
        for cmd in feature.cmds:
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                cFile.write ('    if (localError == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                cFile.write ('        featureController->privatePart->'+structNAckName (cmd)+' = calloc (1, sizeof ('+structNAckType (feature, cmd)+'));\n')
                cFile.write ('        if (featureController->privatePart->'+structNAckName (cmd)+' == NULL)\n')
                cFile.write ('        {\n')
                cFile.write ('            localError = ARCONTROLLER_ERROR_ALLOC;\n')
                cFile.write ('        }\n')
                cFile.write ('    }\n')
                cFile.write ('    // No else: skipped by an error \n')
                cFile.write ('    \n')

        cFile.write ('    // delete the feature Controller if an error occurred\n')
        cFile.write ('    if (localError != ARCONTROLLER_OK)\n')
        cFile.write ('    {\n')
        cFile.write ('        ' + ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'Delete')+' (&featureController);\n')
        cFile.write ('    }\n')
        cFile.write ('    // No else: skipped no error \n')
        cFile.write ('    \n')
        
        cFile.write ('    // Return the error\n')
        cFile.write ('    if (error != NULL)\n')
        cFile.write ('    {\n')
        cFile.write ('        *error = localError;\n')
        cFile.write ('    }\n')
        cFile.write ('    // No else: error is not returned \n')
        cFile.write ('    \n')
        
        cFile.write ('    return featureController;\n')
        cFile.write ('}\n')
        cFile.write ('\n')
        
        cFile.write ('void ' + ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'Delete')+' ('+className+' **feature)\n')
        cFile.write ('{\n')
        
        cFile.write ('    // -- Delete the '+get_ftr_old_name(feature)+' feature Controller --\n')
        cFile.write ('    \n')
        
        cFile.write ('    if (feature != NULL)\n')
        cFile.write ('    {\n')
        cFile.write ('        if ((*feature) != NULL)\n')
        cFile.write ('        {\n')
        
        cFile.write ('            if ((*feature)->privatePart != NULL)\n')
        cFile.write ('            {\n')
        cFile.write ('                ARSAL_Mutex_Destroy (&((*feature)->privatePart->mutex));\n')
        cFile.write ('                \n')
        
        cFile.write ('                if ((*feature)->privatePart->dictionary != NULL)\n')
        cFile.write ('                {\n')
        cFile.write ('                    ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteCommandsDictionary')+' (&((*feature)->privatePart->dictionary));\n')
        cFile.write ('                }\n')
        cFile.write ('                \n')
        
        cFile.write ('                if ((*feature)->privatePart->commandCallbacks != NULL)\n')
        cFile.write ('                {\n')
        cFile.write ('                    // Free the hash table contents the command callback\n')
        cFile.write ('                    ARCONTROLLER_Dictionary_DeleteDictionary (&((*feature)->privatePart->commandCallbacks));\n')
        cFile.write ('                }\n')
        cFile.write ('                \n')
        
        for cmd in feature.cmds:
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                cFile.write ('                if ((*feature)->privatePart->'+structNAckName (cmd)+' != NULL)\n')
                cFile.write ('                {\n')
                cFile.write ('                    free ((*feature)->privatePart->'+structNAckName (cmd)+');\n')
                cFile.write ('                    (*feature)->privatePart->'+structNAckName (cmd)+' = NULL;\n')
                cFile.write ('                }\n')
        
        cFile.write ('                free ((*feature)->privatePart);\n')
        cFile.write ('                (*feature)->privatePart = NULL;\n')
        cFile.write ('            }\n')
        cFile.write ('            \n')
        
        cFile.write ('            free (*feature);\n')
        cFile.write ('            (*feature) = NULL;\n')
        cFile.write ('        }\n')
        cFile.write ('    }\n')
        cFile.write ('}\n')
        cFile.write ('\n')
        
        cFile.write (''+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *' + ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'GetDictionary')+' ('+className+' *feature, eARCONTROLLER_ERROR *error)\n')
        cFile.write ('{\n')
        cFile.write ('    // -- Get the dictionary of the '+get_ftr_old_name(feature)+' Feature Controller --\n')
        cFile.write ('    \n')
        cFile.write ('    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;\n')
        cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *dictionary = NULL;\n')
        cFile.write ('    \n')
        
        cFile.write ('    // Check parameters\n')
        cFile.write ('    if ((feature == NULL) || (feature->privatePart == NULL))\n')
        cFile.write ('    {\n')
        cFile.write ('        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
        cFile.write ('    }\n')
        cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
        cFile.write ('    \n')
        
        cFile.write ('    if (localError == ARCONTROLLER_OK)\n')
        cFile.write ('    {\n')
        cFile.write ('        dictionary = feature->privatePart->dictionary;\n')
        cFile.write ('    }\n')
        cFile.write ('    \n')
        
        cFile.write ('    // Return the error\n')
        cFile.write ('    if (error != NULL)\n')
        cFile.write ('    {\n')
        cFile.write ('        *error = localError;\n')
        cFile.write ('    }\n')
        cFile.write ('    // No else: error is not returned \n')
        cFile.write ('    \n')
        
        cFile.write ('    return dictionary;\n')
        cFile.write ('}\n')
        cFile.write ('\n')
        
        cFile.write ('eARCONTROLLER_ERROR '+ARFunctionName(MODULE_FEATURE, get_ftr_old_name(feature), 'AddCallback')+' ('+className+' *feature, '+defineNotificationDef()+' commandKey, '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'CALLBACK')+' callback, void *customData)\n')
        cFile.write ('{\n')
        
        cFile.write ('    // -- Add a callback to use when a command in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> is received --\n')
        cFile.write ('    \n')
        
        cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
        cFile.write ('    \n')
        
        cFile.write ('    // Check parameters\n')
        cFile.write ('    if ((feature == NULL) || (feature->privatePart == NULL))\n')
        cFile.write ('    {\n')
        cFile.write ('        error = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
        cFile.write ('    }\n')
        cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
        cFile.write ('    \n')
        
        cFile.write ('    if (error == ARCONTROLLER_OK)\n')
        cFile.write ('    {\n')
        cFile.write ('        error = ARCONTROLLER_Dictionary_AddDictionaryElement (&(feature->privatePart->commandCallbacks), commandKey, callback, customData);\n')
        cFile.write ('    }\n')
        cFile.write ('    \n')
        
        cFile.write ('    return error;\n')
        cFile.write ('}\n')
        cFile.write ('\n')
        
        cFile.write ('eARCONTROLLER_ERROR '+ARFunctionName(MODULE_FEATURE, get_ftr_old_name(feature), 'RemoveCallback')+' ('+className+' *feature, '+defineNotificationDef()+' commandKey, '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'CALLBACK')+' callback, void *customData)\n')
        cFile.write ('{\n')
        cFile.write ('    // -- Remove a callback to use when a command in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> is received --\n')
        cFile.write ('    \n')
        
        cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
        cFile.write ('    \n')
        
        cFile.write ('    // Check parameters\n')
        cFile.write ('    if ((feature == NULL) || (feature->privatePart == NULL))\n')
        cFile.write ('    {\n')
        cFile.write ('        error = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
        cFile.write ('    }\n')
        cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
        cFile.write ('    \n')
        
        cFile.write ('    if (error == ARCONTROLLER_OK)\n')
        cFile.write ('    {\n')
        
        cFile.write ('        error = ARCONTROLLER_Dictionary_RemoveDictionaryElement (feature->privatePart->commandCallbacks, commandKey, callback, customData);\n')
        
        cFile.write ('    }\n')
        cFile.write ('    \n')
        
        cFile.write ('    return error;\n')
        cFile.write ('}\n')
        cFile.write ('\n')
        
        cFile.write ('eARCONTROLLER_ERROR '+ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'RegisterARCommands')+' ('+className+' *feature)\n')
        cFile.write ('{\n')
        cFile.write ('    // -- Register the feature controller to be called when the commands are decoded. -- \n')
        cFile.write ('    \n')
        
        cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
        cFile.write ('    \n')
        
        cFile.write ('    // Check parameters\n')
        cFile.write ('    if ((feature == NULL) || (feature->privatePart == NULL) || (feature->privatePart->networkController == NULL) || (feature->privatePart->networkController->decoder == NULL))\n')
        cFile.write ('    {\n')
        cFile.write ('        error = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
        cFile.write ('    }\n')
        cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
        cFile.write ('    \n')
        
        cFile.write ('    if (error == ARCONTROLLER_OK)\n')
        cFile.write ('    {\n')
        
        for evt in feature.evts:
            cFile.write ('        '+arcommandsSetDecode(feature, evt)+' (feature->privatePart->networkController->decoder, &'+decodeCallback(feature, evt)+', feature);\n')
        cFile.write ('    }\n')
        cFile.write ('    \n')
        cFile.write ('    return error;\n')
        cFile.write ('}\n')
        cFile.write ('\n')
        
        cFile.write ('eARCONTROLLER_ERROR '+ARFunctionName (MODULE_FEATURE, get_ftr_old_name(feature), 'UnregisterARCommands')+' ('+className+' *feature)\n')
        cFile.write ('{\n')
        cFile.write ('    // -- Unregister the feature controller to be called when the commands are decoded. -- \n')
        cFile.write ('    \n')
        
        cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
        cFile.write ('    \n')
        
        cFile.write ('    // Check parameters\n')
        cFile.write ('    if ((feature == NULL) || (feature->privatePart == NULL) || (feature->privatePart->networkController == NULL) || (feature->privatePart->networkController->decoder == NULL))\n')
        cFile.write ('    {\n')
        cFile.write ('        error = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
        cFile.write ('    }\n')
        cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
        cFile.write ('    \n')
        
        cFile.write ('    if (error == ARCONTROLLER_OK)\n')
        cFile.write ('    {\n')
        
        for evt in feature.evts:
            cFile.write ('        '+arcommandsSetDecode(feature, evt)+' (feature->privatePart->networkController->decoder, NULL, NULL);\n')
        cFile.write ('    }\n')
        cFile.write ('    \n')
        cFile.write ('    return error;\n')
        cFile.write ('}\n')
        cFile.write ('\n')
        
        for cmd in feature.cmds:
            cFile.write ('eARCONTROLLER_ERROR ' + sendingFunctionName (MODULE_FEATURE, feature, cmd)+' ('+className+' *feature')
            for arg in cmd.args:
                cFile.write (', ' + xmlToC (MODULE_ARCOMMANDS, feature, cmd, arg) + ' ' + arg.name)
            cFile.write (')\n')
            cFile.write ('{\n')
            cFile.write ('    // -- Send a command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> --\n')
            cFile.write ('    \n')
            cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
            cFile.write ('    u_int8_t cmdBuffer[128];\n')
            cFile.write ('    int32_t cmdSize = 0;\n')
            cFile.write ('    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;\n')
            cFile.write ('    eARNETWORK_ERROR netError = ARNETWORK_OK;\n')
            cFile.write ('    \n')
            
            cFile.write ('    // Check parameters\n')
            cFile.write ('    if (feature == NULL)\n')
            cFile.write ('    {\n')
            cFile.write ('        error = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
            cFile.write ('    }\n')
            cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
            cFile.write ('    \n')
            
            cFile.write ('    if (error == ARCONTROLLER_OK)\n')
            cFile.write ('    {\n')
            cFile.write ('        // Send ' + ARCapitalize(cmd.name) + ' command\n')
            cFile.write ('        cmdError = ARCOMMANDS_Generator_Generate' + ARCapitalize(get_ftr_old_name(feature)) + ARCapitalize(format_cmd_name(cmd)) + '(cmdBuffer, sizeof(cmdBuffer), &cmdSize')
            for arg in cmd.args:
                cFile.write (', ' + arg.name)
            cFile.write(');\n')
            cFile.write ('        if (cmdError != ARCOMMANDS_GENERATOR_OK)\n')
            cFile.write ('        {\n')
            cFile.write ('            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;\n')
            cFile.write ('        }\n')
            cFile.write ('    }\n')
            cFile.write ('    \n')
            
            cFile.write ('    if (error == ARCONTROLLER_OK)\n')
            cFile.write ('    {\n')
            
            bufferType = 'ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK'
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                bufferType = 'ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_NOT_ACK'
            elif cmd.bufferType == ArCmdBufferType.ACK:
                bufferType = 'ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK'
            elif cmd.bufferType == ArCmdBufferType.HIGH_PRIO:
                bufferType = 'ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_HIGH_PRIORITY'
                
            timeoutPolicy = 'ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP'
            if cmd.timeoutPolicy == ArCmdTimeoutPolicy.POP:
                timeoutPolicy = 'ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP'
            elif cmd.timeoutPolicy == ArCmdTimeoutPolicy.RETRY:
                timeoutPolicy = 'ARNETWORK_MANAGER_CALLBACK_RETURN_RETRY'

            cFile.write ('        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, '+bufferType+', '+timeoutPolicy+', &netError);\n')
            
            ''' TODO manage error !!!!!!!!!!!!
            cFile.write ('        \n')
            cFile.write ('        if ((error != ARCONTROLLER_OK) || (netError != ARNETWORK_OK))\n')
            cFile.write ('        {\n')
            cFile.write ('            \n')
            cFile.write ('        }\n')
            '''

            cFile.write ('    }\n')
            cFile.write ('    \n')
            
            cFile.write ('    return error;\n')
            cFile.write ('}\n')
            cFile.write ('\n')
            
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                cFile.write ('eARCONTROLLER_ERROR ' + setNAckFunctionName (feature, cmd)+' ('+className+' *feature')
                for arg in cmd.args:
                    cFile.write (', ' + xmlToC (MODULE_ARCOMMANDS, feature, cmd, arg) + ' _' + arg.name)
                cFile.write (')\n')
                cFile.write ('{\n')
                
                cFile.write ('    // -- Set the parameter for the command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> --\n')
                cFile.write ('    \n')
                cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
                cFile.write ('    \n')
                
                cFile.write ('    // Check parameters\n')
                cFile.write ('    if ((feature == NULL) ||\n')
                cFile.write ('       (feature->privatePart == NULL) ||\n')
                cFile.write ('       (feature->privatePart->'+structNAckName (cmd)+' == NULL))\n')
                cFile.write ('    {\n')
                cFile.write ('        error = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
                cFile.write ('    }\n')
                cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
                cFile.write ('    \n')
                
                cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                for arg in cmd.args:
                    cFile.write ('        feature->privatePart->'+structNAckName(cmd)+'->' + arg.name + ' = _'+arg.name+';\n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
                cFile.write ('    return error;\n')
                cFile.write ('}\n')
                cFile.write ('\n')
                
                cFile.write ('eARCONTROLLER_ERROR '+ sendNAckFunctionName (feature, cmd)+' ('+className+' *feature, u_int8_t *cmdBuffer, int32_t cmdBufferSize)\n')
                cFile.write ('{\n')
                cFile.write ('    // -- Send the a command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> with the parame set beforehand  --\n')
                cFile.write ('    \n')
                cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
                cFile.write ('    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;\n')
                cFile.write ('    eARNETWORK_ERROR netError = ARNETWORK_OK;\n')
                cFile.write ('    int32_t cmdSize = 0;\n')
                cFile.write ('    \n')
                
                cFile.write ('    // Check parameters\n')
                cFile.write ('    if ((feature == NULL) ||\n')
                cFile.write ('       (feature->privatePart == NULL) ||\n')
                cFile.write ('       (feature->privatePart->'+structNAckName (cmd)+' == NULL) ||\n')
                cFile.write ('       (cmdBuffer == NULL))\n')
                cFile.write ('    {\n')
                cFile.write ('        error = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
                cFile.write ('    }\n')
                cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
                cFile.write ('    \n')
                
                cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                
                cFile.write ('        // Send ' + ARCapitalize(cmd.name) + ' command\n')
                cFile.write ('        cmdError = ARCOMMANDS_Generator_Generate' + ARCapitalize(get_ftr_old_name(feature)) + ARCapitalize(format_cmd_name(cmd)) + '(cmdBuffer, cmdBufferSize, &cmdSize')
                for arg in cmd.args:
                        cFile.write (', feature->privatePart->'+structNAckName (cmd)+'->' + arg.name)
                cFile.write(');\n')
                cFile.write ('        if (cmdError != ARCOMMANDS_GENERATOR_OK)\n')
                cFile.write ('        {\n')
                cFile.write ('            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;\n')
                cFile.write ('        }\n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
                cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                cFile.write ('        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_NOT_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);\n')
                cFile.write ('        if (netError != ARNETWORK_OK)\n')
                cFile.write ('        {\n')
                cFile.write ('            ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_FEATURE_TAG, "Network sending error : %s", ARNETWORK_Error_ToString (netError));\n')
                cFile.write ('        }\n')
                cFile.write ('        \n')
                
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
                cFile.write ('    return error;\n')
                cFile.write ('}\n')
                cFile.write ('\n')
                
                for arg in cmd.args:
                    cFile.write ('eARCONTROLLER_ERROR ' + setNAckFunctionName (feature, cmd, arg)+' ('+className+' *feature, ' + xmlToC (MODULE_ARCOMMANDS, feature, cmd, arg) + ' _'+ arg.name +')\n')
                    cFile.write ('{\n')
                    
                    cFile.write ('    // -- Set the '+arg.name+' for the command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code> in project <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> --\n')
                    cFile.write ('    \n')
                    cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
                    cFile.write ('    \n')
                    
                    cFile.write ('    // Check parameters\n')
                    cFile.write ('    if ((feature == NULL) ||\n')
                    cFile.write ('       (feature->privatePart == NULL) ||\n')
                    cFile.write ('       (feature->privatePart->'+structNAckName (cmd)+' == NULL))\n')
                    cFile.write ('    {\n')
                    cFile.write ('        error = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
                    cFile.write ('    }\n')
                    cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
                    cFile.write ('    \n')
                    
                    cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                    cFile.write ('    {\n')
                    cFile.write ('        feature->privatePart->'+structNAckName(cmd)+'->' + arg.name + ' = _'+arg.name+';\n')
                    cFile.write ('    }\n')
                    cFile.write ('    \n')
                    
                    cFile.write ('    return error;\n')
                    cFile.write ('}\n')
                    cFile.write ('\n')

        for evt in feature.evts:
            cFile.write ('void '+decodeCallback (feature, evt)+' (')
            for arg in evt.args:
                cFile.write (xmlToC (MODULE_ARCOMMANDS, feature, evt, arg) + ' _' + arg.name + ', ')
            cFile.write ('void *customData)\n')
            cFile.write ('{\n')
            cFile.write ('    // -- callback used when the command <code>' + ARCapitalize (format_cmd_name(evt)) + '</code> is decoded -- \n')
            cFile.write ('    \n')
            
            cFile.write ('    '+className+' *feature = ('+className+' *)customData;\n')
            cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
            cFile.write ('    int commandKey = '+defineNotification(feature, evt)+';\n')
            #if not evt.isNotif: #TODO add
            cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'COMMANDS')+' *dictCmdElement = NULL;\n')
            cFile.write ('    int isANewCommandElement = 0;\n')
            cFile.write ('    int elementAdded = 0;\n')
            
            cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *newElement = NULL;\n')
            if evt.listType == ArCmdListType.LIST:
                cFile.write ('    int listIndex = 0;\n')
            if _LIST_FLAG in evt.argsByName:
                list_flags = getGenericListFlagsEnum(ctx)
                if _LIST_FLAG in evt.argsByName and evt.listType == ArCmdListType.MAP:
                    cFile.write ('    int remove = (_'+evt.argsByName[_LIST_FLAG].name+' & ' + ARFlagValue (MODULE_ARCOMMANDS, 'generic', list_flags.name, 'remove')+');\n')
                cFile.write ('    int clear = (_'+evt.argsByName[_LIST_FLAG].name+' & (' + ARFlagValue (MODULE_ARCOMMANDS, 'generic', list_flags.name, 'first') +' | ' + ARFlagValue (MODULE_ARCOMMANDS, 'generic', list_flags.name, 'empty')+'));\n')
                cFile.write ('    int notify = (_'+evt.argsByName[_LIST_FLAG].name+' & (' + ARFlagValue (MODULE_ARCOMMANDS, 'generic', list_flags.name, 'last') +' | ' + ARFlagValue (MODULE_ARCOMMANDS, 'generic', list_flags.name, 'empty')+'));\n')
                cFile.write ('    int add = !(_'+evt.argsByName[_LIST_FLAG].name+' & (' + ARFlagValue (MODULE_ARCOMMANDS, 'generic', list_flags.name, 'remove') +' | ' + ARFlagValue (MODULE_ARCOMMANDS, 'generic', list_flags.name, 'empty')+'));\n')
                cFile.write ('\n')
                if evt.listType == ArCmdListType.MAP:
                    cFile.write ('    ARCONTROLLER_DICTIONARY_ELEMENT_t *dictElement = NULL;\n')
                    if not evt.mapKey.argType == ArArgType.STRING:
                        cFile.write ('    int elementKeyLength = 0;\n')
                        cFile.write ('    char *elementKey = NULL;\n')
                        cFile.write ('\n')

            cFile.write ('    // Check parameters\n')
            cFile.write ('    if ((feature == NULL) || (feature->privatePart == NULL))\n')
            cFile.write ('    {\n')
            cFile.write ('        error = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
            cFile.write ('    }\n')
            cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
            cFile.write ('    \n')
            
            if _LIST_FLAG in evt.argsByName:
                cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                cFile.write ('        // Find command elements\n')
                cFile.write ('        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));\n')
                cFile.write ('        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);\n')
                cFile.write ('        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));\n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
                cFile.write ('    if ((error == ARCONTROLLER_OK) && (dictCmdElement != NULL) && (clear))\n')
                cFile.write ('    {\n')
                cFile.write ('        //Delete the command\n')
                cFile.write ('        HASH_DEL (feature->privatePart->dictionary, dictCmdElement);\n')
                cFile.write ('        ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteCommandsElement')+'(&dictCmdElement);\n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
                cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                if evt.listType == ArCmdListType.MAP:
                    cFile.write ('        if (remove)\n')
                    cFile.write ('        {\n')
                    cFile.write ('            //remove element\n')
                    cFile.write ('            ARSAL_Mutex_Lock (&(feature->privatePart->mutex));\n')
                    if not evt.mapKey.argType == ArArgType.STRING:
                        cFile.write ('            elementKeyLength = snprintf (NULL, 0, '+xmlToFormat(evt.mapKey)+', _'+evt.mapKey.name+');\n')
                        cFile.write ('            elementKey = malloc (elementKeyLength + 1);\n')
                        cFile.write ('            if (elementKey != NULL)\n')
                        cFile.write ('            {\n')
                        cFile.write ('                snprintf (elementKey, (elementKeyLength + 1), '+xmlToFormat(evt.mapKey)+', _'+evt.mapKey.name+');\n')
                        cFile.write ('                HASH_FIND_STR (dictCmdElement->elements, elementKey, dictElement);\n')
                        cFile.write ('            }\n')
                    else:
                        cFile.write ('            HASH_FIND_STR (dictCmdElement->elements, _'+evt.mapKey.name+', dictElement);\n')

                    cFile.write ('            if (dictElement != NULL)\n')
                    cFile.write ('            {\n')
                    cFile.write ('                HASH_DEL (dictCmdElement->elements, dictElement);\n')
                    cFile.write ('                ARCONTROLLER_Feature_DeleteElement (&dictElement);\n')
                    if not evt.mapKey.argType == ArArgType.STRING:
                        cFile.write ('                free (elementKey);\n')
                        cFile.write ('                elementKey = NULL;\n')
                    cFile.write ('            }\n')
                    cFile.write ('            ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));\n')
                    cFile.write ('            // force notifying when removing because the Mambo does not send last when removing a usbAccessory\n')
                    cFile.write ('            notify = 1;\n')
                    cFile.write ('        }\n')
                    cFile.write ('\n')
                
                cFile.write ('        if (add)\n')
                cFile.write ('        {\n')
                
                #if not evt.isNotif: #TODO add
                cFile.write ('            if (dictCmdElement == NULL)\n')
                cFile.write ('            {\n')
                cFile.write ('                // New command element\n')
                cFile.write ('                isANewCommandElement = 1;\n')
                cFile.write ('                dictCmdElement = ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'NewCommandsElement')+' (commandKey, &error);\n')
                cFile.write ('            }\n')
                cFile.write ('            // No Else ; commandElement already exists.\n')
                cFile.write ('            \n')
                
                #if not evt.isNotif: #TODO add
                if evt.listType == ArCmdListType.LIST:
                    cFile.write ('            if (error == ARCONTROLLER_OK)\n')
                    cFile.write ('            {\n')
                    cFile.write ('                ARSAL_Mutex_Lock (&(feature->privatePart->mutex));\n')
                    cFile.write ('                listIndex = HASH_COUNT (dictCmdElement->elements);\n')
                    cFile.write ('                ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));\n')
                    cFile.write ('            }\n')
                    cFile.write ('            \n')
                
                cFile.write ('            //Create new element\n')
                cFile.write ('            newElement = '+ ARFunctionName (MODULE_ARCONTROLLER, get_ftr_old_name(feature), 'newCmdElement'+ARCapitalize(format_cmd_name(evt)))+' (feature,')
                for arg in evt.args:
                    cFile.write (' _' + arg.name + ', ')
                if evt.listType == ArCmdListType.LIST:
                    cFile.write ('listIndex, ')
                cFile.write ('&error);\n')
                cFile.write ('            \n')
                
                #if not evt.isNotif: #TODO add
                cFile.write ('            //Set new element in CommandElements \n')
                cFile.write ('            if (error == ARCONTROLLER_OK)\n')
                cFile.write ('            {\n')
                cFile.write ('                ARSAL_Mutex_Lock (&(feature->privatePart->mutex));\n')
                cFile.write ('                \n')
                cFile.write ('                ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'AddElement')+' (&(dictCmdElement->elements), newElement);\n')
                cFile.write ('                \n')
                
                cFile.write ('                //Add new commandElement if necessary\n')
                cFile.write ('                if (isANewCommandElement)\n')
                cFile.write ('                {\n')
                cFile.write ('                    HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);\n')
                cFile.write ('                }\n')
                cFile.write ('                \n')
                
                cFile.write ('                elementAdded = 1;\n')
                cFile.write ('                \n')
                
                cFile.write ('                ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));\n')
                cFile.write ('            }\n')
                
                cFile.write ('        }\n')
                cFile.write ('        \n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
                cFile.write ('    if ((error == ARCONTROLLER_OK) && (notify))\n')
                cFile.write ('    {\n')
                cFile.write ('        // Notification Callback\n')
                cFile.write ('        if (dictCmdElement != NULL) {\n')
                cFile.write ('            error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);\n')
                cFile.write ('        } else {\n')
                cFile.write ('            error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, commandKey, NULL);\n')
                cFile.write ('        }\n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
            else:
                #if not evt.isNotif: #TODO add
                cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                cFile.write ('        // Find command elements\n')
                cFile.write ('        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));\n')
                cFile.write ('        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);\n')
                cFile.write ('        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));\n')
                cFile.write ('        \n')
                cFile.write ('        if (dictCmdElement == NULL)\n')
                cFile.write ('        {\n')
                cFile.write ('            // New command element\n')
                cFile.write ('            isANewCommandElement = 1;\n')
                cFile.write ('            dictCmdElement = ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'NewCommandsElement')+' (commandKey, &error);\n')
                cFile.write ('        }\n')
                cFile.write ('        // No Else ; commandElement already exists.\n')
                cFile.write ('        \n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
                #if not evt.isNotif: #TODO add
                if evt.listType == ArCmdListType.LIST:
                    cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                    cFile.write ('    {\n')
                    cFile.write ('        listIndex = HASH_COUNT (dictCmdElement->elements);\n')
                    cFile.write ('    }\n')
                    cFile.write ('    \n')
                
                cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                cFile.write ('        //Create new element\n')
                cFile.write ('        newElement = '+ ARFunctionName (MODULE_ARCONTROLLER, get_ftr_old_name(feature), 'newCmdElement'+ARCapitalize(format_cmd_name(evt)))+' (feature, ')
                for arg in evt.args:
                    cFile.write (' _' + arg.name + ', ')
                if evt.listType == ArCmdListType.LIST:
                    cFile.write ('listIndex, ')
                cFile.write ('&error);\n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
                #if not evt.isNotif: #TODO add
                cFile.write ('    //Set new element in CommandElements \n')
                cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                cFile.write ('        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));\n')
                cFile.write ('        \n')
                cFile.write ('        ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'AddElement')+' (&(dictCmdElement->elements), newElement);\n')
                cFile.write ('        \n')
                
                cFile.write ('        //Add new commandElement if necessary\n')
                cFile.write ('        if (isANewCommandElement)\n')
                cFile.write ('        {\n')
                cFile.write ('            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);\n')
                cFile.write ('        }\n')
                cFile.write ('        \n')
                
                cFile.write ('        elementAdded = 1;\n')
                cFile.write ('        \n')
                
                cFile.write ('        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));\n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
                cFile.write ('    if (error == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                cFile.write ('        // Notification Callback\n')
                cFile.write ('        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);\n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
                
                
            
            #TODO sup new element  notif
            #if not evt.isNotif: #TODO add
            cFile.write ('    // if an error occurred \n')
            cFile.write ('    if (error != ARCONTROLLER_OK)\n')
            cFile.write ('    {\n')
            cFile.write ('        // cleanup\n')
            #cFile.write ('        if ((dictCmdElement != NULL) && (!elementAdded ))\n')
            cFile.write ('        if ((dictCmdElement != NULL) && (isANewCommandElement))\n')
            cFile.write ('        {\n')
            cFile.write ('            ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteCommandsElement')+'(&dictCmdElement);\n')
            cFile.write ('        }\n')
            cFile.write ('        \n')
            
            cFile.write ('        if ((newElement != NULL) && (!elementAdded ))\n')
            cFile.write ('        {\n')
            cFile.write ('            ' + ARFunctionName (MODULE_ARCONTROLLER, 'feature', 'DeleteElement')+' (&newElement);\n')
            cFile.write ('        }\n')
            cFile.write ('        \n')
            cFile.write ('    }\n')
            cFile.write ('    \n')
            
            cFile.write ('}\n')
            cFile.write ('\n')
            
        for evt in feature.evts:
            cFile.write (''+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *'+ ARFunctionName (MODULE_ARCONTROLLER, get_ftr_old_name(feature), 'newCmdElement'+ARCapitalize(format_cmd_name(evt)))+' ('+className+' *feature, ')
            for arg in evt.args:
                cFile.write (xmlToC (MODULE_ARCOMMANDS, feature, evt, arg) + ' _' + arg.name + ', ')
            if evt.listType == ArCmdListType.LIST:
                cFile.write ('int listIndex, ')
            cFile.write ('eARCONTROLLER_ERROR *error)\n')
            cFile.write ('{\n')
            cFile.write ('    // -- Create element of an event '+ARCapitalize(format_cmd_name(evt))+' -- \n')
            cFile.write ('    \n')
            cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+' *newElement = NULL;\n')
            cFile.write ('    int elementKeyLength = 0;\n')
            if evt.args:
                cFile.write ('    '+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ARG')+' *argDictNewElement = NULL;\n')
            if [ a for a in evt.args if a.argType == ArArgType.STRING ]:
                cFile.write ('    int strLength = 0;\n')
 
            cFile.write ('    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;\n')
            cFile.write ('    \n')
            
            cFile.write ('    // Check parameters\n')
            cFile.write ('    if ((feature == NULL) || (feature->privatePart == NULL))\n')
            cFile.write ('    {\n')
            cFile.write ('        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
            cFile.write ('    }\n')
            cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
            cFile.write ('    \n')
            
            cFile.write ('    //Create Element Dictionary\n')
            cFile.write ('    if (localError == ARCONTROLLER_OK)\n')
            cFile.write ('    {\n')
            cFile.write ('        // New element\n')
            cFile.write ('        newElement = malloc (sizeof('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ELEMENT')+'));\n')
            cFile.write ('        if (newElement != NULL)\n')
            cFile.write ('        {\n')
            cFile.write ('            newElement->key = NULL;\n')
            cFile.write ('            newElement->arguments = NULL;\n')
            cFile.write ('        }\n')
            cFile.write ('        else\n')
            cFile.write ('        {\n')
            cFile.write ('            localError = ARCONTROLLER_ERROR_ALLOC;\n')
            cFile.write ('        }\n')
            cFile.write ('    }\n')
            cFile.write ('    \n')
            
            cFile.write ('    if (localError == ARCONTROLLER_OK)\n')
            cFile.write ('    {\n')
            if evt.listType == ArCmdListType.LIST:
                cFile.write ('        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));\n')
                cFile.write ('        \n')
                
            cFile.write ('        //Alloc Element Key\n')
            if evt.listType == ArCmdListType.MAP:
                if evt.mapKey.argType == ArArgType.STRING:
                    cFile.write ('        elementKeyLength = strlen (_'+evt.mapKey.name+');\n')
                else:
                    cFile.write ('        elementKeyLength = snprintf (NULL, 0, '+xmlToFormat(evt.mapKey)+', _'+evt.mapKey.name+');\n')
            elif evt.listType == ArCmdListType.LIST:
                cFile.write ('        elementKeyLength = snprintf (NULL, 0, "%d", listIndex);\n')
            elif evt.listType == ArCmdListType.NONE:
                cFile.write ('        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);\n')
            
            cFile.write ('        newElement->key = malloc (elementKeyLength + 1);\n')
            cFile.write ('        if (newElement->key != NULL)\n')
            cFile.write ('        {\n')
            if evt.listType == ArCmdListType.MAP:
                if evt.mapKey.argType == ArArgType.STRING:
                    cFile.write ('            strncpy (newElement->key, _'+evt.mapKey.name+', (elementKeyLength + 1));\n')
                else:
                    cFile.write ('            snprintf (newElement->key, (elementKeyLength + 1), '+xmlToFormat(evt.mapKey)+', _'+evt.mapKey.name+');\n')
            
            elif evt.listType == ArCmdListType.LIST:
                cFile.write ('            snprintf (newElement->key, (elementKeyLength + 1), "%d", listIndex);\n')
            elif evt.listType == ArCmdListType.NONE:
                cFile.write ('            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));\n')
            
            cFile.write ('            newElement->key[elementKeyLength] = \'\\0\';\n')
            cFile.write ('        }\n')
            cFile.write ('        else\n')
            cFile.write ('        {\n')
            cFile.write ('            localError = ARCONTROLLER_ERROR_ALLOC;\n')
            cFile.write ('        }\n')
            if evt.listType == ArCmdListType.LIST:
                cFile.write ('        \n')
                cFile.write ('        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));\n')
            cFile.write ('    }\n')
            cFile.write ('    \n')
            
            cFile.write ('    //Create argument Dictionary\n')
            for arg in [arg1 for arg1 in evt.args if arg1.name != _LIST_FLAG]:
                cFile.write ('    //Add argument To the element\n')
                cFile.write ('    if (localError == ARCONTROLLER_OK)\n')
                cFile.write ('    {\n')
                
                cFile.write ('        // New argument element\n')
                cFile.write ('        argDictNewElement = malloc (sizeof('+ARTypeName(MODULE_ARCONTROLLER, 'DICTIONARY', 'ARG')+'));\n')
                cFile.write ('        if (argDictNewElement != NULL)\n')
                cFile.write ('        {\n')
                if isinstance(arg.argType, ArEnum):
                    cFile.write ('            argDictNewElement->valueType = '+AREnumValue(MODULE_ARCONTROLLER, 'DICTIONARY', 'VALUE_TYPE', 'ENUM')+';\n')
                elif isinstance(arg.argType, ArBitfield):
                    cFile.write ('            argDictNewElement->valueType = '+AREnumValue(MODULE_ARCONTROLLER, 'DICTIONARY', 'VALUE_TYPE', ArArgType.TO_STRING[arg.argType.btfType])+';\n')
                else:
                    cFile.write ('            argDictNewElement->valueType = '+AREnumValue(MODULE_ARCONTROLLER, 'DICTIONARY', 'VALUE_TYPE', ArArgType.TO_STRING[arg.argType])+';\n')
                
                cFile.write ('            argDictNewElement->argument = '+defineNotification(feature, evt, arg)+';\n')
                
                if arg.argType == ArArgType.STRING:
                    cFile.write ('            strLength = strlen (_'+arg.name+');\n')
                    cFile.write ('            argDictNewElement->value.'+ARCapitalize(ArArgType.TO_STRING[arg.argType])+' = malloc (strLength + 1);\n')
                    cFile.write ('            if (argDictNewElement->value.'+ARCapitalize(ArArgType.TO_STRING[arg.argType])+' != NULL)\n')
                    cFile.write ('            {\n')
                    cFile.write ('                strncpy (argDictNewElement->value.'+ARCapitalize(ArArgType.TO_STRING[arg.argType])+', _'+arg.name+', strLength);\n')
                    cFile.write ('                argDictNewElement->value.'+ARCapitalize(ArArgType.TO_STRING[arg.argType])+'[strLength] = \'\\0\';\n')
                    cFile.write ('            }\n')
                    cFile.write ('            else\n')
                    cFile.write ('            {\n')
                    cFile.write ('                localError = ARCONTROLLER_ERROR_ALLOC;\n')
                    cFile.write ('            }\n')
                elif isinstance(arg.argType, ArEnum):
                    cFile.write ('            argDictNewElement->value.'+ARCapitalize('i32')+' = _'+arg.name+';\n')
                elif isinstance(arg.argType, ArBitfield):
                    cFile.write ('            argDictNewElement->value.'+ARCapitalize(ArArgType.TO_STRING[arg.argType.btfType])+' = _'+arg.name+';\n')
                else:
                    cFile.write ('            argDictNewElement->value.'+ARCapitalize(ArArgType.TO_STRING[arg.argType])+' = _'+arg.name+';\n')                    
                cFile.write ('            \n')
                
                if arg.argType == ArArgType.STRING:
                    cFile.write ('            if (localError == ARCONTROLLER_OK)\n')
                    cFile.write ('            {\n')
                    cFile.write ('                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);\n')
                    cFile.write ('            }\n')
                else:
                    cFile.write ('            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);\n')
                cFile.write ('        }\n')
                cFile.write ('        else\n')
                cFile.write ('        {\n')
                cFile.write ('            localError = ARCONTROLLER_ERROR_ALLOC;\n')
                cFile.write ('        }\n')
                cFile.write ('    }\n')
                cFile.write ('    \n')
                
            cFile.write ('    // If an error occurred \n')
            cFile.write ('    if (localError != ARCONTROLLER_OK)\n')
            cFile.write ('    {\n')
            
            cFile.write ('        // cleanup\n')
            cFile.write ('        if (newElement != NULL)\n')
            cFile.write ('        {\n')
            cFile.write ('            if (newElement->arguments != NULL)\n')
            cFile.write ('            {\n')
            
            for arg in evt.args:
                if arg.argType == ArArgType.STRING:
                    cFile.write ('                if (newElement->arguments->value.'+ARCapitalize(ArArgType.TO_STRING[arg.argType])+' != NULL)\n')
                    cFile.write ('                {\n')
                    cFile.write ('                    free(newElement->arguments->value.'+ARCapitalize(ArArgType.TO_STRING[arg.argType])+');\n')
                    cFile.write ('                    newElement->arguments->value.'+ARCapitalize(ArArgType.TO_STRING[arg.argType])+' = NULL;\n')
                    cFile.write ('                }\n')
                    cFile.write ('                \n')
            
            cFile.write ('                free (newElement->arguments);\n')
            cFile.write ('                newElement->arguments = NULL;\n')
            cFile.write ('            }\n')
            cFile.write ('            \n')
            
            cFile.write ('            if (newElement->key != NULL)\n')
            cFile.write ('            {\n')
            cFile.write ('                free (newElement->key);\n')
            cFile.write ('                newElement->key = NULL;\n')
            cFile.write ('            }\n')
            cFile.write ('            \n')
            
            cFile.write ('            free (newElement);\n')
            cFile.write ('            newElement = NULL;\n')
            cFile.write ('        }\n')
            
            if evt.args:
                cFile.write ('\n')
                cFile.write ('        free (argDictNewElement);\n')
                cFile.write ('        argDictNewElement = NULL;\n')
            
            cFile.write ('    }\n')
            
            cFile.write ('    // Return the error\n')
            cFile.write ('    if (error != NULL)\n')
            cFile.write ('    {\n')
            cFile.write ('        *error = localError;\n')
            cFile.write ('    }\n')
            cFile.write ('    // No else: error is not returned \n')
            cFile.write ('    \n')
            
            cFile.write ('    return newElement;\n')
            cFile.write ('}\n')
            cFile.write ('\n')
            
        cFile.write ('eARCONTROLLER_ERROR '+ARFunctionName(MODULE_FEATURE, get_ftr_old_name(feature), 'SetNetworkController')+' ('+className+' *feature, ARCONTROLLER_Network_t *networkController)\n')
        cFile.write ('{\n')
        cFile.write ('    // -- Set a NetworkController to use to send commands. --\n')
        cFile.write ('    \n')
        
        cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
        cFile.write ('    \n')
        
        cFile.write ('    // Check parameters\n')
        cFile.write ('    if ((feature == NULL) || (feature->privatePart == NULL))\n')
        cFile.write ('    {\n')
        cFile.write ('        error = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
        cFile.write ('    }\n')
        cFile.write ('    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
        cFile.write ('    \n')
        
        cFile.write ('    if (error == ARCONTROLLER_OK)\n')
        cFile.write ('    {\n')
        cFile.write ('        feature->privatePart->networkController = networkController;\n')
        cFile.write ('    }\n')
        cFile.write ('    \n')
        
        cFile.write ('    return error;\n')
        cFile.write ('}\n')
        cFile.write ('\n')
        
        cFile.write ('ARCONTROLLER_DICTIONARY_ELEMENT_t *' + ARFunctionName (MODULE_ARCONTROLLER, get_ftr_old_name(feature), 'GetCommandElements')+' ('+className+' *feature, '+defineNotificationDef()+' commandKey, eARCONTROLLER_ERROR *error)\n')
        cFile.write ('{\n')
        cFile.write ('    // -- Get Command Arguments --\n')
        cFile.write ('    \n')
        
        cFile.write ('    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;\n')
        cFile.write ('    ARCONTROLLER_DICTIONARY_COMMANDS_t *commandDic = NULL;\n')
        cFile.write ('    ARCONTROLLER_DICTIONARY_ELEMENT_t *elements = NULL;\n')
        cFile.write ('    \n')
        
        cFile.write ('    // Check parameters\n')
        cFile.write ('    if ((feature == NULL) ||\n')
        cFile.write ('        (feature->privatePart == NULL))\n')
        cFile.write ('    {\n')
        cFile.write ('        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;\n')
        cFile.write ('    }\n')
        cFile.write ('    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing\n')
        cFile.write ('    \n')
        
        cFile.write ('    if (localError == ARCONTROLLER_OK)\n')
        cFile.write ('    {\n')
        
        cFile.write ('        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));\n')
        cFile.write ('        \n')
                
        cFile.write ('        // Find elements\n')
        cFile.write ('        HASH_FIND_INT (feature->privatePart->dictionary, &(commandKey), commandDic);\n')
        cFile.write ('        if (commandDic != NULL)\n')
        cFile.write ('        {\n')
        cFile.write ('            elements = commandDic->elements;\n')
        cFile.write ('        }\n')
        cFile.write ('        // NO Else ; Command not found \n')
        cFile.write ('        \n')
        
        cFile.write ('        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));\n')
        cFile.write ('        \n')
        
        cFile.write ('        if (elements == NULL)\n')
        cFile.write ('        {\n')
        cFile.write ('            localError = ARCONTROLLER_ERROR_NO_ELEMENT;\n')
        cFile.write ('        }\n')
        cFile.write ('    }\n')
        cFile.write ('    \n')
        
        cFile.write ('    // Return the error\n')
        cFile.write ('    if (error != NULL)\n')
        cFile.write ('    {\n')
        cFile.write ('        *error = localError;\n')
        cFile.write ('    }\n')
        cFile.write ('    // No else: error is not returned \n')
        cFile.write ('    \n')
        
        cFile.write ('    return elements;\n')
        cFile.write ('}\n')
        cFile.write ('\n')
        
        cFile.write ('/************************\n')
        cFile.write (' * Private Implementation\n')
        cFile.write (' *************************/\n')
        

    cFile.close () # see automake all source of folder !!!!!!!!
    
def generateFeatureControllersJava (ctx, JNI_JAVA_DIR):
    
    #########################################
    # Write Device controller JNI java file #
    #########################################
    
    for feature in ctx.features:
    
        className = 'ARFeature'+ ARCapitalize(get_ftr_old_name(feature))
        classPrivateName = ARTypeName (MODULE_ARCONTROLLER, 'device', 'private')

        fileName = className+'.java'
        filepath = JNI_JAVA_DIR + fileName
        jfile = open (filepath, 'w')

        jfile.write ('/**********************************************************\n')
        jfile.write (' *            AUTOGENERATED FILE                          *\n')
        jfile.write (' *             DO NOT MODIFY IT                           *\n')
        jfile.write (' *                                                        *\n')
        jfile.write (' * To add new commands :                                  *\n')
        jfile.write (' *  - Modify ../Xml/commands.xml file                     *\n')
        jfile.write (' *  - Re-run generateDeviceControllers.py script          *\n')
        jfile.write (' *                                                        *\n')
        jfile.write (' **********************************************************/\n')
        jfile.write ('\n')

        jfile.write ('/**\n')
        jfile.write (' * @file '+fileName+'\n')
        jfile.write (' * @brief Feature controller allow to send command related of '+get_ftr_old_name(feature)+' Feature.\n')
        jfile.write (' * ' + feature.doc.replace('\n', '\n * ')+'\n')
        jfile.write (' */\n')
        
        jfile.write ('package com.parrot.arsdk.arcontroller;\n')
        jfile.write ('\n')
        jfile.write ('import com.parrot.arsdk.arsal.ARSALPrint;\n')
        jfile.write ('import com.parrot.arsdk.arcommands.*;\n')
        jfile.write ('import com.parrot.arsdk.ardiscovery.ARDiscoveryDevice;\n')
        jfile.write ('\n')
        jfile.write ('import java.util.List;\n')
        jfile.write ('import java.util.ArrayList;\n')
        jfile.write ('\n')
        jfile.write ('public class '+className+'\n')
        jfile.write ('{\n')
        jfile.write ('    private static String TAG = "'+className+'";\n')
        jfile.write ('    \n')
        
        for evt in feature.evts:
            for arg in [arg1 for arg1 in evt.args if arg1.name != _LIST_FLAG]:
                jfile.write ('    public static String ' + defineNotification(feature, evt, arg) + ' = ""; /**< Key of the argument </code>'+arg.name+'</code> of event <code>' + ARCapitalize (format_cmd_name(evt)) + '</code> in feature <code>' + ARCapitalize (get_ftr_old_name(feature)) + '</code> */\n')
        jfile.write ('\n')
        for evt in feature.evts:
            for arg in evt.args:
                jfile.write ('    private static native String ' + nativeGetNotificationVal(feature, evt, arg) + ' ();\n')
        jfile.write ('\n')
        
        for cmd in feature.cmds:
            jfile.write ('    private native int '+nativeSendingFunction(cmd)+' (long jFeature')
            for arg in cmd.args:
                if isinstance(arg.argType, ArEnum):
                    jfile.write (', int ' + arg.name + '')
                else:
                    jfile.write (', ' + xmlToJava (MODULE_ARCOMMANDS, feature, cmd, arg) + ' ' + arg.name + '')
            jfile.write (');\n')
        
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                jfile.write ('    private native int '+nativeSetNAckFunction(cmd)+' (long jFeature')
                for arg in cmd.args:
                    if isinstance(arg.argType, ArEnum):
                        jfile.write (', int ' + arg.name + '')
                    else:
                        jfile.write (', ' + xmlToJava (MODULE_ARCOMMANDS, feature, cmd, arg) + ' ' + arg.name + '')
                jfile.write (');\n')
            
                for arg in cmd.args:
                    if isinstance(arg.argType, ArEnum):
                        jfile.write ('    private native int '+nativeSetNAckFunction(cmd, arg)+' (long jFeature, int ' + arg.name + ');\n')
                    else:
                        jfile.write ('    private native int '+nativeSetNAckFunction(cmd, arg)+' (long jFeature, ' + xmlToJava (MODULE_ARCOMMANDS, feature, cmd, arg) + ' ' + arg.name + ');\n')
        jfile.write ('\n')
        
        jfile.write ('    private long jniFeature;\n')
        jfile.write ('    private boolean initOk;\n')
        jfile.write ('    \n')
        jfile.write ('    static\n')
        jfile.write ('    {\n')
        for evt in feature.evts:
            for arg in [arg1 for arg1 in evt.args if arg1.name != _LIST_FLAG]:
                jfile.write ('        ' + defineNotification(feature, evt, arg) + ' = '+ nativeGetNotificationVal(feature, evt, arg) + ' ();\n')
        jfile.write ('    }\n')
        jfile.write ('    \n')
        
        jfile.write ('    /**\n')
        jfile.write ('     * Constructor\n')
        jfile.write ('     */\n')
        jfile.write ('    public '+className+' (long nativeFeature)\n')
        jfile.write ('    {\n')
        jfile.write ('        initOk = false;\n')
        jfile.write ('        \n')
        jfile.write ('        if (nativeFeature != 0)\n')
        jfile.write ('        {\n')
        jfile.write ('            jniFeature = nativeFeature;\n')
        jfile.write ('            initOk = true;\n')
        jfile.write ('        }\n')
        jfile.write ('    }\n')
        jfile.write ('\n')
        jfile.write ('    /**\n')
        jfile.write ('     * Dispose\n')
        jfile.write ('     */\n')
        jfile.write ('    public void dispose()\n')
        jfile.write ('    {\n')
        jfile.write ('        ARCONTROLLER_ERROR_ENUM error = ARCONTROLLER_ERROR_ENUM.ARCONTROLLER_OK;\n')
        jfile.write ('        synchronized (this)\n')
        jfile.write ('        {\n')
        jfile.write ('            if(initOk == true)\n')
        jfile.write ('            {\n')
        jfile.write ('                jniFeature = 0;\n')
        jfile.write ('                initOk = false;\n')
        jfile.write ('            }\n')
        jfile.write ('        }\n')
        jfile.write ('    }\n')
        jfile.write ('\n')
        jfile.write ('    /**\n')
        jfile.write ('     * Destructor\n')
        jfile.write ('     */\n')
        jfile.write ('    public void finalize () throws Throwable\n')
        jfile.write ('    {\n')
        jfile.write ('        try\n')
        jfile.write ('        {\n')
        jfile.write ('            dispose ();\n')
        jfile.write ('        }\n')
        jfile.write ('        finally\n')
        jfile.write ('        {\n')
        jfile.write ('            super.finalize ();\n')
        jfile.write ('        }\n')
        jfile.write ('    }\n')
        jfile.write ('    \n')
        
        for cmd in feature.cmds:
            jfile.write ('    /**\n')
            jfile.write ('     * Send a command <code>' + ARCapitalize (format_cmd_name(cmd)) + '</code>\n')
            if cmd.isDeprecated:
                jfile.write ('     * @deprecated\n')
            jfile.write ('     * ' + cmd.doc.desc.replace('\n', '\n     * ')+'\n')
            for arg in cmd.args:
                jfile.write ('     * @param ' + arg.name + ' ' + get_arg_doc(arg).replace('\n', ' ') + '\n')
            jfile.write ('     * return executing error\n')
            jfile.write ('     */\n')
            jfile.write ('    public ARCONTROLLER_ERROR_ENUM '+sendingFunction (cmd)+' (')
            first = True
            for arg in cmd.args:
                if first:
                    first = False
                else :
                    jfile.write (', ')
                jfile.write (xmlToJava (MODULE_ARCOMMANDS, feature, cmd, arg) + ' _' + arg.name + '')
            jfile.write (')\n')
            
            jfile.write ('    {\n')
            jfile.write ('        ARCONTROLLER_ERROR_ENUM error = ARCONTROLLER_ERROR_ENUM.ARCONTROLLER_OK;\n')
            jfile.write ('        synchronized (this)\n')
            jfile.write ('        {\n')
            jfile.write ('            if(initOk == true)\n')
            jfile.write ('            {\n')
            jfile.write ('                int nativeError = '+nativeSendingFunction(cmd)+' (jniFeature')
            for arg in cmd.args:
                jfile.write (', _' + arg.name)
                if isinstance(arg.argType, ArEnum):
                    jfile.write ('.getValue()')
            jfile.write (');\n')
            jfile.write ('                error = ARCONTROLLER_ERROR_ENUM.getFromValue(nativeError);\n')
            jfile.write ('            }\n')
            jfile.write ('        }\n')
            jfile.write ('        return error;\n')
            jfile.write ('    }\n')
            jfile.write ('    \n')
            
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                jfile.write ('    public ARCONTROLLER_ERROR_ENUM '+javaSetNAckFunction (cmd)+' (')
                isFirst = True
                for arg in cmd.args:
                    if isFirst:
                        isFirst = False
                    else:
                        jfile.write (', ')
                    jfile.write (xmlToJava (MODULE_ARCOMMANDS, feature, cmd, arg) + ' _' + arg.name)
                jfile.write (')\n')
                jfile.write ('    {\n')
                jfile.write ('        ARCONTROLLER_ERROR_ENUM error = ARCONTROLLER_ERROR_ENUM.ARCONTROLLER_OK;\n')
                jfile.write ('        synchronized (this)\n')
                jfile.write ('        {\n')
                jfile.write ('            if(initOk == true)\n')
                jfile.write ('            {\n')
                jfile.write ('                int nativeError = '+nativeSetNAckFunction(cmd)+' (jniFeature')
                for arg in cmd.args:
                    jfile.write (', _' + arg.name)
                    if isinstance(arg.argType, ArEnum):
                        jfile.write ('.getValue()')
                jfile.write (');\n')
                jfile.write ('                error = ARCONTROLLER_ERROR_ENUM.getFromValue(nativeError);\n')
                jfile.write ('            }\n')
                jfile.write ('        }\n')
                jfile.write ('        return error;\n')
                jfile.write ('    }\n')
                jfile.write ('    \n')
                
                for arg in cmd.args:
                    jfile.write ('    public ARCONTROLLER_ERROR_ENUM '+javaSetNAckFunction (cmd, arg)+' (' + xmlToJava (MODULE_ARCOMMANDS, feature, cmd, arg) + ' _' + arg.name+')\n')
                    jfile.write ('    {\n')
                    jfile.write ('        ARCONTROLLER_ERROR_ENUM error = ARCONTROLLER_ERROR_ENUM.ARCONTROLLER_OK;\n')
                    jfile.write ('        synchronized (this)\n')
                    jfile.write ('        {\n')
                    jfile.write ('            if(initOk == true)\n')
                    jfile.write ('            {\n')
                    if isinstance(arg.argType, ArEnum):
                        jfile.write ('                int nativeError = '+nativeSetNAckFunction(cmd, arg)+' (jniFeature, _' + arg.name + '.getValue());\n')
                    else:
                        jfile.write ('                int nativeError = '+nativeSetNAckFunction(cmd, arg)+' (jniFeature, _' + arg.name + ');\n')
                    jfile.write ('                error = ARCONTROLLER_ERROR_ENUM.getFromValue(nativeError);\n')
                    jfile.write ('            }\n')
                    jfile.write ('        }\n')
                    jfile.write ('        return error;\n')
                    jfile.write ('    }\n')
                    jfile.write ('    \n')
                        
                    
        jfile.write ('\n')
        jfile.write ('}\n')

        jfile.write ('\n')
        
def generateFeatureControllersJNI (ctx, JNI_C_DIR):

    #################################################
    # Write Feature controller JNI c file           #
    #################################################
    
    for feature in ctx.features:
        
        javaClassName = 'ARFeature'+ ARCapitalize(get_ftr_old_name(feature))
        jniClassName = MODULE_ARCONTROLLER + '_JNI_Feature'+ ARCapitalize(get_ftr_old_name(feature)) #ARTypeName (MODULE_FEATURE, 'JNI_'+get_ftr_old_name(feature), '')
        className = ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), '')
        classTag = 'ARCONTROLLER_JNIFEATURE'+get_ftr_old_name(feature).upper()+'_TAG'

        cFileName = jniClassName + '.c'
        filepath = JNI_C_DIR + cFileName
        cFile = open (filepath, 'w')

        cFile.write ('/**********************************************************\n')
        cFile.write (' *            AUTOGENERATED FILE                          *\n')
        cFile.write (' *             DO NOT MODIFY IT                           *\n')
        cFile.write (' *                                                        *\n')
        cFile.write (' * To add new commands :                                  *\n')
        cFile.write (' *  - Modify ../Xml/commands.xml file                     *\n')
        cFile.write (' *  - Re-run generateFeatureControllers.py script         *\n')
        cFile.write (' *                                                        *\n')
        cFile.write (' **********************************************************/\n')
        cFile.write ('\n')

        cFile.write ('/**\n')
        cFile.write ('* @file '+jniClassName+'\n')
        cFile.write ('* @brief '+ARTypeName (MODULE_FEATURE, get_ftr_old_name(feature), '')+' JNI feature '+get_ftr_old_name(feature)+' c file.\n')
        cFile.write ('*/\n')
        cFile.write ('\n')
        
        cFile.write ('/*****************************************\n')
        cFile.write (' *\n')
        cFile.write (' *             include file :\n')
        cFile.write (' *\n')
        cFile.write (' *****************************************/\n')
        cFile.write ('\n')
        cFile.write ('#include <jni.h>\n')
        cFile.write ('#include <stdlib.h>\n')
        cFile.write ('\n')
        cFile.write ('#include <libARSAL/ARSAL_Print.h>\n')
        cFile.write ('\n')
        cFile.write ('#include <libARController/ARCONTROLLER_Error.h>\n')
        cFile.write ('#include <libARController/ARCONTROLLER_Feature.h>\n')
        cFile.write ('\n')
        cFile.write ('/*****************************************\n')
        cFile.write (' *\n')
        cFile.write (' *             define :\n')
        cFile.write (' *\n')
        cFile.write (' *****************************************/\n')
        cFile.write ('\n')
        cFile.write ('#define '+classTag+' "'+jniClassName+'"\n')
        cFile.write ('\n')
        cFile.write ('/*****************************************\n')
        cFile.write (' *\n')
        cFile.write (' *             private header:\n')
        cFile.write (' *\n')
        cFile.write (' *****************************************/\n')
        cFile.write ('\n')
        cFile.write ('\n')
        cFile.write ('/*****************************************\n')
        cFile.write (' *\n')
        cFile.write (' *             implementation :\n')
        cFile.write (' *\n')
        cFile.write (' *****************************************/\n')
        cFile.write ('\n')
        
        for evt in feature.evts:
            for arg in [arg1 for arg1 in evt.args if arg1.name != _LIST_FLAG]:
                cFile.write ('JNIEXPORT jstring JNICALL\n')
                cFile.write ('Java_com_parrot_arsdk_arcontroller_'+javaClassName+'_' + nativeGetNotificationVal(feature, evt, arg) + ' (JNIEnv *env , jclass class)\n')
                cFile.write ('{\n')
                cFile.write ('    return (*env)->NewStringUTF(env, '+defineNotification(feature, evt, arg)+');\n')
                cFile.write ('}\n')
                cFile.write ('\n')
        
        for cmd in feature.cmds:
            cFile.write ('JNIEXPORT jint JNICALL\n')
            cFile.write ('Java_com_parrot_arsdk_arcontroller_'+javaClassName+'_'+nativeSendingFunction(cmd)+' (JNIEnv *env, jobject thizz, jlong jFeature')
            for arg in cmd.args:
                cFile.write (', ' + xmlToJni (feature, cmd, arg) + ' _' + arg.name + '')
            cFile.write (')\n')
            cFile.write ('{\n')
            cFile.write ('    // local declarations\n')
            cFile.write ('    '+className+' *nativeFeature = ('+className+'*) (intptr_t) jFeature;\n')
            cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
            hasArgString = False
            for arg in cmd.args:
                if (arg.argType == ArArgType.STRING):
                    hasArgString = True
                    cFile.write ('    const char *native'+ARCapitalize(arg.name)+' = (*env)->GetStringUTFChars(env, _'+arg.name+', 0);\n')
            cFile.write ('    \n')
            cFile.write ('    error = nativeFeature->'+sendingFunction(cmd)+' (nativeFeature')
            for arg in cmd.args:
                if (arg.argType == ArArgType.STRING):
                    cFile.write (', (char *)native'+ARCapitalize(arg.name))
                else:
                    cFile.write (', _' + arg.name)
            cFile.write (');\n')
            cFile.write ('\n')

            if hasArgString:
                cFile.write ('    // cleanup\n')
            for arg in cmd.args:
                if (arg.argType == ArArgType.STRING):
                    cFile.write ('    (*env)->ReleaseStringUTFChars(env, _'+arg.name+', native'+ARCapitalize(arg.name)+');\n')
                    
            if hasArgString:
                cFile.write ('\n')
            
            cFile.write ('    return error;\n')
            cFile.write ('}\n')
            cFile.write ('\n')
            
            if cmd.bufferType == ArCmdBufferType.NON_ACK:
                cFile.write ('JNIEXPORT jint JNICALL\n')
                cFile.write ('Java_com_parrot_arsdk_arcontroller_'+javaClassName+'_'+nativeSetNAckFunction(cmd)+' (JNIEnv *env, jobject thizz, jlong jFeature')
                for arg in cmd.args:
                    cFile.write (', ' + xmlToJni (feature, cmd, arg) + ' _' + arg.name + '')
                cFile.write (')\n')
                cFile.write ('{\n')
                cFile.write ('    // local declarations\n')
                cFile.write ('    '+className+' *nativeFeature = ('+className+'*) (intptr_t) jFeature;\n')
                cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')
                hasArgString = False
                for arg in cmd.args:
                    if (arg.argType == ArArgType.STRING):
                        hasArgString = True
                        cFile.write ('    const char *native'+ARCapitalize(arg.name)+' = (*env)->GetStringUTFChars(env, _'+arg.name+', 0);\n')
                cFile.write ('    \n')
                cFile.write ('    error = nativeFeature->'+setNAckFunction(cmd)+' (nativeFeature')
                for arg in cmd.args:
                    if (arg.argType == ArArgType.STRING):
                        cFile.write (', (char *)native'+ARCapitalize(arg.name))
                    else:
                        cFile.write (', _' + arg.name)
                cFile.write (');\n')
                cFile.write ('\n')

                if hasArgString:
                    cFile.write ('    // cleanup\n')
                for arg in cmd.args:
                    if (arg.argType == ArArgType.STRING):
                        cFile.write ('    (*env)->ReleaseStringUTFChars(env, _'+arg.name+', native'+ARCapitalize(arg.name)+');\n')
                        
                if hasArgString:
                    cFile.write ('\n')
                
                cFile.write ('    return error;\n')
                cFile.write ('}\n')
                cFile.write ('\n')
                    
                for arg in cmd.args:
                    cFile.write ('JNIEXPORT jint JNICALL\n')
                    cFile.write ('Java_com_parrot_arsdk_arcontroller_'+javaClassName+'_'+nativeSetNAckFunction(cmd, arg)+' (JNIEnv *env, jobject thizz, jlong jFeature, ' + xmlToJni (feature, cmd, arg) + ' _' + arg.name + ')\n')
                    cFile.write ('{\n')
                    cFile.write ('    // local declarations\n')
                    cFile.write ('    '+className+' *nativeFeature = ('+className+'*) (intptr_t) jFeature;\n')
                    cFile.write ('    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;\n')

                    if (arg.argType == ArArgType.STRING):
                        cFile.write ('    const char *native'+ARCapitalize(arg.name)+' = (*env)->GetStringUTFChars(env, _'+arg.name+', 0);\n')
                    cFile.write ('    \n')
                    cFile.write ('    error = nativeFeature->'+setNAckFunction(cmd, arg)+' (nativeFeature')
                    if (arg.argType == ArArgType.STRING):
                        cFile.write (', (char *)native'+ARCapitalize(arg.name))
                    else:
                        cFile.write (', _' + arg.name)
                    cFile.write (');\n')
                    cFile.write ('\n')
    
                    if (arg.argType == ArArgType.STRING):
                        cFile.write ('    // cleanup\n')
                        cFile.write ('    (*env)->ReleaseStringUTFChars(env, _'+arg.name+', native'+ARCapitalize(arg.name)+');\n')
                        cFile.write ('\n')
                    
                    cFile.write ('    return error;\n')
                    cFile.write ('}\n')
                    cFile.write ('\n')
        
        cFile.close ()
    cFileName = jniClassName + '.c'
    filepath = JNI_C_DIR + CTRL_FTR_JNI_C_NAME

    cFile = open (filepath, 'w')
    for feature in ctx.features:
        jniClassName = MODULE_ARCONTROLLER + '_JNI_Feature'+ ARCapitalize(get_ftr_old_name(feature))
        jniFtrFileName = jniClassName + '.c'
        cFile.write ('#include "'+jniFtrFileName+'"\n')
    cFile.close ()

def list_files_ftr_ctrls (ctx, SRC_DIR, INC_DIR):
    ''' Print features controllers generated files '''
    print INC_DIR + CTRL_FTR_H_NAME
    print SRC_DIR + CTRL_FTR_PRIV_H_NAME
    print SRC_DIR + CTRL_FTR_C_NAME

def list_files_ftr_ctrls_jni (ctx, JNI_JAVA_DIR):
    ''' Print features controllers generated files '''
    # Print java feature class files
    for feature in ctx.features:
        print JNI_JAVA_DIR + 'ARFeature'+ ARCapitalize(get_ftr_old_name(feature)) +'.java'

def list_files_ftr_ctrls_jni (ctx, JNI_C_DIR):
    ''' Print features controllers generated files '''
    # Print feature JNI c files
    for feature in ctx.features:
        print JNI_C_DIR + 'ARCONTROLLER_JNI_Feature'+ ARCapitalize(get_ftr_old_name(feature)) + '.c'
    print JNI_C_DIR + CTRL_FTR_JNI_C_NAME
