/*
 *    This file is part of ACADO Toolkit.
 *
 *    ACADO Toolkit -- A Toolkit for Automatic Control and Dynamic Optimization.
 *    Copyright (C) 2008-2014 by Boris Houska, Hans Joachim Ferreau,
 *    Milan Vukov, Rien Quirynen, KU Leuven.
 *    Developed within the Optimization in Engineering Center (OPTEC)
 *    under supervision of Moritz Diehl. All rights reserved.
 *
 *    ACADO Toolkit is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    ACADO Toolkit is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with ACADO Toolkit; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */



/**
 *    \file include/acado/symbolic_operator/symbolic_operator.hpp
 *    \author Boris Houska, Hans Joachim Ferreau
 *    \date 2008
 */


    // COLLECTION OF ALL OPERATOR-HEADER FILES:
    // -------------------------------------------------------
    #include <acado/symbolic_operator/evaluation_base.hpp>
    #include <acado/symbolic_operator/evaluation_template.hpp>
    
    #include <acado/symbolic_operator/operator.hpp>
    #include <acado/symbolic_operator/smooth_operator.hpp>
	#include <acado/symbolic_operator/nonsmooth_operator.hpp>

    #include <acado/symbolic_operator/unary_operator.hpp>
    #include <acado/symbolic_operator/binary_operator.hpp>

    #include <acado/symbolic_operator/acos.hpp>
    #include <acado/symbolic_operator/addition.hpp>
    #include <acado/symbolic_operator/asin.hpp>
    #include <acado/symbolic_operator/atan.hpp>
    #include <acado/symbolic_operator/cos.hpp>
    #include <acado/symbolic_operator/doubleconstant.hpp>
    #include <acado/symbolic_operator/exp.hpp>
    #include <acado/symbolic_operator/logarithm.hpp>
    #include <acado/symbolic_operator/power.hpp>
    #include <acado/symbolic_operator/powerint.hpp>
    #include <acado/symbolic_operator/product.hpp>
    #include <acado/symbolic_operator/quotient.hpp>
    #include <acado/symbolic_operator/sin.hpp>
    #include <acado/symbolic_operator/subtraction.hpp>
    #include <acado/symbolic_operator/symbolic_index_list.hpp>
    #include <acado/symbolic_operator/tan.hpp>
    #include <acado/symbolic_operator/projection.hpp>
    #include <acado/symbolic_operator/tree_projection.hpp>


    // -------------------------------------------------------
    // -------------------------------------------------------
    // end of file.

