Ariles
======

| branch | CI status |
|--------|-----------|
| `master`                  | [![Build Status](https://travis-ci.org/asherikov/ariles.svg?branch=master)](https://travis-ci.org/asherikov/ariles)  |
| `pkg_ros` (ROS package)   | [![Build Status](https://travis-ci.org/asherikov/ariles.svg?branch=pkg_ros)](https://travis-ci.org/asherikov/ariles) |


Contents
========
* [Links](#links)
* [Introduction](#intro)
* [Supported formats](#formats)
* [Supported types](#types)
* [Minimal example](#example)
* [Advanced features](#features)
* [Documentation and examples](#docs)
* [Compilation using catkin](#catkin)


<a name="links"></a>
Links
=====
* Doxygen: https://asherikov.github.io/ariles/
* GitHub: https://github.com/asherikov/ariles
* CI: https://travis-ci.org/asherikov/ariles


<a name="intro"></a>
Introduction
============

Ariles is a C++ serialization/configuration library with some useful
metaprogramming features. It relies on other open-source libraries for parsing
of various data representation formats. The library also provides some
predefined serialization wrappers for common types, e.g., some standard
containers and smart pointers.

Ariles differs from the common C++ serialization libs in several aspects:

* It is intended to be used for both serialization and configuration,
  therefore, it assumes that the input files could be written by a human or
  generated by another program. For this reason, Ariles tries to be flexible
  while parsing, e.g., for most formats it silently ignores unused entries,
  ignores ordering of entries, does not discriminate attributes from childs in
  XML, can optionally ignore missing entries, etc.

* Ariles is meant to be used primarily for 'invasive' serialization and
  provides a set of macro to generate class methods for serialization,
  initialization to default values, etc. This allows Ariles to use virtual
  methods for serialization via base classes, unlike boost and cereal.

* Ariles supports some uncommon formats, such as ROS parameter server and
  Octave script.


<a name="formats"></a>
Supported data formats
======================

Currently supported formats are (all are optional):

* YAML via yaml-cpp, both old C++03 and new API supported.
    - yaml-cpp does not comply with the specification when it emits NaN's and
      infinities, see https://github.com/jbeder/yaml-cpp/issues/507. Ariles
      includes a workaround for this issue.

* msgpack via msgpack-c.

* JSON via RapidJSON, with optional Jsonnet (https://jsonnet.org/)
  preprocessing:
    * NaN's and infinities, which are not allowed by JSON specification, are
      parsed / saved anyway using `boost::lexical_cast`.

* XML via PugiXML:
    - Attributes are treated as childs while reading and are never used for
      writing.

* Octave script, output only, no dependencies:
    - Ariles outputs a serialized class to an Octave script file, which can
      later be `source`d from Octave to create a struct representation of the
      class.

    - Eigen matrices are written in the 'native' format, so they can be used
      directly, no reshaping is necessary.

    - Matlab might be supported, but has not been tested.

* ROS parameter server, via standard ROS libs.

* A set of key-value pairs, output only, no dependencies:
    - A vector of string-double pairs with flattened member names, e.g.,
      `<class.member_class.member, value>`.

    - Useful for exporting data to time series databases.


<a name="types"></a>
Supported types
===============

* Fundametal types: signed/unsigned integers, floats, booleans.
* Some STL classes (WIP): `std::string`, `std::vector`, `std::map`, `std::pair`, `std::shared_ptr`, `std::unique_ptr`.
* Eigen types: matrices, transforms, quaternions.
* Boost classes: `boost::optional`, `boost::movelib::unique_ptr`. `boost::shared_ptr`.
* Better enums -> https://github.com/aantron/better-enums.


<a name="example"></a>
Minimal example
===============
Class [`./tests/types/minimal.h`]:
```
class Configurable : public ariles::ConfigurableBase
{
    #define ARILES_SECTION_ID "ConfigurableEntryName"
    #define ARILES_AUTO_DEFAULTS
    #define ARILES_ENTRIES \
        ARILES_TYPED_ENTRY(integer_member, int)
    #include ARILES_INITIALIZE
};
```

Serialization:
```
Configurable configurable;
configurable.writeConfig<ariles::yaml_cpp>("config_file.yaml");
```

Result:
```
ConfigurableEntryName:
    integer_member: 0
```

Deserialization:
```
Configurable configurable;
configurable.readConfig<ariles::yaml_cpp>("config_file.yaml");
```


<a name="features"></a>
Advanced features
=================

* Class members can be declared automatically with `ARILES_TYPED_ENTRY` as in
  the minimal example above, or manually, in which case `ARILES_ENTRY` must be
  used.

* All configurable classes must implement `setDefaults()` method, which is
  called before parsing a configuration. However, Ariles may generated this
  method automatically if `ARILES_AUTO_DEFAULTS` is defined as in the example
  above; in this case floats would be set to NaNs, integers to zeros, etc.

* Depending on the configuration format streams can be used instead of
  filenames, e.g, `configurable.writeConfig<ariles::yaml_cpp>(std::cout);`.

* `ariles::Any` class defined in `ariles/types.h` provides functionality
  similar to `protobuf::Any`: this class automatically instantiates and reads
  configuration of some user-defined class based on its string id and stores a
  pointer to its base class. See `tests/types/any.h` for an example. This
  should play well with `ros/pluginlib`.

* 'Sloppy' `std::map` and `std::pair`: optionally maps and pairs, where the key
  or the first element is an `std::string`, can be saved / loaded as maps if
  supported by the chosen format. For example:
`
    std_map:
        key: value
`
  instead of
`
    std_map:
        first: key
        second: value
`

* Configurable classes may implement `finalize()` method, which would be called
  automatically after parsing a configuration. This method can be used to
  perform data consistency checks or initialize parameters which are not stored
  in the configuration. Bug: all ariles classes are `finalize()`d after reading
  a configuration, but manual call to `finalize()` does not guarantee that, see
  TODO for more info.


<a name="docs"></a>
Documentation and examples
==========================

* Precompiled Doxygen documentation: https://asherikov.github.io/ariles/
* Introductory demo: https://asherikov.github.io/ariles/DEMO.html [`./tests/demo.cpp`]
* Various types defined for tests: [`./tests/types/`]


<a name="catkin"></a>
Compilation using catkin
========================

`catkin` (ROS build utility) is not flexible enough to build Ariles, it is,
however, possible to create a proxy catkin package to build Ariles with a
predefined configuration. You can find an example in `pkg_ros` branch of this
repository (https://github.com/asherikov/ariles/tree/pkg_ros).
