#pragma once

#include <memory>

#include <bota_node/bota_node.hpp>

#include <rokubimini_manager/Manager.hpp>

namespace bota_device_driver
{
using namespace rokubimini;

class BotaDeviceDriver : public bota_node::Node
{
public:
  using NodeHandlePtr = std::shared_ptr<ros::NodeHandle>;

  BotaDeviceDriver() = delete;
  explicit BotaDeviceDriver(const NodeHandlePtr& nh);
  ~BotaDeviceDriver() override = default;

  bool init() override;
  void cleanup() override;
  bool update(const bota_worker::WorkerEvent& event);

private:
  std::unique_ptr<RokubiminiManager> rokubiminiManager_;
  NodeHandlePtr nh_;
};

}  // namespace bota_device_driver