/**
 * @file /include/ecl/devices/detail/socket_exception_handler_pos.hpp
 *
 * @brief Defines exception handlers for posix sockets.
 *
 * @date September 2009
 **/
/*****************************************************************************
** Ifdefs
*****************************************************************************/

#ifndef ECL_DEVICES_SOCKET_EXCEPTION_HANDLER_POS_HPP_
#define ECL_DEVICES_SOCKET_EXCEPTION_HANDLER_POS_HPP_

/*****************************************************************************
** Cross platform
*****************************************************************************/

#include <ecl/config/ecl.hpp>
#ifndef ECL_IS_APPLE
#ifdef ECL_IS_POSIX

/*****************************************************************************
** Includes
*****************************************************************************/

#include <string>
#include <ecl/exceptions/standard_exception.hpp>

/*****************************************************************************
** Namespaces
*****************************************************************************/

namespace ecl {
namespace devices {

/*****************************************************************************
** Methods
*****************************************************************************/

/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>socket</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @return StandardException : the exception type.
 */
ecl::StandardException socket_exception(const char* loc);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>bind</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @return StandardException : the exception type.
 */
ecl::StandardException bind_exception(const char* loc);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>accept</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @return StandardException : the exception type.
 */
ecl::StandardException accept_exception(const char* loc);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>receive</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @return StandardException : the exception type.
 */
ecl::StandardException receive_exception(const char* loc);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>ioctl</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @return StandardException : the exception type.
 */
ecl::StandardException ioctl_exception(const char* loc);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>send</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @return StandardException : the exception type.
 */
ecl::StandardException send_exception(const char* loc);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>gethostbyname</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @param hostname : name of the server's host.
 * @return StandardException : the exception type.
 */
StandardException gethostbyname_exception(const char* loc, const std::string& hostname);
/**
 * This function generates a custom StandardException response
 * for posix error numbers generated by posix <i>connect</i> calls.
 *
 * @param loc : use with the LOC macro, identifies the line and file of the code.
 * @return StandardException : the exception type.
 */
StandardException connection_exception(const char* loc);

} // namespace devices
} // namespace ecl

#endif /* ECL_IS_POSIX */
#endif /* !ECL_IS_APPLE */
#endif /* ECL_DEVICES_SOCKET_EXCEPTION_HANDLER_POS_HPP_ */
