// !!! DO NOT EDIT THIS FILE - IT'S ONLY A CONVENCIENCE COPY OF THE CORRESPONDING *Shader.h FILE !!!

#version 410 core

// Input vertex data, different for all executions of this shader.
layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 2) in vec4 vtranslation_and_scale;

// Ouput data
out vec3 fragmentColor;

// Values that stay constant for the whole mesh.
uniform mat4 VP;
uniform int axis; // 0=x-axis, 1=y, 2=z

void main() {
  vec3 v_translation = vtranslation_and_scale.xyz;
  float scale = vtranslation_and_scale.w;

  // this matrix scales the vertex and then translate it
  mat4 M = mat4(vec4(scale,0,0,0),
                vec4(0,scale,0,0),
                vec4(0,0,scale,0),
                vec4(v_translation,1));

  // calculate position
  // result is in display pixel coordinates?
  gl_Position = VP * M * vec4(vertexPosition_modelspace, 1.0f);

  float vertexPos_world_axis = v_translation[axis] + scale * vertexPosition_modelspace[axis];
  // divide axis position into r / g / b bytes
  // will work as long as axis position is <= 2^24 -1
  int v = int(vertexPos_world_axis);
  int r = (v / (256 * 256)) % 256;
  int g = (v / 256) % 256;
  int b = v % 256;

  // output r / g / b channels scaled to [0..1] (float)
  fragmentColor = vec3(r/255.f, g/255.f, b/255.f);
  if(v < 0) {
    fragmentColor = vec3(1.f);
  }
}
