// !!! DO NOT EDIT THIS FILE - IT'S ONLY A CONVENCIENCE COPY OF THE CORRESPONDING *Shader.h FILE !!!

#version 410 core

// Ouput data
out vec4 color_out;

// Input data
in vec4 fragmentColor;


in vec3 normal_cameraspace;
in vec3 position_cameraspace;


uniform mat4 V;
uniform vec3 lightPosition_worldspace;
uniform vec3 lightIntensity;

void main()
{// implement Phong-Lighting
  vec3 normal_cameraspace_normalized = normalize(normal_cameraspace);
  if(dot(position_cameraspace,normal_cameraspace_normalized) > 0.f) {
    // if the fragment is not visible discard it
    discard;
  }
  float n = 50; // Phong exponent
  vec3 kd = fragmentColor.rgb; // diffuse color

  vec3 lightPos_cameraspace = (V * vec4(lightPosition_worldspace,1)).xyz;
  float distance = length(lightPos_cameraspace - position_cameraspace);
  float attenuation = distance > 1.f ? 1.f / pow(distance, 2.f) : 1.f;

  // the attenuated light intensity
  vec3 lightIntensityAttenuation = min(lightIntensity * attenuation, 1.f);

  vec3 light = normalize(lightPos_cameraspace - position_cameraspace);

  vec3 ambient_color = fragmentColor.rgb * vec3(0.4f);
  vec3 diffus_color = vec3(0.f);

  float NL = max(0.f, dot(normalize(normal_cameraspace_normalized),light));
  if(NL > 0.f) {
    diffus_color = kd * lightIntensityAttenuation *  NL;
  }

  color_out = vec4(ambient_color + diffus_color, fragmentColor.a);
}
