# Patch for the DSO-1369 Issue
Extensive testing of the RS400 on large pool of different machines have identified a rare platform problem:
On the affected machines, in a stress-test of start-stop streaming the UVC module can get "stuck" within ~1000 iterations.
Possible work-arounds include re-connecting the device, or re-loading the `uvcvideo` kernel module.
We are also providing Kernel patch that prevents the problem from occurring.

Be aware that running this script will build and install a new kernel version on your machine.

## Installation Instructions
- Update Ubuntu distribution, including getting the latest stable kernel
```bash
$ sudo apt-get update && sudo apt-get upgrade && sudo apt-get dist-upgrade
```

- The following script will download, patch and build the whole Kernel from sources.
This operation should take **~30 minutes**.
The new Kernel version will be noted at the end of the installation.
```bash
$ ./scripts/patch-xhci-realsense-ubuntu-xenial.sh
```
- Reboot and load the newly installed Kernel.
```bash
$ reboot
```

- Check and verify the Kernel version
```bash
$ uname -r
```
