// *****************************************************************************
//
// Copyright (c) 2014, Southwest Research Institute® (SwRI®)
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Southwest Research Institute® (SwRI®) nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// *****************************************************************************

#ifndef MAPVIZ_PLUGINS_POINT_CLICK_PUBLISHER_H
#define MAPVIZ_PLUGINS_POINT_CLICK_PUBLISHER_H

// Include mapviz_plugin.h first to ensure GL deps are included in the right order
#include <mapviz/mapviz_plugin.h>

#include <QGLWidget>
#include <QTimer>
#include <mapviz/map_canvas.h>

#include <mapviz_plugins/canvas_click_filter.h>

#include <ros/ros.h>

// QT autogenerated files
#include "ui_point_click_publisher_config.h"
#include "ui_topic_select.h"

/**
 * This is a pretty straightforward plugin.  It watches for user clicks on the
 * canvas, then converts the coordinates into a specified frame and publishes
 * them as PointStamped messages on a specified topic.
 */
namespace mapviz_plugins
{
  class PointClickPublisherPlugin : public mapviz::MapvizPlugin
  {
    Q_OBJECT;
  public:

    PointClickPublisherPlugin();
    virtual ~PointClickPublisherPlugin();

    bool Initialize(QGLWidget* canvas);
    void Shutdown() {}

    virtual void SetNode(const ros::NodeHandle& node);
    virtual void PrintError(const std::string& message);
    virtual void PrintInfo(const std::string& message);
    virtual void PrintWarning(const std::string& message);

    void Draw(double x, double y, double scale);

    void Transform() {}

    void LoadConfig(const YAML::Node& node, const std::string& path);
    void SaveConfig(YAML::Emitter& emitter, const std::string& path);

    QWidget* GetConfigWidget(QWidget* parent);

  protected Q_SLOTS:
    void pointClicked(const QPointF& point);
    void topicChanged(const QString& topic);
    void updateFrames();

  private:

    Ui::point_click_publisher_config ui_;
    QWidget* config_widget_;

    CanvasClickFilter click_filter_;
    mapviz::MapCanvas* canvas_;

    QTimer frame_timer_;
    ros::Publisher point_publisher_;
  };
}

#endif //MAPVIZ_PLUGINS_POINT_CLICK_PUBLISHER_H
