// *****************************************************************************
//
// Copyright (c) 2021, Trinity University
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Southwest Research Institute® (SwRI®) nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// *****************************************************************************

#ifndef MAPVIZ_PLUGINS_POSE_PUBLISHER_PLUGIN_H_
#define MAPVIZ_PLUGINS_POSE_PUBLISHER_PLUGIN_H_

#include <mapviz/mapviz_plugin.h>

// QT libraries
#include <QGLWidget>

// ROS libraries
#include <ros/ros.h>
#include <tf/transform_datatypes.h>
#include <swri_transform_util/frames.h>
#include <geometry_msgs/PoseWithCovarianceStamped.h>

// Mapviz libraries
#include <mapviz/map_canvas.h>

// QT autogenerated files
#include "ui_pose_publisher_config.h"
#include "ui_topic_select.h"

/**
 * This plugin, when the PublishPose button is pressed, watches for a user to click/drag
 * on the canvas, then converts the coordinates/orientation into a specified frame and publishes
 * them as PoseWithCovarianceStamped message on a specified topic.
 */
namespace mapviz_plugins
{
  class PosePublisherPlugin : public mapviz::MapvizPlugin
  {
    Q_OBJECT

   public:

    PosePublisherPlugin();
    virtual ~PosePublisherPlugin();

    bool Initialize(QGLWidget* canvas);
    void Shutdown() {}

    void Draw(double x, double y, double scale);

    void Paint(QPainter* painter, double x, double y, double scale) {}
    void Transform() {}

    void LoadConfig(const YAML::Node& node, const std::string& path);
    void SaveConfig(YAML::Emitter& emitter, const std::string& path);

    QWidget* GetConfigWidget(QWidget* parent);

   protected:
    virtual void PrintError(const std::string& message) override;
    virtual void PrintInfo(const std::string& message) override;
    virtual void PrintWarning(const std::string& message) override;
    virtual bool eventFilter(QObject *object, QEvent* event) override;
    void timerCallback(const ros::TimerEvent& ev = ros::TimerEvent() );

    bool handleMousePress(QMouseEvent *);
    bool handleMouseRelease(QMouseEvent *);
    bool handleMouseMove(QMouseEvent *);

  private Q_SLOTS:
    void on_pushButtonPose_toggled(bool checked);
    void topicChanged(const QString& topic);
    void updateFrames();

  private:

    Ui::pose_publisher_config ui_;
    QWidget* config_widget_;
    mapviz::MapCanvas* map_canvas_;

    ros::NodeHandle nh_;
    ros::Publisher pose_pub_;

    bool is_mouse_down_;
    QPointF arrow_tail_position_;
    float arrow_angle_;

    ros::Timer timer_;
    QTimer frame_timer_;
    bool monitoring_action_state_;
  };
}

#endif  // MAPVIZ_PLUGINS_POSE_PUBLISHER_PLUGIN_H_
