/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.executionContext;

import OpenRTM.DataFlowComponent;
import OpenRTM.DataFlowComponentHelper;
import RTC.ExecutionContextProfile;
import RTC.ExecutionContextProfileHolder;
import RTC.ExecutionContextService;
import RTC.ExecutionContextServiceHelper;
import RTC.ExecutionKind;
import RTC.LifeCycleState;
import RTC.LightweightRTObject;
import RTC.RTCListHolder;
import RTC.RTObject;
import RTC.RTObjectHelper;
import RTC.ReturnCode_t;
import java.util.Vector;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.RTObject_impl;
import jp.go.aist.rtm.RTC.StateAction;
import jp.go.aist.rtm.RTC.StateHolder;
import jp.go.aist.rtm.RTC.StateMachine;
import jp.go.aist.rtm.RTC.executionContext.ExecutionContextBase;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.POAUtil;
import jp.go.aist.rtm.RTC.util.equalFunctor;

public class PeriodicExecutionContext
extends ExecutionContextBase
implements Runnable {
    protected Vector<Comp> m_comps = new Vector();
    protected boolean m_running;
    private boolean m_svc;
    private Worker m_worker = new Worker();
    protected ExecutionContextProfile m_profile = new ExecutionContextProfile();
    protected long m_usec;
    protected ExecutionContextService m_ref;
    protected boolean m_nowait;
    protected Thread m_thread = null;
    protected Logbuf rtcout = new Logbuf("PeriodicExecutionContext");

    public PeriodicExecutionContext() {
        this.m_running = false;
        this.m_svc = true;
        this.m_nowait = false;
        double d = 1000000.0;
        this.m_usec = (long)(1000000.0 / d);
        this.m_ref = this.__this();
        this.m_profile.kind = ExecutionKind.PERIODIC;
        this.m_profile.rate = 0.0;
        this.m_profile.owner = null;
        this.m_profile.participants = new RTObject[0];
    }

    public PeriodicExecutionContext(DataFlowComponent dataFlowComponent) {
        this(dataFlowComponent, 1000.0);
    }

    public PeriodicExecutionContext(DataFlowComponent dataFlowComponent, double d) {
        this.rtcout.println(2, "PeriodicExecutionContext(owner,rate=" + d + ")");
        this.m_running = false;
        this.m_svc = true;
        this.m_nowait = true;
        if (d == 0.0) {
            d = 1000000.0;
        }
        this.m_usec = (long)(1000000.0 / d);
        if (this.m_usec == 0L) {
            this.m_nowait = true;
        }
        this.m_ref = this.__this();
        this.m_profile.kind = ExecutionKind.PERIODIC;
        this.m_profile.rate = d;
        this.m_profile.owner = dataFlowComponent;
        this.m_profile.participants = new RTObject[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finalizeExecutionContext() {
        Worker worker = this.m_worker;
        synchronized (worker) {
            this.m_worker.running_ = true;
            this.m_worker.notifyAll();
        }
        this.m_svc = false;
        try {
            this.m_thread.join();
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
        return true;
    }

    public ExecutionContextService __this() {
        if (this.m_ref == null) {
            try {
                this.m_ref = ExecutionContextServiceHelper.narrow(POAUtil.getRef(this));
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.m_ref;
    }

    @Override
    public void setObjRef(ExecutionContextService executionContextService) {
        this.rtcout.println(2, "PeriodicExecutionContext.setObjRef()");
        this.m_ref = executionContextService;
    }

    @Override
    public ExecutionContextService getObjRef() {
        this.rtcout.println(2, "PeriodicExecutionContext.getObjRef()");
        return this.m_ref;
    }

    public ExecutionContextService getRef() {
        this.rtcout.println(2, "PeriodicExecutionContext.getRef()");
        return this.m_ref;
    }

    public int open() {
        this.rtcout.println(2, "PeriodicExecutionContext.open()");
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, "PeriodicExecutionContext");
            this.m_thread.start();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int svc() {
        this.rtcout.println(2, "PeriodicExecutionContext.svc()");
        do {
            Worker worker = this.m_worker;
            synchronized (worker) {
                while (!this.m_worker.running_) {
                    try {
                        this.m_worker.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
                if (this.m_worker.running_) {
                    for (int i = 0; i < this.m_comps.size(); ++i) {
                        this.m_comps.elementAt(i).invoke();
                    }
                }
            }
            if (this.m_nowait) continue;
            long l = this.m_usec / 1000L;
            int n = (int)(this.m_usec % 1000L * 1000L);
            try {
                Thread.sleep(l, n);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (this.m_svc);
        return 0;
    }

    @Override
    public void run() {
        this.rtcout.println(2, "PeriodicExecutionContext.run()");
        this.svc();
    }

    public int close(long l) {
        this.rtcout.println(2, "PeriodicExecutionContext.close()");
        return 0;
    }

    @Override
    public boolean is_running() {
        this.rtcout.println(2, "PeriodicExecutionContext.is_running()");
        return this.m_running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t start() {
        this.rtcout.println(2, "PeriodicExecutionContext.start()");
        if (this.m_running) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        for (int i = 0; i < this.m_comps.size(); ++i) {
            this.m_comps.elementAt(i).invoke_on_startup();
        }
        this.m_running = true;
        Worker worker = this.m_worker;
        synchronized (worker) {
            this.m_worker.running_ = true;
            this.m_worker.notifyAll();
        }
        this.open();
        return ReturnCode_t.RTC_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t stop() {
        this.rtcout.println(2, "PeriodicExecutionContext.stop()");
        if (!this.m_running) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        this.m_running = false;
        Worker worker = this.m_worker;
        synchronized (worker) {
            this.m_worker.running_ = false;
        }
        for (int i = 0; i < this.m_comps.size(); ++i) {
            this.m_comps.elementAt(i).invoke_on_shutdown();
        }
        return ReturnCode_t.RTC_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double get_rate() {
        this.rtcout.println(2, "PeriodicExecutionContext.get_rate()");
        ExecutionContextProfile executionContextProfile = this.m_profile;
        synchronized (executionContextProfile) {
            return this.m_profile.rate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t set_rate(double d) {
        this.rtcout.println(2, "PeriodicExecutionContext.set_rate(" + d + ")");
        if (d <= 0.0) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        ExecutionContextProfile executionContextProfile = this.m_profile;
        synchronized (executionContextProfile) {
            this.m_profile.rate = d;
        }
        this.m_usec = (long)(1000000.0 / d);
        if (this.m_usec == 0L) {
            this.m_nowait = true;
        }
        for (int i = 0; i < this.m_comps.size(); ++i) {
            this.m_comps.elementAt(i).invoke_on_rate_changed();
        }
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ReturnCode_t activate_component(LightweightRTObject lightweightRTObject) {
        this.rtcout.println(2, "PeriodicExecutionContext.activate_component()");
        for (int i = 0; i < this.m_comps.size(); ++i) {
            find_comp find_comp2 = new find_comp((LightweightRTObject)lightweightRTObject._duplicate());
            if (!find_comp2.eqaulof(this.m_comps.elementAt(i))) continue;
            if (!this.m_comps.elementAt((int)i)._sm.m_sm.isIn(LifeCycleState.INACTIVE_STATE)) {
                return ReturnCode_t.PRECONDITION_NOT_MET;
            }
            this.m_comps.elementAt((int)i)._sm.m_sm.goTo(LifeCycleState.ACTIVE_STATE);
            return ReturnCode_t.RTC_OK;
        }
        return ReturnCode_t.BAD_PARAMETER;
    }

    @Override
    public ReturnCode_t deactivate_component(LightweightRTObject lightweightRTObject) {
        this.rtcout.println(2, "PeriodicExecutionContext.deactivate_component()");
        for (int i = 0; i < this.m_comps.size(); ++i) {
            find_comp find_comp2 = new find_comp((LightweightRTObject)lightweightRTObject._duplicate());
            if (!find_comp2.eqaulof(this.m_comps.elementAt(i))) continue;
            if (!this.m_comps.elementAt((int)i)._sm.m_sm.isIn(LifeCycleState.ACTIVE_STATE)) {
                return ReturnCode_t.PRECONDITION_NOT_MET;
            }
            this.m_comps.elementAt((int)i)._sm.m_sm.goTo(LifeCycleState.INACTIVE_STATE);
            return ReturnCode_t.RTC_OK;
        }
        return ReturnCode_t.BAD_PARAMETER;
    }

    @Override
    public ReturnCode_t reset_component(LightweightRTObject lightweightRTObject) {
        this.rtcout.println(2, "PeriodicExecutionContext.reset_component()");
        for (int i = 0; i < this.m_comps.size(); ++i) {
            find_comp find_comp2 = new find_comp((LightweightRTObject)lightweightRTObject._duplicate());
            if (!find_comp2.eqaulof(this.m_comps.elementAt(i))) continue;
            if (!this.m_comps.elementAt((int)i)._sm.m_sm.isIn(LifeCycleState.ERROR_STATE)) {
                return ReturnCode_t.PRECONDITION_NOT_MET;
            }
            this.m_comps.elementAt((int)i)._sm.m_sm.goTo(LifeCycleState.INACTIVE_STATE);
            return ReturnCode_t.RTC_OK;
        }
        return ReturnCode_t.BAD_PARAMETER;
    }

    @Override
    public LifeCycleState get_component_state(LightweightRTObject lightweightRTObject) {
        this.rtcout.println(2, "PeriodicExecutionContext.get_component_state()");
        for (int i = 0; i < this.m_comps.size(); ++i) {
            find_comp find_comp2 = new find_comp((LightweightRTObject)lightweightRTObject._duplicate());
            if (!find_comp2.eqaulof(this.m_comps.elementAt(i))) continue;
            return (LifeCycleState)this.m_comps.elementAt((int)i)._sm.m_sm.getState();
        }
        return LifeCycleState.CREATED_STATE;
    }

    @Override
    public ExecutionKind get_kind() {
        this.rtcout.println(2, "PeriodicExecutionContext.get_kind()");
        return this.m_profile.kind;
    }

    @Override
    public ReturnCode_t add_component(LightweightRTObject lightweightRTObject) {
        this.rtcout.println(2, "PeriodicExecutionContext.add_component()");
        if (lightweightRTObject == null) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        try {
            DataFlowComponent dataFlowComponent = DataFlowComponentHelper.narrow(lightweightRTObject);
            if (dataFlowComponent == null) {
                return ReturnCode_t.BAD_PARAMETER;
            }
            int n = dataFlowComponent.attach_context(this.m_ref);
            this.m_comps.add(new Comp((LightweightRTObject)lightweightRTObject._duplicate(), (DataFlowComponent)dataFlowComponent._duplicate(), n));
            RTCListHolder rTCListHolder = new RTCListHolder(this.m_profile.participants);
            CORBA_SeqUtil.push_back(rTCListHolder, RTObjectHelper.narrow(lightweightRTObject));
            this.m_profile.participants = rTCListHolder.value;
            return ReturnCode_t.RTC_OK;
        }
        catch (Exception exception) {
            return ReturnCode_t.BAD_PARAMETER;
        }
    }

    @Override
    public ReturnCode_t bindComponent(RTObject_impl rTObject_impl) {
        this.rtcout.println(2, "PeriodicExecutionContext.bindComponent()");
        if (rTObject_impl == null) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        RTObject rTObject = rTObject_impl.getObjRef();
        DataFlowComponent dataFlowComponent = DataFlowComponentHelper.narrow(rTObject);
        int n = rTObject_impl.bindContext(this.m_ref);
        if (n < 0 || n > 1000) {
            this.rtcout.println(6, "bindContext returns invalid id: " + n);
            return ReturnCode_t.RTC_ERROR;
        }
        this.rtcout.println(3, "bindComponent() returns id = " + n);
        this.m_comps.add(new Comp((LightweightRTObject)rTObject._duplicate(), (DataFlowComponent)dataFlowComponent._duplicate(), n));
        this.m_profile.owner = (DataFlowComponent)dataFlowComponent._duplicate();
        return ReturnCode_t.RTC_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode_t remove_component(LightweightRTObject lightweightRTObject) {
        this.rtcout.println(2, "PeriodicExecutionContext.remove_component()");
        for (int i = 0; i < this.m_comps.size(); ++i) {
            find_comp find_comp2 = new find_comp((LightweightRTObject)lightweightRTObject._duplicate());
            if (!find_comp2.eqaulof(this.m_comps.elementAt(i))) continue;
            this.m_comps.elementAt((int)i)._ref.detach_context(this.m_comps.elementAt((int)i)._sm.ec_id);
            this.m_comps.elementAt((int)i)._ref = null;
            this.m_comps.remove(this.m_comps.elementAt(i));
            this.rtcout.println(2, "remove_component(): an RTC removed from this context.");
            RTObject rTObject = RTObjectHelper.narrow(lightweightRTObject);
            if (rTObject == null) {
                this.rtcout.println(6, "Invalid object reference.");
                return ReturnCode_t.RTC_ERROR;
            }
            ExecutionContextProfile executionContextProfile = this.m_profile;
            synchronized (executionContextProfile) {
                RTCListHolder rTCListHolder = new RTCListHolder(this.m_profile.participants);
                long l = CORBA_SeqUtil.find(rTCListHolder, (equalFunctor)new is_equiv(rTObject));
                if (l < 0L) {
                    this.rtcout.println(6, "Not found.");
                    return ReturnCode_t.BAD_PARAMETER;
                }
                CORBA_SeqUtil.erase(rTCListHolder, (int)l);
                this.m_profile.participants = rTCListHolder.value;
            }
            return ReturnCode_t.RTC_OK;
        }
        this.rtcout.println(2, "remove_component(): no RTC found in this context.");
        return ReturnCode_t.BAD_PARAMETER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionContextProfile get_profile() {
        ExecutionContextProfileHolder executionContextProfileHolder;
        this.rtcout.println(2, "PeriodicExecutionContext.get_profile()");
        ExecutionContextProfile executionContextProfile = this.m_profile;
        synchronized (executionContextProfile) {
            executionContextProfileHolder = new ExecutionContextProfileHolder(this.m_profile);
        }
        return executionContextProfileHolder.value;
    }

    public static void PeriodicExecutionContextInit(Manager manager) {
        manager.registerECFactory("jp.go.aist.rtm.RTC.executionContext.PeriodicExecutionContext");
    }

    @Override
    public ExecutionContextBase ECNewFunc() {
        return this;
    }

    @Override
    public Object ECDeleteFunc(ExecutionContextBase executionContextBase) {
        return null;
    }

    private class is_equiv
    implements equalFunctor {
        private RTObject m_obj;

        public is_equiv(RTObject rTObject) {
            this.m_obj = (RTObject)rTObject._duplicate();
        }

        @Override
        public boolean equalof(Object object) {
            return this.m_obj._is_equivalent((RTObject)object);
        }
    }

    protected class Worker {
        private boolean running_ = false;
    }

    protected class find_comp {
        private LightweightRTObject m_comp;

        public find_comp(LightweightRTObject lightweightRTObject) {
            this.m_comp = lightweightRTObject;
        }

        public boolean eqaulof(Comp comp) {
            return comp._ref._is_equivalent(this.m_comp);
        }
    }

    protected class Comp {
        public LightweightRTObject _ref;
        public DFP _sm;

        public Comp(LightweightRTObject lightweightRTObject, DataFlowComponent dataFlowComponent, int n) {
            this._ref = lightweightRTObject;
            this._sm = new DFP(dataFlowComponent, n);
        }

        public Comp(Comp comp) {
            this._ref = comp._ref;
            this._sm = new DFP(comp._sm.m_obj, comp._sm.ec_id);
        }

        public Comp substitute(Comp comp) {
            this._ref = comp._ref;
            this._sm.m_obj = comp._sm.m_obj;
            this._sm.ec_id = comp._sm.ec_id;
            return this;
        }

        public void invoke() {
            this._sm.worker();
        }

        public void invoke_on_startup() {
            this._sm.on_startup();
        }

        public void invoke_on_shutdown() {
            this._sm.on_shutdown();
        }

        public void invoke_on_rate_changed() {
            this._sm.on_rate_changed();
        }
    }

    protected class DFP
    extends DFPBase {
        private DataFlowComponent m_obj;

        public DFP(DataFlowComponent dataFlowComponent, int n) {
            super(n);
            this.m_obj = dataFlowComponent;
        }

        @Override
        public void on_startup() {
            this.m_obj.on_startup(this.ec_id);
        }

        @Override
        public void on_shutdown() {
            this.m_obj.on_shutdown(this.ec_id);
        }

        @Override
        public void on_activated(StateHolder stateHolder) {
            if (this.m_obj.on_activated(this.ec_id) != ReturnCode_t.RTC_OK) {
                this.m_sm.goTo(LifeCycleState.ERROR_STATE);
                return;
            }
        }

        @Override
        public void on_deactivated(StateHolder stateHolder) {
            if (this.m_obj.on_deactivated(this.ec_id) != ReturnCode_t.RTC_OK) {
                this.m_sm.goTo(LifeCycleState.ERROR_STATE);
                return;
            }
        }

        @Override
        public void on_aborting(StateHolder stateHolder) {
            this.m_obj.on_aborting(this.ec_id);
        }

        @Override
        public void on_error(StateHolder stateHolder) {
            this.m_obj.on_error(this.ec_id);
        }

        @Override
        public void on_reset(StateHolder stateHolder) {
            if (this.m_obj.on_reset(this.ec_id) != ReturnCode_t.RTC_OK) {
                this.m_sm.goTo(LifeCycleState.ERROR_STATE);
                return;
            }
        }

        @Override
        public void on_execute(StateHolder stateHolder) {
            if (this.m_obj.on_execute(this.ec_id) != ReturnCode_t.RTC_OK) {
                this.m_sm.goTo(LifeCycleState.ERROR_STATE);
                return;
            }
        }

        @Override
        public void on_state_update(StateHolder stateHolder) {
            if (this.m_obj.on_state_update(this.ec_id) != ReturnCode_t.RTC_OK) {
                this.m_sm.goTo(LifeCycleState.ERROR_STATE);
                return;
            }
        }

        @Override
        public void on_rate_changed() {
            this.m_obj.on_rate_changed(this.ec_id);
        }
    }

    protected abstract class DFPBase {
        public int ec_id;
        public StateMachine<LifeCycleState, DFPBase> m_sm;

        public DFPBase(int n) {
            this.ec_id = n;
            this.m_sm = new StateMachine(3);
            this.m_sm.setListener(this);
            StateHolder stateHolder = new StateHolder();
            this.m_sm.setEntryAction(LifeCycleState.ACTIVE_STATE, new onActivated());
            this.m_sm.setDoAction(LifeCycleState.ACTIVE_STATE, new onExecute());
            this.m_sm.setPostDoAction(LifeCycleState.ACTIVE_STATE, new onStateUpdate());
            this.m_sm.setExitAction(LifeCycleState.ACTIVE_STATE, new onDeactivated());
            this.m_sm.setEntryAction(LifeCycleState.ERROR_STATE, new onAborting());
            this.m_sm.setDoAction(LifeCycleState.ERROR_STATE, new onError());
            this.m_sm.setExitAction(LifeCycleState.ERROR_STATE, new onReset());
            stateHolder.prev = LifeCycleState.INACTIVE_STATE;
            stateHolder.curr = LifeCycleState.INACTIVE_STATE;
            stateHolder.next = LifeCycleState.INACTIVE_STATE;
            this.m_sm.setStartState(stateHolder);
            this.m_sm.goTo(LifeCycleState.INACTIVE_STATE);
        }

        public abstract void on_startup();

        public abstract void on_shutdown();

        public abstract void on_activated(StateHolder var1);

        public abstract void on_deactivated(StateHolder var1);

        public abstract void on_aborting(StateHolder var1);

        public abstract void on_error(StateHolder var1);

        public abstract void on_reset(StateHolder var1);

        public abstract void on_execute(StateHolder var1);

        public abstract void on_state_update(StateHolder var1);

        public abstract void on_rate_changed();

        public void worker() {
            this.m_sm.worker();
        }

        public LifeCycleState get_state() {
            return this.m_sm.getState();
        }

        private class onReset
        implements StateAction {
            private onReset() {
            }

            public void doAction(StateHolder stateHolder) {
                DFPBase.this.on_reset(stateHolder);
            }
        }

        private class onError
        implements StateAction {
            private onError() {
            }

            public void doAction(StateHolder stateHolder) {
                DFPBase.this.on_error(stateHolder);
            }
        }

        private class onAborting
        implements StateAction {
            private onAborting() {
            }

            public void doAction(StateHolder stateHolder) {
                DFPBase.this.on_aborting(stateHolder);
            }
        }

        private class onDeactivated
        implements StateAction {
            private onDeactivated() {
            }

            public void doAction(StateHolder stateHolder) {
                DFPBase.this.on_deactivated(stateHolder);
            }
        }

        private class onStateUpdate
        implements StateAction {
            private onStateUpdate() {
            }

            public void doAction(StateHolder stateHolder) {
                DFPBase.this.on_state_update(stateHolder);
            }
        }

        private class onExecute
        implements StateAction {
            private onExecute() {
            }

            public void doAction(StateHolder stateHolder) {
                DFPBase.this.on_execute(stateHolder);
            }
        }

        private class onActivated
        implements StateAction {
            private onActivated() {
            }

            public void doAction(StateHolder stateHolder) {
                DFPBase.this.on_activated(stateHolder);
            }
        }
    }
}

