/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import OpenRTM.CdrDataHolder;
import OpenRTM.InPortCdr;
import OpenRTM.InPortCdrHelper;
import OpenRTM.InPortCdrPOA;
import OpenRTM.PortStatus;
import _SDOPackage.NVListHolder;
import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.spi.orb.ORB;
import jp.go.aist.rtm.RTC.InPortProviderFactory;
import jp.go.aist.rtm.RTC.ObjectCreator;
import jp.go.aist.rtm.RTC.ObjectDestructor;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.buffer.ReturnCode;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.ConnectorListeners;
import jp.go.aist.rtm.RTC.port.InPortConnector;
import jp.go.aist.rtm.RTC.port.InPortProvider;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVListHolderFactory;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.POAUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.PortableServer.Servant;

public class InPortCorbaCdrProvider
extends InPortCdrPOA
implements InPortProvider,
ObjectCreator<InPortProvider>,
ObjectDestructor {
    private Logbuf rtcout;
    protected NVListHolder m_properties = NVListHolderFactory.create();
    private String m_dataType = new String();
    private String m_interfaceType = new String();
    private String m_dataflowType = new String();
    private String m_subscriptionType = new String();
    private BufferBase<OutputStream> m_buffer = null;
    private InPortCdr m_objref;
    private ORB m_spi_orb;
    private InPortConnector m_connector;
    private ConnectorListeners m_listeners;
    private ConnectorBase.ConnectorInfo m_profile;

    public InPortCorbaCdrProvider() {
        this.rtcout = new Logbuf("InPortCorbaCdrProvider");
        this.setInterfaceType("corba_cdr");
        this.m_objref = this._this();
        org.omg.CORBA.ORB oRB = ORBUtil.getOrb();
        CORBA_SeqUtil.push_back(this.m_properties, NVUtil.newNVString("dataport.corba_cdr.inport_ior", oRB.object_to_string((Object)this.m_objref)));
        CORBA_SeqUtil.push_back(this.m_properties, NVUtil.newNV("dataport.corba_cdr.inport_ref", this.m_objref, InPortCdr.class));
        this.m_spi_orb = (ORB)ORBUtil.getOrb();
    }

    @Override
    public InPortCdr _this() {
        if (this.m_objref == null) {
            try {
                this.m_objref = InPortCdrHelper.narrow(POAUtil.getRef(this));
            }
            catch (Exception exception) {
                this.rtcout.println(5, "The exception was caught.");
                throw new IllegalStateException(exception);
            }
        }
        return this.m_objref;
    }

    @Override
    public void init(Properties properties) {
    }

    @Override
    public void setBuffer(BufferBase<OutputStream> bufferBase) {
        this.m_buffer = bufferBase;
    }

    @Override
    public PortStatus put(byte[] byArray) throws SystemException {
        this.rtcout.println(0, "InPortCorbaCdrProvider.put()");
        if (this.m_buffer == null) {
            EncapsOutputStream encapsOutputStream = new EncapsOutputStream(this.m_spi_orb, this.m_connector.isLittleEndian());
            encapsOutputStream.write_octet_array(byArray, 0, byArray.length);
            this.onReceiverError((OutputStream)encapsOutputStream);
            return PortStatus.PORT_ERROR;
        }
        this.rtcout.println(0, "received data size: " + byArray.length);
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(this.m_spi_orb, this.m_connector.isLittleEndian());
        encapsOutputStream.write_octet_array(byArray, 0, byArray.length);
        int n = encapsOutputStream.toByteArray().length;
        this.rtcout.println(0, "converted CDR data size: " + n);
        this.onReceived((OutputStream)encapsOutputStream);
        ReturnCode returnCode = this.m_buffer.write((OutputStream)encapsOutputStream);
        return this.convertReturn(returnCode, encapsOutputStream);
    }

    public PortStatus put(CdrDataHolder cdrDataHolder) throws SystemException {
        return this.put(cdrDataHolder.value);
    }

    protected PortStatus convertReturn(ReturnCode returnCode, EncapsOutputStream encapsOutputStream) {
        switch (returnCode) {
            case BUFFER_OK: {
                this.onBufferWrite((OutputStream)encapsOutputStream);
                return PortStatus.from_int(0);
            }
            case BUFFER_ERROR: {
                this.onReceiverError((OutputStream)encapsOutputStream);
                return PortStatus.from_int(1);
            }
            case BUFFER_FULL: {
                this.onBufferFull((OutputStream)encapsOutputStream);
                this.onReceiverFull((OutputStream)encapsOutputStream);
                return PortStatus.from_int(2);
            }
            case BUFFER_EMPTY: {
                return PortStatus.from_int(3);
            }
            case TIMEOUT: {
                this.onBufferWriteTimeout((OutputStream)encapsOutputStream);
                this.onReceiverTimeout((OutputStream)encapsOutputStream);
                return PortStatus.from_int(4);
            }
            case PRECONDITION_NOT_MET: {
                this.onReceiverError((OutputStream)encapsOutputStream);
                return PortStatus.from_int(1);
            }
        }
        this.onReceiverError((OutputStream)encapsOutputStream);
        return PortStatus.from_int(5);
    }

    @Override
    public InPortProvider creator_() {
        return new InPortCorbaCdrProvider();
    }

    @Override
    public void destructor_(java.lang.Object object) {
        try {
            byte[] byArray = this._default_POA().servant_to_id((Servant)((InPortCorbaCdrProvider)object));
            this._default_POA().deactivate_object(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = null;
    }

    public static void InPortCorbaCdrProviderInit() {
        InPortProviderFactory inPortProviderFactory = InPortProviderFactory.instance();
        inPortProviderFactory.addFactory("corba_cdr", new InPortCorbaCdrProvider(), new InPortCorbaCdrProvider());
    }

    @Override
    public void publishInterfaceProfile(NVListHolder nVListHolder) {
        NVUtil.appendStringValue(nVListHolder, "dataport.interface_type", this.m_interfaceType);
        NVUtil.append(nVListHolder, this.m_properties);
    }

    @Override
    public boolean publishInterface(NVListHolder nVListHolder) {
        this.rtcout.println(2, "publishInterface()");
        this.rtcout.println(3, NVUtil.toString(nVListHolder));
        if (!NVUtil.isStringValue(nVListHolder, "dataport.interface_type", this.m_interfaceType)) {
            return false;
        }
        NVUtil.append(nVListHolder, this.m_properties);
        return true;
    }

    @Override
    public void setListener(ConnectorBase.ConnectorInfo connectorInfo, ConnectorListeners connectorListeners) {
        this.m_profile = connectorInfo;
        this.m_listeners = connectorListeners;
    }

    @Override
    public void setConnector(InPortConnector inPortConnector) {
        this.m_connector = inPortConnector;
    }

    protected void setDataType(String string) {
        this.m_dataType = string;
    }

    protected void setInterfaceType(String string) {
        this.rtcout.println(2, "setInterfaceType(" + string + ")");
        this.m_interfaceType = string;
    }

    protected void setDataFlowType(String string) {
        this.rtcout.println(2, "setDataFlowType(" + string + ")");
        this.m_dataflowType = string;
    }

    protected void setSubscriptionType(String string) {
        this.rtcout.println(2, "setSubscriptionType(" + string + ")");
        this.m_subscriptionType = string;
    }

    private void onBufferWrite(OutputStream outputStream) {
        this.m_listeners.connectorData_[0].notify(this.m_profile, outputStream);
    }

    private void onBufferFull(OutputStream outputStream) {
        this.m_listeners.connectorData_[1].notify(this.m_profile, outputStream);
    }

    private void onBufferWriteTimeout(OutputStream outputStream) {
        this.m_listeners.connectorData_[2].notify(this.m_profile, outputStream);
    }

    private void onBufferWriteOverwrite(OutputStream outputStream) {
        this.m_listeners.connectorData_[3].notify(this.m_profile, outputStream);
    }

    private void onReceived(OutputStream outputStream) {
        this.m_listeners.connectorData_[6].notify(this.m_profile, outputStream);
    }

    private void onReceiverFull(OutputStream outputStream) {
        this.m_listeners.connectorData_[7].notify(this.m_profile, outputStream);
    }

    private void onReceiverTimeout(OutputStream outputStream) {
        this.m_listeners.connectorData_[8].notify(this.m_profile, outputStream);
    }

    private void onReceiverError(OutputStream outputStream) {
        this.m_listeners.connectorData_[9].notify(this.m_profile, outputStream);
    }
}

